/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.script.groovy;

import b.ImportedClass;
import groovy.lang.GroovyObject;
import junit.framework.TestCase;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.script.groovy.Book;
import org.exoplatform.services.script.groovy.GroovyScriptInstantiator;
import org.exoplatform.services.script.groovy.SampleComponent;

public class GroovyInstantiatorTest
extends TestCase {
    private GroovyScriptInstantiator groovyScriptInstantiator;
    private GroovyScriptInstantiator jarjarGroovyScriptInstantiator;

    public void setUp() throws Exception {
        StandaloneContainer.setConfigurationPath((String)"src/test/resources/conf/standalone/test-configuration.xml");
        StandaloneContainer container = StandaloneContainer.getInstance();
        this.groovyScriptInstantiator = (GroovyScriptInstantiator)container.getComponentInstance(GroovyScriptInstantiator.class);
        this.jarjarGroovyScriptInstantiator = (GroovyScriptInstantiator)container.getComponentInstance((Object)"JarJarGroovyScriptInstantiator");
        GroovyInstantiatorTest.assertNotNull((Object)this.groovyScriptInstantiator);
        GroovyInstantiatorTest.assertNotNull((Object)this.jarjarGroovyScriptInstantiator);
    }

    public void testGroovyScriptInstantiatorSimple() throws Exception {
        String url = Thread.currentThread().getContextClassLoader().getResource("Book.groovy").toString();
        GroovyObject groovyObject = (GroovyObject)this.groovyScriptInstantiator.instantiateScript(url);
        GroovyInstantiatorTest.assertEquals((Object)"Andrew Glover", (Object)groovyObject.getProperty("author"));
        GroovyInstantiatorTest.assertEquals((Object)"Groovy in Action", (Object)groovyObject.getProperty("title"));
        GroovyInstantiatorTest.assertEquals((Object)"1234567890987654321", (Object)groovyObject.getProperty("isdn"));
        GroovyInstantiatorTest.assertEquals((Object)20, (Object)groovyObject.getProperty("price"));
        groovyObject.setProperty("price", (Object)10);
        GroovyInstantiatorTest.assertEquals((Object)10, (Object)groovyObject.getProperty("price"));
    }

    public void testGroovyScriptInstantiatorInjection() throws Exception {
        String url = Thread.currentThread().getContextClassLoader().getResource("TestInjection.groovy").toString();
        GroovyObject groovyObject = (GroovyObject)this.groovyScriptInstantiator.instantiateScript(url);
        GroovyInstantiatorTest.assertNotNull((Object)groovyObject.getProperty("sampleComponent"));
        GroovyInstantiatorTest.assertEquals((String)"sample component", (String)((SampleComponent)groovyObject.getProperty("sampleComponent")).getAbout());
    }

    public void testGroovyScriptInstantiatorXML() throws Exception {
        String url = Thread.currentThread().getContextClassLoader().getResource("TestSimpleXMLGenerator.groovy").toString();
        GroovyObject groovyObject = (GroovyObject)this.groovyScriptInstantiator.instantiateScript(url);
        groovyObject.invokeMethod("generateXML", (Object)new Object[]{new Book()});
    }

    public void testGroovyScriptJarJar() throws Exception {
        String url = Thread.currentThread().getContextClassLoader().getResource("TestJarJar.groovy").toString();
        GroovyObject groovyObject = (GroovyObject)this.jarjarGroovyScriptInstantiator.instantiateScript(url);
        Object field = groovyObject.getProperty("field");
        GroovyInstantiatorTest.assertNotNull((Object)field);
        GroovyInstantiatorTest.assertTrue((String)("Was expecting object " + String.valueOf(field) + " to be an instance of class " + ImportedClass.class.getName() + "instead of class " + field.getClass().getName()), (boolean)(field instanceof ImportedClass));
    }
}

