/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.script.groovy.jarjar;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.exoplatform.services.script.groovy.jarjar.Mapping;
import org.exoplatform.services.script.groovy.jarjar.TestScript;

public class JarJarTest
extends TestCase {
    public static AssertionFailedError error = null;

    public JarJarTest() {
    }

    public JarJarTest(String s) {
        super(s);
    }

    private void testTop(TestScript script) {
        Mapping m1 = new Mapping();
        m1.addMapping("a", "b");
        Mapping m2 = new Mapping();
        m2.addMapping("a", "prefix1.a");
        JarJarTest.assertEquals((Object)"b", (Object)script.execute(m1));
        JarJarTest.assertEquals((Object)"prefix1.a", (Object)script.execute(m2));
    }

    public void testTopClassLitteral() throws Exception {
        this.testTop(new TestScript("classlitteral1.groovy"));
        this.testTop(new TestScript("classlitteral_1.groovy"));
        this.testTop(new TestScript("import1.groovy"));
    }

    private void testPrefix(TestScript script) throws Exception {
        Mapping m1 = new Mapping();
        m1.addMapping("prefix1", "prefix2");
        Mapping m2 = new Mapping();
        m2.addMapping("prefix1.a", "a");
        Mapping m3 = new Mapping();
        m3.addMapping("prefix1.a", "prefix2.b");
        Mapping m4 = new Mapping();
        m4.addMapping("prefix1.a", "prefix1.b");
        JarJarTest.assertEquals((Object)"prefix2.a", (Object)script.execute(m1));
        JarJarTest.assertEquals((Object)"a", (Object)script.execute(m2));
        JarJarTest.assertEquals((Object)"prefix2.b", (Object)script.execute(m3));
        JarJarTest.assertEquals((Object)"prefix1.b", (Object)script.execute(m4));
    }

    public void testPrefixClassLitteral() throws Exception {
        this.testPrefix(new TestScript("classlitteral2.groovy"));
        this.testPrefix(new TestScript("classlitteral_2.groovy"));
        this.testPrefix(new TestScript("import2.groovy"));
    }
}

