/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.xml.resolving.XMLResolvingService;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class BaseTest
extends TestCase {
    private final String DATE_PATTERN = "yy-MM-DD_HH-mm-ss";
    private DateFormat dateFormat = new SimpleDateFormat("yy-MM-DD_HH-mm-ss");

    protected String getTimeStamp() {
        return this.dateFormat.format(new Date());
    }

    protected InputStream resourceStream(String name) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
    }

    protected void validateXML(InputStream input) throws Exception {
        StandaloneContainer.setConfigurationPath((String)"src/test/resources/conf/standalone/test-configuration.xml");
        StandaloneContainer container = StandaloneContainer.getInstance();
        XMLResolvingService resolvingService = (XMLResolvingService)container.getComponentInstanceOfType(XMLResolvingService.class);
        BaseTest.assertNotNull((String)"XMLResolvingService", (Object)resolvingService);
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setEntityResolver(resolvingService.getEntityResolver());
        BaseTest.assertNotNull((String)"resolvingService.getEntityResolver()", (Object)resolvingService.getEntityResolver());
        InputSource src = resolvingService.getEntityResolver().resolveEntity("-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        BaseTest.assertNotNull((String)"Not resolved InputSource entity", (Object)src);
        xmlReader.setFeature("http://xml.org/sax/features/validation", true);
        try {
            xmlReader.parse(new InputSource(input));
        }
        catch (SAXParseException ex) {
            BaseTest.fail((String)("Document is not valid XML. See: \n" + ex.getMessage()));
        }
    }
}

