/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.resolving.impl;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.xml.BaseTest;
import org.exoplatform.services.xml.resolving.XMLResolvingService;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class TestXMLResolver
extends BaseTest {
    private XMLResolvingService service;

    public void setUp() throws Exception {
        if (this.service == null) {
            StandaloneContainer.setConfigurationPath((String)"src/test/resources/conf/standalone/test-configuration.xml");
            StandaloneContainer container = StandaloneContainer.getInstance();
            this.service = (XMLResolvingService)container.getComponentInstanceOfType(XMLResolvingService.class);
        }
    }

    public void testLookupFailed() throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser jaxpParser = factory.newSAXParser();
        XMLReader reader = jaxpParser.getXMLReader();
        reader.setEntityResolver(this.service.getEntityResolver());
        try {
            reader.parse(new InputSource(this.resourceStream("tmp/dtd-not-found.xml")));
        }
        catch (Throwable e) {
            return;
        }
        TestXMLResolver.fail((String)"Lookup should have been Failed as there is not such local DTD.");
    }

    public void testWebXmlResolving() throws Exception {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser jaxpParser = factory.newSAXParser();
            XMLReader reader = jaxpParser.getXMLReader();
            reader.setEntityResolver(this.service.getEntityResolver());
            reader.parse(new InputSource(this.resourceStream("web.xml")));
        }
        catch (Exception e) {
            TestXMLResolver.fail((String)("testWebXmlResolving() ERROR: " + e.toString()));
        }
    }
}

