/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xml.transform;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.xml.BaseTest;
import org.exoplatform.services.xml.transform.trax.TRAXTemplates;
import org.exoplatform.services.xml.transform.trax.TRAXTransformer;
import org.exoplatform.services.xml.transform.trax.TRAXTransformerService;

public class TestXsl
extends BaseTest {
    private TRAXTransformerService traxService;

    public void setUp() throws Exception {
        StandaloneContainer.setConfigurationPath((String)"src/test/resources/conf/standalone/test-configuration.xml");
        StandaloneContainer container = StandaloneContainer.getInstance();
        this.traxService = (TRAXTransformerService)container.getComponentInstanceOfType(TRAXTransformerService.class);
        TestXsl.assertNotNull((String)"traxService", (Object)this.traxService);
    }

    public void testSimpleXslt() throws Exception {
        InputStream res = this.resourceStream("rss-in.xhtml");
        File outputFile = File.createTempFile("rss-out-", ".xml");
        outputFile.deleteOnExit();
        TestXsl.assertTrue((String)"Empty input file", (res.available() > 0 ? 1 : 0) != 0);
        FileOutputStream outputFileOutputStream = new FileOutputStream(outputFile);
        InputStream xslInputStream = this.resourceStream("html-url-rewite.xsl");
        TestXsl.assertNotNull((String)"empty xsl", (Object)xslInputStream);
        StreamSource xslSource = new StreamSource(xslInputStream);
        TestXsl.assertNotNull((String)"get xsl source", (Object)xslSource);
        TRAXTransformer traxTransformer = this.traxService.getTransformer((Source)xslSource);
        TestXsl.assertNotNull((String)"get transformer", (Object)traxTransformer);
        traxTransformer.initResult((Result)new StreamResult(outputFileOutputStream));
        traxTransformer.transform((Source)new StreamSource(res));
        res.close();
        ((OutputStream)outputFileOutputStream).close();
        FileInputStream outputFileInputStream = new FileInputStream(outputFile);
        TestXsl.assertTrue((String)"Output is empty", (outputFileInputStream.available() > 0 ? 1 : 0) != 0);
        outputFileInputStream.close();
    }

    public void testXsltUseTemplates() throws Exception {
        InputStream res = this.resourceStream("rss-in.xhtml");
        TestXsl.assertTrue((String)"Empty input file", (res.available() > 0 ? 1 : 0) != 0);
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        InputStream xslInputStream = this.resourceStream("html-url-rewite.xsl");
        TestXsl.assertNotNull((String)"empty xsl", (Object)xslInputStream);
        StreamSource xslSource = new StreamSource(xslInputStream);
        TestXsl.assertNotNull((String)"get xsl source", (Object)xslSource);
        TRAXTemplates traxTemplates = this.traxService.getTemplates((Source)xslSource);
        TestXsl.assertNotNull((String)"get templates", (Object)traxTemplates);
        TRAXTransformer traxTransformer = traxTemplates.newTransformer();
        TestXsl.assertNotNull((String)"get transformer", (Object)traxTransformer);
        traxTransformer.initResult((Result)new StreamResult(byteOutputStream));
        traxTransformer.transform((Source)new StreamSource(res));
        res.close();
        TestXsl.assertTrue((String)"Output is empty", (byteOutputStream.size() > 0 ? 1 : 0) != 0);
        TRAXTransformer traxOtherTransformer = traxTemplates.newTransformer();
        TestXsl.assertNotNull((String)"get Other transformer", (Object)traxOtherTransformer);
        res = this.resourceStream("rss-in.xhtml");
        TestXsl.assertTrue((String)"Empty input other file", (res.available() > 0 ? 1 : 0) != 0);
        ByteArrayOutputStream byteOtherOutputStream = new ByteArrayOutputStream();
        traxOtherTransformer.initResult((Result)new StreamResult(byteOtherOutputStream));
        traxOtherTransformer.transform((Source)new StreamSource(res));
        res.close();
        TestXsl.assertTrue((String)"Output other is empty", (byteOutputStream.size() > 0 ? 1 : 0) != 0);
    }
}

