/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.blockchain;

import io.meeds.deeds.blockchain.BlockchainConfigurationProperties;
import io.meeds.deeds.contract.Deed;
import io.meeds.deeds.contract.TenantProvisioningStrategy;
import java.math.BigInteger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.web3j.abi.datatypes.Address;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.http.HttpService;
import org.web3j.tx.ReadonlyTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;
import org.web3j.tx.gas.StaticGasProvider;

@Configuration
public class BlockchainConfiguration {
    @Autowired
    private BlockchainConfigurationProperties properties;

    @Bean
    public Web3j getWeb3j() {
        return Web3j.build((Web3jService)new HttpService(this.properties.getNetworkUrl()));
    }

    @Bean
    public TenantProvisioningStrategy getTenantProvisioningStrategy(Web3j web3j) {
        BigInteger gasPrice = BigInteger.valueOf(20000000000L);
        BigInteger gasLimit = BigInteger.valueOf(300000L);
        return TenantProvisioningStrategy.load((String)this.properties.getTenantProvisioningAddress(), (Web3j)web3j, (TransactionManager)new ReadonlyTransactionManager(this.getWeb3j(), Address.DEFAULT.toString()), (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit));
    }

    @Bean
    public Deed getDeed(Web3j web3j) {
        BigInteger gasPrice = BigInteger.valueOf(20000000000L);
        BigInteger gasLimit = BigInteger.valueOf(300000L);
        return Deed.load((String)this.properties.getDeedAddress(), (Web3j)web3j, (TransactionManager)new ReadonlyTransactionManager(this.getWeb3j(), Address.DEFAULT.toString()), (ContractGasProvider)new StaticGasProvider(gasPrice, gasLimit));
    }
}

