/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.model;

import java.time.LocalDateTime;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="deed_tenant_manager", createIndex=true)
@Setting(sortFields={"date"}, sortOrders={Setting.SortOrder.desc}, replicas=0, shards=1)
public class DeedTenant {
    @Id
    private long nftId;
    private short cityIndex = (short)-1;
    private short cardType = (short)-1;
    private String managerAddress;
    private String managerEmail;
    private String startupTransactionHash;
    private String shutdownTransactionHash;
    private String provisioningStatus;
    private String tenantStatus;
    @Field(type=FieldType.Date, format={DateFormat.date_hour_minute_second})
    private LocalDateTime date;
    private Map<String, String> properties;

    public long getNftId() {
        return this.nftId;
    }

    public short getCityIndex() {
        return this.cityIndex;
    }

    public short getCardType() {
        return this.cardType;
    }

    public String getManagerAddress() {
        return this.managerAddress;
    }

    public String getManagerEmail() {
        return this.managerEmail;
    }

    public String getStartupTransactionHash() {
        return this.startupTransactionHash;
    }

    public String getShutdownTransactionHash() {
        return this.shutdownTransactionHash;
    }

    public String getProvisioningStatus() {
        return this.provisioningStatus;
    }

    public String getTenantStatus() {
        return this.tenantStatus;
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setNftId(long nftId) {
        this.nftId = nftId;
    }

    public void setCityIndex(short cityIndex) {
        this.cityIndex = cityIndex;
    }

    public void setCardType(short cardType) {
        this.cardType = cardType;
    }

    public void setManagerAddress(String managerAddress) {
        this.managerAddress = managerAddress;
    }

    public void setManagerEmail(String managerEmail) {
        this.managerEmail = managerEmail;
    }

    public void setStartupTransactionHash(String startupTransactionHash) {
        this.startupTransactionHash = startupTransactionHash;
    }

    public void setShutdownTransactionHash(String shutdownTransactionHash) {
        this.shutdownTransactionHash = shutdownTransactionHash;
    }

    public void setProvisioningStatus(String provisioningStatus) {
        this.provisioningStatus = provisioningStatus;
    }

    public void setTenantStatus(String tenantStatus) {
        this.tenantStatus = tenantStatus;
    }

    public void setDate(LocalDateTime date) {
        this.date = date;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeedTenant)) {
            return false;
        }
        DeedTenant other = (DeedTenant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNftId() != other.getNftId()) {
            return false;
        }
        if (this.getCityIndex() != other.getCityIndex()) {
            return false;
        }
        if (this.getCardType() != other.getCardType()) {
            return false;
        }
        String this$managerAddress = this.getManagerAddress();
        String other$managerAddress = other.getManagerAddress();
        if (this$managerAddress == null ? other$managerAddress != null : !this$managerAddress.equals(other$managerAddress)) {
            return false;
        }
        String this$managerEmail = this.getManagerEmail();
        String other$managerEmail = other.getManagerEmail();
        if (this$managerEmail == null ? other$managerEmail != null : !this$managerEmail.equals(other$managerEmail)) {
            return false;
        }
        String this$startupTransactionHash = this.getStartupTransactionHash();
        String other$startupTransactionHash = other.getStartupTransactionHash();
        if (this$startupTransactionHash == null ? other$startupTransactionHash != null : !this$startupTransactionHash.equals(other$startupTransactionHash)) {
            return false;
        }
        String this$shutdownTransactionHash = this.getShutdownTransactionHash();
        String other$shutdownTransactionHash = other.getShutdownTransactionHash();
        if (this$shutdownTransactionHash == null ? other$shutdownTransactionHash != null : !this$shutdownTransactionHash.equals(other$shutdownTransactionHash)) {
            return false;
        }
        String this$provisioningStatus = this.getProvisioningStatus();
        String other$provisioningStatus = other.getProvisioningStatus();
        if (this$provisioningStatus == null ? other$provisioningStatus != null : !this$provisioningStatus.equals(other$provisioningStatus)) {
            return false;
        }
        String this$tenantStatus = this.getTenantStatus();
        String other$tenantStatus = other.getTenantStatus();
        if (this$tenantStatus == null ? other$tenantStatus != null : !this$tenantStatus.equals(other$tenantStatus)) {
            return false;
        }
        LocalDateTime this$date = this.getDate();
        LocalDateTime other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeedTenant;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $nftId = this.getNftId();
        result = result * 59 + (int)($nftId >>> 32 ^ $nftId);
        result = result * 59 + this.getCityIndex();
        result = result * 59 + this.getCardType();
        String $managerAddress = this.getManagerAddress();
        result = result * 59 + ($managerAddress == null ? 43 : $managerAddress.hashCode());
        String $managerEmail = this.getManagerEmail();
        result = result * 59 + ($managerEmail == null ? 43 : $managerEmail.hashCode());
        String $startupTransactionHash = this.getStartupTransactionHash();
        result = result * 59 + ($startupTransactionHash == null ? 43 : $startupTransactionHash.hashCode());
        String $shutdownTransactionHash = this.getShutdownTransactionHash();
        result = result * 59 + ($shutdownTransactionHash == null ? 43 : $shutdownTransactionHash.hashCode());
        String $provisioningStatus = this.getProvisioningStatus();
        result = result * 59 + ($provisioningStatus == null ? 43 : $provisioningStatus.hashCode());
        String $tenantStatus = this.getTenantStatus();
        result = result * 59 + ($tenantStatus == null ? 43 : $tenantStatus.hashCode());
        LocalDateTime $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "DeedTenant(nftId=" + this.getNftId() + ", cityIndex=" + this.getCityIndex() + ", cardType=" + this.getCardType() + ", managerAddress=" + this.getManagerAddress() + ", managerEmail=" + this.getManagerEmail() + ", startupTransactionHash=" + this.getStartupTransactionHash() + ", shutdownTransactionHash=" + this.getShutdownTransactionHash() + ", provisioningStatus=" + this.getProvisioningStatus() + ", tenantStatus=" + this.getTenantStatus() + ", date=" + this.getDate() + ", properties=" + this.getProperties() + ")";
    }

    public DeedTenant(long nftId, short cityIndex, short cardType, String managerAddress, String managerEmail, String startupTransactionHash, String shutdownTransactionHash, String provisioningStatus, String tenantStatus, LocalDateTime date, Map<String, String> properties) {
        this.nftId = nftId;
        this.cityIndex = cityIndex;
        this.cardType = cardType;
        this.managerAddress = managerAddress;
        this.managerEmail = managerEmail;
        this.startupTransactionHash = startupTransactionHash;
        this.shutdownTransactionHash = shutdownTransactionHash;
        this.provisioningStatus = provisioningStatus;
        this.tenantStatus = tenantStatus;
        this.date = date;
        this.properties = properties;
    }

    public DeedTenant() {
    }
}

