/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.service;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.lettuce.core.RedisClient;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.redis.RedisConfigurationProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ListenerService
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @Autowired(required=false)
    private RedisConfigurationProperties redisProperties;
    @Autowired(required=false)
    private RedisClient redisClient;
    private ApplicationContext applicationContext;
    private List<EventListener<?>> eventListeners = new ArrayList();
    private Map<String, List<EventListener<?>>> listeners;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        this.initSubscription();
    }

    public void addListener(EventListener<?> listener) {
        List<String> supportedEvents = listener.getSupportedEvents();
        if (!CollectionUtils.isEmpty(supportedEvents)) {
            supportedEvents.forEach(eventName -> this.addListener((String)eventName, listener));
        }
    }

    public void addListener(String eventName, EventListener<?> listener) {
        this.getListeners().computeIfAbsent(eventName, key -> new ArrayList()).add(listener);
    }

    public void removeListsner(String listenerName) {
        Iterator<Map.Entry<String, List<EventListener<?>>>> iterator = this.getListeners().entrySet().iterator();
        iterator.forEachRemaining(entry -> {
            List list = (List)entry.getValue();
            list.removeIf(eventListener -> StringUtils.equals((CharSequence)eventListener.getName(), (CharSequence)listenerName));
            if (list.isEmpty()) {
                iterator.remove();
            }
        });
    }

    public void removeListsner(String eventName, String listenerName) {
        Iterator<Map.Entry<String, List<EventListener<?>>>> iterator = this.getListeners().entrySet().iterator();
        iterator.forEachRemaining(entry -> {
            if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)eventName)) {
                return;
            }
            List list = (List)entry.getValue();
            list.removeIf(eventListener -> StringUtils.equals((CharSequence)eventListener.getName(), (CharSequence)listenerName));
            if (list.isEmpty()) {
                iterator.remove();
            }
        });
    }

    public void publishEvent(String eventName, Object data) {
        Event event = new Event(eventName, data, data == null ? null : data.getClass().getName());
        try {
            StatefulRedisPubSubConnection connection = this.redisClient.connectPubSub();
            RedisPubSubAsyncCommands async = connection.async();
            String eventJsonString = this.serializeObjectToJson(event);
            async.publish((Object)this.getChannelName(), (Object)eventJsonString);
        }
        catch (Exception e) {
            LOG.warn("Redis connection failure, event {} will not be triggered remotely, try to trigger it locally only", (Object)event.getEventName(), (Object)e);
            this.publishEventLocally(event);
        }
    }

    protected void publishEventLocally(Event event) {
        List<EventListener<?>> listenerList = this.getListeners().get(event.getEventName());
        if (!CollectionUtils.isEmpty(listenerList)) {
            listenerList.forEach(listener -> listener.handleEvent(event.getEventName(), event.getData()));
        }
    }

    protected void triggerEvent(Event event) {
        String eventName = event.getEventName();
        Object data = event.getData();
        List<EventListener<?>> listenerList = this.getListeners().get(eventName);
        if (!CollectionUtils.isEmpty(listenerList)) {
            listenerList.forEach(listener -> listener.handleEvent(eventName, data));
        }
    }

    protected void initSubscription() {
        try {
            StatefulRedisPubSubConnection connection = this.redisClient.connectPubSub();
            connection.addListener((RedisPubSubListener)new Listener());
            RedisPubSubAsyncCommands async = connection.async();
            async.subscribe((Object[])new String[]{this.getChannelName()});
        }
        catch (Exception e) {
            LOG.warn("Redis connection failure", (Throwable)e);
        }
    }

    protected Map<String, List<EventListener<?>>> getListeners() {
        if (this.listeners == null) {
            this.initListeners();
        }
        return this.listeners;
    }

    protected synchronized void initListeners() {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        Map eventListenerBeans = this.applicationContext.getBeansOfType(EventListener.class);
        for (EventListener eventListener : eventListenerBeans.values()) {
            this.eventListeners.add(eventListener);
        }
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            this.eventListeners.forEach(this::addListener);
        }
    }

    private String serializeObjectToJson(Event event) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)event);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("An error occurred while parsing POJO object to JSON:" + event, e);
        }
    }

    private String getChannelName() {
        return this.redisProperties.getChannelName();
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }

    public class Listener
    implements RedisPubSubListener<String, String> {
        public void message(String channel, String message) {
            try {
                Event event = (Event)OBJECT_MAPPER.readValue(message, Event.class);
                ListenerService.this.triggerEvent(event);
            }
            catch (Exception e) {
                throw new IllegalStateException("An error occurred while parsing JSON to POJO object:" + message, e);
            }
        }

        public void message(String pattern, String channel, String message) {
            try {
                Event event = (Event)OBJECT_MAPPER.readValue(message, Event.class);
                ListenerService.this.triggerEvent(event);
            }
            catch (Exception e) {
                throw new IllegalStateException("An error occurred while parsing JSON to POJO object:" + message, e);
            }
        }

        public void subscribed(String channel, long count) {
            LOG.info("ListenerService subscribed to channel '{}', count = {}", (Object)channel, (Object)count);
        }

        public void psubscribed(String pattern, long count) {
            LOG.info("ListenerService psubscribed to pattern '{}', count = {}", (Object)pattern, (Object)count);
        }

        public void unsubscribed(String channel, long count) {
            LOG.info("ListenerService unsubscribed to channel '{}', count = {}", (Object)channel, (Object)count);
        }

        public void punsubscribed(String pattern, long count) {
            LOG.info("ListenerService punsubscribed to pattern '{}', count = {}", (Object)pattern, (Object)count);
        }
    }

    public static class EventDeserializer
    extends StdDeserializer<Event> {
        private static final long serialVersionUID = -5369587672932623714L;

        public EventDeserializer() {
            this(null);
        }

        public EventDeserializer(Class<?> vc) {
            super(vc);
        }

        public Event deserialize(JsonParser p, DeserializationContext ctxt) {
            try {
                JsonNode node = (JsonNode)p.getCodec().readTree(p);
                String eventName = node.get("eventName").asText();
                String dataClassName = node.get("dataClassName").asText();
                String dataJson = node.get("data").toString();
                Object data = OBJECT_MAPPER.readValue(dataJson, Class.forName(dataClassName));
                return new Event(eventName, data, dataClassName);
            }
            catch (Exception e) {
                LOG.debug("Error reading value of event", (Throwable)e);
                return null;
            }
        }
    }

    @JsonDeserialize(using=EventDeserializer.class)
    public static class Event {
        private String eventName;
        private Object data;
        private String dataClassName;

        public String getEventName() {
            return this.eventName;
        }

        public Object getData() {
            return this.data;
        }

        public String getDataClassName() {
            return this.dataClassName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public void setDataClassName(String dataClassName) {
            this.dataClassName = dataClassName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Event)) {
                return false;
            }
            Event other = (Event)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$eventName = this.getEventName();
            String other$eventName = other.getEventName();
            if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$dataClassName = this.getDataClassName();
            String other$dataClassName = other.getDataClassName();
            return !(this$dataClassName == null ? other$dataClassName != null : !this$dataClassName.equals(other$dataClassName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Event;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $eventName = this.getEventName();
            result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $dataClassName = this.getDataClassName();
            result = result * 59 + ($dataClassName == null ? 43 : $dataClassName.hashCode());
            return result;
        }

        public String toString() {
            return "ListenerService.Event(eventName=" + this.getEventName() + ", data=" + this.getData() + ", dataClassName=" + this.getDataClassName() + ")";
        }

        public Event() {
        }

        public Event(String eventName, Object data, String dataClassName) {
            this.eventName = eventName;
            this.data = data;
            this.dataClassName = dataClassName;
        }
    }
}

