/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.service;

import io.meeds.deeds.constant.BlockchainLeaseStatus;
import io.meeds.deeds.constant.BlockchainOfferStatus;
import io.meeds.deeds.constant.CommonConstants;
import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.contract.Deed;
import io.meeds.deeds.contract.DeedRenting;
import io.meeds.deeds.contract.DeedTenantProvisioning;
import io.meeds.deeds.contract.ERC20;
import io.meeds.deeds.contract.MeedsToken;
import io.meeds.deeds.contract.TokenFactory;
import io.meeds.deeds.contract.XMeedsNFTRewarding;
import io.meeds.deeds.elasticsearch.model.DeedCity;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.model.DeedLeaseBlockchainState;
import io.meeds.deeds.model.DeedOfferBlockchainState;
import io.meeds.deeds.model.FundInfo;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.crypto.WalletUtils;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple12;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tuples.generated.Tuple5;
import org.web3j.tuples.generated.Tuple8;
import org.web3j.utils.Numeric;

@Component
public class BlockchainService {
    private static final Logger LOG = LoggerFactory.getLogger(BlockchainService.class);
    @Autowired
    @Qualifier(value="ethereumNetwork")
    private Web3j web3j;
    @Autowired(required=false)
    private DeedTenantProvisioning deedTenantProvisioning;
    @Autowired(required=false)
    private DeedRenting deedRenting;
    @Autowired
    private Deed deed;
    @Autowired
    private TokenFactory tokenFactory;
    @Autowired
    private XMeedsNFTRewarding xMeedsToken;
    @Autowired
    @Qualifier(value="ethereumMeedToken")
    private MeedsToken ethereumToken;
    @Autowired
    @Qualifier(value="polygonMeedToken")
    private MeedsToken polygonToken;
    @Autowired
    @Qualifier(value="sushiPairToken")
    private ERC20 sushiPairToken;
    private long networkId;

    public boolean isDeedStarted(long nftId) {
        try {
            return (Boolean)this.deedTenantProvisioning.tenantStatus(BigInteger.valueOf(nftId)).send();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving information 'getDeedCityIndex' from Blockchain", e);
        }
    }

    public boolean isTransactionMined(String transactionHash) {
        TransactionReceipt receipt = this.getTransactionReceipt(transactionHash);
        return receipt != null;
    }

    public boolean isTransactionConfirmed(String transactionHash) {
        TransactionReceipt receipt = this.getTransactionReceipt(transactionHash);
        return receipt != null && receipt.isStatusOK();
    }

    public long getLastBlock() {
        try {
            return ((EthBlockNumber)this.web3j.ethBlockNumber().send()).getBlockNumber().longValue();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting last block number", e);
        }
    }

    public List<DeedTenant> getMinedProvisioningTransactions(long fromBlock, long toBlock) {
        EthFilter ethFilter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), this.deedTenantProvisioning.getContractAddress());
        try {
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                return Collections.emptyList();
            }
            return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).map(this::getTransactionReceipt).filter(TransactionReceipt::isStatusOK).map(this::getMinedDeedTenant).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs", e);
        }
    }

    public List<Map<?, ?>> getMinedRentingTransactions(long fromBlock, long toBlock) {
        EthFilter ethFilter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), this.deedRenting.getContractAddress());
        try {
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                return Collections.emptyList();
            }
            return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).flatMap(transactionHash -> {
                Map<BlockchainOfferStatus, DeedOfferBlockchainState> offerEvents = this.getOfferTransactionEvents((String)transactionHash);
                Map<BlockchainLeaseStatus, DeedLeaseBlockchainState> leaseEvents = this.getLeaseTransactionEvents((String)transactionHash);
                return MapUtils.isEmpty(offerEvents) ? Stream.of(leaseEvents) : (MapUtils.isEmpty(leaseEvents) ? Stream.of(offerEvents) : Stream.of(offerEvents, leaseEvents));
            }).filter(MapUtils::isNotEmpty).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs of mined transactions", e);
        }
    }

    public Set<CommonConstants.DeedOwnershipTransferEvent> getMinedTransferOwnershipDeedTransactions(long fromBlock, long toBlock) {
        EthFilter ethFilter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), this.deed.getContractAddress());
        try {
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                return Collections.emptySet();
            }
            List events = ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).map(this::getTransactionReceipt).filter(TransactionReceipt::isStatusOK).flatMap(this::getTransferOwnershipEvents).filter(Objects::nonNull).collect(Collectors.toList());
            return new LinkedHashSet<CommonConstants.DeedOwnershipTransferEvent>(events);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs", e);
        }
    }

    public Map<BlockchainOfferStatus, DeedOfferBlockchainState> getOfferTransactionEvents(String transactionHash) {
        try {
            List rentPaidEvents;
            List deletedEvents;
            List updatedEvents;
            TransactionReceipt transactionReceipt = ((EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(transactionHash).send()).getTransactionReceipt().orElse(null);
            if (transactionReceipt == null || !transactionReceipt.isStatusOK()) {
                return Collections.emptyMap();
            }
            EnumMap<BlockchainOfferStatus, DeedOfferBlockchainState> events = new EnumMap<BlockchainOfferStatus, DeedOfferBlockchainState>(BlockchainOfferStatus.class);
            List createdEvents = DeedRenting.getOfferCreatedEvents((TransactionReceipt)transactionReceipt);
            if (createdEvents != null && !createdEvents.isEmpty()) {
                if (createdEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one offer creation, {} events. This can't be handled, only first one will be handled", (Object)createdEvents.size());
                }
                DeedRenting.OfferCreatedEventResponse response = (DeedRenting.OfferCreatedEventResponse)createdEvents.get(0);
                DeedOfferBlockchainState deedOffer = this.getOfferById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                events.put(BlockchainOfferStatus.OFFER_CREATED, deedOffer);
            }
            if ((updatedEvents = DeedRenting.getOfferUpdatedEvents((TransactionReceipt)transactionReceipt)) != null && !updatedEvents.isEmpty()) {
                if (updatedEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one offer update, {} events. This can't be handled, only first one will be handled", (Object)updatedEvents.size());
                }
                DeedRenting.OfferUpdatedEventResponse response = (DeedRenting.OfferUpdatedEventResponse)updatedEvents.get(0);
                DeedOfferBlockchainState deedOffer = this.getOfferById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                events.put(BlockchainOfferStatus.OFFER_UPDATED, deedOffer);
            }
            if ((deletedEvents = DeedRenting.getOfferDeletedEvents((TransactionReceipt)transactionReceipt)) != null && !deletedEvents.isEmpty()) {
                if (deletedEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one offer delete, {} events. This can't be handled, only first one will be handled", (Object)deletedEvents.size());
                }
                DeedRenting.OfferDeletedEventResponse response = (DeedRenting.OfferDeletedEventResponse)deletedEvents.get(0);
                DeedOfferBlockchainState deedOffer = new DeedOfferBlockchainState(response.id, transactionReceipt.getBlockNumber(), response.deedId, response.owner, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, Address.DEFAULT.getValue(), BigInteger.ZERO, StringUtils.lowerCase((String)transactionHash));
                events.put(BlockchainOfferStatus.OFFER_DELETED, deedOffer);
            }
            if ((rentPaidEvents = DeedRenting.getRentPaidEvents((TransactionReceipt)transactionReceipt)) != null && !rentPaidEvents.isEmpty()) {
                if (rentPaidEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one rent paid {} events. This can't be handled, only first one will be handled", (Object)rentPaidEvents.size());
                }
                DeedRenting.RentPaidEventResponse response = (DeedRenting.RentPaidEventResponse)rentPaidEvents.get(0);
                DeedOfferBlockchainState deedOffer = this.getOfferById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                if (response.firstRent.booleanValue()) {
                    events.put(BlockchainOfferStatus.OFFER_ACQUIRED, deedOffer);
                }
            }
            return events;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving transaction receipt " + transactionHash + " logs", e);
        }
    }

    public Map<BlockchainLeaseStatus, DeedLeaseBlockchainState> getLeaseTransactionEvents(String transactionHash) {
        try {
            List tenantEvictedEvents;
            List leaseEndedEvents;
            TransactionReceipt transactionReceipt = ((EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(transactionHash).send()).getTransactionReceipt().orElse(null);
            if (transactionReceipt == null || !transactionReceipt.isStatusOK()) {
                return Collections.emptyMap();
            }
            EnumMap<BlockchainLeaseStatus, DeedLeaseBlockchainState> events = new EnumMap<BlockchainLeaseStatus, DeedLeaseBlockchainState>(BlockchainLeaseStatus.class);
            List rentPaidEvents = DeedRenting.getRentPaidEvents((TransactionReceipt)transactionReceipt);
            if (rentPaidEvents != null && !rentPaidEvents.isEmpty()) {
                if (rentPaidEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one rent paid {} events. This can't be handled, only first one will be handled", (Object)rentPaidEvents.size());
                }
                DeedRenting.RentPaidEventResponse response = (DeedRenting.RentPaidEventResponse)rentPaidEvents.get(0);
                DeedLeaseBlockchainState deedLease = this.getLeaseById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                if (response.firstRent.booleanValue()) {
                    events.put(BlockchainLeaseStatus.LEASE_ACQUIRED, deedLease);
                } else {
                    events.put(BlockchainLeaseStatus.LEASE_PAYED, deedLease);
                }
            }
            if ((leaseEndedEvents = DeedRenting.getLeaseEndedEvents((TransactionReceipt)transactionReceipt)) != null && !leaseEndedEvents.isEmpty()) {
                if (leaseEndedEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one lease ended {} events. This can't be handled, only first one will be handled", (Object)leaseEndedEvents.size());
                }
                DeedRenting.LeaseEndedEventResponse response = (DeedRenting.LeaseEndedEventResponse)leaseEndedEvents.get(0);
                DeedLeaseBlockchainState deedLease = this.getLeaseById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                events.put(BlockchainLeaseStatus.LEASE_ENDED, deedLease);
            }
            if ((tenantEvictedEvents = DeedRenting.getTenantEvictedEvents((TransactionReceipt)transactionReceipt)) != null && !tenantEvictedEvents.isEmpty()) {
                if (tenantEvictedEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one tenant evicted {} events. This can't be handled, only first one will be handled", (Object)tenantEvictedEvents.size());
                }
                DeedRenting.TenantEvictedEventResponse response = (DeedRenting.TenantEvictedEventResponse)tenantEvictedEvents.get(0);
                DeedLeaseBlockchainState deedLease = this.getLeaseById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                events.put(BlockchainLeaseStatus.LEASE_MANAGER_EVICTED, deedLease);
            }
            return events;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving transaction receipt " + transactionHash + " logs", e);
        }
    }

    public DeedOfferBlockchainState getOfferById(BigInteger offerId, BigInteger blockNumber, String transactionHash) throws Exception {
        Tuple12 offerTuple = (Tuple12)this.deedRenting.deedOffers(offerId).send();
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            transactionHash = this.getOfferCreationTransactionHash(offerId);
        }
        return new DeedOfferBlockchainState((BigInteger)offerTuple.component1(), blockNumber == null ? BigInteger.ZERO : blockNumber, (BigInteger)offerTuple.component2(), (String)offerTuple.component3(), (BigInteger)offerTuple.component4(), (BigInteger)offerTuple.component5(), (BigInteger)offerTuple.component6(), (BigInteger)offerTuple.component7(), (BigInteger)offerTuple.component8(), (BigInteger)offerTuple.component9(), (BigInteger)offerTuple.component10(), (String)offerTuple.component11(), (BigInteger)offerTuple.component12(), StringUtils.lowerCase((String)transactionHash));
    }

    public DeedLeaseBlockchainState getLeaseById(BigInteger leaseId, BigInteger blockNumber, String transactionHash) throws Exception {
        Tuple8 leaseTuple = (Tuple8)this.deedRenting.deedLeases(leaseId).send();
        return new DeedLeaseBlockchainState((BigInteger)leaseTuple.component1(), blockNumber == null ? BigInteger.ZERO : blockNumber, (BigInteger)leaseTuple.component2(), (BigInteger)leaseTuple.component3(), (BigInteger)leaseTuple.component4(), (BigInteger)leaseTuple.component5(), (BigInteger)leaseTuple.component6(), (BigInteger)leaseTuple.component7(), (String)leaseTuple.component8(), StringUtils.lowerCase((String)transactionHash));
    }

    public boolean isDeedProvisioningManager(String address, long nftId) {
        return WalletUtils.isValidAddress((String)address) && (Boolean)this.blockchainCall(this.deedTenantProvisioning.isProvisioningManager(address, BigInteger.valueOf(nftId))) != false;
    }

    public boolean isDeedOwner(String address, long nftId) {
        return WalletUtils.isValidAddress((String)address) && ((BigInteger)this.blockchainCall(this.deed.balanceOf(address, BigInteger.valueOf(nftId)))).longValue() > 0L;
    }

    public short getDeedCardType(long nftId) throws ObjectNotFoundException {
        try {
            return ((BigInteger)this.deed.cardType(BigInteger.valueOf(nftId)).send()).shortValue();
        }
        catch (Exception e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"execution reverted")) {
                throw new ObjectNotFoundException(e.getMessage());
            }
            throw new IllegalStateException("Error retrieving information 'getDeedCardType' from Blockchain", e);
        }
    }

    public boolean isOfferEnabled(long offerId) throws Exception {
        DeedOfferBlockchainState offer = this.getOfferById(BigInteger.valueOf(offerId), null, "0x");
        if (offer != null && offer.getId().longValue() == offerId) {
            DeedLeaseBlockchainState lease = this.getLeaseById(BigInteger.valueOf(offerId), null, null);
            return lease == null || lease.getId().longValue() == 0L;
        }
        return false;
    }

    public short getDeedCityIndex(long nftId) throws ObjectNotFoundException {
        try {
            return ((BigInteger)this.deed.cityIndex(BigInteger.valueOf(nftId)).send()).shortValue();
        }
        catch (Exception e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"execution reverted")) {
                throw new ObjectNotFoundException(e.getMessage());
            }
            throw new IllegalStateException("Error retrieving information 'getDeedCityIndex' from Blockchain", e);
        }
    }

    public BigDecimal meedsTotalSupplyNoDecimals() {
        BigInteger totalSupply = this.meedsTotalSupply();
        return new BigDecimal(totalSupply).divide(BigDecimal.valueOf(10L).pow(18));
    }

    public BigInteger meedsTotalSupply() {
        return (BigInteger)this.blockchainCall(this.ethereumToken.totalSupply());
    }

    public BigInteger xMeedsTotalSupply() {
        return (BigInteger)this.blockchainCall(this.xMeedsToken.totalSupply());
    }

    public BigInteger sushiPairTotalSupply() {
        return (BigInteger)this.blockchainCall(this.sushiPairToken.totalSupply());
    }

    public FundInfo getFundInfo(String address) {
        Tuple5 fundInfo = (Tuple5)this.blockchainCall(this.tokenFactory.fundInfos(address));
        return fundInfo == null ? null : new FundInfo(address, (BigInteger)fundInfo.component1(), (BigInteger)fundInfo.component2(), (BigInteger)fundInfo.component3(), (BigInteger)fundInfo.component4(), (Boolean)fundInfo.component5());
    }

    public DeedCity getCurrentCity() {
        BigInteger currentCityIndex = (BigInteger)this.blockchainCall(this.xMeedsToken.currentCityIndex());
        Tuple4 cityInfo = (Tuple4)this.blockchainCall(this.xMeedsToken.cityInfo(currentCityIndex));
        return cityInfo == null ? null : new DeedCity(currentCityIndex, (String)cityInfo.component1(), (BigInteger)cityInfo.component2(), (BigInteger)cityInfo.component3(), (BigInteger)cityInfo.component4());
    }

    public FundInfo getXMeedFundInfo() {
        FundInfo fundInfo = this.getFundInfo(this.xMeedsToken.getContractAddress());
        fundInfo.setTotalSupply(this.xMeedsTotalSupply());
        fundInfo.setXMeedPendingReward(this.pendingRewardBalanceOf(this.xMeedsToken.getContractAddress()));
        fundInfo.setMeedsBalance(this.meedBalanceOf(this.xMeedsToken.getContractAddress()));
        return fundInfo;
    }

    public FundInfo getSushiPairFundInfo() {
        FundInfo fundInfo = this.getFundInfo(this.sushiPairToken.getContractAddress());
        fundInfo.setSymbol(this.sushiPairSymbol());
        fundInfo.setLpBalanceOfTokenFactory(this.stakedSushiPair());
        fundInfo.setTotalSupply(this.sushiPairTotalSupply());
        fundInfo.setMeedsBalance(this.meedBalanceOf(this.sushiPairToken.getContractAddress()));
        return fundInfo;
    }

    public BigInteger pendingRewardBalanceOf(String address) {
        return (BigInteger)this.blockchainCall(this.tokenFactory.pendingRewardBalanceOf(address));
    }

    public BigInteger totalAllocationPoints() {
        return (BigInteger)this.blockchainCall(this.tokenFactory.totalAllocationPoints());
    }

    public BigInteger totalFixedPercentage() {
        return (BigInteger)this.blockchainCall(this.tokenFactory.totalFixedPercentage());
    }

    public BigDecimal meedBalanceOfNoDecimals(String address) {
        BigInteger balance = this.meedBalanceOf(address);
        return new BigDecimal(balance).divide(BigDecimal.valueOf(10L).pow(18));
    }

    public BigInteger meedBalanceOf(String address) {
        return (BigInteger)this.blockchainCall(this.ethereumToken.balanceOf(address));
    }

    public String sushiPairSymbol() {
        return (String)this.blockchainCall(this.sushiPairToken.symbol());
    }

    public BigInteger stakedSushiPair() {
        return (BigInteger)this.blockchainCall(this.sushiPairToken.balanceOf(this.tokenFactory.getContractAddress()));
    }

    public BigDecimal meedBalanceOfOnPolygon(String address) {
        BigInteger balance = (BigInteger)this.blockchainCall(this.polygonToken.balanceOf(address));
        return new BigDecimal(balance).divide(BigDecimal.valueOf(10L).pow(18));
    }

    public long getNetworkId() throws IOException {
        if (this.networkId == 0L) {
            this.networkId = new BigInteger(((NetVersion)this.web3j.netVersion().send()).getNetVersion()).longValue();
        }
        return this.networkId;
    }

    public String getOfferCreationTransactionHash(BigInteger offerId) throws IOException {
        try {
            EthFilter ethFilter = (EthFilter)((EthFilter)new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, this.deedRenting.getContractAddress()).addSingleTopic(EventEncoder.encode((Event)DeedRenting.OFFERCREATED_EVENT))).addOptionalTopics(new String[]{Numeric.toHexStringWithPrefixZeroPadded((BigInteger)offerId, (int)64)});
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List logs = ethLog.getLogs();
            if (CollectionUtils.isNotEmpty((Collection)logs)) {
                EthLog.LogResult logResult = (EthLog.LogResult)logs.get(0);
                EthLog.LogObject logObject = (EthLog.LogObject)logResult.get();
                return logObject.getTransactionHash();
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving Offer Creation Hash, return null instead", (Throwable)e);
        }
        return null;
    }

    private Stream<CommonConstants.DeedOwnershipTransferEvent> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List transferSingleEvents = Deed.getTransferSingleEvents((TransactionReceipt)transactionReceipt);
        if (transferSingleEvents != null && !transferSingleEvents.isEmpty()) {
            return transferSingleEvents.stream().map(transferSingleEventResponse -> new CommonConstants.DeedOwnershipTransferEvent(transferSingleEventResponse._id.longValue(), transferSingleEventResponse._from, transferSingleEventResponse._to));
        }
        List transferBatchEvents = Deed.getTransferBatchEvents((TransactionReceipt)transactionReceipt);
        if (transferBatchEvents != null && !transferBatchEvents.isEmpty()) {
            return transferBatchEvents.stream().flatMap(transferBatchEventResponse -> {
                String from = transferBatchEventResponse._from;
                String to = transferBatchEventResponse._to;
                return transferBatchEventResponse._ids.stream().map(nftId -> new CommonConstants.DeedOwnershipTransferEvent(nftId.longValue(), from, to));
            });
        }
        return Stream.empty();
    }

    private DeedTenant getMinedDeedTenant(TransactionReceipt transactionReceipt) {
        List startedEvents = DeedTenantProvisioning.getTenantStartedEvents((TransactionReceipt)transactionReceipt);
        if (startedEvents != null && !startedEvents.isEmpty()) {
            DeedTenantProvisioning.TenantStartedEventResponse tenantStartedEventResponse = (DeedTenantProvisioning.TenantStartedEventResponse)startedEvents.get(0);
            DeedTenant deedTenant = new DeedTenant();
            deedTenant.setNftId(tenantStartedEventResponse.nftId.longValue());
            deedTenant.setStartupTransactionHash(transactionReceipt.getTransactionHash());
            deedTenant.setManagerAddress(tenantStartedEventResponse.manager.toLowerCase());
            return deedTenant;
        }
        List endedEvents = DeedTenantProvisioning.getTenantStoppedEvents((TransactionReceipt)transactionReceipt);
        if (endedEvents != null && !endedEvents.isEmpty()) {
            DeedTenantProvisioning.TenantStoppedEventResponse tenantStoppedEventResponse = (DeedTenantProvisioning.TenantStoppedEventResponse)endedEvents.get(0);
            DeedTenant deedTenant = new DeedTenant();
            deedTenant.setNftId(tenantStoppedEventResponse.nftId.longValue());
            deedTenant.setShutdownTransactionHash(transactionReceipt.getTransactionHash());
            deedTenant.setManagerAddress(tenantStoppedEventResponse.manager.toLowerCase());
            return deedTenant;
        }
        return null;
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash) {
        try {
            EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(transactionHash).send();
            if (ethGetTransactionReceipt != null) {
                return (TransactionReceipt)ethGetTransactionReceipt.getResult();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving Receipt for Transaction with hash: " + transactionHash, e);
        }
        return null;
    }

    private <T> T blockchainCall(RemoteFunctionCall<T> remoteCall) {
        try {
            return (T)remoteCall.send();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error calling blockchain", e);
        }
    }
}

