/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.elasticsearch.model.UserProfile;
import io.meeds.deeds.common.elasticsearch.storage.UserProfileRepository;
import io.meeds.deeds.common.model.UserProfileDTO;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.service.UserProfileService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={UserProfileService.class})
class UserProfileServiceTest {
    private static final String ADDRESS = "address";
    private static final String EMAIL = "email";
    private static final String ID = "@id";
    @MockBean
    private UserProfileRepository userProfileRepository;
    @MockBean
    private ListenerService listenerService;
    @Autowired
    private UserProfileService userProfileService;

    UserProfileServiceTest() {
    }

    @Test
    void testGetUserProfileNull() {
        UserProfileDTO userProfileDTO = this.userProfileService.getUserProfile(ADDRESS);
        Assertions.assertNull((Object)userProfileDTO);
    }

    @Test
    void testGetUserProfile() {
        Mockito.when((Object)this.userProfileRepository.findByAddress(ADDRESS)).thenReturn((Object)new UserProfile(ID, ADDRESS, EMAIL));
        UserProfileDTO userProfileDTO = this.userProfileService.getUserProfile(ADDRESS);
        Assertions.assertNotNull((Object)userProfileDTO);
        Assertions.assertEquals((Object)new UserProfileDTO(ADDRESS, EMAIL), (Object)userProfileDTO);
    }

    @Test
    void testSaveUserProfileWhenNotExists() {
        this.userProfileService.saveUserProfile(new UserProfileDTO(ADDRESS, EMAIL));
        ((UserProfileRepository)Mockito.verify((Object)this.userProfileRepository, (VerificationMode)Mockito.times((int)1))).save((Object)new UserProfile().withAddress(ADDRESS).withEmail(EMAIL));
    }

    @Test
    void testSaveUserProfileWhenExists() {
        Mockito.when((Object)this.userProfileRepository.findByAddress(ADDRESS)).thenReturn((Object)new UserProfile(ID, ADDRESS, EMAIL));
        this.userProfileService.saveUserProfile(new UserProfileDTO(ADDRESS, EMAIL));
        ((UserProfileRepository)Mockito.verify((Object)this.userProfileRepository, (VerificationMode)Mockito.times((int)1))).save((Object)new UserProfile(ID, ADDRESS, EMAIL));
    }
}

