/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.blockchain;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.tx.gas.ContractGasProvider;

public class PolygonWomContractGasProvider
implements ContractGasProvider {
    private static final BigInteger GAS_LIMIT = BigInteger.valueOf(300000L);
    private Web3j web3j;

    public PolygonWomContractGasProvider(Web3j web3j) {
        this.web3j = web3j;
    }

    public BigInteger getGasPrice() {
        BigInteger gasPrice = ((EthGasPrice)this.web3j.ethGasPrice().send()).getGasPrice();
        return new BigDecimal(gasPrice).multiply(BigDecimal.valueOf(1.2)).setScale(0, RoundingMode.HALF_EVEN).toBigInteger();
    }

    public BigInteger getGasPrice(String contractFunc) {
        return this.getGasPrice();
    }

    public BigInteger getGasLimit(String contractFunc) {
        return this.getGasLimit();
    }

    public BigInteger getGasLimit() {
        return GAS_LIMIT;
    }
}

