/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.elasticsearch.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Instant;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="deed_tenant_events", createIndex=true)
@Setting(replicas=0, shards=1)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DeedTenantEvent {
    @Id
    private String id;
    @Field(type=FieldType.Keyword)
    private String eventName;
    private String objectJson;
    @Field(type=FieldType.Keyword)
    private List<String> consumers;
    @Field(type=FieldType.Date, format={DateFormat.epoch_millis})
    private Instant date;

    public DeedTenantEvent(String eventName, String objectJson, List<String> consumers, Instant date) {
        this.eventName = eventName;
        this.objectJson = objectJson;
        this.consumers = consumers;
        this.date = date;
    }

    public String getId() {
        return this.id;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getObjectJson() {
        return this.objectJson;
    }

    public List<String> getConsumers() {
        return this.consumers;
    }

    public Instant getDate() {
        return this.date;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void setObjectJson(String objectJson) {
        this.objectJson = objectJson;
    }

    public void setConsumers(List<String> consumers) {
        this.consumers = consumers;
    }

    public void setDate(Instant date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeedTenantEvent)) {
            return false;
        }
        DeedTenantEvent other = (DeedTenantEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$eventName = this.getEventName();
        String other$eventName = other.getEventName();
        if (this$eventName == null ? other$eventName != null : !this$eventName.equals(other$eventName)) {
            return false;
        }
        String this$objectJson = this.getObjectJson();
        String other$objectJson = other.getObjectJson();
        if (this$objectJson == null ? other$objectJson != null : !this$objectJson.equals(other$objectJson)) {
            return false;
        }
        List<String> this$consumers = this.getConsumers();
        List<String> other$consumers = other.getConsumers();
        if (this$consumers == null ? other$consumers != null : !((Object)this$consumers).equals(other$consumers)) {
            return false;
        }
        Instant this$date = this.getDate();
        Instant other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeedTenantEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $eventName = this.getEventName();
        result = result * 59 + ($eventName == null ? 43 : $eventName.hashCode());
        String $objectJson = this.getObjectJson();
        result = result * 59 + ($objectJson == null ? 43 : $objectJson.hashCode());
        List<String> $consumers = this.getConsumers();
        result = result * 59 + ($consumers == null ? 43 : ((Object)$consumers).hashCode());
        Instant $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public String toString() {
        return "DeedTenantEvent(id=" + this.getId() + ", eventName=" + this.getEventName() + ", objectJson=" + this.getObjectJson() + ", consumers=" + this.getConsumers() + ", date=" + this.getDate() + ")";
    }

    public DeedTenantEvent() {
    }

    public DeedTenantEvent(String id, String eventName, String objectJson, List<String> consumers, Instant date) {
        this.id = id;
        this.eventName = eventName;
        this.objectJson = objectJson;
        this.consumers = consumers;
        this.date = date;
    }
}

