/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.elasticsearch.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Instant;
import java.util.SortedSet;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Document(indexName="hub_report", createIndex=true)
@Setting(replicas=0, shards=1)
public class HubReportEntity {
    @Id
    @Field(type=FieldType.Long)
    private long reportId;
    @Field(type=FieldType.Keyword)
    private long rewardId;
    @Field(type=FieldType.Keyword)
    private String hubAddress;
    @Field(type=FieldType.Keyword)
    private String deedManagerAddress;
    @Field(type=FieldType.Keyword)
    private String ownerAddress;
    @Field(type=FieldType.Integer)
    private int ownerMintingPercentage;
    @Field(type=FieldType.Long)
    private long deedId;
    @Field(type=FieldType.Short)
    private short city;
    @Field(type=FieldType.Short)
    private short cardType;
    @Field(type=FieldType.Short)
    private short mintingPower;
    @Field(type=FieldType.Long)
    private long maxUsers;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant fromDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant toDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant sentDate;
    @Field(type=FieldType.Keyword)
    private String periodType;
    @Field(type=FieldType.Long)
    private long usersCount;
    @Field(type=FieldType.Long)
    private long participantsCount;
    @Field(type=FieldType.Long)
    private long recipientsCount;
    @Field(type=FieldType.Long)
    private long achievementsCount;
    @Field(type=FieldType.Long)
    private long actionsCount;
    @Field(type=FieldType.Text)
    private String rewardTokenAddress;
    @Field(type=FieldType.Long)
    private long rewardTokenNetworkId;
    @Field(type=FieldType.Text)
    private SortedSet<String> transactions;
    @Field(type=FieldType.Double)
    private double hubRewardAmount;
    @Field(type=FieldType.Double)
    private double hubTopRewardedAmount;
    @Field(type=FieldType.Double)
    private double fixedRewardIndex;
    @Field(type=FieldType.Double)
    private double ownerFixedIndex;
    @Field(type=FieldType.Double)
    private double tenantFixedIndex;
    @Field(type=FieldType.Boolean)
    private boolean fraud;
    @Field(type=FieldType.Double)
    private double lastPeriodUemRewardAmount;
    @Field(type=FieldType.Double)
    private double uemRewardAmount;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    @LastModifiedDate
    private Instant updatedDate = Instant.now();
    @Field(type=FieldType.Double)
    private double engagementScore;

    public long getReportId() {
        return this.reportId;
    }

    public long getRewardId() {
        return this.rewardId;
    }

    public String getHubAddress() {
        return this.hubAddress;
    }

    public String getDeedManagerAddress() {
        return this.deedManagerAddress;
    }

    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public int getOwnerMintingPercentage() {
        return this.ownerMintingPercentage;
    }

    public long getDeedId() {
        return this.deedId;
    }

    public short getCity() {
        return this.city;
    }

    public short getCardType() {
        return this.cardType;
    }

    public short getMintingPower() {
        return this.mintingPower;
    }

    public long getMaxUsers() {
        return this.maxUsers;
    }

    public Instant getFromDate() {
        return this.fromDate;
    }

    public Instant getToDate() {
        return this.toDate;
    }

    public Instant getSentDate() {
        return this.sentDate;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public long getUsersCount() {
        return this.usersCount;
    }

    public long getParticipantsCount() {
        return this.participantsCount;
    }

    public long getRecipientsCount() {
        return this.recipientsCount;
    }

    public long getAchievementsCount() {
        return this.achievementsCount;
    }

    public long getActionsCount() {
        return this.actionsCount;
    }

    public String getRewardTokenAddress() {
        return this.rewardTokenAddress;
    }

    public long getRewardTokenNetworkId() {
        return this.rewardTokenNetworkId;
    }

    public SortedSet<String> getTransactions() {
        return this.transactions;
    }

    public double getHubRewardAmount() {
        return this.hubRewardAmount;
    }

    public double getHubTopRewardedAmount() {
        return this.hubTopRewardedAmount;
    }

    public double getFixedRewardIndex() {
        return this.fixedRewardIndex;
    }

    public double getOwnerFixedIndex() {
        return this.ownerFixedIndex;
    }

    public double getTenantFixedIndex() {
        return this.tenantFixedIndex;
    }

    public boolean isFraud() {
        return this.fraud;
    }

    public double getLastPeriodUemRewardAmount() {
        return this.lastPeriodUemRewardAmount;
    }

    public double getUemRewardAmount() {
        return this.uemRewardAmount;
    }

    public Instant getUpdatedDate() {
        return this.updatedDate;
    }

    public double getEngagementScore() {
        return this.engagementScore;
    }

    public void setReportId(long reportId) {
        this.reportId = reportId;
    }

    public void setRewardId(long rewardId) {
        this.rewardId = rewardId;
    }

    public void setHubAddress(String hubAddress) {
        this.hubAddress = hubAddress;
    }

    public void setDeedManagerAddress(String deedManagerAddress) {
        this.deedManagerAddress = deedManagerAddress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public void setOwnerMintingPercentage(int ownerMintingPercentage) {
        this.ownerMintingPercentage = ownerMintingPercentage;
    }

    public void setDeedId(long deedId) {
        this.deedId = deedId;
    }

    public void setCity(short city) {
        this.city = city;
    }

    public void setCardType(short cardType) {
        this.cardType = cardType;
    }

    public void setMintingPower(short mintingPower) {
        this.mintingPower = mintingPower;
    }

    public void setMaxUsers(long maxUsers) {
        this.maxUsers = maxUsers;
    }

    public void setFromDate(Instant fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Instant toDate) {
        this.toDate = toDate;
    }

    public void setSentDate(Instant sentDate) {
        this.sentDate = sentDate;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public void setUsersCount(long usersCount) {
        this.usersCount = usersCount;
    }

    public void setParticipantsCount(long participantsCount) {
        this.participantsCount = participantsCount;
    }

    public void setRecipientsCount(long recipientsCount) {
        this.recipientsCount = recipientsCount;
    }

    public void setAchievementsCount(long achievementsCount) {
        this.achievementsCount = achievementsCount;
    }

    public void setActionsCount(long actionsCount) {
        this.actionsCount = actionsCount;
    }

    public void setRewardTokenAddress(String rewardTokenAddress) {
        this.rewardTokenAddress = rewardTokenAddress;
    }

    public void setRewardTokenNetworkId(long rewardTokenNetworkId) {
        this.rewardTokenNetworkId = rewardTokenNetworkId;
    }

    public void setTransactions(SortedSet<String> transactions) {
        this.transactions = transactions;
    }

    public void setHubRewardAmount(double hubRewardAmount) {
        this.hubRewardAmount = hubRewardAmount;
    }

    public void setHubTopRewardedAmount(double hubTopRewardedAmount) {
        this.hubTopRewardedAmount = hubTopRewardedAmount;
    }

    public void setFixedRewardIndex(double fixedRewardIndex) {
        this.fixedRewardIndex = fixedRewardIndex;
    }

    public void setOwnerFixedIndex(double ownerFixedIndex) {
        this.ownerFixedIndex = ownerFixedIndex;
    }

    public void setTenantFixedIndex(double tenantFixedIndex) {
        this.tenantFixedIndex = tenantFixedIndex;
    }

    public void setFraud(boolean fraud) {
        this.fraud = fraud;
    }

    public void setLastPeriodUemRewardAmount(double lastPeriodUemRewardAmount) {
        this.lastPeriodUemRewardAmount = lastPeriodUemRewardAmount;
    }

    public void setUemRewardAmount(double uemRewardAmount) {
        this.uemRewardAmount = uemRewardAmount;
    }

    public void setUpdatedDate(Instant updatedDate) {
        this.updatedDate = updatedDate;
    }

    public void setEngagementScore(double engagementScore) {
        this.engagementScore = engagementScore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HubReportEntity)) {
            return false;
        }
        HubReportEntity other = (HubReportEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReportId() != other.getReportId()) {
            return false;
        }
        if (this.getRewardId() != other.getRewardId()) {
            return false;
        }
        if (this.getOwnerMintingPercentage() != other.getOwnerMintingPercentage()) {
            return false;
        }
        if (this.getDeedId() != other.getDeedId()) {
            return false;
        }
        if (this.getCity() != other.getCity()) {
            return false;
        }
        if (this.getCardType() != other.getCardType()) {
            return false;
        }
        if (this.getMintingPower() != other.getMintingPower()) {
            return false;
        }
        if (this.getMaxUsers() != other.getMaxUsers()) {
            return false;
        }
        if (this.getUsersCount() != other.getUsersCount()) {
            return false;
        }
        if (this.getParticipantsCount() != other.getParticipantsCount()) {
            return false;
        }
        if (this.getRecipientsCount() != other.getRecipientsCount()) {
            return false;
        }
        if (this.getAchievementsCount() != other.getAchievementsCount()) {
            return false;
        }
        if (this.getActionsCount() != other.getActionsCount()) {
            return false;
        }
        if (this.getRewardTokenNetworkId() != other.getRewardTokenNetworkId()) {
            return false;
        }
        if (Double.compare(this.getHubRewardAmount(), other.getHubRewardAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getHubTopRewardedAmount(), other.getHubTopRewardedAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getFixedRewardIndex(), other.getFixedRewardIndex()) != 0) {
            return false;
        }
        if (Double.compare(this.getOwnerFixedIndex(), other.getOwnerFixedIndex()) != 0) {
            return false;
        }
        if (Double.compare(this.getTenantFixedIndex(), other.getTenantFixedIndex()) != 0) {
            return false;
        }
        if (this.isFraud() != other.isFraud()) {
            return false;
        }
        if (Double.compare(this.getLastPeriodUemRewardAmount(), other.getLastPeriodUemRewardAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getUemRewardAmount(), other.getUemRewardAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getEngagementScore(), other.getEngagementScore()) != 0) {
            return false;
        }
        String this$hubAddress = this.getHubAddress();
        String other$hubAddress = other.getHubAddress();
        if (this$hubAddress == null ? other$hubAddress != null : !this$hubAddress.equals(other$hubAddress)) {
            return false;
        }
        String this$deedManagerAddress = this.getDeedManagerAddress();
        String other$deedManagerAddress = other.getDeedManagerAddress();
        if (this$deedManagerAddress == null ? other$deedManagerAddress != null : !this$deedManagerAddress.equals(other$deedManagerAddress)) {
            return false;
        }
        String this$ownerAddress = this.getOwnerAddress();
        String other$ownerAddress = other.getOwnerAddress();
        if (this$ownerAddress == null ? other$ownerAddress != null : !this$ownerAddress.equals(other$ownerAddress)) {
            return false;
        }
        Instant this$fromDate = this.getFromDate();
        Instant other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        Instant this$toDate = this.getToDate();
        Instant other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        Instant this$sentDate = this.getSentDate();
        Instant other$sentDate = other.getSentDate();
        if (this$sentDate == null ? other$sentDate != null : !((Object)this$sentDate).equals(other$sentDate)) {
            return false;
        }
        String this$periodType = this.getPeriodType();
        String other$periodType = other.getPeriodType();
        if (this$periodType == null ? other$periodType != null : !this$periodType.equals(other$periodType)) {
            return false;
        }
        String this$rewardTokenAddress = this.getRewardTokenAddress();
        String other$rewardTokenAddress = other.getRewardTokenAddress();
        if (this$rewardTokenAddress == null ? other$rewardTokenAddress != null : !this$rewardTokenAddress.equals(other$rewardTokenAddress)) {
            return false;
        }
        SortedSet<String> this$transactions = this.getTransactions();
        SortedSet<String> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !this$transactions.equals(other$transactions)) {
            return false;
        }
        Instant this$updatedDate = this.getUpdatedDate();
        Instant other$updatedDate = other.getUpdatedDate();
        return !(this$updatedDate == null ? other$updatedDate != null : !((Object)this$updatedDate).equals(other$updatedDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HubReportEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $reportId = this.getReportId();
        result = result * 59 + (int)($reportId >>> 32 ^ $reportId);
        long $rewardId = this.getRewardId();
        result = result * 59 + (int)($rewardId >>> 32 ^ $rewardId);
        result = result * 59 + this.getOwnerMintingPercentage();
        long $deedId = this.getDeedId();
        result = result * 59 + (int)($deedId >>> 32 ^ $deedId);
        result = result * 59 + this.getCity();
        result = result * 59 + this.getCardType();
        result = result * 59 + this.getMintingPower();
        long $maxUsers = this.getMaxUsers();
        result = result * 59 + (int)($maxUsers >>> 32 ^ $maxUsers);
        long $usersCount = this.getUsersCount();
        result = result * 59 + (int)($usersCount >>> 32 ^ $usersCount);
        long $participantsCount = this.getParticipantsCount();
        result = result * 59 + (int)($participantsCount >>> 32 ^ $participantsCount);
        long $recipientsCount = this.getRecipientsCount();
        result = result * 59 + (int)($recipientsCount >>> 32 ^ $recipientsCount);
        long $achievementsCount = this.getAchievementsCount();
        result = result * 59 + (int)($achievementsCount >>> 32 ^ $achievementsCount);
        long $actionsCount = this.getActionsCount();
        result = result * 59 + (int)($actionsCount >>> 32 ^ $actionsCount);
        long $rewardTokenNetworkId = this.getRewardTokenNetworkId();
        result = result * 59 + (int)($rewardTokenNetworkId >>> 32 ^ $rewardTokenNetworkId);
        long $hubRewardAmount = Double.doubleToLongBits(this.getHubRewardAmount());
        result = result * 59 + (int)($hubRewardAmount >>> 32 ^ $hubRewardAmount);
        long $hubTopRewardedAmount = Double.doubleToLongBits(this.getHubTopRewardedAmount());
        result = result * 59 + (int)($hubTopRewardedAmount >>> 32 ^ $hubTopRewardedAmount);
        long $fixedRewardIndex = Double.doubleToLongBits(this.getFixedRewardIndex());
        result = result * 59 + (int)($fixedRewardIndex >>> 32 ^ $fixedRewardIndex);
        long $ownerFixedIndex = Double.doubleToLongBits(this.getOwnerFixedIndex());
        result = result * 59 + (int)($ownerFixedIndex >>> 32 ^ $ownerFixedIndex);
        long $tenantFixedIndex = Double.doubleToLongBits(this.getTenantFixedIndex());
        result = result * 59 + (int)($tenantFixedIndex >>> 32 ^ $tenantFixedIndex);
        result = result * 59 + (this.isFraud() ? 79 : 97);
        long $lastPeriodUemRewardAmount = Double.doubleToLongBits(this.getLastPeriodUemRewardAmount());
        result = result * 59 + (int)($lastPeriodUemRewardAmount >>> 32 ^ $lastPeriodUemRewardAmount);
        long $uemRewardAmount = Double.doubleToLongBits(this.getUemRewardAmount());
        result = result * 59 + (int)($uemRewardAmount >>> 32 ^ $uemRewardAmount);
        long $engagementScore = Double.doubleToLongBits(this.getEngagementScore());
        result = result * 59 + (int)($engagementScore >>> 32 ^ $engagementScore);
        String $hubAddress = this.getHubAddress();
        result = result * 59 + ($hubAddress == null ? 43 : $hubAddress.hashCode());
        String $deedManagerAddress = this.getDeedManagerAddress();
        result = result * 59 + ($deedManagerAddress == null ? 43 : $deedManagerAddress.hashCode());
        String $ownerAddress = this.getOwnerAddress();
        result = result * 59 + ($ownerAddress == null ? 43 : $ownerAddress.hashCode());
        Instant $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        Instant $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        Instant $sentDate = this.getSentDate();
        result = result * 59 + ($sentDate == null ? 43 : ((Object)$sentDate).hashCode());
        String $periodType = this.getPeriodType();
        result = result * 59 + ($periodType == null ? 43 : $periodType.hashCode());
        String $rewardTokenAddress = this.getRewardTokenAddress();
        result = result * 59 + ($rewardTokenAddress == null ? 43 : $rewardTokenAddress.hashCode());
        SortedSet<String> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : $transactions.hashCode());
        Instant $updatedDate = this.getUpdatedDate();
        result = result * 59 + ($updatedDate == null ? 43 : ((Object)$updatedDate).hashCode());
        return result;
    }

    public String toString() {
        return "HubReportEntity(reportId=" + this.getReportId() + ", rewardId=" + this.getRewardId() + ", hubAddress=" + this.getHubAddress() + ", deedManagerAddress=" + this.getDeedManagerAddress() + ", ownerAddress=" + this.getOwnerAddress() + ", ownerMintingPercentage=" + this.getOwnerMintingPercentage() + ", deedId=" + this.getDeedId() + ", city=" + this.getCity() + ", cardType=" + this.getCardType() + ", mintingPower=" + this.getMintingPower() + ", maxUsers=" + this.getMaxUsers() + ", fromDate=" + this.getFromDate() + ", toDate=" + this.getToDate() + ", sentDate=" + this.getSentDate() + ", periodType=" + this.getPeriodType() + ", usersCount=" + this.getUsersCount() + ", participantsCount=" + this.getParticipantsCount() + ", recipientsCount=" + this.getRecipientsCount() + ", achievementsCount=" + this.getAchievementsCount() + ", actionsCount=" + this.getActionsCount() + ", rewardTokenAddress=" + this.getRewardTokenAddress() + ", rewardTokenNetworkId=" + this.getRewardTokenNetworkId() + ", transactions=" + this.getTransactions() + ", hubRewardAmount=" + this.getHubRewardAmount() + ", hubTopRewardedAmount=" + this.getHubTopRewardedAmount() + ", fixedRewardIndex=" + this.getFixedRewardIndex() + ", ownerFixedIndex=" + this.getOwnerFixedIndex() + ", tenantFixedIndex=" + this.getTenantFixedIndex() + ", fraud=" + this.isFraud() + ", lastPeriodUemRewardAmount=" + this.getLastPeriodUemRewardAmount() + ", uemRewardAmount=" + this.getUemRewardAmount() + ", updatedDate=" + this.getUpdatedDate() + ", engagementScore=" + this.getEngagementScore() + ")";
    }

    public HubReportEntity() {
    }

    public HubReportEntity(long reportId, long rewardId, String hubAddress, String deedManagerAddress, String ownerAddress, int ownerMintingPercentage, long deedId, short city, short cardType, short mintingPower, long maxUsers, Instant fromDate, Instant toDate, Instant sentDate, String periodType, long usersCount, long participantsCount, long recipientsCount, long achievementsCount, long actionsCount, String rewardTokenAddress, long rewardTokenNetworkId, SortedSet<String> transactions, double hubRewardAmount, double hubTopRewardedAmount, double fixedRewardIndex, double ownerFixedIndex, double tenantFixedIndex, boolean fraud, double lastPeriodUemRewardAmount, double uemRewardAmount, Instant updatedDate, double engagementScore) {
        this.reportId = reportId;
        this.rewardId = rewardId;
        this.hubAddress = hubAddress;
        this.deedManagerAddress = deedManagerAddress;
        this.ownerAddress = ownerAddress;
        this.ownerMintingPercentage = ownerMintingPercentage;
        this.deedId = deedId;
        this.city = city;
        this.cardType = cardType;
        this.mintingPower = mintingPower;
        this.maxUsers = maxUsers;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.sentDate = sentDate;
        this.periodType = periodType;
        this.usersCount = usersCount;
        this.participantsCount = participantsCount;
        this.recipientsCount = recipientsCount;
        this.achievementsCount = achievementsCount;
        this.actionsCount = actionsCount;
        this.rewardTokenAddress = rewardTokenAddress;
        this.rewardTokenNetworkId = rewardTokenNetworkId;
        this.transactions = transactions;
        this.hubRewardAmount = hubRewardAmount;
        this.hubTopRewardedAmount = hubTopRewardedAmount;
        this.fixedRewardIndex = fixedRewardIndex;
        this.ownerFixedIndex = ownerFixedIndex;
        this.tenantFixedIndex = tenantFixedIndex;
        this.fraud = fraud;
        this.lastPeriodUemRewardAmount = lastPeriodUemRewardAmount;
        this.uemRewardAmount = uemRewardAmount;
        this.updatedDate = updatedDate;
        this.engagementScore = engagementScore;
    }
}

