/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.meeds.deeds.common.constant.DeedCard;
import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.constant.NoticePeriod;
import io.meeds.deeds.common.constant.RentalPaymentPeriodicity;
import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.TenantStatus;
import io.meeds.deeds.common.constant.TransactionStatus;
import java.time.Instant;
import org.springframework.hateoas.server.core.Relation;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Relation(collectionRelation="leases", itemRelation="lease")
public class DeedTenantLeaseDTO {
    private long id;
    private long nftId;
    private DeedCity city;
    private DeedCard cardType;
    private TenantStatus tenantStatus;
    private TenantProvisioningStatus provisioningStatus;
    private int months;
    private int paidMonths;
    private int monthPaymentInProgress;
    private String ownerAddress;
    private String managerAddress;
    private RentalPaymentPeriodicity paymentPeriodicity;
    private double amount;
    private double allDurationAmount;
    private double distributedAmount;
    private NoticePeriod noticePeriod;
    private int ownerMintingPercentage;
    private double mintingPower;
    private TransactionStatus transactionStatus;
    private Instant startDate;
    private Instant endDate;
    private Instant noticeDate;
    private Instant paidRentsDate;
    private boolean confirmed;
    private boolean endingLease;
    private String endingLeaseAddress;

    public long getId() {
        return this.id;
    }

    public long getNftId() {
        return this.nftId;
    }

    public DeedCity getCity() {
        return this.city;
    }

    public DeedCard getCardType() {
        return this.cardType;
    }

    public TenantStatus getTenantStatus() {
        return this.tenantStatus;
    }

    public TenantProvisioningStatus getProvisioningStatus() {
        return this.provisioningStatus;
    }

    public int getMonths() {
        return this.months;
    }

    public int getPaidMonths() {
        return this.paidMonths;
    }

    public int getMonthPaymentInProgress() {
        return this.monthPaymentInProgress;
    }

    public String getOwnerAddress() {
        return this.ownerAddress;
    }

    public String getManagerAddress() {
        return this.managerAddress;
    }

    public RentalPaymentPeriodicity getPaymentPeriodicity() {
        return this.paymentPeriodicity;
    }

    public double getAmount() {
        return this.amount;
    }

    public double getAllDurationAmount() {
        return this.allDurationAmount;
    }

    public double getDistributedAmount() {
        return this.distributedAmount;
    }

    public NoticePeriod getNoticePeriod() {
        return this.noticePeriod;
    }

    public int getOwnerMintingPercentage() {
        return this.ownerMintingPercentage;
    }

    public double getMintingPower() {
        return this.mintingPower;
    }

    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public Instant getEndDate() {
        return this.endDate;
    }

    public Instant getNoticeDate() {
        return this.noticeDate;
    }

    public Instant getPaidRentsDate() {
        return this.paidRentsDate;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public boolean isEndingLease() {
        return this.endingLease;
    }

    public String getEndingLeaseAddress() {
        return this.endingLeaseAddress;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setNftId(long nftId) {
        this.nftId = nftId;
    }

    public void setCity(DeedCity city) {
        this.city = city;
    }

    public void setCardType(DeedCard cardType) {
        this.cardType = cardType;
    }

    public void setTenantStatus(TenantStatus tenantStatus) {
        this.tenantStatus = tenantStatus;
    }

    public void setProvisioningStatus(TenantProvisioningStatus provisioningStatus) {
        this.provisioningStatus = provisioningStatus;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public void setPaidMonths(int paidMonths) {
        this.paidMonths = paidMonths;
    }

    public void setMonthPaymentInProgress(int monthPaymentInProgress) {
        this.monthPaymentInProgress = monthPaymentInProgress;
    }

    public void setOwnerAddress(String ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public void setManagerAddress(String managerAddress) {
        this.managerAddress = managerAddress;
    }

    public void setPaymentPeriodicity(RentalPaymentPeriodicity paymentPeriodicity) {
        this.paymentPeriodicity = paymentPeriodicity;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setAllDurationAmount(double allDurationAmount) {
        this.allDurationAmount = allDurationAmount;
    }

    public void setDistributedAmount(double distributedAmount) {
        this.distributedAmount = distributedAmount;
    }

    public void setNoticePeriod(NoticePeriod noticePeriod) {
        this.noticePeriod = noticePeriod;
    }

    public void setOwnerMintingPercentage(int ownerMintingPercentage) {
        this.ownerMintingPercentage = ownerMintingPercentage;
    }

    public void setMintingPower(double mintingPower) {
        this.mintingPower = mintingPower;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public void setStartDate(Instant startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(Instant endDate) {
        this.endDate = endDate;
    }

    public void setNoticeDate(Instant noticeDate) {
        this.noticeDate = noticeDate;
    }

    public void setPaidRentsDate(Instant paidRentsDate) {
        this.paidRentsDate = paidRentsDate;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public void setEndingLease(boolean endingLease) {
        this.endingLease = endingLease;
    }

    public void setEndingLeaseAddress(String endingLeaseAddress) {
        this.endingLeaseAddress = endingLeaseAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeedTenantLeaseDTO)) {
            return false;
        }
        DeedTenantLeaseDTO other = (DeedTenantLeaseDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getNftId() != other.getNftId()) {
            return false;
        }
        if (this.getMonths() != other.getMonths()) {
            return false;
        }
        if (this.getPaidMonths() != other.getPaidMonths()) {
            return false;
        }
        if (this.getMonthPaymentInProgress() != other.getMonthPaymentInProgress()) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getAllDurationAmount(), other.getAllDurationAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getDistributedAmount(), other.getDistributedAmount()) != 0) {
            return false;
        }
        if (this.getOwnerMintingPercentage() != other.getOwnerMintingPercentage()) {
            return false;
        }
        if (Double.compare(this.getMintingPower(), other.getMintingPower()) != 0) {
            return false;
        }
        if (this.isConfirmed() != other.isConfirmed()) {
            return false;
        }
        if (this.isEndingLease() != other.isEndingLease()) {
            return false;
        }
        DeedCity this$city = this.getCity();
        DeedCity other$city = other.getCity();
        if (this$city == null ? other$city != null : !((Object)((Object)this$city)).equals((Object)other$city)) {
            return false;
        }
        DeedCard this$cardType = this.getCardType();
        DeedCard other$cardType = other.getCardType();
        if (this$cardType == null ? other$cardType != null : !((Object)((Object)this$cardType)).equals((Object)other$cardType)) {
            return false;
        }
        TenantStatus this$tenantStatus = this.getTenantStatus();
        TenantStatus other$tenantStatus = other.getTenantStatus();
        if (this$tenantStatus == null ? other$tenantStatus != null : !((Object)((Object)this$tenantStatus)).equals((Object)other$tenantStatus)) {
            return false;
        }
        TenantProvisioningStatus this$provisioningStatus = this.getProvisioningStatus();
        TenantProvisioningStatus other$provisioningStatus = other.getProvisioningStatus();
        if (this$provisioningStatus == null ? other$provisioningStatus != null : !((Object)((Object)this$provisioningStatus)).equals((Object)other$provisioningStatus)) {
            return false;
        }
        String this$ownerAddress = this.getOwnerAddress();
        String other$ownerAddress = other.getOwnerAddress();
        if (this$ownerAddress == null ? other$ownerAddress != null : !this$ownerAddress.equals(other$ownerAddress)) {
            return false;
        }
        String this$managerAddress = this.getManagerAddress();
        String other$managerAddress = other.getManagerAddress();
        if (this$managerAddress == null ? other$managerAddress != null : !this$managerAddress.equals(other$managerAddress)) {
            return false;
        }
        RentalPaymentPeriodicity this$paymentPeriodicity = this.getPaymentPeriodicity();
        RentalPaymentPeriodicity other$paymentPeriodicity = other.getPaymentPeriodicity();
        if (this$paymentPeriodicity == null ? other$paymentPeriodicity != null : !((Object)((Object)this$paymentPeriodicity)).equals((Object)other$paymentPeriodicity)) {
            return false;
        }
        NoticePeriod this$noticePeriod = this.getNoticePeriod();
        NoticePeriod other$noticePeriod = other.getNoticePeriod();
        if (this$noticePeriod == null ? other$noticePeriod != null : !((Object)((Object)this$noticePeriod)).equals((Object)other$noticePeriod)) {
            return false;
        }
        TransactionStatus this$transactionStatus = this.getTransactionStatus();
        TransactionStatus other$transactionStatus = other.getTransactionStatus();
        if (this$transactionStatus == null ? other$transactionStatus != null : !((Object)((Object)this$transactionStatus)).equals((Object)other$transactionStatus)) {
            return false;
        }
        Instant this$startDate = this.getStartDate();
        Instant other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Instant this$endDate = this.getEndDate();
        Instant other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Instant this$noticeDate = this.getNoticeDate();
        Instant other$noticeDate = other.getNoticeDate();
        if (this$noticeDate == null ? other$noticeDate != null : !((Object)this$noticeDate).equals(other$noticeDate)) {
            return false;
        }
        Instant this$paidRentsDate = this.getPaidRentsDate();
        Instant other$paidRentsDate = other.getPaidRentsDate();
        if (this$paidRentsDate == null ? other$paidRentsDate != null : !((Object)this$paidRentsDate).equals(other$paidRentsDate)) {
            return false;
        }
        String this$endingLeaseAddress = this.getEndingLeaseAddress();
        String other$endingLeaseAddress = other.getEndingLeaseAddress();
        return !(this$endingLeaseAddress == null ? other$endingLeaseAddress != null : !this$endingLeaseAddress.equals(other$endingLeaseAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeedTenantLeaseDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $nftId = this.getNftId();
        result = result * 59 + (int)($nftId >>> 32 ^ $nftId);
        result = result * 59 + this.getMonths();
        result = result * 59 + this.getPaidMonths();
        result = result * 59 + this.getMonthPaymentInProgress();
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $allDurationAmount = Double.doubleToLongBits(this.getAllDurationAmount());
        result = result * 59 + (int)($allDurationAmount >>> 32 ^ $allDurationAmount);
        long $distributedAmount = Double.doubleToLongBits(this.getDistributedAmount());
        result = result * 59 + (int)($distributedAmount >>> 32 ^ $distributedAmount);
        result = result * 59 + this.getOwnerMintingPercentage();
        long $mintingPower = Double.doubleToLongBits(this.getMintingPower());
        result = result * 59 + (int)($mintingPower >>> 32 ^ $mintingPower);
        result = result * 59 + (this.isConfirmed() ? 79 : 97);
        result = result * 59 + (this.isEndingLease() ? 79 : 97);
        DeedCity $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : ((Object)((Object)$city)).hashCode());
        DeedCard $cardType = this.getCardType();
        result = result * 59 + ($cardType == null ? 43 : ((Object)((Object)$cardType)).hashCode());
        TenantStatus $tenantStatus = this.getTenantStatus();
        result = result * 59 + ($tenantStatus == null ? 43 : ((Object)((Object)$tenantStatus)).hashCode());
        TenantProvisioningStatus $provisioningStatus = this.getProvisioningStatus();
        result = result * 59 + ($provisioningStatus == null ? 43 : ((Object)((Object)$provisioningStatus)).hashCode());
        String $ownerAddress = this.getOwnerAddress();
        result = result * 59 + ($ownerAddress == null ? 43 : $ownerAddress.hashCode());
        String $managerAddress = this.getManagerAddress();
        result = result * 59 + ($managerAddress == null ? 43 : $managerAddress.hashCode());
        RentalPaymentPeriodicity $paymentPeriodicity = this.getPaymentPeriodicity();
        result = result * 59 + ($paymentPeriodicity == null ? 43 : ((Object)((Object)$paymentPeriodicity)).hashCode());
        NoticePeriod $noticePeriod = this.getNoticePeriod();
        result = result * 59 + ($noticePeriod == null ? 43 : ((Object)((Object)$noticePeriod)).hashCode());
        TransactionStatus $transactionStatus = this.getTransactionStatus();
        result = result * 59 + ($transactionStatus == null ? 43 : ((Object)((Object)$transactionStatus)).hashCode());
        Instant $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Instant $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Instant $noticeDate = this.getNoticeDate();
        result = result * 59 + ($noticeDate == null ? 43 : ((Object)$noticeDate).hashCode());
        Instant $paidRentsDate = this.getPaidRentsDate();
        result = result * 59 + ($paidRentsDate == null ? 43 : ((Object)$paidRentsDate).hashCode());
        String $endingLeaseAddress = this.getEndingLeaseAddress();
        result = result * 59 + ($endingLeaseAddress == null ? 43 : $endingLeaseAddress.hashCode());
        return result;
    }

    public String toString() {
        return "DeedTenantLeaseDTO(id=" + this.getId() + ", nftId=" + this.getNftId() + ", city=" + this.getCity() + ", cardType=" + this.getCardType() + ", tenantStatus=" + this.getTenantStatus() + ", provisioningStatus=" + this.getProvisioningStatus() + ", months=" + this.getMonths() + ", paidMonths=" + this.getPaidMonths() + ", monthPaymentInProgress=" + this.getMonthPaymentInProgress() + ", ownerAddress=" + this.getOwnerAddress() + ", managerAddress=" + this.getManagerAddress() + ", paymentPeriodicity=" + this.getPaymentPeriodicity() + ", amount=" + this.getAmount() + ", allDurationAmount=" + this.getAllDurationAmount() + ", distributedAmount=" + this.getDistributedAmount() + ", noticePeriod=" + this.getNoticePeriod() + ", ownerMintingPercentage=" + this.getOwnerMintingPercentage() + ", mintingPower=" + this.getMintingPower() + ", transactionStatus=" + this.getTransactionStatus() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", noticeDate=" + this.getNoticeDate() + ", paidRentsDate=" + this.getPaidRentsDate() + ", confirmed=" + this.isConfirmed() + ", endingLease=" + this.isEndingLease() + ", endingLeaseAddress=" + this.getEndingLeaseAddress() + ")";
    }

    public DeedTenantLeaseDTO() {
    }

    public DeedTenantLeaseDTO(long id, long nftId, DeedCity city, DeedCard cardType, TenantStatus tenantStatus, TenantProvisioningStatus provisioningStatus, int months, int paidMonths, int monthPaymentInProgress, String ownerAddress, String managerAddress, RentalPaymentPeriodicity paymentPeriodicity, double amount, double allDurationAmount, double distributedAmount, NoticePeriod noticePeriod, int ownerMintingPercentage, double mintingPower, TransactionStatus transactionStatus, Instant startDate, Instant endDate, Instant noticeDate, Instant paidRentsDate, boolean confirmed, boolean endingLease, String endingLeaseAddress) {
        this.id = id;
        this.nftId = nftId;
        this.city = city;
        this.cardType = cardType;
        this.tenantStatus = tenantStatus;
        this.provisioningStatus = provisioningStatus;
        this.months = months;
        this.paidMonths = paidMonths;
        this.monthPaymentInProgress = monthPaymentInProgress;
        this.ownerAddress = ownerAddress;
        this.managerAddress = managerAddress;
        this.paymentPeriodicity = paymentPeriodicity;
        this.amount = amount;
        this.allDurationAmount = allDurationAmount;
        this.distributedAmount = distributedAmount;
        this.noticePeriod = noticePeriod;
        this.ownerMintingPercentage = ownerMintingPercentage;
        this.mintingPower = mintingPower;
        this.transactionStatus = transactionStatus;
        this.startDate = startDate;
        this.endDate = endDate;
        this.noticeDate = noticeDate;
        this.paidRentsDate = paidRentsDate;
        this.confirmed = confirmed;
        this.endingLease = endingLease;
        this.endingLeaseAddress = endingLeaseAddress;
    }
}

