/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.elasticsearch.model.HubReportEntity;
import io.meeds.deeds.common.elasticsearch.model.UemRewardEntity;
import io.meeds.deeds.common.elasticsearch.storage.HubReportRepository;
import io.meeds.deeds.common.elasticsearch.storage.UemRewardRepository;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.HubReportService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.wom.api.constant.WomAuthorizationException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportPayload;
import io.meeds.wom.api.model.HubReportVerifiableData;
import java.nio.charset.StandardCharsets;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

@SpringBootTest(classes={HubReportService.class})
@ExtendWith(value={MockitoExtension.class})
public class HubReportServiceTest {
    private static final Pageable PAGEABLE = Pageable.ofSize((int)10);
    @MockBean
    private BlockchainService blockchainService;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private HubReportRepository reportRepository;
    @MockBean
    private UemRewardRepository rewardRepository;
    @Autowired
    private HubReportService hubReportService;
    private Credentials hubCredentials = Credentials.create((String)"0x1da4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    private String hubAddress = this.hubCredentials.getAddress();
    private long deedId = 3L;
    private long reportId = 56684L;
    private long rewardId = 6398841L;
    private long periodStartTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private long periodEndTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(2L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private short city = 1;
    private short cardType = (short)3;
    private short mintingPower = (short)120;
    private long maxUsers = Long.MAX_VALUE;
    private int ownerMintingPercentage = 60;
    private double fixedRewardIndex = 0.005446;
    private double ownerFixedIndex = 0.0032676;
    private double tenantFixedIndex = 0.0021784;
    private double engagementScore = 1.23;
    private double lastPeriodUemRewardAmount = 84.0;
    private double uemRewardAmount = 90.0;
    private double hubRewardAmount = 150.0;
    private double hubTopRewardedAmount = 12.365;
    private Instant updatedDate = Instant.now();
    private boolean fraud = false;
    private long usersCount = 125L;
    private long participantsCount = 85L;
    private long recipientsCount = 65L;
    private int achievementsCount = 55698;
    private int actionsCount = 55698;
    private String rewardTokenAddress = "0x334d85047da64738c065d36e10b2adeb965000d0";
    private long rewardTokenNetworkId = 1L;
    private String deedManagerAddress = "0x609a6f01b7976439603356e41d5456b42df957b7";
    private String ownerAddress = "0x27d282d1e7e790df596f50a234602d9e761d22aa";
    private String periodType = "WEEK";
    private String txHash = "0xef4e9db309b5dd7020ce463ae726b4d0759e1de0635661de91d8d98e83ae2862";
    private Instant sentDate = Instant.now();

    @Test
    void getReportsByHub() {
        Mockito.when((Object)this.reportRepository.findByHubAddress((String)ArgumentMatchers.eq((Object)StringUtils.lowerCase((String)this.hubAddress)), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Arrays.asList(this.newHubReportEntity())));
        Page reports = this.hubReportService.getReportsByHub(this.hubAddress, PAGEABLE);
        Assert.assertNotNull((Object)reports);
        Assertions.assertEquals((int)1, (int)reports.getSize());
        HubReport report = (HubReport)reports.getContent().get(0);
        Assert.assertNotNull((Object)report);
        Assertions.assertEquals((long)report.getReportId(), (long)this.reportId);
        Assertions.assertEquals((long)report.getRewardId(), (long)this.rewardId);
        Assertions.assertEquals((Object)report.getHubAddress(), (Object)StringUtils.lowerCase((String)this.hubAddress));
        Assertions.assertEquals((Object)report.getDeedManagerAddress(), (Object)StringUtils.lowerCase((String)this.deedManagerAddress));
        Assertions.assertEquals((Object)report.getOwnerAddress(), (Object)StringUtils.lowerCase((String)this.ownerAddress));
        Assertions.assertEquals((int)report.getOwnerMintingPercentage(), (int)this.ownerMintingPercentage);
        Assertions.assertEquals((long)report.getDeedId(), (long)this.deedId);
        Assertions.assertEquals((short)report.getCity(), (short)this.city);
        Assertions.assertEquals((short)report.getCardType(), (short)this.cardType);
        Assertions.assertEquals((short)report.getMintingPower(), (short)this.mintingPower);
        Assertions.assertEquals((long)report.getMaxUsers(), (long)this.maxUsers);
        Assertions.assertEquals((Object)report.getFromDate(), (Object)this.fromDate());
        Assertions.assertEquals((Object)report.getToDate(), (Object)this.toDate());
        Assertions.assertEquals((Object)report.getSentDate(), (Object)this.sentDate);
        Assertions.assertEquals((Object)report.getPeriodType(), (Object)this.periodType);
        Assertions.assertEquals((long)report.getUsersCount(), (long)this.usersCount);
        Assertions.assertEquals((long)report.getParticipantsCount(), (long)this.participantsCount);
        Assertions.assertEquals((long)report.getRecipientsCount(), (long)this.recipientsCount);
        Assertions.assertEquals((long)report.getAchievementsCount(), (long)this.achievementsCount);
        Assertions.assertEquals((long)report.getActionsCount(), (long)this.actionsCount);
        Assertions.assertEquals((Object)report.getRewardTokenAddress(), (Object)this.rewardTokenAddress);
        Assertions.assertEquals((long)report.getRewardTokenNetworkId(), (long)this.rewardTokenNetworkId);
        Assertions.assertEquals((Object)report.getTransactions(), this.transactions());
        Assertions.assertEquals((double)report.getHubRewardAmount(), (double)this.hubRewardAmount);
        Assertions.assertEquals((double)report.getHubTopRewardedAmount(), (double)this.hubTopRewardedAmount);
        Assertions.assertEquals((double)report.getFixedRewardIndex(), (double)this.fixedRewardIndex);
        Assertions.assertEquals((double)report.getOwnerFixedIndex(), (double)this.ownerFixedIndex);
        Assertions.assertEquals((double)report.getTenantFixedIndex(), (double)this.tenantFixedIndex);
        Assertions.assertEquals((Object)report.isFraud(), (Object)this.fraud);
        Assertions.assertEquals((double)report.getLastPeriodUemRewardAmount(), (double)this.lastPeriodUemRewardAmount);
        Assertions.assertEquals((double)report.getUemRewardAmount(), (double)this.uemRewardAmount);
        Assertions.assertEquals((Object)report.getUpdatedDate(), (Object)this.updatedDate);
    }

    @Test
    void getReportsByRewardIdByPage() {
        Mockito.when((Object)this.reportRepository.findByRewardId(ArgumentMatchers.eq((long)this.rewardId), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Arrays.asList(this.newHubReportEntity())));
        Page reports = this.hubReportService.getReportsByRewardId(this.rewardId, PAGEABLE);
        Assert.assertNotNull((Object)reports);
        Assertions.assertEquals((int)1, (int)reports.getSize());
        HubReport report = (HubReport)reports.getContent().get(0);
        Assert.assertNotNull((Object)report);
        Assertions.assertEquals((long)report.getReportId(), (long)this.reportId);
        Assertions.assertEquals((long)report.getRewardId(), (long)this.rewardId);
        Assertions.assertEquals((Object)report.getHubAddress(), (Object)StringUtils.lowerCase((String)this.hubAddress));
        Assertions.assertEquals((Object)report.getDeedManagerAddress(), (Object)StringUtils.lowerCase((String)this.deedManagerAddress));
        Assertions.assertEquals((Object)report.getOwnerAddress(), (Object)StringUtils.lowerCase((String)this.ownerAddress));
        Assertions.assertEquals((int)report.getOwnerMintingPercentage(), (int)this.ownerMintingPercentage);
        Assertions.assertEquals((long)report.getDeedId(), (long)this.deedId);
        Assertions.assertEquals((short)report.getCity(), (short)this.city);
        Assertions.assertEquals((short)report.getCardType(), (short)this.cardType);
        Assertions.assertEquals((short)report.getMintingPower(), (short)this.mintingPower);
        Assertions.assertEquals((long)report.getMaxUsers(), (long)this.maxUsers);
        Assertions.assertEquals((Object)report.getFromDate(), (Object)this.fromDate());
        Assertions.assertEquals((Object)report.getToDate(), (Object)this.toDate());
        Assertions.assertEquals((Object)report.getSentDate(), (Object)this.sentDate);
        Assertions.assertEquals((Object)report.getPeriodType(), (Object)this.periodType);
        Assertions.assertEquals((long)report.getUsersCount(), (long)this.usersCount);
        Assertions.assertEquals((long)report.getParticipantsCount(), (long)this.participantsCount);
        Assertions.assertEquals((long)report.getRecipientsCount(), (long)this.recipientsCount);
        Assertions.assertEquals((long)report.getAchievementsCount(), (long)this.achievementsCount);
        Assertions.assertEquals((long)report.getActionsCount(), (long)this.actionsCount);
        Assertions.assertEquals((Object)report.getRewardTokenAddress(), (Object)this.rewardTokenAddress);
        Assertions.assertEquals((long)report.getRewardTokenNetworkId(), (long)this.rewardTokenNetworkId);
        Assertions.assertEquals((Object)report.getTransactions(), this.transactions());
        Assertions.assertEquals((double)report.getHubRewardAmount(), (double)this.hubRewardAmount);
        Assertions.assertEquals((double)report.getHubTopRewardedAmount(), (double)this.hubTopRewardedAmount);
        Assertions.assertEquals((double)report.getFixedRewardIndex(), (double)this.fixedRewardIndex);
        Assertions.assertEquals((double)report.getOwnerFixedIndex(), (double)this.ownerFixedIndex);
        Assertions.assertEquals((double)report.getTenantFixedIndex(), (double)this.tenantFixedIndex);
        Assertions.assertEquals((Object)report.isFraud(), (Object)this.fraud);
        Assertions.assertEquals((double)report.getLastPeriodUemRewardAmount(), (double)this.lastPeriodUemRewardAmount);
        Assertions.assertEquals((double)report.getUemRewardAmount(), (double)this.uemRewardAmount);
        Assertions.assertEquals((Object)report.getUpdatedDate(), (Object)this.updatedDate);
    }

    @Test
    void getReportsByRewardId() {
        Mockito.when((Object)this.reportRepository.findByRewardId(ArgumentMatchers.eq((long)this.rewardId))).thenReturn(Stream.of(this.newHubReportEntity()));
        List reports = this.hubReportService.getReportsByRewardId(this.rewardId);
        Assert.assertNotNull((Object)reports);
        Assertions.assertEquals((int)1, (int)reports.size());
        HubReport report = (HubReport)reports.get(0);
        Assert.assertNotNull((Object)report);
        Assertions.assertEquals((long)report.getReportId(), (long)this.reportId);
        Assertions.assertEquals((long)report.getRewardId(), (long)this.rewardId);
        Assertions.assertEquals((Object)report.getHubAddress(), (Object)StringUtils.lowerCase((String)this.hubAddress));
        Assertions.assertEquals((Object)report.getDeedManagerAddress(), (Object)StringUtils.lowerCase((String)this.deedManagerAddress));
        Assertions.assertEquals((Object)report.getOwnerAddress(), (Object)StringUtils.lowerCase((String)this.ownerAddress));
        Assertions.assertEquals((int)report.getOwnerMintingPercentage(), (int)this.ownerMintingPercentage);
        Assertions.assertEquals((long)report.getDeedId(), (long)this.deedId);
        Assertions.assertEquals((short)report.getCity(), (short)this.city);
        Assertions.assertEquals((short)report.getCardType(), (short)this.cardType);
        Assertions.assertEquals((short)report.getMintingPower(), (short)this.mintingPower);
        Assertions.assertEquals((long)report.getMaxUsers(), (long)this.maxUsers);
        Assertions.assertEquals((Object)report.getFromDate(), (Object)this.fromDate());
        Assertions.assertEquals((Object)report.getToDate(), (Object)this.toDate());
        Assertions.assertEquals((Object)report.getSentDate(), (Object)this.sentDate);
        Assertions.assertEquals((Object)report.getPeriodType(), (Object)this.periodType);
        Assertions.assertEquals((long)report.getUsersCount(), (long)this.usersCount);
        Assertions.assertEquals((long)report.getParticipantsCount(), (long)this.participantsCount);
        Assertions.assertEquals((long)report.getRecipientsCount(), (long)this.recipientsCount);
        Assertions.assertEquals((long)report.getAchievementsCount(), (long)this.achievementsCount);
        Assertions.assertEquals((long)report.getActionsCount(), (long)this.actionsCount);
        Assertions.assertEquals((Object)report.getRewardTokenAddress(), (Object)this.rewardTokenAddress);
        Assertions.assertEquals((long)report.getRewardTokenNetworkId(), (long)this.rewardTokenNetworkId);
        Assertions.assertEquals((Object)report.getTransactions(), this.transactions());
        Assertions.assertEquals((double)report.getHubRewardAmount(), (double)this.hubRewardAmount);
        Assertions.assertEquals((double)report.getHubTopRewardedAmount(), (double)this.hubTopRewardedAmount);
        Assertions.assertEquals((double)report.getFixedRewardIndex(), (double)this.fixedRewardIndex);
        Assertions.assertEquals((double)report.getOwnerFixedIndex(), (double)this.ownerFixedIndex);
        Assertions.assertEquals((double)report.getTenantFixedIndex(), (double)this.tenantFixedIndex);
        Assertions.assertEquals((Object)report.isFraud(), (Object)this.fraud);
        Assertions.assertEquals((double)report.getLastPeriodUemRewardAmount(), (double)this.lastPeriodUemRewardAmount);
        Assertions.assertEquals((double)report.getUemRewardAmount(), (double)this.uemRewardAmount);
        Assertions.assertEquals((Object)report.getUpdatedDate(), (Object)this.updatedDate);
    }

    @Test
    void getAllReports() {
        Mockito.when((Object)this.reportRepository.findAll((Pageable)ArgumentMatchers.any(Pageable.class))).thenReturn((Object)new PageImpl(Arrays.asList(this.newHubReportEntity())));
        Page reports = this.hubReportService.getReports(null, 0L, PAGEABLE);
        Assert.assertNotNull((Object)reports);
        Assertions.assertEquals((int)1, (int)reports.getSize());
        HubReport report = (HubReport)reports.getContent().get(0);
        Assert.assertNotNull((Object)report);
        Assertions.assertEquals((long)report.getReportId(), (long)this.reportId);
        Assertions.assertEquals((long)report.getRewardId(), (long)this.rewardId);
        Assertions.assertEquals((Object)report.getHubAddress(), (Object)StringUtils.lowerCase((String)this.hubAddress));
        Assertions.assertEquals((Object)report.getDeedManagerAddress(), (Object)StringUtils.lowerCase((String)this.deedManagerAddress));
        Assertions.assertEquals((Object)report.getOwnerAddress(), (Object)StringUtils.lowerCase((String)this.ownerAddress));
        Assertions.assertEquals((int)report.getOwnerMintingPercentage(), (int)this.ownerMintingPercentage);
        Assertions.assertEquals((long)report.getDeedId(), (long)this.deedId);
        Assertions.assertEquals((short)report.getCity(), (short)this.city);
        Assertions.assertEquals((short)report.getCardType(), (short)this.cardType);
        Assertions.assertEquals((short)report.getMintingPower(), (short)this.mintingPower);
        Assertions.assertEquals((long)report.getMaxUsers(), (long)this.maxUsers);
        Assertions.assertEquals((Object)report.getFromDate(), (Object)this.fromDate());
        Assertions.assertEquals((Object)report.getToDate(), (Object)this.toDate());
        Assertions.assertEquals((Object)report.getSentDate(), (Object)this.sentDate);
        Assertions.assertEquals((Object)report.getPeriodType(), (Object)this.periodType);
        Assertions.assertEquals((long)report.getUsersCount(), (long)this.usersCount);
        Assertions.assertEquals((long)report.getParticipantsCount(), (long)this.participantsCount);
        Assertions.assertEquals((long)report.getRecipientsCount(), (long)this.recipientsCount);
        Assertions.assertEquals((long)report.getAchievementsCount(), (long)this.achievementsCount);
        Assertions.assertEquals((long)report.getActionsCount(), (long)this.actionsCount);
        Assertions.assertEquals((Object)report.getRewardTokenAddress(), (Object)this.rewardTokenAddress);
        Assertions.assertEquals((long)report.getRewardTokenNetworkId(), (long)this.rewardTokenNetworkId);
        Assertions.assertEquals((Object)report.getTransactions(), this.transactions());
        Assertions.assertEquals((double)report.getHubRewardAmount(), (double)this.hubRewardAmount);
        Assertions.assertEquals((double)report.getHubTopRewardedAmount(), (double)this.hubTopRewardedAmount);
        Assertions.assertEquals((double)report.getFixedRewardIndex(), (double)this.fixedRewardIndex);
        Assertions.assertEquals((double)report.getOwnerFixedIndex(), (double)this.ownerFixedIndex);
        Assertions.assertEquals((double)report.getTenantFixedIndex(), (double)this.tenantFixedIndex);
        Assertions.assertEquals((Object)report.isFraud(), (Object)this.fraud);
        Assertions.assertEquals((double)report.getLastPeriodUemRewardAmount(), (double)this.lastPeriodUemRewardAmount);
        Assertions.assertEquals((double)report.getUemRewardAmount(), (double)this.uemRewardAmount);
        Assertions.assertEquals((Object)report.getUpdatedDate(), (Object)this.updatedDate);
    }

    @Test
    void getReportsByHubAndRewardId() {
        Mockito.when((Object)this.reportRepository.findByRewardIdAndHubAddress(ArgumentMatchers.eq((long)this.rewardId), (String)ArgumentMatchers.eq((Object)StringUtils.lowerCase((String)this.hubAddress)), (Pageable)ArgumentMatchers.any(Pageable.class))).thenReturn((Object)new PageImpl(Arrays.asList(this.newHubReportEntity())));
        Page reports = this.hubReportService.getReports(this.hubAddress, this.rewardId, PAGEABLE);
        Assert.assertNotNull((Object)reports);
        Assertions.assertEquals((int)1, (int)reports.getSize());
        HubReport report = (HubReport)reports.getContent().get(0);
        Assert.assertNotNull((Object)report);
        Assertions.assertEquals((long)report.getReportId(), (long)this.reportId);
        Assertions.assertEquals((long)report.getRewardId(), (long)this.rewardId);
        Assertions.assertEquals((Object)report.getHubAddress(), (Object)StringUtils.lowerCase((String)this.hubAddress));
        Assertions.assertEquals((Object)report.getDeedManagerAddress(), (Object)StringUtils.lowerCase((String)this.deedManagerAddress));
        Assertions.assertEquals((Object)report.getOwnerAddress(), (Object)StringUtils.lowerCase((String)this.ownerAddress));
        Assertions.assertEquals((int)report.getOwnerMintingPercentage(), (int)this.ownerMintingPercentage);
        Assertions.assertEquals((long)report.getDeedId(), (long)this.deedId);
        Assertions.assertEquals((short)report.getCity(), (short)this.city);
        Assertions.assertEquals((short)report.getCardType(), (short)this.cardType);
        Assertions.assertEquals((short)report.getMintingPower(), (short)this.mintingPower);
        Assertions.assertEquals((long)report.getMaxUsers(), (long)this.maxUsers);
        Assertions.assertEquals((Object)report.getFromDate(), (Object)this.fromDate());
        Assertions.assertEquals((Object)report.getToDate(), (Object)this.toDate());
        Assertions.assertEquals((Object)report.getSentDate(), (Object)this.sentDate);
        Assertions.assertEquals((Object)report.getPeriodType(), (Object)this.periodType);
        Assertions.assertEquals((long)report.getUsersCount(), (long)this.usersCount);
        Assertions.assertEquals((long)report.getParticipantsCount(), (long)this.participantsCount);
        Assertions.assertEquals((long)report.getRecipientsCount(), (long)this.recipientsCount);
        Assertions.assertEquals((long)report.getAchievementsCount(), (long)this.achievementsCount);
        Assertions.assertEquals((long)report.getActionsCount(), (long)this.actionsCount);
        Assertions.assertEquals((Object)report.getRewardTokenAddress(), (Object)this.rewardTokenAddress);
        Assertions.assertEquals((long)report.getRewardTokenNetworkId(), (long)this.rewardTokenNetworkId);
        Assertions.assertEquals((Object)report.getTransactions(), this.transactions());
        Assertions.assertEquals((double)report.getHubRewardAmount(), (double)this.hubRewardAmount);
        Assertions.assertEquals((double)report.getHubTopRewardedAmount(), (double)this.hubTopRewardedAmount);
        Assertions.assertEquals((double)report.getFixedRewardIndex(), (double)this.fixedRewardIndex);
        Assertions.assertEquals((double)report.getOwnerFixedIndex(), (double)this.ownerFixedIndex);
        Assertions.assertEquals((double)report.getTenantFixedIndex(), (double)this.tenantFixedIndex);
        Assertions.assertEquals((Object)report.isFraud(), (Object)this.fraud);
        Assertions.assertEquals((double)report.getLastPeriodUemRewardAmount(), (double)this.lastPeriodUemRewardAmount);
        Assertions.assertEquals((double)report.getUemRewardAmount(), (double)this.uemRewardAmount);
        Assertions.assertEquals((Object)report.getUpdatedDate(), (Object)this.updatedDate);
    }

    @Test
    void getReportByHubAndRewardId() {
        HubReport report = this.hubReportService.getReport(this.rewardId, this.hubAddress);
        Assert.assertNull((Object)report);
        Mockito.when((Object)this.reportRepository.findByRewardIdAndHubAddress(ArgumentMatchers.eq((long)this.rewardId), (String)ArgumentMatchers.eq((Object)StringUtils.lowerCase((String)this.hubAddress)))).thenReturn(Optional.of(this.newHubReportEntity()));
        report = this.hubReportService.getReport(this.rewardId, this.hubAddress);
        Assert.assertNotNull((Object)report);
        Assertions.assertEquals((long)report.getReportId(), (long)this.reportId);
        Assertions.assertEquals((long)report.getRewardId(), (long)this.rewardId);
        Assertions.assertEquals((Object)report.getHubAddress(), (Object)StringUtils.lowerCase((String)this.hubAddress));
        Assertions.assertEquals((Object)report.getDeedManagerAddress(), (Object)StringUtils.lowerCase((String)this.deedManagerAddress));
        Assertions.assertEquals((Object)report.getOwnerAddress(), (Object)StringUtils.lowerCase((String)this.ownerAddress));
        Assertions.assertEquals((int)report.getOwnerMintingPercentage(), (int)this.ownerMintingPercentage);
        Assertions.assertEquals((long)report.getDeedId(), (long)this.deedId);
        Assertions.assertEquals((short)report.getCity(), (short)this.city);
        Assertions.assertEquals((short)report.getCardType(), (short)this.cardType);
        Assertions.assertEquals((short)report.getMintingPower(), (short)this.mintingPower);
        Assertions.assertEquals((long)report.getMaxUsers(), (long)this.maxUsers);
        Assertions.assertEquals((Object)report.getFromDate(), (Object)this.fromDate());
        Assertions.assertEquals((Object)report.getToDate(), (Object)this.toDate());
        Assertions.assertEquals((Object)report.getSentDate(), (Object)this.sentDate);
        Assertions.assertEquals((Object)report.getPeriodType(), (Object)this.periodType);
        Assertions.assertEquals((long)report.getUsersCount(), (long)this.usersCount);
        Assertions.assertEquals((long)report.getParticipantsCount(), (long)this.participantsCount);
        Assertions.assertEquals((long)report.getRecipientsCount(), (long)this.recipientsCount);
        Assertions.assertEquals((long)report.getAchievementsCount(), (long)this.achievementsCount);
        Assertions.assertEquals((long)report.getActionsCount(), (long)this.actionsCount);
        Assertions.assertEquals((Object)report.getRewardTokenAddress(), (Object)this.rewardTokenAddress);
        Assertions.assertEquals((long)report.getRewardTokenNetworkId(), (long)this.rewardTokenNetworkId);
        Assertions.assertEquals((Object)report.getTransactions(), this.transactions());
        Assertions.assertEquals((double)report.getHubRewardAmount(), (double)this.hubRewardAmount);
        Assertions.assertEquals((double)report.getHubTopRewardedAmount(), (double)this.hubTopRewardedAmount);
        Assertions.assertEquals((double)report.getFixedRewardIndex(), (double)this.fixedRewardIndex);
        Assertions.assertEquals((double)report.getOwnerFixedIndex(), (double)this.ownerFixedIndex);
        Assertions.assertEquals((double)report.getTenantFixedIndex(), (double)this.tenantFixedIndex);
        Assertions.assertEquals((Object)report.isFraud(), (Object)this.fraud);
        Assertions.assertEquals((double)report.getLastPeriodUemRewardAmount(), (double)this.lastPeriodUemRewardAmount);
        Assertions.assertEquals((double)report.getUemRewardAmount(), (double)this.uemRewardAmount);
        Assertions.assertEquals((Object)report.getUpdatedDate(), (Object)this.updatedDate);
    }

    @Test
    void getReportById() {
        Mockito.when((Object)this.reportRepository.findById((Object)this.reportId)).thenReturn(Optional.of(this.newHubReportEntity()));
        HubReport report = this.hubReportService.getReport(this.reportId);
        Assert.assertNotNull((Object)report);
        Assertions.assertEquals((long)report.getReportId(), (long)this.reportId);
        Assertions.assertEquals((long)report.getRewardId(), (long)this.rewardId);
        Assertions.assertEquals((Object)report.getHubAddress(), (Object)StringUtils.lowerCase((String)this.hubAddress));
        Assertions.assertEquals((Object)report.getDeedManagerAddress(), (Object)StringUtils.lowerCase((String)this.deedManagerAddress));
        Assertions.assertEquals((Object)report.getOwnerAddress(), (Object)StringUtils.lowerCase((String)this.ownerAddress));
        Assertions.assertEquals((int)report.getOwnerMintingPercentage(), (int)this.ownerMintingPercentage);
        Assertions.assertEquals((long)report.getDeedId(), (long)this.deedId);
        Assertions.assertEquals((short)report.getCity(), (short)this.city);
        Assertions.assertEquals((short)report.getCardType(), (short)this.cardType);
        Assertions.assertEquals((short)report.getMintingPower(), (short)this.mintingPower);
        Assertions.assertEquals((long)report.getMaxUsers(), (long)this.maxUsers);
        Assertions.assertEquals((Object)report.getFromDate(), (Object)this.fromDate());
        Assertions.assertEquals((Object)report.getToDate(), (Object)this.toDate());
        Assertions.assertEquals((Object)report.getSentDate(), (Object)this.sentDate);
        Assertions.assertEquals((Object)report.getPeriodType(), (Object)this.periodType);
        Assertions.assertEquals((long)report.getUsersCount(), (long)this.usersCount);
        Assertions.assertEquals((long)report.getParticipantsCount(), (long)this.participantsCount);
        Assertions.assertEquals((long)report.getRecipientsCount(), (long)this.recipientsCount);
        Assertions.assertEquals((long)report.getAchievementsCount(), (long)this.achievementsCount);
        Assertions.assertEquals((long)report.getActionsCount(), (long)this.actionsCount);
        Assertions.assertEquals((Object)report.getRewardTokenAddress(), (Object)this.rewardTokenAddress);
        Assertions.assertEquals((long)report.getRewardTokenNetworkId(), (long)this.rewardTokenNetworkId);
        Assertions.assertEquals((Object)report.getTransactions(), this.transactions());
        Assertions.assertEquals((double)report.getHubRewardAmount(), (double)this.hubRewardAmount);
        Assertions.assertEquals((double)report.getHubTopRewardedAmount(), (double)this.hubTopRewardedAmount);
        Assertions.assertEquals((double)report.getFixedRewardIndex(), (double)this.fixedRewardIndex);
        Assertions.assertEquals((double)report.getOwnerFixedIndex(), (double)this.ownerFixedIndex);
        Assertions.assertEquals((double)report.getTenantFixedIndex(), (double)this.tenantFixedIndex);
        Assertions.assertEquals((Object)report.isFraud(), (Object)this.fraud);
        Assertions.assertEquals((double)report.getLastPeriodUemRewardAmount(), (double)this.lastPeriodUemRewardAmount);
        Assertions.assertEquals((double)report.getUemRewardAmount(), (double)this.uemRewardAmount);
        Assertions.assertEquals((Object)report.getUpdatedDate(), (Object)this.updatedDate);
    }

    @Test
    void getReportByIdWhenNotFound() {
        Mockito.when((Object)this.blockchainService.retrieveReportProperties(this.reportId)).thenReturn((Object)this.newHubReport());
        HubReport report = this.hubReportService.getReport(this.reportId);
        Assert.assertNotNull((Object)report);
        Assertions.assertEquals((long)report.getReportId(), (long)this.reportId);
        Assertions.assertEquals((long)report.getRewardId(), (long)this.rewardId);
        Assertions.assertEquals((Object)report.getHubAddress(), (Object)StringUtils.lowerCase((String)this.hubAddress));
        Assertions.assertEquals((Object)report.getDeedManagerAddress(), (Object)StringUtils.lowerCase((String)this.deedManagerAddress));
        Assertions.assertEquals((Object)report.getOwnerAddress(), (Object)StringUtils.lowerCase((String)this.ownerAddress));
        Assertions.assertEquals((int)report.getOwnerMintingPercentage(), (int)this.ownerMintingPercentage);
        Assertions.assertEquals((long)report.getDeedId(), (long)this.deedId);
        Assertions.assertEquals((short)report.getCity(), (short)this.city);
        Assertions.assertEquals((short)report.getCardType(), (short)this.cardType);
        Assertions.assertEquals((short)report.getMintingPower(), (short)this.mintingPower);
        Assertions.assertEquals((long)report.getMaxUsers(), (long)this.maxUsers);
        Assertions.assertEquals((Object)report.getFromDate(), (Object)this.fromDate());
        Assertions.assertEquals((Object)report.getToDate(), (Object)this.toDate());
        Assertions.assertEquals((Object)report.getSentDate(), (Object)this.sentDate);
        Assertions.assertEquals((Object)report.getPeriodType(), (Object)this.periodType);
        Assertions.assertEquals((long)report.getUsersCount(), (long)this.usersCount);
        Assertions.assertEquals((long)report.getParticipantsCount(), (long)this.participantsCount);
        Assertions.assertEquals((long)report.getRecipientsCount(), (long)this.recipientsCount);
        Assertions.assertEquals((long)report.getAchievementsCount(), (long)this.achievementsCount);
        Assertions.assertEquals((long)report.getActionsCount(), (long)this.actionsCount);
        Assertions.assertEquals((Object)report.getRewardTokenAddress(), (Object)this.rewardTokenAddress);
        Assertions.assertEquals((long)report.getRewardTokenNetworkId(), (long)this.rewardTokenNetworkId);
        Assertions.assertEquals((Object)report.getTransactions(), this.transactions());
        Assertions.assertEquals((double)report.getHubRewardAmount(), (double)this.hubRewardAmount);
        Assertions.assertEquals((double)report.getHubTopRewardedAmount(), (double)this.hubTopRewardedAmount);
        Assertions.assertEquals((double)report.getFixedRewardIndex(), (double)this.fixedRewardIndex);
        Assertions.assertEquals((double)report.getOwnerFixedIndex(), (double)this.ownerFixedIndex);
        Assertions.assertEquals((double)report.getTenantFixedIndex(), (double)this.tenantFixedIndex);
        Assertions.assertEquals((Object)report.isFraud(), (Object)this.fraud);
        Assertions.assertEquals((double)report.getLastPeriodUemRewardAmount(), (double)this.lastPeriodUemRewardAmount);
        Assertions.assertEquals((double)report.getUemRewardAmount(), (double)this.uemRewardAmount);
        Assertions.assertEquals((Object)report.getUpdatedDate(), (Object)this.updatedDate);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.report.saved", (Object)this.reportId);
    }

    @Test
    void saveReportWhenUnverified() {
        HubReportVerifiableData hubReportVerifiableData = this.newHubReportVerifiableData();
        hubReportVerifiableData.setSignature(hubReportVerifiableData.getSignature().replace("1", "2"));
        Assertions.assertThrows(WomAuthorizationException.class, () -> this.hubReportService.saveReport(hubReportVerifiableData));
    }

    @Test
    void saveReport() throws WomException {
        HubReportVerifiableData hubReportVerifiableData = this.newHubReportVerifiableData();
        HubReport report = this.hubReportService.saveReport(hubReportVerifiableData);
        Assert.assertNotNull((Object)report);
        ((HubReportRepository)Mockito.verify((Object)this.reportRepository)).save((Object)((HubReportEntity)ArgumentMatchers.any()));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.report.saved", (Object)this.reportId);
    }

    @Test
    void refreshReportFraudWhenNotFound() {
        Mockito.when((Object)this.reportRepository.findById((Object)this.reportId)).thenReturn(Optional.empty());
        this.hubReportService.refreshReportFraud(this.reportId);
        ((HubReportRepository)Mockito.verify((Object)this.reportRepository, (VerificationMode)Mockito.never())).save((Object)((HubReportEntity)ArgumentMatchers.any()));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).publishEvent("uem.report.saved", (Object)this.reportId);
    }

    @Test
    void refreshReportFraudWhenFalse() {
        HubReportEntity hubReportEntity = this.newHubReportEntity();
        Mockito.when((Object)this.reportRepository.findById((Object)this.reportId)).thenReturn(Optional.of(hubReportEntity));
        this.hubReportService.refreshReportFraud(this.reportId);
        ((HubReportRepository)Mockito.verify((Object)this.reportRepository)).save((Object)((HubReportEntity)ArgumentMatchers.any()));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.report.saved", (Object)this.reportId);
        Assertions.assertFalse((boolean)hubReportEntity.isFraud());
    }

    @Test
    void refreshReportFraudWhenTrue() {
        HubReportEntity hubReportEntity = this.newHubReportEntity();
        Mockito.when((Object)this.reportRepository.findById((Object)this.reportId)).thenReturn(Optional.of(hubReportEntity));
        Mockito.when((Object)this.blockchainService.isReportFraud(this.reportId)).thenReturn((Object)true);
        this.hubReportService.refreshReportFraud(this.reportId);
        ((HubReportRepository)Mockito.verify((Object)this.reportRepository)).save((Object)((HubReportEntity)ArgumentMatchers.any()));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.report.saved", (Object)this.reportId);
        Assertions.assertTrue((boolean)hubReportEntity.isFraud());
    }

    @Test
    void computeUemRewardWhenFraud() {
        Mockito.when((Object)this.reportRepository.findById((Object)this.reportId)).thenReturn(Optional.of(this.newHubReportEntity()));
        HubReport hubReport = this.newHubReport();
        hubReport.setFraud(true);
        this.hubReportService.computeUemReward(hubReport, 2.0, this.fixedRewardIndex * 2.0);
        Assertions.assertEquals((double)0.0, (double)hubReport.getUemRewardAmount());
        ((HubReportRepository)Mockito.verify((Object)this.reportRepository)).save((Object)((HubReportEntity)ArgumentMatchers.any()));
    }

    @Test
    void computeUemReward() {
        Mockito.when((Object)this.reportRepository.findById((Object)this.reportId)).thenReturn(Optional.of(this.newHubReportEntity()));
        HubReport hubReport = this.newHubReport();
        this.hubReportService.computeUemReward(hubReport, this.fixedRewardIndex * 2.0, 2.0);
        Assertions.assertEquals((double)1.0, (double)hubReport.getUemRewardAmount());
        ((HubReportRepository)Mockito.verify((Object)this.reportRepository)).save((Object)((HubReportEntity)ArgumentMatchers.any()));
    }

    @Test
    void computeEngagementScore() {
        Assertions.assertThrows(RuntimeException.class, () -> this.hubReportService.computeEngagementScore(this.reportId));
        HubReportEntity hubReportEntity = this.newHubReportEntity();
        Mockito.when((Object)this.reportRepository.findById((Object)this.reportId)).thenReturn(Optional.of(hubReportEntity));
        Assertions.assertEquals((double)0.0, (double)this.hubReportService.computeEngagementScore(this.reportId));
        hubReportEntity.setSentDate(this.sentDate.minusSeconds(604800L));
        Assertions.assertEquals((double)this.engagementScore, (double)this.hubReportService.computeEngagementScore(this.reportId));
        hubReportEntity.setEngagementScore(0.0);
        Assertions.assertThrows(RuntimeException.class, () -> this.hubReportService.computeEngagementScore(this.reportId));
        UemRewardEntity rewardEntity = (UemRewardEntity)Mockito.mock(UemRewardEntity.class);
        int multiplier = 4;
        Mockito.when((Object)rewardEntity.getFixedGlobalIndex()).thenReturn((Object)(this.fixedRewardIndex * (double)multiplier));
        List<Long> reportIds = Arrays.asList(1L, 2L, 3L);
        Mockito.when((Object)rewardEntity.getReportIds()).thenReturn(reportIds);
        Mockito.when((Object)this.rewardRepository.findById((Object)this.rewardId)).thenReturn(Optional.of(rewardEntity));
        Mockito.when((Object)this.reportRepository.save((Object)((HubReportEntity)ArgumentMatchers.any()))).thenAnswer(i -> i.getArgument(0));
        Assertions.assertEquals((double)(10.0 * (double)reportIds.size() / (double)multiplier), (double)this.hubReportService.computeEngagementScore(this.reportId));
        ((HubReportRepository)Mockito.verify((Object)this.reportRepository)).save((Object)((HubReportEntity)ArgumentMatchers.any()));
    }

    private HubReportVerifiableData newHubReportVerifiableData() {
        HubReportPayload reportPayload = new HubReportPayload(this.reportId, this.hubAddress, this.deedId, this.fromDate(), this.toDate(), this.sentDate, this.periodType, this.usersCount, this.participantsCount, this.recipientsCount, (long)this.achievementsCount, (long)this.actionsCount, this.rewardTokenAddress, this.rewardTokenNetworkId, this.hubRewardAmount, this.hubTopRewardedAmount, this.transactions());
        String signature = this.signHubMessage(reportPayload.generateRawMessage(), this.hubCredentials.getEcKeyPair());
        String hash = Hash.sha3((String)signature);
        return new HubReportVerifiableData(hash, signature, reportPayload);
    }

    private HubReportEntity newHubReportEntity() {
        return new HubReportEntity(this.reportId, this.rewardId, StringUtils.lowerCase((String)this.hubAddress), StringUtils.lowerCase((String)this.deedManagerAddress), StringUtils.lowerCase((String)this.ownerAddress), this.ownerMintingPercentage, this.deedId, this.city, this.cardType, this.mintingPower, this.maxUsers, this.fromDate(), this.toDate(), this.sentDate, this.periodType, this.usersCount, this.participantsCount, this.recipientsCount, (long)this.achievementsCount, (long)this.actionsCount, this.rewardTokenAddress, this.rewardTokenNetworkId, this.transactions(), this.hubRewardAmount, this.hubTopRewardedAmount, this.fixedRewardIndex, this.ownerFixedIndex, this.tenantFixedIndex, this.fraud, this.lastPeriodUemRewardAmount, this.uemRewardAmount, this.updatedDate, this.engagementScore);
    }

    private HubReport newHubReport() {
        return new HubReport(this.reportId, StringUtils.lowerCase((String)this.hubAddress), this.deedId, this.fromDate(), this.toDate(), this.sentDate, this.periodType, this.usersCount, this.participantsCount, this.recipientsCount, (long)this.achievementsCount, (long)this.actionsCount, this.rewardTokenAddress, this.rewardTokenNetworkId, this.hubRewardAmount, this.hubTopRewardedAmount, this.transactions(), this.rewardId, this.city, this.cardType, this.mintingPower, this.maxUsers, StringUtils.lowerCase((String)this.deedManagerAddress), StringUtils.lowerCase((String)this.ownerAddress), this.ownerMintingPercentage, this.fixedRewardIndex, this.ownerFixedIndex, this.tenantFixedIndex, this.fraud, this.lastPeriodUemRewardAmount, this.uemRewardAmount, this.updatedDate);
    }

    private Instant toDate() {
        return Instant.ofEpochSecond(this.periodEndTime);
    }

    private Instant fromDate() {
        return Instant.ofEpochSecond(this.periodStartTime);
    }

    private String signHubMessage(String rawRequest, ECKeyPair ecKeyPair) {
        byte[] encodedRequest = rawRequest.getBytes(StandardCharsets.UTF_8);
        Sign.SignatureData signatureData = Sign.signPrefixedMessage((byte[])encodedRequest, (ECKeyPair)ecKeyPair);
        byte[] retval = new byte[65];
        System.arraycopy(signatureData.getR(), 0, retval, 0, 32);
        System.arraycopy(signatureData.getS(), 0, retval, 32, 32);
        System.arraycopy(signatureData.getV(), 0, retval, 64, 1);
        return Numeric.toHexString((byte[])retval);
    }

    private TreeSet<String> transactions() {
        TreeSet<String> transactions = new TreeSet<String>();
        transactions.add(this.txHash);
        return transactions;
    }
}

