/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.utils;

import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.elasticsearch.model.HubEntity;
import io.meeds.deeds.common.model.DeedTenantLeaseDTO;
import io.meeds.wom.api.model.Hub;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;

public class HubMapper {
    private HubMapper() {
    }

    public static Hub fromEntity(HubEntity hubEntity) {
        if (hubEntity == null) {
            return null;
        }
        return new Hub(hubEntity.getNftId(), hubEntity.getCity(), hubEntity.getType(), hubEntity.getAddress(), hubEntity.getName(), hubEntity.getDescription(), hubEntity.getUrl(), hubEntity.getColor(), hubEntity.getHubOwnerAddress(), hubEntity.getDeedOwnerAddress(), hubEntity.getDeedManagerAddress(), hubEntity.getCreatedDate(), hubEntity.getUntilDate(), hubEntity.getJoinDate(), hubEntity.getUpdatedDate(), hubEntity.getUsersCount(), hubEntity.getRewardsPeriodType(), hubEntity.getRewardsPerPeriod(), HubMapper.isConnected(hubEntity), hubEntity.getOwnerClaimableAmount(), hubEntity.getManagerClaimableAmount());
    }

    public static HubEntity toEntity(Hub hub, DeedTenant deedTenant, DeedTenantLeaseDTO lease, HubEntity existingEntity) {
        String managerAddress;
        boolean connected = existingEntity != null && existingEntity.isEnabled();
        Instant untilDate = existingEntity == null ? lease.getEndDate() : existingEntity.getUntilDate();
        String ownerAddress = deedTenant.getOwnerAddress();
        if (StringUtils.equalsIgnoreCase((CharSequence)ownerAddress, (CharSequence)(managerAddress = deedTenant.getManagerAddress()))) {
            untilDate = null;
        } else if (connected && lease != null && StringUtils.equalsIgnoreCase((CharSequence)hub.getHubOwnerAddress(), (CharSequence)lease.getManagerAddress())) {
            untilDate = lease.getEndDate();
        }
        if (connected && untilDate != null && untilDate.isBefore(Instant.now())) {
            connected = false;
        }
        return new HubEntity(hub.getAddress(), deedTenant.getNftId(), deedTenant.getCityIndex(), deedTenant.getCardType(), hub.getHubOwnerAddress(), ownerAddress, managerAddress, hub.getName(), hub.getDescription(), hub.getUrl(), hub.getColor(), existingEntity == null ? null : existingEntity.getAvatarId(), existingEntity == null ? null : existingEntity.getBannerId(), hub.getUsersCount(), hub.getRewardsPeriodType(), hub.getRewardsPerPeriod(), connected, existingEntity == null ? 0.0 : existingEntity.getOwnerClaimableAmount(), existingEntity == null ? 0.0 : existingEntity.getManagerClaimableAmount(), existingEntity == null ? Instant.now() : existingEntity.getCreatedDate(), untilDate, existingEntity == null ? null : existingEntity.getJoinDate(), existingEntity == null ? Instant.now() : existingEntity.getUpdatedDate());
    }

    public static boolean isConnected(HubEntity hubEntity) {
        return !(hubEntity == null || !hubEntity.isEnabled() || hubEntity.getUntilDate() != null && !hubEntity.getUntilDate().isAfter(Instant.now()) || !StringUtils.equalsIgnoreCase((CharSequence)hubEntity.getHubOwnerAddress(), (CharSequence)hubEntity.getDeedManagerAddress()) && !StringUtils.equalsIgnoreCase((CharSequence)hubEntity.getHubOwnerAddress(), (CharSequence)hubEntity.getDeedOwnerAddress()));
    }
}

