/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.constant.TenantProvisioningStatus;
import io.meeds.deeds.common.constant.TenantStatus;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.elasticsearch.model.HubEntity;
import io.meeds.deeds.common.elasticsearch.model.HubReportEntity;
import io.meeds.deeds.common.elasticsearch.model.UemRewardEntity;
import io.meeds.deeds.common.elasticsearch.storage.HubReportRepository;
import io.meeds.deeds.common.elasticsearch.storage.HubRepository;
import io.meeds.deeds.common.elasticsearch.storage.UemRewardRepository;
import io.meeds.deeds.common.model.DeedTenantLeaseDTO;
import io.meeds.deeds.common.model.FileBinary;
import io.meeds.deeds.common.model.LeaseFilter;
import io.meeds.deeds.common.model.ManagedDeed;
import io.meeds.deeds.common.model.WomDeed;
import io.meeds.deeds.common.model.WomHub;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.FileService;
import io.meeds.deeds.common.service.HubService;
import io.meeds.deeds.common.service.LeaseService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.service.TenantService;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import io.meeds.wom.api.constant.WomAuthorizationException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.constant.WomRequestException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.HubUpdateRequest;
import io.meeds.wom.api.model.WomConnectionRequest;
import io.meeds.wom.api.model.WomDisconnectionRequest;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.multipart.MultipartFile;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

@SpringBootTest(classes={HubService.class})
@TestPropertySource(properties={"meeds.hub.maxTokensPerClientIp=2", "meeds.hub.maxTokenLiveTimeSeconds=1"})
@ExtendWith(value={MockitoExtension.class})
class HubServiceTest {
    private static final String CLIENT_IP = "clientIp";
    private static final String RAW_MESSAGE = "rawMessage";
    @MockBean
    private TenantService tenantService;
    @MockBean
    private ListenerService listenerService;
    @MockBean
    private FileService fileService;
    @MockBean
    private BlockchainService blockchainService;
    @MockBean
    private LeaseService leaseService;
    @MockBean
    private HubRepository hubRepository;
    @MockBean
    private HubReportRepository reportRepository;
    @MockBean
    private UemRewardRepository rewardRepository;
    @Autowired
    private HubService hubService;
    private long periodStartTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private long periodEndTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(2L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private Credentials hubCredentials = Credentials.create((String)"0x1da4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    private String hubAddress = this.hubCredentials.getAddress();
    private Set<String> hubAddresses = Collections.singleton(this.hubAddress.toLowerCase());
    private long deedId = 3L;
    private short city = 1;
    private short cardType = (short)2;
    private short ownerPercentage = (short)60;
    private short mintingPower = (short)130;
    private long maxUsers = 10000L;
    private String deedOwnerAddress = "0x530417D6909834f9Ebfe5d98b649433B616Efb38";
    private Credentials deedManagerCredentials = Credentials.create((String)"0x3ba4ef21b864d2cc526dbdb2a120bd2874c36c9d0a1fb7f8c63d7f7a8b41de8f");
    private String deedManagerAddress;
    private String hubOwnerAddress = this.deedManagerAddress = this.deedManagerCredentials.getAddress();
    private String deedManagerEmail = "managerEmail";
    private String txHash = "0xef4e9db309b5dd7020ce463ae726b4d0759e1de0635661de91d8d98e83ae2862";
    private Map<String, String> name = Collections.singletonMap("en", "name");
    private Map<String, String> description = Collections.singletonMap("en", "description");
    private String url = "url";
    private String color = "#144523";
    private String avatarId = "avatarId";
    private String bannerId = "bannerId";
    private long usersCount = 56L;
    private String rewardsPeriodType = "WEEK";
    private double rewardsPerPeriod = 566.54;
    private boolean enabled = true;
    private double ownerClaimableAmount = 25.6;
    private double managerClaimableAmount = 12.9;
    private double uemRewardAmount = 2008.9;
    private double fixedGlobalIndex = 3000.6554879;
    private double sumEd = 800.6554879;
    private long rewardId = 328746L;
    private long reportId = 25546L;
    private List<Long> reportIds = Collections.singletonList(this.reportId);
    private Instant createdDate = Instant.now().minusSeconds(16L);
    private Instant untilDate = Instant.now().plusSeconds(28L);
    private Instant joinDate = Instant.now().minusSeconds(10L);
    private Instant updatedDate = Instant.now();

    HubServiceTest() {
    }

    @BeforeEach
    void setup() {
        this.hubService.cleanTokens();
    }

    @Test
    void getHubs() {
        HubEntity hubEntity = this.newHubEntity();
        PageImpl hubEntitiesPage = new PageImpl(Collections.singletonList(hubEntity));
        Mockito.when((Object)this.hubRepository.findByEnabledIsTrue((Pageable)ArgumentMatchers.any())).thenReturn((Object)hubEntitiesPage);
        Page hubsPage = this.hubService.getHubs(Pageable.unpaged());
        Assertions.assertNotNull((Object)hubsPage);
        Assertions.assertEquals((int)1, (int)hubsPage.getSize());
        Hub hub = (Hub)hubsPage.getContent().get(0);
        Assertions.assertEquals((Object)hubEntity.getAddress().toLowerCase(), (Object)hub.getAddress().toLowerCase());
        Assertions.assertEquals((long)hubEntity.getNftId(), (long)hub.getDeedId());
        Assertions.assertEquals((short)hubEntity.getCity(), (short)hub.getCity());
        Assertions.assertEquals((short)hubEntity.getType(), (short)hub.getType());
        Assertions.assertEquals((Object)hubEntity.getHubOwnerAddress().toLowerCase(), (Object)hub.getHubOwnerAddress().toLowerCase());
        Assertions.assertEquals((Object)hubEntity.getDeedOwnerAddress().toLowerCase(), (Object)hub.getDeedOwnerAddress().toLowerCase());
        Assertions.assertEquals((Object)hubEntity.getDeedManagerAddress().toLowerCase(), (Object)hub.getDeedManagerAddress().toLowerCase());
        Assertions.assertEquals((Object)hubEntity.getName(), (Object)hub.getName());
        Assertions.assertEquals((Object)hubEntity.getDescription(), (Object)hub.getDescription());
        Assertions.assertEquals((Object)hubEntity.getUrl(), (Object)hub.getUrl());
        Assertions.assertEquals((Object)hubEntity.getColor(), (Object)hub.getColor());
        Assertions.assertEquals((Object)hubEntity.getRewardsPeriodType(), (Object)hub.getRewardsPeriodType());
        Assertions.assertEquals((double)hubEntity.getRewardsPerPeriod(), (double)hub.getRewardsPerPeriod());
        Assertions.assertEquals((Object)hubEntity.isEnabled(), (Object)hub.isConnected());
        Assertions.assertEquals((double)hubEntity.getOwnerClaimableAmount(), (double)hub.getOwnerClaimableAmount());
        Assertions.assertEquals((double)hubEntity.getManagerClaimableAmount(), (double)hub.getManagerClaimableAmount());
        Assertions.assertEquals((long)hubEntity.getCreatedDate().toEpochMilli(), (long)hub.getCreatedDate().toEpochMilli());
        Assertions.assertEquals((long)hubEntity.getUntilDate().toEpochMilli(), (long)hub.getUntilDate().toEpochMilli());
        Assertions.assertEquals((long)hubEntity.getJoinDate().toEpochMilli(), (long)hub.getJoinDate().toEpochMilli());
        Assertions.assertEquals((long)hubEntity.getUpdatedDate().toEpochMilli(), (long)hub.getUpdatedDate().toEpochMilli());
    }

    @Test
    void getHubsByRewardIdWhenEmpty() {
        Mockito.when((Object)this.rewardRepository.findById((Object)this.rewardId)).thenReturn(Optional.empty());
        Page hubsPage = this.hubService.getHubs(this.rewardId, Pageable.unpaged());
        Assertions.assertNotNull((Object)hubsPage);
        Assertions.assertEquals((int)0, (int)hubsPage.getSize());
    }

    @Test
    void getHubsByRewardIdWhenNoReports() {
        Pageable pageable = Pageable.unpaged();
        UemRewardEntity rewardEntity = this.newUemRewardEntity();
        Mockito.when((Object)this.rewardRepository.findById((Object)this.rewardId)).thenReturn(Optional.of(rewardEntity));
        Mockito.when((Object)this.hubRepository.findByAddressInAndEnabledIsTrue(this.hubAddresses, pageable)).thenReturn((Object)new PageImpl(Collections.emptyList()));
        Page hubsPage = this.hubService.getHubs(this.rewardId, pageable);
        Assertions.assertNotNull((Object)hubsPage);
        Assertions.assertEquals((int)0, (int)hubsPage.getSize());
    }

    @Test
    void getHubsByRewardId() {
        Pageable pageable = Pageable.unpaged();
        UemRewardEntity rewardEntity = this.newUemRewardEntity();
        HubEntity hubEntity = this.newHubEntity();
        Mockito.when((Object)this.rewardRepository.findById((Object)this.rewardId)).thenReturn(Optional.of(rewardEntity));
        Mockito.when((Object)this.hubRepository.findByAddressInAndEnabledIsTrue(this.hubAddresses, pageable)).thenReturn((Object)new PageImpl(Collections.singletonList(hubEntity)));
        Page hubsPage = this.hubService.getHubs(this.rewardId, pageable);
        Assertions.assertNotNull((Object)hubsPage);
        Assertions.assertEquals((int)1, (int)hubsPage.getSize());
    }

    @Test
    void getHubByNftWhenNotExists() throws ObjectNotFoundException {
        Mockito.when((Object)this.hubRepository.findByNftId(this.deedId)).thenReturn(Optional.empty());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenThrow(ObjectNotFoundException.class);
        Assertions.assertNull((Object)this.hubService.getHub(Long.valueOf(this.deedId)));
    }

    @Test
    void getHubByNftWhenExistsOnBlockchain() throws ObjectNotFoundException {
        Mockito.when((Object)this.hubRepository.findByNftId(this.deedId)).thenReturn(Optional.empty());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenReturn((Object)this.newDeedTenant());
        Hub hub = this.hubService.getHub(Long.valueOf(this.deedId));
        Assertions.assertNotNull((Object)hub);
        Assertions.assertEquals((long)this.deedId, (long)hub.getDeedId());
        Assertions.assertEquals((short)this.city, (short)hub.getCity());
        Assertions.assertEquals((short)this.cardType, (short)hub.getType());
        Assertions.assertNull((Object)hub.getColor());
        Assertions.assertNull((Object)hub.getName());
        Assertions.assertNull((Object)hub.getDescription());
        Assertions.assertNull((Object)hub.getUrl());
        Assertions.assertNull((Object)hub.getJoinDate());
        Assertions.assertNull((Object)hub.getUntilDate());
        Assertions.assertNull((Object)hub.getCreatedDate());
        Assertions.assertNull((Object)hub.getUpdatedDate());
        Assertions.assertEquals((double)0.0, (double)hub.getOwnerClaimableAmount());
        Assertions.assertEquals((double)0.0, (double)hub.getManagerClaimableAmount());
        Assertions.assertNull((Object)hub.getRewardsPeriodType());
        Assertions.assertEquals((double)0.0, (double)hub.getRewardsPerPeriod());
        Assertions.assertEquals((long)0L, (long)hub.getUsersCount());
    }

    @Test
    void getHubByAddressWhenNoRefreshAndNotFound() {
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.empty());
        Hub hub = this.hubService.getHub(this.hubAddress);
        Assertions.assertNull((Object)hub);
    }

    @Test
    void getHubByAddressWhenNoRefresh() {
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(this.newHubEntity()));
        Hub hub = this.hubService.getHub(this.hubAddress);
        Assertions.assertNotNull((Object)hub);
    }

    @Test
    void getHubByAddressWhenRefreshAndNotFound() {
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.empty());
        Hub hub = this.hubService.getHub(this.hubAddress, true);
        Assertions.assertNull((Object)hub);
    }

    @Test
    void getHubByAddressWhenRefreshAndDisconnected() {
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(this.newHubEntity()));
        Hub hub = this.hubService.getHub(this.hubAddress, true);
        Assertions.assertNotNull((Object)hub);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.disconnectedFromWom", (Object)this.hubAddress.toLowerCase());
        ((HubRepository)Mockito.verify((Object)this.hubRepository, (VerificationMode)Mockito.atLeast((int)1))).save((Object)((HubEntity)ArgumentMatchers.argThat(entity -> !entity.isEnabled())));
    }

    @Test
    void getHubByAddressWhenRefreshAndExistsInBlockchainNotDisconnectWhenChangeOwner() throws ObjectNotFoundException, WomException {
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(this.newHubEntity()));
        Mockito.when((Object)this.hubRepository.findByNftId(this.deedId)).thenReturn(Optional.of(this.newHubEntity()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        WomHub womHub = new WomHub(this.deedId, this.hubOwnerAddress, this.enabled, Instant.now().minusSeconds(56L).getEpochSecond());
        Mockito.when((Object)this.blockchainService.getHub(this.hubAddress)).thenReturn((Object)womHub);
        WomDeed womDeed = new WomDeed(this.city, this.cardType, (double)this.mintingPower, this.maxUsers, this.deedOwnerAddress.replace("1", "2"), this.deedManagerAddress, this.hubAddress, this.ownerPercentage);
        Mockito.when((Object)this.blockchainService.getWomDeed(this.deedId)).thenReturn((Object)womDeed);
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenReturn((Object)this.newDeedTenant());
        Assertions.assertThrows(WomAuthorizationException.class, () -> this.hubService.getHub(this.hubAddress, true));
        Mockito.when((Object)this.blockchainService.getDeedOwner(this.deedId)).thenReturn((Object)this.deedOwnerAddress);
        Mockito.when((Object)this.blockchainService.isDeedOwner(this.deedOwnerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedManager(this.deedId)).thenReturn((Object)this.deedManagerAddress);
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(this.deedManagerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(this.deedId)).thenReturn((Object)this.city);
        Mockito.when((Object)this.blockchainService.getDeedCardType(this.deedId)).thenReturn((Object)this.cardType);
        DeedTenantLeaseDTO lease = (DeedTenantLeaseDTO)Mockito.mock(DeedTenantLeaseDTO.class);
        Mockito.when((Object)this.leaseService.getCurrentLease(this.deedId)).thenReturn((Object)lease);
        Mockito.when((Object)lease.getOwnerMintingPercentage()).thenReturn((Object)this.ownerPercentage);
        Hub hub = this.hubService.getHub(this.hubAddress, true);
        Assertions.assertNotNull((Object)hub);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.saved", (Object)this.hubAddress.toLowerCase());
        ((BlockchainService)Mockito.verify((Object)this.blockchainService)).updateWomDeed(this.deedId, this.city, this.cardType, this.mintingPower, this.maxUsers, this.deedOwnerAddress, this.deedManagerAddress, this.ownerPercentage);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).publishEvent("uem.hub.connectedToWom", (Object)this.hubAddress.toLowerCase());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.never())).publishEvent("uem.hub.disconnectedFromWom", (Object)this.hubAddress.toLowerCase());
    }

    @Test
    void getHubByAddressWhenRefreshAndExistsInBlockchainAndDisconnectWhenChangeManager() throws ObjectNotFoundException, WomException {
        String newDeedManagerAddress = this.deedManagerAddress.replace("1", "2");
        ThreadLocal<WomDeed> womDeedTL = new ThreadLocal<WomDeed>();
        womDeedTL.set(new WomDeed(this.city, this.cardType, (double)this.mintingPower, this.maxUsers, this.deedOwnerAddress, this.deedManagerAddress, this.hubAddress, this.ownerPercentage));
        ((BlockchainService)Mockito.doAnswer(invocation -> {
            womDeedTL.set(new WomDeed(((Short)invocation.getArgument(1)).shortValue(), ((Short)invocation.getArgument(2)).shortValue(), (double)((Short)invocation.getArgument(3, Short.class)).shortValue() / 100.0, ((Long)invocation.getArgument(4)).longValue(), (String)invocation.getArgument(5), (String)invocation.getArgument(6), this.hubAddress, ((Short)invocation.getArgument(7)).shortValue()));
            return null;
        }).when((Object)this.blockchainService)).updateWomDeed(ArgumentMatchers.eq((long)this.deedId), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyShort());
        ThreadLocal<HubEntity> hubEntityTL = new ThreadLocal<HubEntity>();
        HubEntity hubEntity = this.newHubEntity();
        hubEntityTL.set(hubEntity);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenAnswer(invocation -> Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.findByNftId(this.deedId)).thenAnswer(invocation -> Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            HubEntity savedHubEntity = (HubEntity)invocation.getArgument(0);
            hubEntityTL.set(savedHubEntity);
            return savedHubEntity;
        });
        WomHub womHub = new WomHub(this.deedId, this.hubOwnerAddress, this.enabled, Instant.now().minusSeconds(56L).getEpochSecond());
        Mockito.when((Object)this.blockchainService.getHub(this.hubAddress)).thenReturn((Object)womHub);
        Mockito.when((Object)this.blockchainService.getWomDeed(this.deedId)).thenAnswer(invocation -> womDeedTL.get());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.tenantService.getDeedTenant(this.deedId)).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.blockchainService.getDeedOwner(this.deedId)).thenReturn((Object)this.deedOwnerAddress);
        Mockito.when((Object)this.blockchainService.isDeedOwner(this.deedOwnerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedManager(this.deedId)).thenReturn((Object)newDeedManagerAddress);
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(newDeedManagerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(this.deedId)).thenReturn((Object)this.city);
        Mockito.when((Object)this.blockchainService.getDeedCardType(this.deedId)).thenReturn((Object)this.cardType);
        DeedTenantLeaseDTO lease = (DeedTenantLeaseDTO)Mockito.mock(DeedTenantLeaseDTO.class);
        Mockito.when((Object)this.leaseService.getCurrentLease(this.deedId)).thenReturn((Object)lease);
        Mockito.when((Object)lease.getOwnerMintingPercentage()).thenReturn((Object)this.ownerPercentage);
        Hub hub = this.hubService.getHub(this.hubAddress, true);
        Assertions.assertNotNull((Object)hub);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.disconnectedFromWom", (Object)this.hubAddress.toLowerCase());
        ((BlockchainService)Mockito.verify((Object)this.blockchainService)).updateWomDeed(this.deedId, this.city, this.cardType, this.mintingPower, this.maxUsers, this.deedOwnerAddress, newDeedManagerAddress, this.ownerPercentage);
    }

    @Test
    void getHubByAddressWhenRefreshAndExistsInBlockchainAsConnected() throws ObjectNotFoundException, WomException {
        String previousDeedManagerAddress = this.deedManagerAddress.replace("1", "2");
        ThreadLocal<WomDeed> womDeedTL = new ThreadLocal<WomDeed>();
        womDeedTL.set(new WomDeed(this.city, this.cardType, (double)this.mintingPower, this.maxUsers, this.deedOwnerAddress, previousDeedManagerAddress, this.hubAddress, this.ownerPercentage));
        ((BlockchainService)Mockito.doAnswer(invocation -> {
            womDeedTL.set(new WomDeed(((Short)invocation.getArgument(1)).shortValue(), ((Short)invocation.getArgument(2)).shortValue(), (double)((Short)invocation.getArgument(3, Short.class)).shortValue() / 100.0, ((Long)invocation.getArgument(4)).longValue(), (String)invocation.getArgument(5), (String)invocation.getArgument(6), this.hubAddress, ((Short)invocation.getArgument(7)).shortValue()));
            return null;
        }).when((Object)this.blockchainService)).updateWomDeed(ArgumentMatchers.eq((long)this.deedId), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyShort());
        ThreadLocal<HubEntity> hubEntityTL = new ThreadLocal<HubEntity>();
        HubEntity hubEntity = this.newHubEntity();
        hubEntity.setDeedManagerAddress(previousDeedManagerAddress);
        hubEntityTL.set(hubEntity);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenAnswer(invocation -> Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.findByNftId(this.deedId)).thenAnswer(invocation -> Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            HubEntity savedHubEntity = (HubEntity)invocation.getArgument(0);
            hubEntityTL.set(savedHubEntity);
            return savedHubEntity;
        });
        WomHub womHub = new WomHub(this.deedId, this.hubOwnerAddress, this.enabled, Instant.now().minusSeconds(56L).getEpochSecond());
        Mockito.when((Object)this.blockchainService.getHub(this.hubAddress)).thenReturn((Object)womHub);
        Mockito.when((Object)this.blockchainService.getWomDeed(this.deedId)).thenAnswer(invocation -> womDeedTL.get());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.tenantService.getDeedTenant(this.deedId)).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.blockchainService.getDeedOwner(this.deedId)).thenReturn((Object)this.deedOwnerAddress);
        Mockito.when((Object)this.blockchainService.isDeedOwner(this.deedOwnerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedManager(this.deedId)).thenReturn((Object)this.deedManagerAddress);
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(this.deedManagerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(this.deedId)).thenReturn((Object)this.city);
        Mockito.when((Object)this.blockchainService.getDeedCardType(this.deedId)).thenReturn((Object)this.cardType);
        DeedTenantLeaseDTO lease = (DeedTenantLeaseDTO)Mockito.mock(DeedTenantLeaseDTO.class);
        Mockito.when((Object)this.leaseService.getCurrentLease(this.deedId)).thenReturn((Object)lease);
        Mockito.when((Object)lease.getOwnerMintingPercentage()).thenReturn((Object)this.ownerPercentage);
        Hub hub = this.hubService.getHub(this.hubAddress, true);
        Assertions.assertNotNull((Object)hub);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.connectedToWom", (Object)this.hubAddress.toLowerCase());
        ((BlockchainService)Mockito.verify((Object)this.blockchainService)).updateWomDeed(this.deedId, this.city, this.cardType, this.mintingPower, this.maxUsers, this.deedOwnerAddress, this.deedManagerAddress, this.ownerPercentage);
    }

    @Test
    void refreshClaimableAmount() {
        HubEntity entity = this.newHubEntity();
        Mockito.when((Object)this.hubRepository.findByDeedOwnerAddress(StringUtils.lowerCase((String)this.deedOwnerAddress))).thenReturn(Stream.of(entity));
        Mockito.when((Object)this.hubRepository.findByDeedManagerAddress(StringUtils.lowerCase((String)this.deedManagerAddress))).thenReturn(Stream.of(entity));
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(entity));
        double amount1 = 5.22;
        double amount2 = 6.77;
        Mockito.when((Object)this.blockchainService.getPendingRewards(this.deedManagerAddress)).thenReturn((Object)amount1);
        Mockito.when((Object)this.blockchainService.getPendingRewards(this.deedOwnerAddress)).thenReturn((Object)amount2);
        this.hubService.refreshClaimableAmount(this.deedManagerAddress);
        ((HubRepository)Mockito.verify((Object)this.hubRepository)).save((Object)((HubEntity)ArgumentMatchers.any()));
        ((HubRepository)Mockito.verify((Object)this.hubRepository)).save((Object)((HubEntity)ArgumentMatchers.argThat(hubEntity -> hubEntity.getOwnerClaimableAmount() == amount2 && hubEntity.getManagerClaimableAmount() == amount1)));
    }

    @Test
    void generateToken() {
        String token = this.hubService.generateToken(CLIENT_IP);
        Assertions.assertNotNull((Object)token);
        String token2 = this.hubService.generateToken(CLIENT_IP);
        Assertions.assertNotNull((Object)token);
        Assertions.assertNotEquals((Object)token, (Object)token2);
        Assertions.assertThrows(IllegalStateException.class, () -> this.hubService.generateToken(CLIENT_IP));
        String token3 = this.hubService.generateToken("clientIp2");
        Assertions.assertNotNull((Object)token3);
        Assertions.assertNotEquals((Object)token3, (Object)token);
        Assertions.assertNotEquals((Object)token3, (Object)token2);
        Thread.sleep(1000L);
        String token4 = this.hubService.generateToken(CLIENT_IP);
        Assertions.assertNotNull((Object)token4);
    }

    @Test
    void connectToWomWithSignatureErrors() {
        String fakeDeedManagerSignedMessage = "fakeSignedMessage";
        String fakeHubSignedMessage = "fakeHubSignedMessage";
        String rawMessage = RAW_MESSAGE;
        WomException exception = (WomException)Assertions.assertThrows(WomException.class, () -> {
            WomConnectionRequest hubConnectionRequest = new WomConnectionRequest(fakeDeedManagerSignedMessage, fakeHubSignedMessage, rawMessage, null);
            this.hubService.connectToWom(hubConnectionRequest);
        });
        Assertions.assertEquals((Object)"wom.emptyTokenForSignedMessage", (Object)exception.getMessage());
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> {
            WomConnectionRequest hubConnectionRequest = new WomConnectionRequest(fakeDeedManagerSignedMessage, fakeHubSignedMessage, rawMessage, "token");
            this.hubService.connectToWom(hubConnectionRequest);
        });
        Assertions.assertEquals((Object)"wom.invalidTokenForSignedMessage", (Object)exception.getMessage());
        String token = this.hubService.generateToken(CLIENT_IP);
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubService.connectToWom(new WomConnectionRequest(fakeDeedManagerSignedMessage, fakeHubSignedMessage, rawMessage, token)));
        Assertions.assertEquals((Object)"wom.emptyDeedManagerAddress", (Object)exception.getMessage());
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> {
            WomConnectionRequest hubConnectionRequest = new WomConnectionRequest(this.signHubMessage(rawMessage, this.deedManagerCredentials.getEcKeyPair()), this.signHubMessage(rawMessage, this.deedManagerCredentials.getEcKeyPair()), null, token);
            hubConnectionRequest.setAddress(this.hubAddress);
            hubConnectionRequest.setDeedManagerAddress(this.deedManagerAddress);
            this.hubService.connectToWom(hubConnectionRequest);
        });
        Assertions.assertEquals((Object)"wom.emptySignedMessage", (Object)exception.getMessage());
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> {
            WomConnectionRequest hubConnectionRequest = new WomConnectionRequest(this.signHubMessage(rawMessage, this.deedManagerCredentials.getEcKeyPair()), this.signHubMessage(rawMessage, this.deedManagerCredentials.getEcKeyPair()), rawMessage, token);
            hubConnectionRequest.setAddress(this.hubAddress);
            hubConnectionRequest.setDeedManagerAddress(this.deedManagerAddress);
            this.hubService.connectToWom(hubConnectionRequest);
        });
        Assertions.assertEquals((Object)"wom.invalidSignedMessage", (Object)exception.getMessage());
    }

    @Test
    void connectToWom() throws WomException, ObjectNotFoundException {
        String previousDeedManagerAddress = this.deedManagerAddress.replace("1", "2");
        ThreadLocal<WomDeed> womDeedTL = new ThreadLocal<WomDeed>();
        womDeedTL.set(new WomDeed(this.city, this.cardType, (double)this.mintingPower, this.maxUsers, this.deedOwnerAddress, previousDeedManagerAddress, this.hubAddress, this.ownerPercentage));
        ((BlockchainService)Mockito.doAnswer(invocation -> {
            womDeedTL.set(new WomDeed(((Short)invocation.getArgument(1)).shortValue(), ((Short)invocation.getArgument(2)).shortValue(), (double)((Short)invocation.getArgument(3, Short.class)).shortValue() / 100.0, ((Long)invocation.getArgument(4)).longValue(), (String)invocation.getArgument(5), (String)invocation.getArgument(6), this.hubAddress, ((Short)invocation.getArgument(7)).shortValue()));
            return null;
        }).when((Object)this.blockchainService)).updateWomDeed(ArgumentMatchers.eq((long)this.deedId), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyShort());
        ThreadLocal<HubEntity> hubEntityTL = new ThreadLocal<HubEntity>();
        HubEntity hubEntity = this.newHubEntity();
        hubEntity.setDeedManagerAddress(previousDeedManagerAddress);
        hubEntityTL.set(hubEntity);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenAnswer(invocation -> Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.findByNftId(this.deedId)).thenAnswer(invocation -> Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            HubEntity savedHubEntity = (HubEntity)invocation.getArgument(0);
            hubEntityTL.set(savedHubEntity);
            return savedHubEntity;
        });
        WomHub womHub = new WomHub(this.deedId, this.hubOwnerAddress, this.enabled, Instant.now().minusSeconds(56L).getEpochSecond());
        Mockito.when((Object)this.blockchainService.getHub(this.hubAddress)).thenReturn((Object)womHub);
        Mockito.when((Object)this.blockchainService.getWomDeed(this.deedId)).thenAnswer(invocation -> womDeedTL.get());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.tenantService.getDeedTenant(this.deedId)).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.blockchainService.getDeedOwner(this.deedId)).thenReturn((Object)this.deedOwnerAddress);
        Mockito.when((Object)this.blockchainService.isDeedOwner(this.deedOwnerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedManager(this.deedId)).thenReturn((Object)this.deedManagerAddress);
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(this.deedManagerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(this.deedId)).thenReturn((Object)this.city);
        Mockito.when((Object)this.blockchainService.getDeedCardType(this.deedId)).thenReturn((Object)this.cardType);
        DeedTenantLeaseDTO lease = (DeedTenantLeaseDTO)Mockito.mock(DeedTenantLeaseDTO.class);
        Mockito.when((Object)this.leaseService.getCurrentLease(this.deedId)).thenReturn((Object)lease);
        Mockito.when((Object)lease.getOwnerMintingPercentage()).thenReturn((Object)this.ownerPercentage);
        String token = this.hubService.generateToken(CLIENT_IP);
        String rawMessage = RAW_MESSAGE + token;
        WomConnectionRequest hubConnectionRequest = new WomConnectionRequest(this.signHubMessage(rawMessage, this.deedManagerCredentials.getEcKeyPair()), this.signHubMessage(rawMessage, this.hubCredentials.getEcKeyPair()), rawMessage, token);
        hubConnectionRequest.setAddress(this.hubAddress);
        hubConnectionRequest.setDeedManagerAddress(this.deedManagerAddress);
        hubConnectionRequest.setDeedId(this.deedId);
        this.hubService.connectToWom(hubConnectionRequest);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.connectedToWom", (Object)this.hubAddress.toLowerCase());
        ((BlockchainService)Mockito.verify((Object)this.blockchainService)).updateWomDeed(this.deedId, this.city, this.cardType, this.mintingPower, this.maxUsers, this.deedOwnerAddress, this.deedManagerAddress, this.ownerPercentage);
    }

    @Test
    void disconnectToWomWithSignatureErrors() {
        String fakeDeedManagerSignedMessage = "fakeSignedMessage";
        String fakeHubSignedMessage = "fakeHubSignedMessage";
        String rawMessage = RAW_MESSAGE;
        WomException exception = (WomException)Assertions.assertThrows(WomException.class, () -> {
            WomDisconnectionRequest disconnectionRequest = new WomDisconnectionRequest(this.hubAddress, fakeHubSignedMessage, this.deedManagerAddress, fakeDeedManagerSignedMessage, rawMessage, null);
            this.hubService.disconnectFromWom(disconnectionRequest);
        });
        Assertions.assertEquals((Object)"wom.emptyTokenForSignedMessage", (Object)exception.getMessage());
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> {
            WomDisconnectionRequest disconnectionRequest = new WomDisconnectionRequest(this.hubAddress, fakeHubSignedMessage, this.deedManagerAddress, fakeDeedManagerSignedMessage, rawMessage, "token");
            this.hubService.disconnectFromWom(disconnectionRequest);
        });
        Assertions.assertEquals((Object)"wom.invalidTokenForSignedMessage", (Object)exception.getMessage());
        String token = this.hubService.generateToken(CLIENT_IP);
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubService.disconnectFromWom(new WomDisconnectionRequest(this.hubAddress, fakeHubSignedMessage, this.deedManagerAddress, fakeDeedManagerSignedMessage, rawMessage, token)));
        Assertions.assertEquals((Object)"wom.invalidSignedMessage", (Object)exception.getMessage());
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubService.disconnectFromWom(new WomDisconnectionRequest(this.hubAddress, fakeHubSignedMessage, this.deedManagerAddress, null, rawMessage, token)));
        Assertions.assertEquals((Object)"wom.emptySignedMessage", (Object)exception.getMessage());
        exception = (WomException)Assertions.assertThrows(WomException.class, () -> this.hubService.disconnectFromWom(new WomDisconnectionRequest(this.hubAddress, this.signHubMessage(rawMessage, this.deedManagerCredentials.getEcKeyPair()), this.deedManagerAddress, this.signHubMessage(rawMessage, this.deedManagerCredentials.getEcKeyPair()), rawMessage, token)));
        Assertions.assertEquals((Object)"wom.invalidSignedMessage", (Object)exception.getMessage());
    }

    @Test
    void disconnectToWom() throws WomException, ObjectNotFoundException {
        ThreadLocal<WomDeed> womDeedTL = new ThreadLocal<WomDeed>();
        womDeedTL.set(new WomDeed(this.city, this.cardType, (double)this.mintingPower, this.maxUsers, this.deedOwnerAddress, this.deedManagerAddress, this.hubAddress, this.ownerPercentage));
        ((BlockchainService)Mockito.doAnswer(invocation -> {
            womDeedTL.set(new WomDeed(((Short)invocation.getArgument(1)).shortValue(), ((Short)invocation.getArgument(2)).shortValue(), (double)((Short)invocation.getArgument(3, Short.class)).shortValue() / 100.0, ((Long)invocation.getArgument(4)).longValue(), (String)invocation.getArgument(5), (String)invocation.getArgument(6), this.hubAddress, ((Short)invocation.getArgument(7)).shortValue()));
            return null;
        }).when((Object)this.blockchainService)).updateWomDeed(ArgumentMatchers.eq((long)this.deedId), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyShort());
        ThreadLocal<HubEntity> hubEntityTL = new ThreadLocal<HubEntity>();
        HubEntity hubEntity = this.newHubEntity();
        hubEntityTL.set(hubEntity);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenAnswer(invocation -> Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.findByNftId(this.deedId)).thenAnswer(invocation -> Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            HubEntity savedHubEntity = (HubEntity)invocation.getArgument(0);
            hubEntityTL.set(savedHubEntity);
            return savedHubEntity;
        });
        WomHub womHub = new WomHub(this.deedId, this.hubOwnerAddress, false, Instant.now().minusSeconds(56L).getEpochSecond());
        Mockito.when((Object)this.blockchainService.getHub(this.hubAddress)).thenReturn((Object)womHub);
        Mockito.when((Object)this.blockchainService.getWomDeed(this.deedId)).thenAnswer(invocation -> womDeedTL.get());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.tenantService.getDeedTenant(this.deedId)).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.blockchainService.getDeedOwner(this.deedId)).thenReturn((Object)this.deedOwnerAddress);
        Mockito.when((Object)this.blockchainService.isDeedOwner(this.deedOwnerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedManager(this.deedId)).thenReturn((Object)this.deedManagerAddress);
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(this.deedManagerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(this.deedId)).thenReturn((Object)this.city);
        Mockito.when((Object)this.blockchainService.getDeedCardType(this.deedId)).thenReturn((Object)this.cardType);
        DeedTenantLeaseDTO lease = (DeedTenantLeaseDTO)Mockito.mock(DeedTenantLeaseDTO.class);
        Mockito.when((Object)this.leaseService.getCurrentLease(this.deedId)).thenReturn((Object)lease);
        Mockito.when((Object)lease.getOwnerMintingPercentage()).thenReturn((Object)this.ownerPercentage);
        String token = this.hubService.generateToken(CLIENT_IP);
        String rawMessage = RAW_MESSAGE + token;
        this.hubService.disconnectFromWom(new WomDisconnectionRequest(this.hubAddress, this.signHubMessage(rawMessage, this.hubCredentials.getEcKeyPair()), this.deedManagerAddress, this.signHubMessage(rawMessage, this.deedManagerCredentials.getEcKeyPair()), rawMessage, token));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.disconnectedFromWom", (Object)this.hubAddress.toLowerCase());
    }

    @Test
    void updateHubWhenNotFound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            String token = this.hubService.generateToken(CLIENT_IP);
            this.hubService.updateHub(new HubUpdateRequest(this.hubAddress, this.name, this.description, this.url, this.color, this.signHubMessage(token, this.hubCredentials.getEcKeyPair()), token));
        });
    }

    @Test
    void updateHubWhenNotConnected() {
        HubEntity hubEntity = this.newHubEntity();
        hubEntity.setUntilDate(Instant.now().minusSeconds(5L));
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(hubEntity));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        String token = this.hubService.generateToken(CLIENT_IP);
        Assertions.assertThrows(WomException.class, () -> this.hubService.updateHub(new HubUpdateRequest(this.hubAddress, this.name, this.description, this.url, this.color, this.signHubMessage(token, this.hubCredentials.getEcKeyPair()), token)));
    }

    @Test
    void updateHub() throws WomException, ObjectNotFoundException {
        HubEntity oldHubEntity = this.newHubEntity();
        oldHubEntity.setName(null);
        oldHubEntity.setDescription(null);
        oldHubEntity.setUrl(null);
        oldHubEntity.setColor(null);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(oldHubEntity));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> new HubEntity(((HubEntity)invocation.getArgument(0, HubEntity.class)).getAddress(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getNftId(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getCity(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getType(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getHubOwnerAddress(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getDeedOwnerAddress(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getDeedManagerAddress(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getName(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getDescription(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getUrl(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getColor(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getAvatarId(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getBannerId(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getUsersCount(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getRewardsPeriodType(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getRewardsPerPeriod(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).isEnabled(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getOwnerClaimableAmount(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getManagerClaimableAmount(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getCreatedDate(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getUntilDate(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getJoinDate(), ((HubEntity)invocation.getArgument(0, HubEntity.class)).getUpdatedDate()));
        String token = this.hubService.generateToken(CLIENT_IP);
        this.hubService.updateHub(new HubUpdateRequest(this.hubAddress, this.name, this.description, this.url, this.color, this.signHubMessage(token, this.hubCredentials.getEcKeyPair()), token));
        ((HubRepository)Mockito.verify((Object)this.hubRepository, (VerificationMode)Mockito.atLeast((int)1))).save((Object)((HubEntity)ArgumentMatchers.argThat(entity -> this.name.equals(entity.getName()) && this.description.equals(entity.getDescription()) && this.url.equals(entity.getUrl()) && this.color.equals(entity.getColor()))));
    }

    @Test
    void saveHubAvatarWhenInvalidSignature() {
        String token = this.hubService.generateToken(CLIENT_IP);
        MultipartFile file = (MultipartFile)Mockito.mock(MultipartFile.class);
        Assertions.assertThrows(Exception.class, () -> this.hubService.saveHubAvatar(this.hubAddress, token, "signature", token, file));
    }

    @Test
    void saveHubAvatarWhenNotFound() {
        String token = this.hubService.generateToken(CLIENT_IP);
        MultipartFile file = (MultipartFile)Mockito.mock(MultipartFile.class);
        Assertions.assertThrows(Exception.class, () -> this.hubService.saveHubAvatar(this.hubAddress, token, this.signHubMessage(token, this.hubCredentials.getEcKeyPair()), token, file));
    }

    @Test
    void saveHubAvatarWhenNoFile() {
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(this.newHubEntity()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        String token = this.hubService.generateToken(CLIENT_IP);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.hubService.saveHubAvatar(this.hubAddress, this.signHubMessage(token, this.hubCredentials.getEcKeyPair()), token, token, null));
    }

    @Test
    void saveHubAvatarWhenSizeExceedsAllowed() {
        MultipartFile file = (MultipartFile)Mockito.mock(MultipartFile.class);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(this.newHubEntity()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)file.getSize()).thenReturn((Object)524288001L);
        String token = this.hubService.generateToken(CLIENT_IP);
        Assertions.assertThrows(WomRequestException.class, () -> this.hubService.saveHubAvatar(this.hubAddress, this.signHubMessage(token, this.hubCredentials.getEcKeyPair()), token, token, file));
    }

    @Test
    void saveHubAvatar() throws WomException, ObjectNotFoundException, IOException {
        MultipartFile file = (MultipartFile)Mockito.mock(MultipartFile.class);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(this.newHubEntity()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> invocation.getArgument(0));
        Mockito.when((Object)this.fileService.saveFile((FileBinary)ArgumentMatchers.any())).thenReturn((Object)this.avatarId);
        String token = this.hubService.generateToken(CLIENT_IP);
        this.hubService.saveHubAvatar(this.hubAddress, this.signHubMessage(token, this.hubCredentials.getEcKeyPair()), token, token, file);
        ((FileService)Mockito.verify((Object)this.fileService)).saveFile((FileBinary)ArgumentMatchers.any());
        ((HubRepository)Mockito.verify((Object)this.hubRepository)).save((Object)((HubEntity)ArgumentMatchers.any()));
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.saved", (Object)this.hubAddress.toLowerCase());
    }

    @Test
    void getHubAvatarWhenNoHub() {
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.empty());
        Assertions.assertThrows(Exception.class, () -> this.hubService.getHubAvatar(this.hubAddress));
    }

    @Test
    void getHubAvatarWhenNoHubAvatar() {
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(this.newHubEntity()));
        Assertions.assertNull((Object)this.hubService.getHubAvatar(this.hubAddress));
    }

    @Test
    void getHubAvatarWhenNoHubAvatarFile() {
        HubEntity hubEntity = this.newHubEntity();
        hubEntity.setAvatarId(this.avatarId);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(hubEntity));
        Assertions.assertNull((Object)this.hubService.getHubAvatar(this.hubAddress));
    }

    @Test
    void getHubAvatar() {
        HubEntity hubEntity = this.newHubEntity();
        hubEntity.setAvatarId(this.avatarId);
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(hubEntity));
        Mockito.when((Object)this.fileService.getFile(this.avatarId)).thenReturn((Object)((FileBinary)Mockito.mock(FileBinary.class)));
        Assertions.assertNotNull((Object)this.hubService.getHubAvatar(this.hubAddress));
    }

    @Test
    void refreshHubUemProperties() {
        HubEntity hubEntity = this.newHubEntity();
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenReturn(Optional.of(hubEntity));
        HubReportEntity reportEntity = new HubReportEntity();
        reportEntity.setHubAddress(this.hubAddress);
        reportEntity.setUsersCount(this.usersCount);
        reportEntity.setPeriodType("WEEK");
        reportEntity.setHubRewardAmount(2.0);
        Mockito.when((Object)this.reportRepository.findByHubAddress((String)ArgumentMatchers.eq((Object)StringUtils.lowerCase((String)this.hubAddress)), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Collections.singletonList(reportEntity)));
        this.hubService.refreshHubUemProperties(this.hubAddress);
        ((HubRepository)Mockito.verify((Object)this.hubRepository)).save((Object)hubEntity);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.status.changed", (Object)StringUtils.lowerCase((String)reportEntity.getHubAddress()));
        Assertions.assertEquals((long)reportEntity.getUsersCount(), (long)hubEntity.getUsersCount());
        Assertions.assertEquals((Object)reportEntity.getPeriodType(), (Object)hubEntity.getRewardsPeriodType());
        Assertions.assertEquals((double)reportEntity.getHubRewardAmount(), (double)hubEntity.getRewardsPerPeriod());
    }

    @Test
    void getManagedDeeds() throws ObjectNotFoundException {
        BigInteger ownedDeedId = BigInteger.TWO;
        BigInteger ownedLeasedDeedId = BigInteger.ONE;
        BigInteger leasedDeedId = BigInteger.TEN;
        Mockito.when((Object)this.blockchainService.getDeedsOwnedBy(this.deedManagerAddress)).thenReturn(Arrays.asList(ownedDeedId, ownedLeasedDeedId));
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(this.deedManagerAddress, Long.valueOf(ownedDeedId.longValue()))).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(this.deedManagerAddress, Long.valueOf(ownedLeasedDeedId.longValue()))).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(this.deedManagerAddress, Long.valueOf(leasedDeedId.longValue()))).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.leaseService.getCurrentLease(ownedLeasedDeedId.longValue())).thenReturn((Object)((DeedTenantLeaseDTO)Mockito.mock(DeedTenantLeaseDTO.class)));
        DeedTenantLeaseDTO lease = new DeedTenantLeaseDTO();
        lease.setNftId(leasedDeedId.longValue());
        Mockito.when((Object)this.leaseService.getLeases((LeaseFilter)ArgumentMatchers.any(LeaseFilter.class), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Collections.singletonList(lease)));
        List managedDeeds = this.hubService.getManagedDeeds(this.deedManagerAddress);
        Assertions.assertNotNull((Object)managedDeeds);
        Assertions.assertEquals((int)2, (int)managedDeeds.size());
        Assertions.assertTrue((boolean)managedDeeds.stream().map(ManagedDeed::getNftId).toList().contains(ownedDeedId.longValue()));
        Assertions.assertFalse((boolean)managedDeeds.stream().map(ManagedDeed::getNftId).toList().contains(ownedLeasedDeedId.longValue()));
        Assertions.assertTrue((boolean)managedDeeds.stream().map(ManagedDeed::getNftId).toList().contains(leasedDeedId.longValue()));
    }

    @Test
    void autoConnectToWomWhenDeedNotFound() throws ObjectNotFoundException {
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenThrow(ObjectNotFoundException.class);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.hubService.autoConnectHubToWom(this.hubAddress, this.deedId));
    }

    @Test
    void autoConnectToWom() throws ObjectNotFoundException, WomException {
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenReturn((Object)this.newDeedTenant());
        ThreadLocal<WomDeed> womDeedTL = new ThreadLocal<WomDeed>();
        womDeedTL.set(new WomDeed());
        ((BlockchainService)Mockito.doAnswer(invocation -> {
            womDeedTL.set(new WomDeed(((Short)invocation.getArgument(1)).shortValue(), ((Short)invocation.getArgument(2)).shortValue(), (double)((Short)invocation.getArgument(3, Short.class)).shortValue() / 100.0, ((Long)invocation.getArgument(4)).longValue(), (String)invocation.getArgument(5), (String)invocation.getArgument(6), (String)invocation.getArgument(7), ((Short)invocation.getArgument(8)).shortValue()));
            return null;
        }).when((Object)this.blockchainService)).autoConnectToWom(ArgumentMatchers.eq((long)this.deedId), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyShort(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyShort());
        DeedTenantLeaseDTO lease = new DeedTenantLeaseDTO();
        lease.setNftId(this.deedId);
        lease.setOwnerMintingPercentage((int)this.ownerPercentage);
        Mockito.when((Object)this.leaseService.getCurrentLease(this.deedId)).thenReturn((Object)lease);
        ThreadLocal hubEntityTL = new ThreadLocal();
        Mockito.when((Object)this.hubRepository.findById((Object)StringUtils.lowerCase((String)this.hubAddress))).thenAnswer(invocation -> hubEntityTL.get() == null ? Optional.empty() : Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.findByNftId(this.deedId)).thenAnswer(invocation -> hubEntityTL.get() == null ? Optional.empty() : Optional.of((HubEntity)hubEntityTL.get()));
        Mockito.when((Object)this.hubRepository.save((Object)((HubEntity)ArgumentMatchers.any()))).thenAnswer(invocation -> {
            HubEntity savedHubEntity = (HubEntity)invocation.getArgument(0);
            hubEntityTL.set(savedHubEntity);
            return savedHubEntity;
        });
        WomHub womHub = new WomHub(this.deedId, this.hubOwnerAddress, this.enabled, Instant.now().minusSeconds(56L).getEpochSecond());
        Mockito.when((Object)this.blockchainService.getHub(this.hubAddress)).thenReturn((Object)womHub);
        Mockito.when((Object)this.blockchainService.getWomDeed(this.deedId)).thenAnswer(invocation -> womDeedTL.get());
        Mockito.when((Object)this.tenantService.getDeedTenantOrImport(Long.valueOf(this.deedId))).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.tenantService.getDeedTenant(this.deedId)).thenReturn((Object)this.newDeedTenant());
        Mockito.when((Object)this.blockchainService.getDeedOwner(this.deedId)).thenReturn((Object)this.deedOwnerAddress);
        Mockito.when((Object)this.blockchainService.isDeedOwner(this.deedOwnerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedManager(this.deedId)).thenReturn((Object)this.deedManagerAddress);
        Mockito.when((Object)this.blockchainService.isDeedProvisioningManager(this.deedManagerAddress, this.deedId)).thenReturn((Object)true);
        Mockito.when((Object)this.blockchainService.getDeedCityIndex(this.deedId)).thenReturn((Object)this.city);
        Mockito.when((Object)this.blockchainService.getDeedCardType(this.deedId)).thenReturn((Object)this.cardType);
        this.hubService.autoConnectHubToWom(this.hubAddress, this.deedId);
        ((ListenerService)Mockito.verify((Object)this.listenerService)).publishEvent("uem.hub.connectedToWom", (Object)this.hubAddress.toLowerCase());
        ((BlockchainService)Mockito.verify((Object)this.blockchainService)).autoConnectToWom(this.deedId, this.city, this.cardType, this.mintingPower, this.maxUsers, this.deedOwnerAddress, this.deedManagerAddress, this.hubAddress, this.ownerPercentage);
    }

    private DeedTenant newDeedTenant() {
        return new DeedTenant(this.deedId, this.city, this.cardType, this.deedOwnerAddress, this.deedManagerAddress, this.deedManagerEmail, this.txHash, this.txHash, TenantProvisioningStatus.START_CONFIRMED, TenantStatus.DEPLOYED, true, null, null);
    }

    private UemRewardEntity newUemRewardEntity() {
        return new UemRewardEntity(Long.valueOf(this.rewardId), this.uemRewardAmount, this.fixedGlobalIndex, this.fromDate(), this.toDate(), this.reportIds, this.hubAddresses, this.sumEd);
    }

    private HubEntity newHubEntity() {
        return new HubEntity(this.hubAddress, this.deedId, this.city, this.cardType, this.hubOwnerAddress, this.deedOwnerAddress, this.deedManagerAddress, this.name, this.description, this.url, this.color, null, this.bannerId, this.usersCount, this.rewardsPeriodType, this.rewardsPerPeriod, this.enabled, this.ownerClaimableAmount, this.managerClaimableAmount, this.createdDate, this.untilDate, this.joinDate, this.updatedDate);
    }

    private Instant toDate() {
        return Instant.ofEpochSecond(this.periodEndTime);
    }

    private Instant fromDate() {
        return Instant.ofEpochSecond(this.periodStartTime);
    }

    public String signHubMessage(String rawRequest, ECKeyPair ecKeyPair) {
        byte[] encodedRequest = rawRequest.getBytes(StandardCharsets.UTF_8);
        Sign.SignatureData signatureData = Sign.signPrefixedMessage((byte[])encodedRequest, (ECKeyPair)ecKeyPair);
        byte[] retval = new byte[65];
        System.arraycopy(signatureData.getR(), 0, retval, 0, 32);
        System.arraycopy(signatureData.getS(), 0, retval, 32, 32);
        System.arraycopy(signatureData.getV(), 0, retval, 64, 1);
        return Numeric.toHexString((byte[])retval);
    }
}

