/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.elasticsearch.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Document(indexName="uem_reward", createIndex=true)
@Setting(replicas=0, shards=1)
public class UemRewardEntity {
    @Id
    @Field(type=FieldType.Long)
    private Long rewardId;
    @Field(type=FieldType.Double)
    private double amount;
    @Field(type=FieldType.Double)
    private double fixedGlobalIndex;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant fromDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant toDate;
    @Field(type=FieldType.Long)
    private List<Long> reportIds;
    @Field(type=FieldType.Keyword)
    private Set<String> hubAddresses;
    @Field(type=FieldType.Double)
    private double sumEd;

    @Generated
    public Long getRewardId() {
        return this.rewardId;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Generated
    public double getFixedGlobalIndex() {
        return this.fixedGlobalIndex;
    }

    @Generated
    public Instant getFromDate() {
        return this.fromDate;
    }

    @Generated
    public Instant getToDate() {
        return this.toDate;
    }

    @Generated
    public List<Long> getReportIds() {
        return this.reportIds;
    }

    @Generated
    public Set<String> getHubAddresses() {
        return this.hubAddresses;
    }

    @Generated
    public double getSumEd() {
        return this.sumEd;
    }

    @Generated
    public void setRewardId(Long rewardId) {
        this.rewardId = rewardId;
    }

    @Generated
    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Generated
    public void setFixedGlobalIndex(double fixedGlobalIndex) {
        this.fixedGlobalIndex = fixedGlobalIndex;
    }

    @Generated
    public void setFromDate(Instant fromDate) {
        this.fromDate = fromDate;
    }

    @Generated
    public void setToDate(Instant toDate) {
        this.toDate = toDate;
    }

    @Generated
    public void setReportIds(List<Long> reportIds) {
        this.reportIds = reportIds;
    }

    @Generated
    public void setHubAddresses(Set<String> hubAddresses) {
        this.hubAddresses = hubAddresses;
    }

    @Generated
    public void setSumEd(double sumEd) {
        this.sumEd = sumEd;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UemRewardEntity)) {
            return false;
        }
        UemRewardEntity other = (UemRewardEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getFixedGlobalIndex(), other.getFixedGlobalIndex()) != 0) {
            return false;
        }
        if (Double.compare(this.getSumEd(), other.getSumEd()) != 0) {
            return false;
        }
        Long this$rewardId = this.getRewardId();
        Long other$rewardId = other.getRewardId();
        if (this$rewardId == null ? other$rewardId != null : !((Object)this$rewardId).equals(other$rewardId)) {
            return false;
        }
        Instant this$fromDate = this.getFromDate();
        Instant other$fromDate = other.getFromDate();
        if (this$fromDate == null ? other$fromDate != null : !((Object)this$fromDate).equals(other$fromDate)) {
            return false;
        }
        Instant this$toDate = this.getToDate();
        Instant other$toDate = other.getToDate();
        if (this$toDate == null ? other$toDate != null : !((Object)this$toDate).equals(other$toDate)) {
            return false;
        }
        List<Long> this$reportIds = this.getReportIds();
        List<Long> other$reportIds = other.getReportIds();
        if (this$reportIds == null ? other$reportIds != null : !((Object)this$reportIds).equals(other$reportIds)) {
            return false;
        }
        Set<String> this$hubAddresses = this.getHubAddresses();
        Set<String> other$hubAddresses = other.getHubAddresses();
        return !(this$hubAddresses == null ? other$hubAddresses != null : !((Object)this$hubAddresses).equals(other$hubAddresses));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UemRewardEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $fixedGlobalIndex = Double.doubleToLongBits(this.getFixedGlobalIndex());
        result = result * 59 + (int)($fixedGlobalIndex >>> 32 ^ $fixedGlobalIndex);
        long $sumEd = Double.doubleToLongBits(this.getSumEd());
        result = result * 59 + (int)($sumEd >>> 32 ^ $sumEd);
        Long $rewardId = this.getRewardId();
        result = result * 59 + ($rewardId == null ? 43 : ((Object)$rewardId).hashCode());
        Instant $fromDate = this.getFromDate();
        result = result * 59 + ($fromDate == null ? 43 : ((Object)$fromDate).hashCode());
        Instant $toDate = this.getToDate();
        result = result * 59 + ($toDate == null ? 43 : ((Object)$toDate).hashCode());
        List<Long> $reportIds = this.getReportIds();
        result = result * 59 + ($reportIds == null ? 43 : ((Object)$reportIds).hashCode());
        Set<String> $hubAddresses = this.getHubAddresses();
        result = result * 59 + ($hubAddresses == null ? 43 : ((Object)$hubAddresses).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UemRewardEntity(rewardId=" + this.getRewardId() + ", amount=" + this.getAmount() + ", fixedGlobalIndex=" + this.getFixedGlobalIndex() + ", fromDate=" + String.valueOf(this.getFromDate()) + ", toDate=" + String.valueOf(this.getToDate()) + ", reportIds=" + String.valueOf(this.getReportIds()) + ", hubAddresses=" + String.valueOf(this.getHubAddresses()) + ", sumEd=" + this.getSumEd() + ")";
    }

    @Generated
    public UemRewardEntity() {
    }

    @Generated
    public UemRewardEntity(Long rewardId, double amount, double fixedGlobalIndex, Instant fromDate, Instant toDate, List<Long> reportIds, Set<String> hubAddresses, double sumEd) {
        this.rewardId = rewardId;
        this.amount = amount;
        this.fixedGlobalIndex = fixedGlobalIndex;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.reportIds = reportIds;
        this.hubAddresses = hubAddresses;
        this.sumEd = sumEd;
    }
}

