/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.elasticsearch.model.TrialContactInformation;
import io.meeds.deeds.common.elasticsearch.storage.TrialRepository;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.service.TrialService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={TrialService.class})
class TrialServiceTest {
    private static final Long ID = 1L;
    private static final String FULLNAME = "fullname";
    private static final String MOTIVATION = "motivation";
    private static final String POSITION = "position";
    private static final String ORGANIZATION = "organization";
    private static final String EMAIL = "email@test.com";
    @Autowired
    private TrialService trialService;
    @MockBean
    private TrialRepository trialRepository;
    @MockBean
    private ListenerService listenerService;

    TrialServiceTest() {
    }

    @Test
    void testSaveWithEmailTrial() {
        Mockito.when((Object)this.trialRepository.save((Object)((TrialContactInformation)ArgumentMatchers.any()))).thenAnswer(arg -> {
            TrialContactInformation trial = (TrialContactInformation)arg.getArgument(0);
            trial.setId(ID);
            return trial;
        });
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trialService.saveTrial(null, POSITION, ORGANIZATION, MOTIVATION, EMAIL));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.trialService.saveTrial(FULLNAME, POSITION, ORGANIZATION, MOTIVATION, null));
        TrialContactInformation savedTrial = this.trialService.saveTrial(FULLNAME, POSITION, ORGANIZATION, MOTIVATION, EMAIL);
        Assertions.assertNotNull((Object)savedTrial);
        Assertions.assertEquals((Long)ID, (Long)savedTrial.getId());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).publishEvent((String)ArgumentMatchers.eq((Object)"deed.event.trialCreate"), ArgumentMatchers.eq((Object)savedTrial));
    }

    @Test
    void testGetTrialByEmail() {
        TrialContactInformation trialContactInformation = new TrialContactInformation(ID, FULLNAME, POSITION, ORGANIZATION, MOTIVATION, EMAIL, null, null, null, null, null, null);
        Mockito.when((Object)this.trialRepository.findByEmail(EMAIL)).thenReturn((Object)trialContactInformation);
        TrialContactInformation trialByEmail = this.trialService.getTrialByEmail(EMAIL);
        Assertions.assertEquals((Object)trialContactInformation, (Object)trialByEmail);
    }
}

