/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.constant.BlockchainLeaseStatus;
import io.meeds.deeds.common.constant.BlockchainOfferStatus;
import io.meeds.deeds.common.constant.CommonConstants;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.model.DeedCity;
import io.meeds.deeds.common.model.DeedLeaseBlockchainState;
import io.meeds.deeds.common.model.DeedOfferBlockchainState;
import io.meeds.deeds.common.model.FundInfo;
import io.meeds.deeds.common.model.WomDeed;
import io.meeds.deeds.common.model.WomHub;
import io.meeds.deeds.contract.Deed;
import io.meeds.deeds.contract.DeedRenting;
import io.meeds.deeds.contract.DeedTenantProvisioning;
import io.meeds.deeds.contract.ERC20;
import io.meeds.deeds.contract.MeedsToken;
import io.meeds.deeds.contract.TokenFactory;
import io.meeds.deeds.contract.UserEngagementMinting;
import io.meeds.deeds.contract.WoM;
import io.meeds.deeds.contract.XMeedsNFTRewarding;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.UemReward;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Event;
import org.web3j.crypto.WalletUtils;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthLog;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple10;
import org.web3j.tuples.generated.Tuple12;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tuples.generated.Tuple5;
import org.web3j.tuples.generated.Tuple7;
import org.web3j.tuples.generated.Tuple8;
import org.web3j.tuples.generated.Tuple9;
import org.web3j.utils.Numeric;

@Component
public class BlockchainService {
    private static final Logger LOG = LoggerFactory.getLogger(BlockchainService.class);
    private static final StampedLock LOCK = new StampedLock();
    @Autowired
    @Qualifier(value="ethereumNetwork")
    private Web3j web3j;
    @Autowired
    @Qualifier(value="polygonNetwork")
    private Web3j polygonWeb3j;
    @Autowired(required=false)
    private DeedTenantProvisioning deedTenantProvisioning;
    @Autowired(required=false)
    private DeedRenting deedRenting;
    @Autowired
    private Deed deed;
    @Autowired
    private TokenFactory tokenFactory;
    @Autowired
    private XMeedsNFTRewarding xMeedsToken;
    @Autowired(required=false)
    private UserEngagementMinting uemContract;
    @Autowired(required=false)
    @Qualifier(value="womContractReadOnly")
    private WoM womContract;
    @Autowired(required=false)
    @Qualifier(value="womContractReadWrite")
    private WoM womContractWithManager;
    @Autowired
    @Qualifier(value="ethereumMeedToken")
    private MeedsToken ethereumToken;
    @Autowired
    @Qualifier(value="polygonMeedToken")
    private MeedsToken polygonToken;
    @Autowired
    @Qualifier(value="sushiPairToken")
    private ERC20 sushiPairToken;
    @Value(value="${io.meeds.maxWaitTransactionSending:3}")
    private int maxWaitTransactionSending;
    private long ethereumNetworkId;
    private long polygonNetworkId;

    public boolean isDeedStarted(long nftId) {
        try {
            return (Boolean)this.deedTenantProvisioning.tenantStatus(BigInteger.valueOf(nftId)).send();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving information 'getDeedCityIndex' from Blockchain", e);
        }
    }

    public boolean isTransactionMined(String transactionHash) {
        TransactionReceipt receipt = this.getTransactionReceipt(transactionHash);
        return receipt != null;
    }

    public boolean isTransactionConfirmed(String transactionHash) {
        TransactionReceipt receipt = this.getTransactionReceipt(transactionHash);
        return receipt != null && receipt.isStatusOK();
    }

    public boolean isPolygonTransactionMined(String transactionHash) {
        TransactionReceipt receipt = this.getPolygonTransactionReceipt(transactionHash);
        return receipt != null;
    }

    public boolean isPolygonTransactionConfirmed(String transactionHash) {
        TransactionReceipt receipt = this.getPolygonTransactionReceipt(transactionHash);
        return receipt != null && receipt.isStatusOK();
    }

    public long getLastBlock() {
        try {
            return ((EthBlockNumber)this.web3j.ethBlockNumber().send()).getBlockNumber().longValue();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting last block number", e);
        }
    }

    public long getPolygonLastBlock() {
        try {
            return ((EthBlockNumber)this.polygonWeb3j.ethBlockNumber().send()).getBlockNumber().longValue();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting last block number", e);
        }
    }

    public String getDeedManager(long deedId) {
        EthFilter ethFilter = (EthFilter)new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, this.deedTenantProvisioning.getContractAddress()).addSingleTopic(EventEncoder.encode((Event)DeedTenantProvisioning.DELEGATEEADDED_EVENT));
        try {
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                return this.getDeedOwner(deedId);
            }
            return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).map(this::getTransactionReceipt).filter(TransactionReceipt::isStatusOK).map(this::getMinedDeedTenant).filter(Objects::nonNull).distinct().filter(tenant -> tenant.getNftId() == deedId && !StringUtils.equalsIgnoreCase((CharSequence)tenant.getManagerAddress(), (CharSequence)"0x0000000000000000000000000000000000000000") && this.isDeedProvisioningManager(tenant.getManagerAddress(), deedId)).findFirst().map(DeedTenant::getManagerAddress).orElseGet(() -> this.getDeedOwner(deedId));
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs for deedTenantProvisioning.getDeedManager", e);
        }
    }

    public List<DeedTenant> getMinedProvisioningTransactions(long fromBlock, long toBlock) {
        EthFilter ethFilter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), this.deedTenantProvisioning.getContractAddress());
        try {
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                return Collections.emptyList();
            }
            return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).map(this::getTransactionReceipt).filter(TransactionReceipt::isStatusOK).map(this::getMinedDeedTenant).filter(Objects::nonNull).toList();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs", e);
        }
    }

    public List<? extends BaseEventResponse> getMinedUemLogs(long fromBlock, long toBlock) {
        EthFilter ethFilter = (EthFilter)new EthFilter((DefaultBlockParameter)(fromBlock == 0L ? DefaultBlockParameterName.EARLIEST : new DefaultBlockParameterNumber(fromBlock)), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), this.womContract.getContractAddress()).addOptionalTopics(new String[]{EventEncoder.encode((Event)WoM.HUBCONNECTED_EVENT), EventEncoder.encode((Event)WoM.HUBDISCONNECTED_EVENT)});
        EthLog ethLog = (EthLog)this.polygonWeb3j.ethGetLogs(ethFilter).send();
        List ethLogs = ethLog.getLogs();
        if (CollectionUtils.isEmpty((Collection)ethLogs)) {
            return Collections.emptyList();
        }
        return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).map(this::getPolygonTransactionReceipt).filter(Objects::nonNull).filter(TransactionReceipt::isStatusOK).map(this::getUemLogs).flatMap(Collection::stream).filter(Objects::nonNull).toList();
    }

    public Set<String> getMinedHubConnectionTransactions(long fromBlock, long toBlock) {
        EthFilter ethFilter = (EthFilter)new EthFilter((DefaultBlockParameter)(fromBlock == 0L ? DefaultBlockParameterName.EARLIEST : new DefaultBlockParameterNumber(fromBlock)), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), this.womContract.getContractAddress()).addOptionalTopics(new String[]{EventEncoder.encode((Event)WoM.HUBCONNECTED_EVENT), EventEncoder.encode((Event)WoM.HUBDISCONNECTED_EVENT)});
        EthLog ethLog = (EthLog)this.polygonWeb3j.ethGetLogs(ethFilter).send();
        List ethLogs = ethLog.getLogs();
        if (CollectionUtils.isEmpty((Collection)ethLogs)) {
            return Collections.emptySet();
        }
        return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).map(this::getPolygonTransactionReceipt).filter(Objects::nonNull).filter(TransactionReceipt::isStatusOK).map(this::getHubAddresses).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    public List<Map<?, ?>> getMinedRentingTransactions(long fromBlock, long toBlock) {
        EthFilter ethFilter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), this.deedRenting.getContractAddress());
        try {
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                return Collections.emptyList();
            }
            return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).flatMap(transactionHash -> {
                Map<BlockchainOfferStatus, DeedOfferBlockchainState> offerEvents = this.getOfferTransactionEvents((String)transactionHash);
                Map<BlockchainLeaseStatus, DeedLeaseBlockchainState> leaseEvents = this.getLeaseTransactionEvents((String)transactionHash);
                return MapUtils.isEmpty(offerEvents) ? Stream.of(leaseEvents) : (MapUtils.isEmpty(leaseEvents) ? Stream.of(offerEvents) : Stream.of(offerEvents, leaseEvents));
            }).filter(MapUtils::isNotEmpty).toList();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs of mined transactions", e);
        }
    }

    public String getDeedOwner(long deedId) {
        EthFilter ethFilter = (EthFilter)new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, this.deed.getContractAddress()).addOptionalTopics(new String[]{EventEncoder.encode((Event)Deed.TRANSFERSINGLE_EVENT), EventEncoder.encode((Event)Deed.TRANSFERBATCH_EVENT)});
        try {
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                throw new IllegalStateException("Should never happen: can't find owner by Blockchain Logs of the Deed " + deedId);
            }
            return ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).map(this::getTransactionReceipt).filter(TransactionReceipt::isStatusOK).flatMap(this::getTransferOwnershipEvents).filter(Objects::nonNull).map(CommonConstants.DeedOwnershipTransferEvent::getTo).distinct().filter(address -> this.isDeedOwner((String)address, deedId)).findFirst().orElseThrow();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs of deed ownership : " + deedId, e);
        }
    }

    public Set<CommonConstants.DeedOwnershipTransferEvent> getMinedTransferOwnershipDeedTransactions(long fromBlock, long toBlock) {
        EthFilter ethFilter = new EthFilter((DefaultBlockParameter)new DefaultBlockParameterNumber(fromBlock), (DefaultBlockParameter)new DefaultBlockParameterNumber(toBlock), this.deed.getContractAddress());
        try {
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List ethLogs = ethLog.getLogs();
            if (CollectionUtils.isEmpty((Collection)ethLogs)) {
                return Collections.emptySet();
            }
            List<CommonConstants.DeedOwnershipTransferEvent> events = ethLogs.stream().map(logResult -> (EthLog.LogObject)logResult.get()).filter(logObject -> !logObject.isRemoved()).map(Log::getTransactionHash).map(this::getTransactionReceipt).filter(TransactionReceipt::isStatusOK).flatMap(this::getTransferOwnershipEvents).filter(Objects::nonNull).toList();
            return new LinkedHashSet<CommonConstants.DeedOwnershipTransferEvent>(events);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving event logs", e);
        }
    }

    public Map<BlockchainOfferStatus, DeedOfferBlockchainState> getOfferTransactionEvents(String transactionHash) {
        try {
            List rentPaidEvents;
            List deletedEvents;
            List updatedEvents;
            TransactionReceipt transactionReceipt = ((EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(transactionHash).send()).getTransactionReceipt().orElse(null);
            if (transactionReceipt == null || !transactionReceipt.isStatusOK()) {
                return Collections.emptyMap();
            }
            EnumMap<BlockchainOfferStatus, DeedOfferBlockchainState> events = new EnumMap<BlockchainOfferStatus, DeedOfferBlockchainState>(BlockchainOfferStatus.class);
            List createdEvents = DeedRenting.getOfferCreatedEvents((TransactionReceipt)transactionReceipt);
            if (createdEvents != null && !createdEvents.isEmpty()) {
                if (createdEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one offer creation, {} events. This can't be handled, only first one will be handled", (Object)createdEvents.size());
                }
                DeedRenting.OfferCreatedEventResponse response = (DeedRenting.OfferCreatedEventResponse)createdEvents.get(0);
                DeedOfferBlockchainState deedOffer = this.getOfferById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                events.put(BlockchainOfferStatus.OFFER_CREATED, deedOffer);
            }
            if ((updatedEvents = DeedRenting.getOfferUpdatedEvents((TransactionReceipt)transactionReceipt)) != null && !updatedEvents.isEmpty()) {
                if (updatedEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one offer update, {} events. This can't be handled, only first one will be handled", (Object)updatedEvents.size());
                }
                DeedRenting.OfferUpdatedEventResponse response = (DeedRenting.OfferUpdatedEventResponse)updatedEvents.get(0);
                DeedOfferBlockchainState deedOffer = this.getOfferById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                events.put(BlockchainOfferStatus.OFFER_UPDATED, deedOffer);
            }
            if ((deletedEvents = DeedRenting.getOfferDeletedEvents((TransactionReceipt)transactionReceipt)) != null && !deletedEvents.isEmpty()) {
                if (deletedEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one offer delete, {} events. This can't be handled, only first one will be handled", (Object)deletedEvents.size());
                }
                DeedRenting.OfferDeletedEventResponse response = (DeedRenting.OfferDeletedEventResponse)deletedEvents.get(0);
                DeedOfferBlockchainState deedOffer = new DeedOfferBlockchainState(response.id, transactionReceipt.getBlockNumber(), response.deedId, response.owner, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, Address.DEFAULT.getValue(), BigInteger.ZERO, StringUtils.lowerCase((String)transactionHash));
                events.put(BlockchainOfferStatus.OFFER_DELETED, deedOffer);
            }
            if ((rentPaidEvents = DeedRenting.getRentPaidEvents((TransactionReceipt)transactionReceipt)) != null && !rentPaidEvents.isEmpty()) {
                if (rentPaidEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one rent paid {} events. This can't be handled, only first one will be handled", (Object)rentPaidEvents.size());
                }
                DeedRenting.RentPaidEventResponse response = (DeedRenting.RentPaidEventResponse)rentPaidEvents.get(0);
                DeedOfferBlockchainState deedOffer = this.getOfferById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                if (response.firstRent.booleanValue()) {
                    events.put(BlockchainOfferStatus.OFFER_ACQUIRED, deedOffer);
                }
            }
            return events;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving transaction receipt " + transactionHash + " logs", e);
        }
    }

    public Map<BlockchainLeaseStatus, DeedLeaseBlockchainState> getLeaseTransactionEvents(String transactionHash) {
        try {
            List tenantEvictedEvents;
            List leaseEndedEvents;
            TransactionReceipt transactionReceipt = ((EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(transactionHash).send()).getTransactionReceipt().orElse(null);
            if (transactionReceipt == null || !transactionReceipt.isStatusOK()) {
                return Collections.emptyMap();
            }
            EnumMap<BlockchainLeaseStatus, DeedLeaseBlockchainState> events = new EnumMap<BlockchainLeaseStatus, DeedLeaseBlockchainState>(BlockchainLeaseStatus.class);
            List rentPaidEvents = DeedRenting.getRentPaidEvents((TransactionReceipt)transactionReceipt);
            if (rentPaidEvents != null && !rentPaidEvents.isEmpty()) {
                if (rentPaidEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one rent paid {} events. This can't be handled, only first one will be handled", (Object)rentPaidEvents.size());
                }
                DeedRenting.RentPaidEventResponse response = (DeedRenting.RentPaidEventResponse)rentPaidEvents.get(0);
                DeedLeaseBlockchainState deedLease = this.getLeaseById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                if (response.firstRent.booleanValue()) {
                    events.put(BlockchainLeaseStatus.LEASE_ACQUIRED, deedLease);
                } else {
                    events.put(BlockchainLeaseStatus.LEASE_PAYED, deedLease);
                }
            }
            if ((leaseEndedEvents = DeedRenting.getLeaseEndedEvents((TransactionReceipt)transactionReceipt)) != null && !leaseEndedEvents.isEmpty()) {
                if (leaseEndedEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one lease ended {} events. This can't be handled, only first one will be handled", (Object)leaseEndedEvents.size());
                }
                DeedRenting.LeaseEndedEventResponse response = (DeedRenting.LeaseEndedEventResponse)leaseEndedEvents.get(0);
                DeedLeaseBlockchainState deedLease = this.getLeaseById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                events.put(BlockchainLeaseStatus.LEASE_ENDED, deedLease);
            }
            if ((tenantEvictedEvents = DeedRenting.getTenantEvictedEvents((TransactionReceipt)transactionReceipt)) != null && !tenantEvictedEvents.isEmpty()) {
                if (tenantEvictedEvents.size() > 1) {
                    LOG.warn("It seems that in a single transaction, we have more than one tenant evicted {} events. This can't be handled, only first one will be handled", (Object)tenantEvictedEvents.size());
                }
                DeedRenting.TenantEvictedEventResponse response = (DeedRenting.TenantEvictedEventResponse)tenantEvictedEvents.get(0);
                DeedLeaseBlockchainState deedLease = this.getLeaseById(response.id, transactionReceipt.getBlockNumber(), transactionHash);
                events.put(BlockchainLeaseStatus.LEASE_MANAGER_EVICTED, deedLease);
            }
            return events;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving transaction receipt " + transactionHash + " logs", e);
        }
    }

    public DeedOfferBlockchainState getOfferById(BigInteger offerId, BigInteger blockNumber, String transactionHash) throws Exception {
        Tuple12 offerTuple = (Tuple12)this.deedRenting.deedOffers(offerId).send();
        if (StringUtils.isBlank((CharSequence)transactionHash)) {
            transactionHash = this.getOfferCreationTransactionHash(offerId);
        }
        return new DeedOfferBlockchainState((BigInteger)offerTuple.component1(), blockNumber == null ? BigInteger.ZERO : blockNumber, (BigInteger)offerTuple.component2(), (String)offerTuple.component3(), (BigInteger)offerTuple.component4(), (BigInteger)offerTuple.component5(), (BigInteger)offerTuple.component6(), (BigInteger)offerTuple.component7(), (BigInteger)offerTuple.component8(), (BigInteger)offerTuple.component9(), (BigInteger)offerTuple.component10(), (String)offerTuple.component11(), (BigInteger)offerTuple.component12(), StringUtils.lowerCase((String)transactionHash));
    }

    public DeedLeaseBlockchainState getLeaseById(BigInteger leaseId, BigInteger blockNumber, String transactionHash) throws Exception {
        Tuple8 leaseTuple = (Tuple8)this.deedRenting.deedLeases(leaseId).send();
        return new DeedLeaseBlockchainState((BigInteger)leaseTuple.component1(), blockNumber == null ? BigInteger.ZERO : blockNumber, (BigInteger)leaseTuple.component2(), (BigInteger)leaseTuple.component3(), (BigInteger)leaseTuple.component4(), (BigInteger)leaseTuple.component5(), (BigInteger)leaseTuple.component6(), (BigInteger)leaseTuple.component7(), (String)leaseTuple.component8(), StringUtils.lowerCase((String)transactionHash));
    }

    public boolean isDeedProvisioningManager(String address, long nftId) {
        return WalletUtils.isValidAddress((String)address) && (Boolean)this.blockchainCall(this.deedTenantProvisioning.isProvisioningManager(address, BigInteger.valueOf(nftId))) != false;
    }

    public double getPendingRewards(String address) {
        return WalletUtils.isValidAddress((String)address) ? this.convertFromDecimals((BigInteger)this.blockchainCall(this.uemContract.pendingRewardBalanceOf(address)), 18) : 0.0;
    }

    public boolean isDeedOwner(String address, long nftId) {
        return WalletUtils.isValidAddress((String)address) && ((BigInteger)this.blockchainCall(this.deed.balanceOf(address, BigInteger.valueOf(nftId)))).longValue() > 0L;
    }

    public short getDeedCardType(long nftId) throws ObjectNotFoundException {
        try {
            return ((BigInteger)this.deed.cardType(BigInteger.valueOf(nftId)).send()).shortValue();
        }
        catch (Exception e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"execution reverted")) {
                throw new ObjectNotFoundException(e.getMessage());
            }
            throw new IllegalStateException("Error retrieving information 'getDeedCardType' from Blockchain", e);
        }
    }

    public List<BigInteger> getDeedsOwnedBy(String managerAddress) {
        return (List)this.deed.nftsOf(managerAddress).send();
    }

    public boolean isOfferEnabled(long offerId) throws Exception {
        DeedOfferBlockchainState offer = this.getOfferById(BigInteger.valueOf(offerId), null, "0x");
        if (offer != null && offer.getId().longValue() == offerId) {
            DeedLeaseBlockchainState lease = this.getLeaseById(BigInteger.valueOf(offerId), null, null);
            return lease == null || lease.getId().longValue() == 0L;
        }
        return false;
    }

    public short getDeedCityIndex(long nftId) throws ObjectNotFoundException {
        try {
            return ((BigInteger)this.deed.cityIndex(BigInteger.valueOf(nftId)).send()).shortValue();
        }
        catch (Exception e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"execution reverted")) {
                throw new ObjectNotFoundException(e.getMessage());
            }
            throw new IllegalStateException("Error retrieving information 'getDeedCityIndex' from Blockchain", e);
        }
    }

    public BigDecimal meedsTotalSupplyNoDecimals() {
        BigInteger totalSupply = this.meedsTotalSupply();
        return new BigDecimal(totalSupply).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128);
    }

    public BigInteger meedsTotalSupply() {
        return (BigInteger)this.blockchainCall(this.ethereumToken.totalSupply());
    }

    public BigInteger xMeedsTotalSupply() {
        return (BigInteger)this.blockchainCall(this.xMeedsToken.totalSupply());
    }

    public BigInteger sushiPairTotalSupply() {
        return (BigInteger)this.blockchainCall(this.sushiPairToken.totalSupply());
    }

    public FundInfo getFundInfo(String address) {
        Tuple5 fundInfo = (Tuple5)this.blockchainCall(this.tokenFactory.fundInfos(address));
        return fundInfo == null ? null : new FundInfo(address, (BigInteger)fundInfo.component1(), (BigInteger)fundInfo.component2(), (BigInteger)fundInfo.component3(), (BigInteger)fundInfo.component4(), (Boolean)fundInfo.component5());
    }

    public DeedCity getCurrentCity() {
        BigInteger currentCityIndex = (BigInteger)this.blockchainCall(this.xMeedsToken.currentCityIndex());
        Tuple4 cityInfo = (Tuple4)this.blockchainCall(this.xMeedsToken.cityInfo(currentCityIndex));
        return cityInfo == null ? null : new DeedCity(currentCityIndex, (String)cityInfo.component1(), (BigInteger)cityInfo.component2(), (BigInteger)cityInfo.component3(), (BigInteger)cityInfo.component4());
    }

    public FundInfo getXMeedFundInfo() {
        FundInfo fundInfo = this.getFundInfo(this.xMeedsToken.getContractAddress());
        fundInfo.setTotalSupply(this.xMeedsTotalSupply());
        fundInfo.setXMeedPendingReward(this.pendingRewardBalanceOf(this.xMeedsToken.getContractAddress()));
        fundInfo.setMeedsBalance(this.meedBalanceOf(this.xMeedsToken.getContractAddress()));
        return fundInfo;
    }

    public FundInfo getSushiPairFundInfo() {
        FundInfo fundInfo = this.getFundInfo(this.sushiPairToken.getContractAddress());
        fundInfo.setSymbol(this.sushiPairSymbol());
        fundInfo.setLpBalanceOfTokenFactory(this.stakedSushiPair());
        fundInfo.setTotalSupply(this.sushiPairTotalSupply());
        fundInfo.setMeedsBalance(this.meedBalanceOf(this.sushiPairToken.getContractAddress()));
        return fundInfo;
    }

    public String getHubOwner(String address) {
        if (this.womContract == null) {
            return null;
        }
        Tuple4 hubTuple = (Tuple4)this.womContract.hubs(address).send();
        String owner = hubTuple == null ? null : (String)hubTuple.component2();
        return StringUtils.equals((CharSequence)address, (CharSequence)"0x0000000000000000000000000000000000000000") ? null : owner;
    }

    public String getHubByDeedId(long nftId) {
        Tuple9 deedTuple = (Tuple9)this.womContract.nfts(BigInteger.valueOf(nftId)).send();
        return this.getHubAddressIfConnected(deedTuple == null ? null : (String)deedTuple.component7());
    }

    public WomDeed getWomDeed(long nftId) {
        if (this.womContract == null) {
            return null;
        }
        Tuple9 deedTuple = (Tuple9)this.womContract.nfts(BigInteger.valueOf(nftId)).send();
        if (deedTuple == null) {
            return null;
        }
        return new WomDeed(((BigInteger)deedTuple.component1()).shortValue(), ((BigInteger)deedTuple.component2()).shortValue(), (double)((BigInteger)deedTuple.component3()).shortValue() / 10.0, ((BigInteger)deedTuple.component4()).longValue(), (String)deedTuple.component5(), (String)deedTuple.component6(), this.getHubAddressIfConnected((String)deedTuple.component7()), ((BigInteger)deedTuple.component8()).shortValue());
    }

    public void autoConnectToWom(long deedId, short city, short cardType, short mintingPower, long maxUsers, String ownerAddress, String managerAddress, String hubAddress, short ownerMintingPercentage) throws WomException {
        this.updateDeedStatusOnWom(deedId, city, cardType, mintingPower, maxUsers, ownerAddress, managerAddress, hubAddress, ownerMintingPercentage);
    }

    public void updateWomDeed(long deedId, short city, short cardType, short mintingPower, long maxUsers, String ownerAddress, String managerAddress, short ownerMintingPercentage) throws WomException {
        this.updateDeedStatusOnWom(deedId, city, cardType, mintingPower, maxUsers, ownerAddress, managerAddress, "0x0000000000000000000000000000000000000000", ownerMintingPercentage);
    }

    public WomHub getHub(String address) {
        if (this.womContract == null) {
            return null;
        }
        Tuple4 hubTuple = (Tuple4)this.womContract.hubs(address).send();
        if (hubTuple == null) {
            return null;
        }
        return new WomHub(((BigInteger)hubTuple.component1()).longValue(), (String)hubTuple.component2(), this.isHubConnected(address), ((BigInteger)hubTuple.component4()).longValue());
    }

    public double getUemPeriodicRewardAmount() {
        if (this.uemContract == null) {
            return 0.0;
        }
        BigInteger periodicRewardAmount = (BigInteger)this.uemContract.periodicRewardAmount().send();
        return BigDecimal.valueOf(periodicRewardAmount.doubleValue()).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue();
    }

    public void retrieveRewardProperties(UemReward reward) {
        if (this.uemContract == null) {
            return;
        }
        BigInteger rewardId = BigInteger.valueOf(reward.getRewardId());
        Tuple7 uemReward = (Tuple7)this.uemContract.rewards(rewardId).send();
        reward.setAmount(new BigDecimal((BigInteger)uemReward.component1()).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue());
        long fromReport = ((BigInteger)uemReward.component3()).longValue();
        long toReport = ((BigInteger)uemReward.component4()).longValue();
        ArrayList<Long> reportIds = new ArrayList<Long>();
        if (fromReport > 0L) {
            for (long i = fromReport; i <= toReport; ++i) {
                reportIds.add(i);
            }
        }
        reward.setReportIds(reportIds);
        reward.setFixedGlobalIndex(new BigDecimal((BigInteger)uemReward.component5()).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue());
        reward.setFromDate(Instant.ofEpochSecond(((BigInteger)uemReward.component6()).longValue()));
        reward.setToDate(Instant.ofEpochSecond(((BigInteger)uemReward.component7()).longValue()));
    }

    public HubReport retrieveReportProperties(long reportId) {
        if (this.uemContract == null) {
            return null;
        }
        HubReport report = new HubReport();
        report.setReportId(reportId);
        this.retrieveReportProperties(report);
        return report;
    }

    public void retrieveReportProperties(HubReport report) {
        if (this.uemContract == null) {
            return;
        }
        BigInteger reportId = BigInteger.valueOf(report.getReportId());
        Tuple10 hubReport = (Tuple10)this.uemContract.hubReports(reportId).send();
        if (StringUtils.equals((CharSequence)((CharSequence)hubReport.component1()), (CharSequence)"0x0000000000000000000000000000000000000000")) {
            throw new IllegalStateException("Report with id " + report.getReportId() + " doesn't exist in Blockchain");
        }
        report.setHubAddress(StringUtils.lowerCase((String)((String)hubReport.component1())));
        report.setUsersCount(((BigInteger)hubReport.component2()).longValue());
        report.setRecipientsCount(((BigInteger)hubReport.component3()).longValue());
        report.setParticipantsCount(((BigInteger)hubReport.component4()).longValue());
        report.setAchievementsCount(((BigInteger)hubReport.component5()).longValue());
        report.setHubRewardAmount(new BigDecimal((BigInteger)hubReport.component6()).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue());
        report.setRewardTokenAddress(StringUtils.lowerCase((String)((String)hubReport.component7())));
        report.setRewardTokenNetworkId(((BigInteger)hubReport.component8()).longValue());
        report.setFromDate(Instant.ofEpochSecond(((BigInteger)hubReport.component9()).longValue()));
        report.setToDate(Instant.ofEpochSecond(((BigInteger)hubReport.component10()).longValue()));
        Tuple9 hubReportReward = (Tuple9)this.uemContract.hubRewards(reportId).send();
        report.setRewardId(((BigInteger)hubReportReward.component1()).longValue());
        report.setOwnerAddress(StringUtils.lowerCase((String)((String)hubReportReward.component2())));
        report.setDeedManagerAddress(StringUtils.lowerCase((String)((String)hubReportReward.component3())));
        report.setFixedRewardIndex(new BigDecimal((BigInteger)hubReportReward.component4()).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue());
        report.setOwnerFixedIndex(new BigDecimal((BigInteger)hubReportReward.component5()).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue());
        report.setTenantFixedIndex(new BigDecimal((BigInteger)hubReportReward.component6()).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue());
        report.setOwnerMintingPercentage(new BigDecimal((BigInteger)hubReportReward.component5()).multiply(BigDecimal.valueOf(100L)).divide(new BigDecimal((BigInteger)hubReportReward.component4()), MathContext.DECIMAL128).setScale(0, RoundingMode.HALF_EVEN).toBigInteger().intValue());
        report.setSentDate(Instant.ofEpochSecond(((BigInteger)hubReportReward.component7()).longValue()));
        report.setFraud(((Boolean)hubReportReward.component8()).booleanValue());
        report.setLastPeriodUemRewardAmount(new BigDecimal((BigInteger)hubReportReward.component9()).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128).doubleValue());
        Tuple5 reportDeed = (Tuple5)this.uemContract.hubDeeds(reportId).send();
        report.setDeedId(((BigInteger)reportDeed.component1()).longValue());
        report.setCity(((BigInteger)reportDeed.component2()).shortValue());
        report.setCardType(((BigInteger)reportDeed.component3()).shortValue());
        report.setMintingPower(((BigInteger)reportDeed.component4()).shortValue());
        report.setMaxUsers(((BigInteger)reportDeed.component5()).longValue());
    }

    public boolean isReportFraud(long reportId) {
        return (Boolean)((Tuple9)this.uemContract.hubRewards(BigInteger.valueOf(reportId)).send()).component8();
    }

    public boolean isHubConnected(String address) {
        return (Boolean)this.womContract.isHubConnected(address).send();
    }

    public String getEthereumMeedTokenAddress() {
        return this.ethereumToken.getContractAddress();
    }

    public String getPolygonMeedTokenAddress() {
        return this.polygonToken.getContractAddress();
    }

    public String getUemAddress() {
        return this.uemContract == null ? null : this.uemContract.getContractAddress();
    }

    public String getWomAddress() {
        return this.womContract == null ? null : this.womContract.getContractAddress();
    }

    public BigInteger pendingRewardBalanceOf(String address) {
        return (BigInteger)this.blockchainCall(this.tokenFactory.pendingRewardBalanceOf(address));
    }

    public BigInteger totalAllocationPoints() {
        return (BigInteger)this.blockchainCall(this.tokenFactory.totalAllocationPoints());
    }

    public BigInteger totalFixedPercentage() {
        return (BigInteger)this.blockchainCall(this.tokenFactory.totalFixedPercentage());
    }

    public BigDecimal meedBalanceOfNoDecimals(String address) {
        BigInteger balance = this.meedBalanceOf(address);
        return new BigDecimal(balance).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128);
    }

    public BigInteger meedBalanceOf(String address) {
        return (BigInteger)this.blockchainCall(this.ethereumToken.balanceOf(address));
    }

    public String sushiPairSymbol() {
        return (String)this.blockchainCall(this.sushiPairToken.symbol());
    }

    public BigInteger stakedSushiPair() {
        return (BigInteger)this.blockchainCall(this.sushiPairToken.balanceOf(this.tokenFactory.getContractAddress()));
    }

    public BigDecimal meedBalanceOfOnPolygon(String address) {
        BigInteger balance = (BigInteger)this.blockchainCall(this.polygonToken.balanceOf(address));
        return new BigDecimal(balance).divide(BigDecimal.valueOf(10L).pow(18), MathContext.DECIMAL128);
    }

    public long getNetworkId() {
        if (this.ethereumNetworkId == 0L) {
            this.ethereumNetworkId = new BigInteger(((NetVersion)this.web3j.netVersion().send()).getNetVersion()).longValue();
        }
        return this.ethereumNetworkId;
    }

    public long getPolygonNetworkId() {
        if (this.polygonNetworkId == 0L) {
            this.polygonNetworkId = new BigInteger(((NetVersion)this.polygonWeb3j.netVersion().send()).getNetVersion()).longValue();
        }
        return this.polygonNetworkId;
    }

    public String getOfferCreationTransactionHash(BigInteger offerId) throws IOException {
        try {
            EthFilter ethFilter = (EthFilter)((EthFilter)new EthFilter((DefaultBlockParameter)DefaultBlockParameterName.EARLIEST, (DefaultBlockParameter)DefaultBlockParameterName.LATEST, this.deedRenting.getContractAddress()).addSingleTopic(EventEncoder.encode((Event)DeedRenting.OFFERCREATED_EVENT))).addOptionalTopics(new String[]{Numeric.toHexStringWithPrefixZeroPadded((BigInteger)offerId, (int)64)});
            EthLog ethLog = (EthLog)this.web3j.ethGetLogs(ethFilter).send();
            List logs = ethLog.getLogs();
            if (CollectionUtils.isNotEmpty((Collection)logs)) {
                EthLog.LogResult logResult = (EthLog.LogResult)logs.get(0);
                EthLog.LogObject logObject = (EthLog.LogObject)logResult.get();
                return logObject.getTransactionHash();
            }
        }
        catch (Exception e) {
            LOG.warn("Error retrieving Offer Creation Hash, return null instead", (Throwable)e);
        }
        return null;
    }

    private Stream<CommonConstants.DeedOwnershipTransferEvent> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List transferSingleEvents = Deed.getTransferSingleEvents((TransactionReceipt)transactionReceipt);
        if (transferSingleEvents != null && !transferSingleEvents.isEmpty()) {
            return transferSingleEvents.stream().map(transferSingleEventResponse -> new CommonConstants.DeedOwnershipTransferEvent(transferSingleEventResponse._id.longValue(), transferSingleEventResponse._from, transferSingleEventResponse._to));
        }
        List transferBatchEvents = Deed.getTransferBatchEvents((TransactionReceipt)transactionReceipt);
        if (transferBatchEvents != null && !transferBatchEvents.isEmpty()) {
            return transferBatchEvents.stream().flatMap(transferBatchEventResponse -> {
                String from = transferBatchEventResponse._from;
                String to = transferBatchEventResponse._to;
                return transferBatchEventResponse._ids.stream().map(nftId -> new CommonConstants.DeedOwnershipTransferEvent(nftId.longValue(), from, to));
            });
        }
        return Stream.empty();
    }

    private DeedTenant getMinedDeedTenant(TransactionReceipt transactionReceipt) {
        List startedEvents = DeedTenantProvisioning.getTenantStartedEvents((TransactionReceipt)transactionReceipt);
        if (startedEvents != null && !startedEvents.isEmpty()) {
            DeedTenantProvisioning.TenantStartedEventResponse tenantStartedEventResponse = (DeedTenantProvisioning.TenantStartedEventResponse)startedEvents.get(0);
            DeedTenant deedTenant = new DeedTenant();
            deedTenant.setNftId(tenantStartedEventResponse.nftId.longValue());
            deedTenant.setStartupTransactionHash(transactionReceipt.getTransactionHash());
            deedTenant.setManagerAddress(tenantStartedEventResponse.manager.toLowerCase());
            return deedTenant;
        }
        List endedEvents = DeedTenantProvisioning.getTenantStoppedEvents((TransactionReceipt)transactionReceipt);
        if (endedEvents != null && !endedEvents.isEmpty()) {
            DeedTenantProvisioning.TenantStoppedEventResponse tenantStoppedEventResponse = (DeedTenantProvisioning.TenantStoppedEventResponse)endedEvents.get(0);
            DeedTenant deedTenant = new DeedTenant();
            deedTenant.setNftId(tenantStoppedEventResponse.nftId.longValue());
            deedTenant.setShutdownTransactionHash(transactionReceipt.getTransactionHash());
            deedTenant.setManagerAddress(tenantStoppedEventResponse.manager.toLowerCase());
            return deedTenant;
        }
        return null;
    }

    private List<String> getHubAddresses(TransactionReceipt transactionReceipt) {
        List hubDisconnectedEvents;
        ArrayList<String> result = new ArrayList<String>();
        List hubConnectedEvents = WoM.getHubConnectedEvents((TransactionReceipt)transactionReceipt);
        if (CollectionUtils.isNotEmpty((Collection)hubConnectedEvents)) {
            WoM.HubConnectedEventResponse hubConnectedEventResponse = (WoM.HubConnectedEventResponse)hubConnectedEvents.get(0);
            result.add(hubConnectedEventResponse.hub);
        }
        if (CollectionUtils.isNotEmpty((Collection)(hubDisconnectedEvents = WoM.getHubDisconnectedEvents((TransactionReceipt)transactionReceipt)))) {
            WoM.HubDisconnectedEventResponse hubDisconnectedEventResponse = (WoM.HubDisconnectedEventResponse)hubDisconnectedEvents.get(0);
            result.add(hubDisconnectedEventResponse.hub);
        }
        return result;
    }

    private TransactionReceipt getPolygonTransactionReceipt(String transactionHash) {
        return this.getTransactionReceipt(transactionHash, this.polygonWeb3j);
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash) {
        return this.getTransactionReceipt(transactionHash, this.web3j);
    }

    private TransactionReceipt getTransactionReceipt(String transactionHash, Web3j customWeb3j) {
        try {
            EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)customWeb3j.ethGetTransactionReceipt(transactionHash).send();
            if (ethGetTransactionReceipt != null) {
                return (TransactionReceipt)ethGetTransactionReceipt.getResult();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error retrieving Receipt for Transaction with hash: " + transactionHash, e);
        }
        return null;
    }

    private <T> T blockchainCall(RemoteFunctionCall<T> remoteCall) {
        try {
            return (T)remoteCall.send();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error calling blockchain", e);
        }
    }

    private String getWomContractExceptionMessage(Throwable e) {
        if (e != null) {
            String message;
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"wom.") && StringUtils.isNotBlank((CharSequence)(message = this.getWomContractMessage(e.getMessage())))) {
                return message;
            }
            if (e.getCause() != null) {
                return this.getWomContractExceptionMessage(e.getCause());
            }
        }
        return null;
    }

    private String getWomContractMessage(String message) {
        Matcher matcher = Pattern.compile("wom\\.[a-zA-Z0-9]+").matcher(message);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private String getHubAddressIfConnected(String hubAddress) throws Exception {
        hubAddress = StringUtils.equalsIgnoreCase((CharSequence)hubAddress, (CharSequence)"0x0000000000000000000000000000000000000000") ? null : hubAddress;
        return hubAddress != null && (Boolean)this.womContract.isHubConnected(hubAddress).send() != false ? hubAddress : null;
    }

    private void updateDeedStatusOnWom(long deedId, short city, short cardType, short mintingPower, long maxUsers, String ownerAddress, String managerAddress, String hubAddress, short ownerMintingPercentage) throws WomException {
        long stamp;
        try {
            stamp = LOCK.tryWriteLock((long)this.maxWaitTransactionSending * 3L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new WomException("wom.updateDeedTransactionTimedOut");
        }
        try {
            TransactionReceipt transactionReceipt = (TransactionReceipt)this.womContractWithManager.updateDeed(BigInteger.valueOf(deedId), new WoM.Deed(BigInteger.valueOf(city), BigInteger.valueOf(cardType), BigInteger.valueOf(mintingPower), BigInteger.valueOf(maxUsers), ownerAddress, managerAddress, hubAddress, BigInteger.valueOf(ownerMintingPercentage), BigInteger.valueOf(100L - (long)ownerMintingPercentage))).sendAsync().orTimeout(this.maxWaitTransactionSending, TimeUnit.MINUTES).get();
            if (transactionReceipt == null) {
                throw new WomException("wom.updateDeedTransactionFailedWithoutReceipt");
            }
            if (!transactionReceipt.isStatusOK()) {
                String message = this.getWomContractMessage(transactionReceipt.getRevertReason());
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    throw new WomException(message);
                }
                message = this.getWomContractMessage(transactionReceipt.getStatus());
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    throw new WomException(message);
                }
                throw new WomException("wom.updateDeedTransactionFailed");
            }
        }
        catch (Exception e) {
            String message = this.getWomContractExceptionMessage(e);
            if (StringUtils.isNotBlank((CharSequence)message)) {
                throw new WomException(message);
            }
            throw new IllegalStateException("Error While processing Deed Update transaction", e);
        }
        finally {
            LOCK.unlock(stamp);
        }
    }

    private List<? extends BaseEventResponse> getUemLogs(TransactionReceipt transactionReceipt) {
        return Stream.of(UserEngagementMinting.getReportSentEvents((TransactionReceipt)transactionReceipt), UserEngagementMinting.getReportFraudEvents((TransactionReceipt)transactionReceipt), UserEngagementMinting.getClaimedEvents((TransactionReceipt)transactionReceipt)).flatMap(Collection::stream).filter(Objects::nonNull).toList();
    }

    private double convertFromDecimals(BigInteger amount, int decimals) {
        return amount == null ? 0.0 : BigDecimal.valueOf(amount.doubleValue()).divide(BigDecimal.valueOf(10L).pow(decimals), MathContext.DECIMAL128).doubleValue();
    }
}

