/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.constant.AttachmentType;
import io.meeds.deeds.common.constant.DeedCard;
import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.elasticsearch.model.HubEntity;
import io.meeds.deeds.common.elasticsearch.model.HubReportEntity;
import io.meeds.deeds.common.elasticsearch.model.UemRewardEntity;
import io.meeds.deeds.common.elasticsearch.storage.HubReportRepository;
import io.meeds.deeds.common.elasticsearch.storage.HubRepository;
import io.meeds.deeds.common.elasticsearch.storage.UemRewardRepository;
import io.meeds.deeds.common.model.DeedTenantLeaseDTO;
import io.meeds.deeds.common.model.FileBinary;
import io.meeds.deeds.common.model.LeaseFilter;
import io.meeds.deeds.common.model.ManagedDeed;
import io.meeds.deeds.common.model.WomDeed;
import io.meeds.deeds.common.model.WomHub;
import io.meeds.deeds.common.service.BlockchainService;
import io.meeds.deeds.common.service.FileService;
import io.meeds.deeds.common.service.LeaseService;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.service.TenantService;
import io.meeds.deeds.common.utils.HubMapper;
import io.meeds.wom.api.constant.ObjectNotFoundException;
import io.meeds.wom.api.constant.WomAuthorizationException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.constant.WomRequestException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.HubUpdateRequest;
import io.meeds.wom.api.model.WomConnectionRequest;
import io.meeds.wom.api.model.WomConnectionResponse;
import io.meeds.wom.api.model.WomDisconnectionRequest;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

@Component
public class HubService {
    private static final Logger LOG = LoggerFactory.getLogger(HubService.class);
    public static final String HUB_SAVED = "uem.hub.saved";
    public static final String HUB_CONNECTED = "uem.hub.connectedToWom";
    public static final String HUB_DISCONNECTED = "uem.hub.disconnectedFromWom";
    public static final String HUB_STATUS_CHANGED = "uem.hub.status.changed";
    public static final String WOM_INVALID_SIGNED_MESSAGE = "wom.invalidSignedMessage";
    private SecureRandom secureRandomCodeGenerator;
    @Autowired
    private TenantService tenantService;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private FileService fileService;
    @Autowired
    private BlockchainService blockchainService;
    @Autowired
    private LeaseService leaseService;
    @Autowired
    private HubRepository hubRepository;
    @Autowired
    private HubReportRepository reportRepository;
    @Autowired
    private UemRewardRepository rewardRepository;
    @Value(value="${meeds.hub.maxTokensPerClientIp:100}")
    private int maxTokensPerClientIp;
    @Value(value="${meeds.hub.maxTokenLiveTimeSeconds:600}")
    private int maxTokenLiveTime;
    private Map<String, TokenDetail> tokens = new ConcurrentHashMap<String, TokenDetail>();

    @PostConstruct
    public void init() {
        try {
            this.secureRandomCodeGenerator = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.secureRandomCodeGenerator = SecureRandom.getInstanceStrong();
        }
    }

    public Page<Hub> getHubs(Pageable pageable) {
        return this.getHubs(0L, pageable);
    }

    public Page<Hub> getHubs(long rewardId, Pageable pageable) {
        Page<HubEntity> page;
        Object object = pageable = pageable.isUnpaged() ? pageable : PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)pageable.getSortOr(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdDate"})));
        if (rewardId == 0L) {
            page = this.hubRepository.findByEnabledIsTrue(pageable);
        } else {
            UemRewardEntity rewardEntity = this.rewardRepository.findById(rewardId).orElse(null);
            if (rewardEntity == null || CollectionUtils.isEmpty(rewardEntity.getHubAddresses())) {
                return Page.empty((Pageable)pageable);
            }
            page = this.hubRepository.findByAddressInAndEnabledIsTrue(rewardEntity.getHubAddresses(), pageable);
        }
        return page.map(HubMapper::fromEntity);
    }

    public Hub getHub(Long nftId) {
        return this.hubRepository.findByNftId(nftId).map(HubMapper::fromEntity).orElseGet(() -> {
            try {
                DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(nftId);
                Hub hub = new Hub();
                hub.setDeedId(nftId.longValue());
                hub.setCity(deedTenant.getCityIndex());
                hub.setType(deedTenant.getCardType());
                hub.setDeedOwnerAddress(deedTenant.getOwnerAddress());
                hub.setDeedManagerAddress(deedTenant.getManagerAddress());
                hub.setHubOwnerAddress(StringUtils.isBlank((CharSequence)hub.getDeedManagerAddress()) ? hub.getDeedOwnerAddress() : hub.getDeedManagerAddress());
                return hub;
            }
            catch (ObjectNotFoundException e) {
                return null;
            }
        });
    }

    public Hub getHub(String hubAddress) {
        return this.getHub(hubAddress, false);
    }

    public Hub getHub(String hubAddress, boolean forceRefresh) {
        Hub hub;
        if (forceRefresh && (hub = this.refreshHubFromWom(hubAddress)) != null) {
            this.refreshHubClaimableAmount(hubAddress);
        }
        HubEntity hubEntity = this.hubRepository.findById(StringUtils.lowerCase((String)hubAddress)).orElse(null);
        return HubMapper.fromEntity(hubEntity);
    }

    public Hub refreshHubFromWom(String hubAddress) {
        boolean hubExistsInWom;
        LOG.info("Update Hub {} from the WoM (Polygon Blockchain)", (Object)hubAddress);
        HubEntity hubEntity = this.hubRepository.findById(StringUtils.lowerCase((String)hubAddress)).orElse(null);
        boolean previouslyConnected = HubMapper.isConnected(hubEntity);
        WomHub hubFromWom = this.blockchainService.getHub(hubAddress);
        boolean bl = hubExistsInWom = hubFromWom != null && !StringUtils.equals((CharSequence)hubFromWom.getOwner(), (CharSequence)"0x0000000000000000000000000000000000000000");
        if (hubExistsInWom) {
            boolean refreshed;
            long deedId = hubFromWom.getDeedId();
            WomDeed womDeed = this.blockchainService.getWomDeed(deedId);
            if ((StringUtils.isBlank((CharSequence)womDeed.getManagerAddress()) || StringUtils.isBlank((CharSequence)womDeed.getOwnerAddress()) || StringUtils.equals((CharSequence)"0x0000000000000000000000000000000000000000", (CharSequence)womDeed.getManagerAddress()) || StringUtils.equals((CharSequence)"0x0000000000000000000000000000000000000000", (CharSequence)womDeed.getOwnerAddress()) || !this.blockchainService.isDeedProvisioningManager(womDeed.getManagerAddress(), deedId) || !this.blockchainService.isDeedOwner(womDeed.getOwnerAddress(), deedId)) && (refreshed = this.updateDeedOnWom(deedId))) {
                womDeed = this.blockchainService.getWomDeed(deedId);
            }
            if (hubEntity == null) {
                hubEntity = new HubEntity();
                hubEntity.setAddress(StringUtils.lowerCase((String)hubAddress));
                hubEntity.setCreatedDate(Instant.now());
                hubEntity.setUpdatedDate(hubEntity.getCreatedDate());
            } else {
                hubEntity.setUpdatedDate(Instant.now());
            }
            hubEntity.setNftId(deedId);
            hubEntity.setEnabled(hubFromWom.isEnabled());
            hubEntity.setHubOwnerAddress(hubFromWom.getOwner());
            hubEntity.setDeedOwnerAddress(womDeed.getOwnerAddress());
            hubEntity.setDeedManagerAddress(womDeed.getManagerAddress());
            hubEntity.setCity(womDeed.getCity());
            hubEntity.setType(womDeed.getCardType());
            hubEntity.setJoinDate(Instant.ofEpochSecond(hubFromWom.getJoinDate()));
            DeedTenantLeaseDTO lease = this.leaseService.getCurrentLease(deedId);
            if (lease == null) {
                hubEntity.setUntilDate(null);
            } else {
                hubEntity.setUntilDate(lease.getEndDate());
            }
            hubEntity = (HubEntity)this.hubRepository.save(hubEntity);
            this.listenerService.publishEvent(HUB_SAVED, StringUtils.lowerCase((String)hubEntity.getAddress()));
        } else if (hubEntity != null) {
            hubEntity.setEnabled(false);
            hubEntity = (HubEntity)this.hubRepository.save(hubEntity);
        }
        boolean connected = HubMapper.isConnected(hubEntity);
        if (connected != previouslyConnected) {
            if (connected) {
                this.listenerService.publishEvent(HUB_CONNECTED, StringUtils.lowerCase((String)hubAddress));
            } else {
                this.listenerService.publishEvent(HUB_DISCONNECTED, StringUtils.lowerCase((String)hubAddress));
            }
        }
        return HubMapper.fromEntity(hubEntity);
    }

    public void refreshClaimableAmount(String address) {
        Stream.of(this.hubRepository.findByDeedOwnerAddress(StringUtils.lowerCase((String)address)), this.hubRepository.findByDeedManagerAddress(StringUtils.lowerCase((String)address))).flatMap(s -> s).map(HubEntity::getAddress).distinct().forEach(this::refreshHubClaimableAmount);
    }

    public String generateToken(String clientIp) {
        this.cleanInvalidTokens();
        if (this.countTokens(clientIp) >= (long)this.maxTokensPerClientIp) {
            throw new IllegalStateException("Too much Tokens generated in a small time by Client IP:" + clientIp);
        }
        String token = String.format("%s-%s-%s", this.secureRandomCodeGenerator.nextLong(), this.secureRandomCodeGenerator.nextLong(), this.secureRandomCodeGenerator.nextLong());
        this.tokens.put(token, new TokenDetail(System.currentTimeMillis(), clientIp));
        return token;
    }

    public WomConnectionResponse connectToWom(WomConnectionRequest hubConnectionRequest) throws WomException {
        LOG.info("Hub connection {} initiation with Deed Id {} to the WoM", (Object)hubConnectionRequest.getAddress(), (Object)hubConnectionRequest.getDeedId());
        this.validateHubCommunityConnectionRequest(hubConnectionRequest);
        this.updateDeedOnWom(hubConnectionRequest.getDeedId(), null, hubConnectionRequest.getDeedOwnerAddress(), hubConnectionRequest.getDeedManagerAddress());
        this.saveHubProperties(hubConnectionRequest);
        return new WomConnectionResponse(hubConnectionRequest.getDeedId(), hubConnectionRequest.getAddress(), this.blockchainService.getWomAddress(), this.blockchainService.getUemAddress(), this.blockchainService.getPolygonNetworkId());
    }

    public String disconnectFromWom(WomDisconnectionRequest hubDisconnectionRequest) throws WomException {
        LOG.info("Hub disconnection {} initiation from the WoM", (Object)hubDisconnectionRequest.getHubAddress());
        this.validateHubCommunityDisonnectionRequest(hubDisconnectionRequest);
        Hub hub = this.getHub(hubDisconnectionRequest.getHubAddress());
        this.updateDeedOnWom(hub.getDeedId());
        this.refreshHubFromWom(hubDisconnectionRequest.getHubAddress());
        return this.blockchainService.getWomAddress();
    }

    public void updateHub(HubUpdateRequest hubUpdateRequest) throws WomException, ObjectNotFoundException {
        Hub hub = this.getHub(hubUpdateRequest.getAddress());
        if (hub == null) {
            throw new IllegalArgumentException("wom.hubIsMandatory");
        }
        LOG.info("Update Hub Card {} for owner {} with Deed Id {} to the WoM", new Object[]{hub.getAddress(), hub.getHubOwnerAddress(), hub.getDeedId()});
        String hubAddress = hub.getAddress();
        this.validateSignedHubMessage(hubAddress, hubUpdateRequest.getHubSignedMessage(), hubUpdateRequest.getToken(), hubUpdateRequest.getToken());
        Hub savedHub = this.getHub(hubAddress);
        if (savedHub == null) {
            throw new WomException("wom.hubNotConnectedToWoM");
        }
        if (!(savedHub.isConnected() || (savedHub = this.getHub(hubAddress, true)) != null && savedHub.isConnected())) {
            throw new WomException("wom.hubNotConnectedToWoM");
        }
        this.saveHubProperties(hubUpdateRequest);
    }

    public void saveHubAvatar(String hubAddress, String signedMessage, String rawMessage, String token, MultipartFile file) throws ObjectNotFoundException, WomException, IOException {
        this.validateSignedHubMessage(hubAddress, signedMessage, rawMessage, token);
        this.saveHubAttachment(hubAddress, file, AttachmentType.AVATAR);
    }

    public FileBinary getHubAvatar(String hubAddress) {
        String avatarId = this.getAvatarId(hubAddress);
        if (StringUtils.isNotBlank((CharSequence)avatarId)) {
            return this.fileService.getFile(avatarId);
        }
        return null;
    }

    public void refreshHubUemProperties(String hubAddress) {
        hubAddress = StringUtils.lowerCase((String)hubAddress);
        Page<HubReportEntity> page = this.reportRepository.findByHubAddress(hubAddress, (Pageable)PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"sentDate"})));
        HubReportEntity reportEntity = page.stream().findFirst().orElse(null);
        if (reportEntity != null) {
            this.hubRepository.findById(hubAddress).ifPresent(hubEntity -> {
                hubEntity.setUsersCount(reportEntity.getUsersCount());
                hubEntity.setRewardsPeriodType(reportEntity.getPeriodType());
                hubEntity.setRewardsPerPeriod(reportEntity.getHubRewardAmount());
                hubEntity = (HubEntity)this.hubRepository.save(hubEntity);
                this.listenerService.publishEvent(HUB_STATUS_CHANGED, StringUtils.lowerCase((String)reportEntity.getHubAddress()));
            });
        }
    }

    public List<ManagedDeed> getManagedDeeds(String address) {
        ArrayList<ManagedDeed> result = new ArrayList<ManagedDeed>();
        this.addOwnedDeeds(address, result);
        this.addLeasedDeeds(address, result);
        return result;
    }

    public boolean updateDeedOnWom(long deedId) throws ObjectNotFoundException, WomException {
        return this.updateDeedOnWom(deedId, false);
    }

    public boolean updateDeedOnWom(long deedId, boolean forceRefresh) throws ObjectNotFoundException, WomException {
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(deedId);
        return this.updateDeedOnWom(deedId, null, deedTenant.getOwnerAddress(), deedTenant.getManagerAddress(), forceRefresh);
    }

    public void autoConnectHubToWom(String hubAddress, long deedId) throws ObjectNotFoundException, WomException {
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(deedId);
        this.updateDeedOnWom(deedId, hubAddress, deedTenant.getOwnerAddress(), deedTenant.getManagerAddress());
        this.refreshHubFromWom(hubAddress);
    }

    public void transferDeedOwner(long deedId, String previousOwner, String newOwner) throws WomException {
        if (this.blockchainService.isDeedOwner(newOwner, deedId)) {
            this.updateDeedOnWom(deedId, null, newOwner, previousOwner);
            Hub hub = this.getHub(deedId);
            if (hub != null && StringUtils.isNotBlank((CharSequence)hub.getAddress()) && !StringUtils.equals((CharSequence)hub.getAddress(), (CharSequence)"0x0000000000000000000000000000000000000000")) {
                this.refreshHubFromWom(hub.getAddress());
                this.refreshHubClaimableAmount(hub.getAddress());
            }
        }
    }

    public void transferDeedManager(long deedId, String previousManager, String newManager) throws WomException {
        if (this.blockchainService.isDeedProvisioningManager(newManager, deedId)) {
            this.updateDeedOnWom(deedId, null, previousManager, newManager);
            Hub hub = this.getHub(deedId);
            if (hub != null && StringUtils.isNotBlank((CharSequence)hub.getAddress()) && !StringUtils.equals((CharSequence)hub.getAddress(), (CharSequence)"0x0000000000000000000000000000000000000000")) {
                this.refreshHubFromWom(hub.getAddress());
                this.refreshHubClaimableAmount(hub.getAddress());
            }
        }
    }

    protected void cleanTokens() {
        this.tokens.clear();
    }

    private void saveHubAttachment(String hubAddress, MultipartFile file, AttachmentType attachmentType) throws IOException, WomException {
        if (file == null) {
            throw new IllegalArgumentException("wom.fileIsMandatory");
        }
        if (file.getSize() > 524288000L) {
            throw new WomRequestException("wom.fileTooBig");
        }
        String fileId = null;
        if (attachmentType == AttachmentType.AVATAR) {
            fileId = this.getAvatarId(hubAddress);
        }
        String contentType = StringUtils.contains((CharSequence)file.getContentType(), (CharSequence)"image/") ? file.getContentType() : "image/png";
        FileBinary fileBinary = new FileBinary(fileId, file.getName(), contentType, file.getInputStream(), Instant.now());
        String savedFileId = this.fileService.saveFile(fileBinary);
        HubEntity hubEntity = (HubEntity)this.hubRepository.findById(StringUtils.lowerCase((String)hubAddress)).orElseThrow();
        if (attachmentType == AttachmentType.AVATAR) {
            hubEntity.setAvatarId(savedFileId);
        }
        hubEntity.setUpdatedDate(Instant.now());
        hubEntity = (HubEntity)this.hubRepository.save(hubEntity);
        this.listenerService.publishEvent(HUB_SAVED, StringUtils.lowerCase((String)hubEntity.getAddress()));
    }

    private String getAvatarId(String hubAddress) {
        HubEntity deedHub = (HubEntity)this.hubRepository.findById(StringUtils.lowerCase((String)hubAddress)).orElseThrow();
        return deedHub.getAvatarId();
    }

    private void refreshHubClaimableAmount(String hubAddress) {
        HubEntity hubEntity = (HubEntity)this.hubRepository.findById(StringUtils.lowerCase((String)hubAddress)).orElseThrow();
        if (StringUtils.isNotBlank((CharSequence)hubEntity.getDeedOwnerAddress()) && !StringUtils.equals((CharSequence)hubEntity.getDeedOwnerAddress(), (CharSequence)"0x0000000000000000000000000000000000000000")) {
            double ownerClaimableAmount = this.blockchainService.getPendingRewards(hubEntity.getDeedOwnerAddress());
            hubEntity.setOwnerClaimableAmount(ownerClaimableAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)hubEntity.getDeedManagerAddress()) && !StringUtils.equals((CharSequence)hubEntity.getDeedManagerAddress(), (CharSequence)"0x0000000000000000000000000000000000000000") && !StringUtils.equalsIgnoreCase((CharSequence)hubEntity.getDeedOwnerAddress(), (CharSequence)hubEntity.getDeedManagerAddress())) {
            double managerClaimableAmount = this.blockchainService.getPendingRewards(hubEntity.getDeedManagerAddress());
            hubEntity.setManagerClaimableAmount(managerClaimableAmount);
        }
        this.hubRepository.save(hubEntity);
    }

    private void validateSignedHubMessage(String hubAddress, String signedMessage, String rawMessage, String token) throws ObjectNotFoundException, WomException {
        Hub hub = this.getHub(hubAddress);
        if (hub == null) {
            throw new ObjectNotFoundException("wom.hubDoesNotExist");
        }
        this.checkTokenInMessage(token);
        this.checkSignedMessage(hubAddress, signedMessage, rawMessage, token);
    }

    private void validateHubCommunityConnectionRequest(WomConnectionRequest hubConnectionRequest) throws WomException {
        this.checkTokenInMessage(hubConnectionRequest.getToken());
        this.checkSignedMessage(hubConnectionRequest.getDeedManagerAddress(), hubConnectionRequest.getSignedMessage(), hubConnectionRequest.getRawMessage(), hubConnectionRequest.getToken());
        this.checkSignedMessage(hubConnectionRequest.getAddress(), hubConnectionRequest.getHubSignedMessage(), hubConnectionRequest.getRawMessage(), hubConnectionRequest.getToken());
    }

    private void validateHubCommunityDisonnectionRequest(WomDisconnectionRequest hubConnectionRequest) throws WomException {
        this.checkTokenInMessage(hubConnectionRequest.getToken());
        this.checkSignedMessage(hubConnectionRequest.getDeedManagerAddress(), hubConnectionRequest.getSignedMessage(), hubConnectionRequest.getRawMessage(), hubConnectionRequest.getToken());
        this.checkSignedMessage(hubConnectionRequest.getHubAddress(), hubConnectionRequest.getHubSignedMessage(), hubConnectionRequest.getRawMessage(), hubConnectionRequest.getToken());
    }

    private void saveHubProperties(WomConnectionRequest hubConnectionRequest) {
        this.saveHubProperties(hubConnectionRequest.getAddress(), hubConnectionRequest.getUrl(), hubConnectionRequest.getColor(), hubConnectionRequest.getName(), hubConnectionRequest.getDescription());
    }

    private void saveHubProperties(HubUpdateRequest hubUpdateRequest) {
        this.saveHubProperties(hubUpdateRequest.getAddress(), hubUpdateRequest.getUrl(), hubUpdateRequest.getColor(), hubUpdateRequest.getName(), hubUpdateRequest.getDescription());
    }

    private void saveHubProperties(String address, String url, String color, Map<String, String> name, Map<String, String> description) {
        this.refreshHubFromWom(address);
        HubEntity existingHubEntity = this.hubRepository.findById(StringUtils.lowerCase((String)address)).orElseGet(() -> {
            HubEntity hubEntity = new HubEntity();
            hubEntity.setAddress(address);
            return hubEntity;
        });
        existingHubEntity.setUrl(url);
        existingHubEntity.setColor(color);
        existingHubEntity.setName(name);
        existingHubEntity.setDescription(description);
        this.hubRepository.save(existingHubEntity);
    }

    private void checkTokenInMessage(String token) throws WomException {
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new WomAuthorizationException("wom.emptyTokenForSignedMessage");
        }
        this.cleanInvalidTokens();
        if (!this.tokens.containsKey(token)) {
            throw new WomAuthorizationException("wom.invalidTokenForSignedMessage");
        }
    }

    private void checkSignedMessage(String address, String signedMessage, String rawMessage, String token) throws WomException {
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new WomAuthorizationException("wom.emptyDeedManagerAddress");
        }
        if (StringUtils.isBlank((CharSequence)signedMessage) || StringUtils.isBlank((CharSequence)rawMessage)) {
            throw new WomAuthorizationException("wom.emptySignedMessage");
        }
        if (!StringUtils.contains((CharSequence)rawMessage, (CharSequence)token)) {
            throw new WomAuthorizationException(WOM_INVALID_SIGNED_MESSAGE);
        }
        try {
            BigInteger publicKey;
            String recoveredAddress;
            byte[] signatureBytes = Numeric.hexStringToByteArray((String)signedMessage);
            if (signatureBytes.length < 64) {
                throw new WomAuthorizationException(WOM_INVALID_SIGNED_MESSAGE);
            }
            byte[] r = Arrays.copyOfRange(signatureBytes, 0, 32);
            byte[] s = Arrays.copyOfRange(signatureBytes, 32, 64);
            byte v = signatureBytes[64];
            if (v < 27) {
                v = (byte)(v + 27);
            }
            if (!(recoveredAddress = "0x" + Keys.getAddress((BigInteger)(publicKey = Sign.signedPrefixedMessageToKey((byte[])rawMessage.getBytes(), (Sign.SignatureData)new Sign.SignatureData(v, r, s))))).equalsIgnoreCase(address)) {
                throw new WomAuthorizationException(WOM_INVALID_SIGNED_MESSAGE);
            }
        }
        catch (WomException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WomAuthorizationException(WOM_INVALID_SIGNED_MESSAGE, e);
        }
    }

    private boolean updateDeedOnWom(long deedId, String hubAddress, String potentialOwnerAddress, String potentialManagerAddress) throws WomException {
        return this.updateDeedOnWom(deedId, hubAddress, potentialOwnerAddress, potentialManagerAddress, false);
    }

    private boolean updateDeedOnWom(long deedId, String hubAddress, String potentialOwnerAddress, String potentialManagerAddress, boolean forceRefresh) throws WomException {
        DeedTenantLeaseDTO lease = this.leaseService.getCurrentLease(deedId);
        short ownerMintingPercentage = lease == null ? (short)100 : (short)lease.getOwnerMintingPercentage();
        String ownerAddress = this.getDeedOwnerAddress(deedId, potentialOwnerAddress);
        String managerAddress = this.getDeedManagerAddress(deedId, potentialManagerAddress, ownerAddress);
        long start = System.currentTimeMillis();
        this.validateDeedCharacteristics(deedId, ownerAddress, managerAddress);
        if (StringUtils.isBlank((CharSequence)hubAddress) || StringUtils.equals((CharSequence)hubAddress, (CharSequence)"0x0000000000000000000000000000000000000000")) {
            WomDeed woMDeed = this.blockchainService.getWomDeed(deedId);
            if (forceRefresh || woMDeed == null || !StringUtils.equalsIgnoreCase((CharSequence)woMDeed.getOwnerAddress(), (CharSequence)ownerAddress) || !StringUtils.equalsIgnoreCase((CharSequence)woMDeed.getManagerAddress(), (CharSequence)managerAddress) || woMDeed.getOwnerPercentage() != ownerMintingPercentage || StringUtils.isBlank((CharSequence)hubAddress)) {
                LOG.info("Sending Deed Update Transaction on Blockchain for Deed NFT #{} owner {} and manager {}", new Object[]{deedId, ownerAddress, managerAddress});
                short city = this.blockchainService.getDeedCityIndex(deedId);
                short cardType = this.blockchainService.getDeedCardType(deedId);
                DeedCard deedCard = DeedCard.values()[cardType];
                short mintingPower = (short)(deedCard.getMintingPower() * 100.0);
                long maxUsers = deedCard.getMaxUsers();
                this.blockchainService.updateWomDeed(deedId, city, cardType, mintingPower, maxUsers, ownerAddress, managerAddress, ownerMintingPercentage);
                LOG.info("Sent Deed Update Transaction on Blockchain for Deed NFT #{} owner {} and manager {} in {}ms", new Object[]{deedId, ownerAddress, managerAddress, System.currentTimeMillis() - start});
                return true;
            }
        } else {
            LOG.info("Sending Deed Auto Connect Transaction for Hub {} on Blockchain using Deed NFT #{} with owner {} and manager {}", new Object[]{hubAddress, deedId, ownerAddress, managerAddress});
            short city = this.blockchainService.getDeedCityIndex(deedId);
            short cardType = this.blockchainService.getDeedCardType(deedId);
            DeedCard deedCard = DeedCard.values()[cardType];
            short mintingPower = (short)(deedCard.getMintingPower() * 100.0);
            long maxUsers = deedCard.getMaxUsers();
            this.blockchainService.autoConnectToWom(deedId, city, cardType, mintingPower, maxUsers, ownerAddress, managerAddress, hubAddress, ownerMintingPercentage);
            LOG.info("Sent Deed Auto Connect Transaction on Blockchain for Hub {}, Deed NFT #{}, owner {} and manager {} in {}ms", new Object[]{hubAddress, deedId, ownerAddress, managerAddress, System.currentTimeMillis() - start});
            return true;
        }
        return false;
    }

    private void validateDeedCharacteristics(long deedId, String deedOwnerAddress, String deedManagerAddress) throws WomException {
        this.checkDeedOwner(deedOwnerAddress, deedId);
        this.checkDeedManager(deedManagerAddress, deedId);
    }

    private String getDeedOwnerAddress(long deedId, String potentialDeedOwner) {
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(deedId);
        Hub hub = this.getHub(deedId);
        String ownerAddress = Arrays.asList(potentialDeedOwner, deedTenant.getOwnerAddress(), hub.getDeedOwnerAddress(), hub.getHubOwnerAddress()).stream().filter(StringUtils::isNotBlank).map(StringUtils::lowerCase).collect(Collectors.toSet()).stream().filter(address -> this.blockchainService.isDeedOwner((String)address, deedId)).findFirst().orElse(null);
        if (ownerAddress == null) {
            ownerAddress = this.blockchainService.getDeedOwner(deedId);
        }
        if (ownerAddress != null && !StringUtils.equalsIgnoreCase((CharSequence)ownerAddress, (CharSequence)"0x0000000000000000000000000000000000000000") && !StringUtils.equalsIgnoreCase((CharSequence)ownerAddress, (CharSequence)deedTenant.getOwnerAddress())) {
            deedTenant.setOwnerAddress(ownerAddress);
            this.tenantService.saveDeedTenant(deedTenant);
        }
        return ownerAddress;
    }

    private String getDeedManagerAddress(long deedId, String potentialManagerAddress, String potentialOwnerAddress) {
        DeedTenantLeaseDTO lease = this.leaseService.getCurrentLease(deedId);
        DeedTenant deedTenant = this.tenantService.getDeedTenantOrImport(deedId);
        Hub hub = this.getHub(deedId);
        String managerAddress = Arrays.asList(potentialManagerAddress, potentialOwnerAddress, lease == null ? null : lease.getManagerAddress(), deedTenant.getManagerAddress(), hub.getDeedManagerAddress(), lease == null ? null : lease.getOwnerAddress(), deedTenant.getOwnerAddress(), hub.getDeedOwnerAddress(), hub.getHubOwnerAddress()).stream().filter(StringUtils::isNotBlank).map(StringUtils::lowerCase).collect(Collectors.toSet()).stream().filter(address -> this.blockchainService.isDeedProvisioningManager((String)address, deedId)).findFirst().orElse(null);
        if (managerAddress == null) {
            managerAddress = this.blockchainService.getDeedManager(deedId);
        }
        if (managerAddress != null && !StringUtils.equalsIgnoreCase((CharSequence)managerAddress, (CharSequence)"0x0000000000000000000000000000000000000000") && !StringUtils.equalsIgnoreCase((CharSequence)managerAddress, (CharSequence)deedTenant.getManagerAddress())) {
            deedTenant.setManagerAddress(managerAddress);
            this.tenantService.saveDeedTenant(deedTenant);
        }
        return managerAddress;
    }

    private void checkDeedOwner(String deedOwnerAddress, long deedId) throws WomException {
        if (!this.blockchainService.isDeedOwner(deedOwnerAddress, deedId)) {
            throw new WomAuthorizationException("wom.notDeedOwner");
        }
    }

    private void checkDeedManager(String deedManagerAddress, long deedId) throws WomException {
        if (!this.blockchainService.isDeedProvisioningManager(deedManagerAddress, deedId)) {
            throw new WomAuthorizationException("wom.notDeedManager");
        }
    }

    private void cleanInvalidTokens() {
        this.tokens.entrySet().removeIf(entry -> (System.currentTimeMillis() - ((TokenDetail)entry.getValue()).createdTime) / 1000L >= (long)this.maxTokenLiveTime);
    }

    private long countTokens(String clientIp) {
        return this.tokens.values().stream().filter(t -> StringUtils.equals((CharSequence)clientIp, (CharSequence)t.clientIp)).count();
    }

    private void addOwnedDeeds(String address, List<ManagedDeed> result) {
        List<BigInteger> deeds = this.blockchainService.getDeedsOwnedBy(address);
        if (CollectionUtils.isNotEmpty(deeds)) {
            deeds.stream().map(deedIdBN -> {
                long deedId = deedIdBN.longValue();
                DeedTenant deedTenant = this.getDeedTenant(address, deedId);
                if (this.leaseService.getCurrentLease(deedId) != null) {
                    return null;
                }
                return new ManagedDeed(deedId, DeedCity.values()[deedTenant.getCityIndex()], DeedCard.values()[deedTenant.getCardType()], deedTenant.getTenantProvisioningStatus(), address, address, null, null, this.isConnected(deedId));
            }).filter(Objects::nonNull).forEach(result::add);
        }
    }

    private void addLeasedDeeds(String address, List<ManagedDeed> result) {
        LeaseFilter leaseFilter = new LeaseFilter();
        leaseFilter.setCurrentAddress(address);
        leaseFilter.setOwner(false);
        Page<DeedTenantLeaseDTO> leasePage = this.leaseService.getLeases(leaseFilter, Pageable.unpaged());
        leasePage.get().map(lease -> {
            long deedId = lease.getNftId();
            DeedTenant deedTenant = this.getDeedTenant(address, deedId);
            return new ManagedDeed(deedId, DeedCity.values()[deedTenant.getCityIndex()], DeedCard.values()[deedTenant.getCardType()], deedTenant.getTenantProvisioningStatus(), lease.getOwnerAddress(), lease.getManagerAddress(), lease.getStartDate(), lease.getEndDate(), this.isConnected(deedId));
        }).filter(Objects::nonNull).forEach(result::add);
    }

    private DeedTenant getDeedTenant(String address, long deedId) {
        return this.tenantService.getDeedTenantOrImport(address, deedId);
    }

    private boolean isConnected(long deedId) {
        return this.hubRepository.findByNftId(deedId).map(HubMapper::isConnected).orElse(false);
    }

    private static class TokenDetail {
        long createdTime;
        String clientIp;

        @Generated
        public TokenDetail(long createdTime, String clientIp) {
            this.createdTime = createdTime;
            this.clientIp = clientIp;
        }
    }
}

