/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.listener.EventListener;
import io.meeds.deeds.common.service.ListenerService;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ListenerServiceInit
implements ApplicationContextAware {
    @Autowired
    private ListenerService listenerService;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        if (!ListenerService.LISTENERS.isEmpty()) {
            ListenerService.persistentFeatureEnabled = false;
        }
        this.registerListeners();
    }

    private synchronized void registerListeners() {
        Map eventListenerBeans = this.applicationContext.getBeansOfType(EventListener.class);
        for (EventListener eventListener : eventListenerBeans.values()) {
            ListenerService.EVENT_LISTENERS.add(eventListener);
        }
        if (!CollectionUtils.isEmpty(ListenerService.EVENT_LISTENERS)) {
            ListenerService.EVENT_LISTENERS.forEach(this.listenerService::addListener);
        }
    }
}

