package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple10;
import org.web3j.tuples.generated.Tuple3;
import org.web3j.tuples.generated.Tuple5;
import org.web3j.tuples.generated.Tuple7;
import org.web3j.tuples.generated.Tuple9;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 4.10.3.
 */
@SuppressWarnings("rawtypes")
public class TestUEM extends Contract {
    public static final String BINARY = "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";

    public static final String FUNC_MULTIPLIER = "MULTIPLIER";

    public static final String FUNC_REWARD_PERIOD_IN_SECONDS = "REWARD_PERIOD_IN_SECONDS";

    public static final String FUNC_ADDMANAGER = "addManager";

    public static final String FUNC_ADDREPORT = "addReport";

    public static final String FUNC_CLAIM = "claim";

    public static final String FUNC_HUBDEEDS = "hubDeeds";

    public static final String FUNC_HUBREPORTIDS = "hubReportIds";

    public static final String FUNC_HUBREPORTS = "hubReports";

    public static final String FUNC_HUBREWARDS = "hubRewards";

    public static final String FUNC_INITIALIZE = "initialize";

    public static final String FUNC_ISMANAGER = "isManager";

    public static final String FUNC_ISOWNER = "isOwner";

    public static final String FUNC_LASTREPORTID = "lastReportId";

    public static final String FUNC_MARKASFRAUD = "markAsFraud";

    public static final String FUNC_MEED = "meed";

    public static final String FUNC_OWNER = "owner";

    public static final String FUNC_PENDINGREWARDBALANCEOF = "pendingRewardBalanceOf";

    public static final String FUNC_PERIODICREWARDAMOUNT = "periodicRewardAmount";

    public static final String FUNC_PROXIABLEUUID = "proxiableUUID";

    public static final String FUNC_RECIPIENTS = "recipients";

    public static final String FUNC_REMOVEMANAGER = "removeManager";

    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";

    public static final String FUNC_REPORTSBYPERIODBYDEED = "reportsByPeriodByDeed";

    public static final String FUNC_REPORTSBYPERIODBYHUB = "reportsByPeriodByHub";

    public static final String FUNC_REPORTSBYRECIPIENT = "reportsByRecipient";

    public static final String FUNC_REWARDS = "rewards";

    public static final String FUNC_SETPERIODICREWARDAMOUNT = "setPeriodicRewardAmount";

    public static final String FUNC_SETTESTONPREVIOUSPERIOD = "setTestOnPreviousPeriod";

    public static final String FUNC_STARTREWARDSTIME = "startRewardsTime";

    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";

    public static final String FUNC_UPGRADETO = "upgradeTo";

    public static final String FUNC_UPGRADETOANDCALL = "upgradeToAndCall";

    public static final String FUNC_WOM = "wom";

    public static final Event ADMINCHANGED_EVENT = new Event("AdminChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Address>() {}));
    ;

    public static final Event BEACONUPGRADED_EVENT = new Event("BeaconUpgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event CLAIMED_EVENT = new Event("Claimed", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>(true) {}));
    ;

    public static final Event INITIALIZED_EVENT = new Event("Initialized", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint8>() {}));
    ;

    public static final Event MANAGERADDED_EVENT = new Event("ManagerAdded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event MANAGERREMOVED_EVENT = new Event("ManagerRemoved", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}));
    ;

    public static final Event REPORTFRAUD_EVENT = new Event("ReportFraud", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>(true) {}));
    ;

    public static final Event REPORTSENT_EVENT = new Event("ReportSent", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>(true) {}));
    ;

    public static final Event REWARDAMOUNTCHANGED_EVENT = new Event("RewardAmountChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>(true) {}));
    ;

    public static final Event UPGRADED_EVENT = new Event("Upgraded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}));
    ;

    @Deprecated
    protected TestUEM(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected TestUEM(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected TestUEM(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected TestUEM(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<AdminChangedEventResponse> getAdminChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(ADMINCHANGED_EVENT, transactionReceipt);
        ArrayList<AdminChangedEventResponse> responses = new ArrayList<AdminChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousAdmin = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.newAdmin = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static AdminChangedEventResponse getAdminChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(ADMINCHANGED_EVENT, log);
        AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
        typedResponse.log = log;
        typedResponse.previousAdmin = (String) eventValues.getNonIndexedValues().get(0).getValue();
        typedResponse.newAdmin = (String) eventValues.getNonIndexedValues().get(1).getValue();
        return typedResponse;
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getAdminChangedEventFromLog(log));
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(ADMINCHANGED_EVENT));
        return adminChangedEventFlowable(filter);
    }

    public static List<BeaconUpgradedEventResponse> getBeaconUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(BEACONUPGRADED_EVENT, transactionReceipt);
        ArrayList<BeaconUpgradedEventResponse> responses = new ArrayList<BeaconUpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.beacon = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static BeaconUpgradedEventResponse getBeaconUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(BEACONUPGRADED_EVENT, log);
        BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.beacon = (String) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getBeaconUpgradedEventFromLog(log));
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(BEACONUPGRADED_EVENT));
        return beaconUpgradedEventFlowable(filter);
    }

    public static List<ClaimedEventResponse> getClaimedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(CLAIMED_EVENT, transactionReceipt);
        ArrayList<ClaimedEventResponse> responses = new ArrayList<ClaimedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ClaimedEventResponse typedResponse = new ClaimedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.recipient = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.receiver = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.amount = (BigInteger) eventValues.getIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ClaimedEventResponse getClaimedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(CLAIMED_EVENT, log);
        ClaimedEventResponse typedResponse = new ClaimedEventResponse();
        typedResponse.log = log;
        typedResponse.recipient = (String) eventValues.getIndexedValues().get(0).getValue();
        typedResponse.receiver = (String) eventValues.getIndexedValues().get(1).getValue();
        typedResponse.amount = (BigInteger) eventValues.getIndexedValues().get(2).getValue();
        return typedResponse;
    }

    public Flowable<ClaimedEventResponse> claimedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getClaimedEventFromLog(log));
    }

    public Flowable<ClaimedEventResponse> claimedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(CLAIMED_EVENT));
        return claimedEventFlowable(filter);
    }

    public static List<InitializedEventResponse> getInitializedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(INITIALIZED_EVENT, transactionReceipt);
        ArrayList<InitializedEventResponse> responses = new ArrayList<InitializedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InitializedEventResponse typedResponse = new InitializedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.version = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static InitializedEventResponse getInitializedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(INITIALIZED_EVENT, log);
        InitializedEventResponse typedResponse = new InitializedEventResponse();
        typedResponse.log = log;
        typedResponse.version = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getInitializedEventFromLog(log));
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(INITIALIZED_EVENT));
        return initializedEventFlowable(filter);
    }

    public static List<ManagerAddedEventResponse> getManagerAddedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MANAGERADDED_EVENT, transactionReceipt);
        ArrayList<ManagerAddedEventResponse> responses = new ArrayList<ManagerAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ManagerAddedEventResponse getManagerAddedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(MANAGERADDED_EVENT, log);
        ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
        typedResponse.log = log;
        typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getManagerAddedEventFromLog(log));
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MANAGERADDED_EVENT));
        return managerAddedEventFlowable(filter);
    }

    public static List<ManagerRemovedEventResponse> getManagerRemovedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MANAGERREMOVED_EVENT, transactionReceipt);
        ArrayList<ManagerRemovedEventResponse> responses = new ArrayList<ManagerRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ManagerRemovedEventResponse getManagerRemovedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(MANAGERREMOVED_EVENT, log);
        ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
        typedResponse.log = log;
        typedResponse.account = (String) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getManagerRemovedEventFromLog(log));
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MANAGERREMOVED_EVENT));
        return managerRemovedEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OwnershipTransferredEventResponse getOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(OWNERSHIPTRANSFERRED_EVENT, log);
        OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String) eventValues.getIndexedValues().get(0).getValue();
        typedResponse.newOwner = (String) eventValues.getIndexedValues().get(1).getValue();
        return typedResponse;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getOwnershipTransferredEventFromLog(log));
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(OWNERSHIPTRANSFERRED_EVENT));
        return ownershipTransferredEventFlowable(filter);
    }

    public static List<ReportFraudEventResponse> getReportFraudEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(REPORTFRAUD_EVENT, transactionReceipt);
        ArrayList<ReportFraudEventResponse> responses = new ArrayList<ReportFraudEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ReportFraudEventResponse typedResponse = new ReportFraudEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.reportId = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ReportFraudEventResponse getReportFraudEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(REPORTFRAUD_EVENT, log);
        ReportFraudEventResponse typedResponse = new ReportFraudEventResponse();
        typedResponse.log = log;
        typedResponse.reportId = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<ReportFraudEventResponse> reportFraudEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getReportFraudEventFromLog(log));
    }

    public Flowable<ReportFraudEventResponse> reportFraudEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REPORTFRAUD_EVENT));
        return reportFraudEventFlowable(filter);
    }

    public static List<ReportSentEventResponse> getReportSentEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(REPORTSENT_EVENT, transactionReceipt);
        ArrayList<ReportSentEventResponse> responses = new ArrayList<ReportSentEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ReportSentEventResponse typedResponse = new ReportSentEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.hub = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.reportId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ReportSentEventResponse getReportSentEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(REPORTSENT_EVENT, log);
        ReportSentEventResponse typedResponse = new ReportSentEventResponse();
        typedResponse.log = log;
        typedResponse.hub = (String) eventValues.getIndexedValues().get(0).getValue();
        typedResponse.reportId = (BigInteger) eventValues.getIndexedValues().get(1).getValue();
        return typedResponse;
    }

    public Flowable<ReportSentEventResponse> reportSentEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getReportSentEventFromLog(log));
    }

    public Flowable<ReportSentEventResponse> reportSentEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REPORTSENT_EVENT));
        return reportSentEventFlowable(filter);
    }

    public static List<RewardAmountChangedEventResponse> getRewardAmountChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(REWARDAMOUNTCHANGED_EVENT, transactionReceipt);
        ArrayList<RewardAmountChangedEventResponse> responses = new ArrayList<RewardAmountChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RewardAmountChangedEventResponse typedResponse = new RewardAmountChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.amount = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static RewardAmountChangedEventResponse getRewardAmountChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(REWARDAMOUNTCHANGED_EVENT, log);
        RewardAmountChangedEventResponse typedResponse = new RewardAmountChangedEventResponse();
        typedResponse.log = log;
        typedResponse.amount = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<RewardAmountChangedEventResponse> rewardAmountChangedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getRewardAmountChangedEventFromLog(log));
    }

    public Flowable<RewardAmountChangedEventResponse> rewardAmountChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(REWARDAMOUNTCHANGED_EVENT));
        return rewardAmountChangedEventFlowable(filter);
    }

    public static List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementation = (String) eventValues.getIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static UpgradedEventResponse getUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = staticExtractEventParametersWithLog(UPGRADED_EVENT, log);
        UpgradedEventResponse typedResponse = new UpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.implementation = (String) eventValues.getIndexedValues().get(0).getValue();
        return typedResponse;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(log -> getUpgradedEventFromLog(log));
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(UPGRADED_EVENT));
        return upgradedEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> MULTIPLIER() {
        final Function function = new Function(FUNC_MULTIPLIER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> REWARD_PERIOD_IN_SECONDS() {
        final Function function = new Function(FUNC_REWARD_PERIOD_IN_SECONDS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> addManager(String account) {
        final Function function = new Function(
                FUNC_ADDMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> addReport(HubReport _report) {
        final Function function = new Function(
                FUNC_ADDREPORT, 
                Arrays.<Type>asList(_report), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> claim(String _receiver, BigInteger _amount) {
        final Function function = new Function(
                FUNC_CLAIM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _receiver), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>> hubDeeds(BigInteger param0) {
        final Function function = new Function(FUNC_HUBDEEDS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}, new TypeReference<Uint8>() {}, new TypeReference<Uint8>() {}, new TypeReference<Uint8>() {}, new TypeReference<Uint256>() {}));
        return new RemoteFunctionCall<Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>(function,
                new Callable<Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>() {
                    @Override
                    public Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>(
                                (BigInteger) results.get(0).getValue(), 
                                (BigInteger) results.get(1).getValue(), 
                                (BigInteger) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue(), 
                                (BigInteger) results.get(4).getValue());
                    }
                });
    }

    public RemoteFunctionCall<BigInteger> hubReportIds(String param0, BigInteger param1) {
        final Function function = new Function(FUNC_HUBREPORTIDS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, param0), 
                new org.web3j.abi.datatypes.generated.Uint256(param1)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Tuple10<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger>> hubReports(BigInteger param0) {
        final Function function = new Function(FUNC_HUBREPORTS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Address>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
        return new RemoteFunctionCall<Tuple10<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger>>(function,
                new Callable<Tuple10<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger>>() {
                    @Override
                    public Tuple10<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple10<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger>(
                                (String) results.get(0).getValue(), 
                                (BigInteger) results.get(1).getValue(), 
                                (BigInteger) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue(), 
                                (BigInteger) results.get(4).getValue(), 
                                (BigInteger) results.get(5).getValue(), 
                                (String) results.get(6).getValue(), 
                                (BigInteger) results.get(7).getValue(), 
                                (BigInteger) results.get(8).getValue(), 
                                (BigInteger) results.get(9).getValue());
                    }
                });
    }

    public RemoteFunctionCall<Tuple9<BigInteger, String, String, BigInteger, BigInteger, BigInteger, BigInteger, Boolean, BigInteger>> hubRewards(BigInteger param0) {
        final Function function = new Function(FUNC_HUBREWARDS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}, new TypeReference<Address>() {}, new TypeReference<Address>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Bool>() {}, new TypeReference<Uint256>() {}));
        return new RemoteFunctionCall<Tuple9<BigInteger, String, String, BigInteger, BigInteger, BigInteger, BigInteger, Boolean, BigInteger>>(function,
                new Callable<Tuple9<BigInteger, String, String, BigInteger, BigInteger, BigInteger, BigInteger, Boolean, BigInteger>>() {
                    @Override
                    public Tuple9<BigInteger, String, String, BigInteger, BigInteger, BigInteger, BigInteger, Boolean, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple9<BigInteger, String, String, BigInteger, BigInteger, BigInteger, BigInteger, Boolean, BigInteger>(
                                (BigInteger) results.get(0).getValue(), 
                                (String) results.get(1).getValue(), 
                                (String) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue(), 
                                (BigInteger) results.get(4).getValue(), 
                                (BigInteger) results.get(5).getValue(), 
                                (BigInteger) results.get(6).getValue(), 
                                (Boolean) results.get(7).getValue(), 
                                (BigInteger) results.get(8).getValue());
                    }
                });
    }

    public RemoteFunctionCall<TransactionReceipt> initialize(String _meed, String _wom, BigInteger _startRewardsTime) {
        final Function function = new Function(
                FUNC_INITIALIZE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _meed), 
                new org.web3j.abi.datatypes.Address(160, _wom), 
                new org.web3j.abi.datatypes.generated.Uint256(_startRewardsTime)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isManager(String account) {
        final Function function = new Function(FUNC_ISMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        final Function function = new Function(FUNC_ISOWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> lastReportId() {
        final Function function = new Function(FUNC_LASTREPORTID, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> markAsFraud(BigInteger _reportId) {
        final Function function = new Function(
                FUNC_MARKASFRAUD, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_reportId)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> meed() {
        final Function function = new Function(FUNC_MEED, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> owner() {
        final Function function = new Function(FUNC_OWNER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> pendingRewardBalanceOf(String _address) {
        final Function function = new Function(FUNC_PENDINGREWARDBALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _address)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> periodicRewardAmount() {
        final Function function = new Function(FUNC_PERIODICREWARDAMOUNT, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<byte[]> proxiableUUID() {
        final Function function = new Function(FUNC_PROXIABLEUUID, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bytes32>() {}));
        return executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<Tuple3<BigInteger, BigInteger, BigInteger>> recipients(String param0) {
        final Function function = new Function(FUNC_RECIPIENTS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
        return new RemoteFunctionCall<Tuple3<BigInteger, BigInteger, BigInteger>>(function,
                new Callable<Tuple3<BigInteger, BigInteger, BigInteger>>() {
                    @Override
                    public Tuple3<BigInteger, BigInteger, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple3<BigInteger, BigInteger, BigInteger>(
                                (BigInteger) results.get(0).getValue(), 
                                (BigInteger) results.get(1).getValue(), 
                                (BigInteger) results.get(2).getValue());
                    }
                });
    }

    public RemoteFunctionCall<TransactionReceipt> removeManager(String account) {
        final Function function = new Function(
                FUNC_REMOVEMANAGER, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, account)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        final Function function = new Function(
                FUNC_RENOUNCEOWNERSHIP, 
                Arrays.<Type>asList(), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> reportsByPeriodByDeed(BigInteger param0, BigInteger param1) {
        final Function function = new Function(FUNC_REPORTSBYPERIODBYDEED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0), 
                new org.web3j.abi.datatypes.generated.Uint256(param1)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> reportsByPeriodByHub(BigInteger param0, String param1) {
        final Function function = new Function(FUNC_REPORTSBYPERIODBYHUB, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0), 
                new org.web3j.abi.datatypes.Address(160, param1)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<List> reportsByRecipient(String _address) {
        final Function function = new Function(FUNC_REPORTSBYRECIPIENT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, _address)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<DynamicArray<Uint256>>() {}));
        return new RemoteFunctionCall<List>(function,
                new Callable<List>() {
                    @Override
                    @SuppressWarnings("unchecked")
                    public List call() throws Exception {
                        List<Type> result = (List<Type>) executeCallSingleValueReturn(function, List.class);
                        return convertToNative(result);
                    }
                });
    }

    public RemoteFunctionCall<Tuple7<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>> rewards(BigInteger param0) {
        final Function function = new Function(FUNC_REWARDS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
        return new RemoteFunctionCall<Tuple7<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>(function,
                new Callable<Tuple7<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>() {
                    @Override
                    public Tuple7<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple7<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>(
                                (BigInteger) results.get(0).getValue(), 
                                (BigInteger) results.get(1).getValue(), 
                                (BigInteger) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue(), 
                                (BigInteger) results.get(4).getValue(), 
                                (BigInteger) results.get(5).getValue(), 
                                (BigInteger) results.get(6).getValue());
                    }
                });
    }

    public RemoteFunctionCall<TransactionReceipt> setPeriodicRewardAmount(BigInteger _periodicRewardAmount) {
        final Function function = new Function(
                FUNC_SETPERIODICREWARDAMOUNT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_periodicRewardAmount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setTestOnPreviousPeriod(BigInteger _testPreviousPeriodInWeeks) {
        final Function function = new Function(
                FUNC_SETTESTONPREVIOUSPERIOD, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_testPreviousPeriodInWeeks)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> startRewardsTime() {
        final Function function = new Function(FUNC_STARTREWARDSTIME, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        final Function function = new Function(
                FUNC_TRANSFEROWNERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newOwner)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeTo(String newImplementation) {
        final Function function = new Function(
                FUNC_UPGRADETO, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newImplementation)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeToAndCall(String newImplementation, byte[] data, BigInteger weiValue) {
        final Function function = new Function(
                FUNC_UPGRADETOANDCALL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(160, newImplementation), 
                new org.web3j.abi.datatypes.DynamicBytes(data)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function, weiValue);
    }

    public RemoteFunctionCall<String> wom() {
        final Function function = new Function(FUNC_WOM, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    @Deprecated
    public static TestUEM load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new TestUEM(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static TestUEM load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new TestUEM(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static TestUEM load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new TestUEM(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static TestUEM load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new TestUEM(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<TestUEM> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(TestUEM.class, web3j, credentials, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<TestUEM> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(TestUEM.class, web3j, credentials, gasPrice, gasLimit, BINARY, "");
    }

    public static RemoteCall<TestUEM> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return deployRemoteCall(TestUEM.class, web3j, transactionManager, contractGasProvider, BINARY, "");
    }

    @Deprecated
    public static RemoteCall<TestUEM> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return deployRemoteCall(TestUEM.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, "");
    }

    public static class HubReport extends StaticStruct {
        public String hub;

        public BigInteger usersCount;

        public BigInteger recipientsCount;

        public BigInteger participantsCount;

        public BigInteger achievementsCount;

        public BigInteger amount;

        public String tokenAddress;

        public BigInteger tokenChainId;

        public BigInteger fromDate;

        public BigInteger toDate;

        public HubReport(String hub, BigInteger usersCount, BigInteger recipientsCount, BigInteger participantsCount, BigInteger achievementsCount, BigInteger amount, String tokenAddress, BigInteger tokenChainId, BigInteger fromDate, BigInteger toDate) {
            super(new org.web3j.abi.datatypes.Address(160, hub), 
                    new org.web3j.abi.datatypes.generated.Uint256(usersCount), 
                    new org.web3j.abi.datatypes.generated.Uint256(recipientsCount), 
                    new org.web3j.abi.datatypes.generated.Uint256(participantsCount), 
                    new org.web3j.abi.datatypes.generated.Uint256(achievementsCount), 
                    new org.web3j.abi.datatypes.generated.Uint256(amount), 
                    new org.web3j.abi.datatypes.Address(160, tokenAddress), 
                    new org.web3j.abi.datatypes.generated.Uint256(tokenChainId), 
                    new org.web3j.abi.datatypes.generated.Uint256(fromDate), 
                    new org.web3j.abi.datatypes.generated.Uint256(toDate));
            this.hub = hub;
            this.usersCount = usersCount;
            this.recipientsCount = recipientsCount;
            this.participantsCount = participantsCount;
            this.achievementsCount = achievementsCount;
            this.amount = amount;
            this.tokenAddress = tokenAddress;
            this.tokenChainId = tokenChainId;
            this.fromDate = fromDate;
            this.toDate = toDate;
        }

        public HubReport(Address hub, Uint256 usersCount, Uint256 recipientsCount, Uint256 participantsCount, Uint256 achievementsCount, Uint256 amount, Address tokenAddress, Uint256 tokenChainId, Uint256 fromDate, Uint256 toDate) {
            super(hub, usersCount, recipientsCount, participantsCount, achievementsCount, amount, tokenAddress, tokenChainId, fromDate, toDate);
            this.hub = hub.getValue();
            this.usersCount = usersCount.getValue();
            this.recipientsCount = recipientsCount.getValue();
            this.participantsCount = participantsCount.getValue();
            this.achievementsCount = achievementsCount.getValue();
            this.amount = amount.getValue();
            this.tokenAddress = tokenAddress.getValue();
            this.tokenChainId = tokenChainId.getValue();
            this.fromDate = fromDate.getValue();
            this.toDate = toDate.getValue();
        }
    }

    public static class AdminChangedEventResponse extends BaseEventResponse {
        public String previousAdmin;

        public String newAdmin;
    }

    public static class BeaconUpgradedEventResponse extends BaseEventResponse {
        public String beacon;
    }

    public static class ClaimedEventResponse extends BaseEventResponse {
        public String recipient;

        public String receiver;

        public BigInteger amount;
    }

    public static class InitializedEventResponse extends BaseEventResponse {
        public BigInteger version;
    }

    public static class ManagerAddedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class ManagerRemovedEventResponse extends BaseEventResponse {
        public String account;
    }

    public static class OwnershipTransferredEventResponse extends BaseEventResponse {
        public String previousOwner;

        public String newOwner;
    }

    public static class ReportFraudEventResponse extends BaseEventResponse {
        public BigInteger reportId;
    }

    public static class ReportSentEventResponse extends BaseEventResponse {
        public String hub;

        public BigInteger reportId;
    }

    public static class RewardAmountChangedEventResponse extends BaseEventResponse {
        public BigInteger amount;
    }

    public static class UpgradedEventResponse extends BaseEventResponse {
        public String implementation;
    }
}
