/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple10;
import org.web3j.tuples.generated.Tuple3;
import org.web3j.tuples.generated.Tuple5;
import org.web3j.tuples.generated.Tuple7;
import org.web3j.tuples.generated.Tuple9;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class UserEngagementMinting
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_MULTIPLIER = "MULTIPLIER";
    public static final String FUNC_REWARD_PERIOD_IN_SECONDS = "REWARD_PERIOD_IN_SECONDS";
    public static final String FUNC_ADDMANAGER = "addManager";
    public static final String FUNC_ADDREPORT = "addReport";
    public static final String FUNC_CLAIM = "claim";
    public static final String FUNC_HUBDEEDS = "hubDeeds";
    public static final String FUNC_HUBREPORTIDS = "hubReportIds";
    public static final String FUNC_HUBREPORTS = "hubReports";
    public static final String FUNC_HUBREWARDS = "hubRewards";
    public static final String FUNC_INITIALIZE = "initialize";
    public static final String FUNC_ISMANAGER = "isManager";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_LASTREPORTID = "lastReportId";
    public static final String FUNC_MARKASFRAUD = "markAsFraud";
    public static final String FUNC_MEED = "meed";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_PENDINGREWARDBALANCEOF = "pendingRewardBalanceOf";
    public static final String FUNC_PERIODICREWARDAMOUNT = "periodicRewardAmount";
    public static final String FUNC_PROXIABLEUUID = "proxiableUUID";
    public static final String FUNC_RECIPIENTS = "recipients";
    public static final String FUNC_REMOVEMANAGER = "removeManager";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_REPORTSBYPERIODBYDEED = "reportsByPeriodByDeed";
    public static final String FUNC_REPORTSBYPERIODBYHUB = "reportsByPeriodByHub";
    public static final String FUNC_REPORTSBYRECIPIENT = "reportsByRecipient";
    public static final String FUNC_REWARDS = "rewards";
    public static final String FUNC_SETPERIODICREWARDAMOUNT = "setPeriodicRewardAmount";
    public static final String FUNC_STARTREWARDSTIME = "startRewardsTime";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_UPGRADETO = "upgradeTo";
    public static final String FUNC_UPGRADETOANDCALL = "upgradeToAndCall";
    public static final String FUNC_WOM = "wom";
    public static final Event ADMINCHANGED_EVENT = new Event("AdminChanged", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Address>(){}));
    public static final Event BEACONUPGRADED_EVENT = new Event("BeaconUpgraded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event CLAIMED_EVENT = new Event("Claimed", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}));
    public static final Event INITIALIZED_EVENT = new Event("Initialized", Arrays.asList(new TypeReference<Uint8>(){}));
    public static final Event MANAGERADDED_EVENT = new Event("ManagerAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event MANAGERREMOVED_EVENT = new Event("ManagerRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event REPORTFRAUD_EVENT = new Event("ReportFraud", Arrays.asList(new TypeReference<Uint256>(true){}));
    public static final Event REPORTSENT_EVENT = new Event("ReportSent", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}));
    public static final Event REWARDAMOUNTCHANGED_EVENT = new Event("RewardAmountChanged", Arrays.asList(new TypeReference<Uint256>(true){}));
    public static final Event UPGRADED_EVENT = new Event("Upgraded", Arrays.asList(new TypeReference<Address>(true){}));

    @Deprecated
    protected UserEngagementMinting(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected UserEngagementMinting(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected UserEngagementMinting(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected UserEngagementMinting(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<AdminChangedEventResponse> getAdminChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)ADMINCHANGED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<AdminChangedEventResponse> responses = new ArrayList<AdminChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousAdmin = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.newAdmin = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static AdminChangedEventResponse getAdminChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)ADMINCHANGED_EVENT, (Log)log);
        AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
        typedResponse.log = log;
        typedResponse.previousAdmin = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.newAdmin = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getAdminChangedEventFromLog(log));
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADMINCHANGED_EVENT));
        return this.adminChangedEventFlowable(filter);
    }

    public static List<BeaconUpgradedEventResponse> getBeaconUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)BEACONUPGRADED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<BeaconUpgradedEventResponse> responses = new ArrayList<BeaconUpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.beacon = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static BeaconUpgradedEventResponse getBeaconUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)BEACONUPGRADED_EVENT, (Log)log);
        BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.beacon = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getBeaconUpgradedEventFromLog(log));
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)BEACONUPGRADED_EVENT));
        return this.beaconUpgradedEventFlowable(filter);
    }

    public static List<ClaimedEventResponse> getClaimedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)CLAIMED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ClaimedEventResponse> responses = new ArrayList<ClaimedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ClaimedEventResponse typedResponse = new ClaimedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.recipient = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.receiver = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ClaimedEventResponse getClaimedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)CLAIMED_EVENT, (Log)log);
        ClaimedEventResponse typedResponse = new ClaimedEventResponse();
        typedResponse.log = log;
        typedResponse.recipient = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.receiver = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getIndexedValues().get(2)).getValue();
        return typedResponse;
    }

    public Flowable<ClaimedEventResponse> claimedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getClaimedEventFromLog(log));
    }

    public Flowable<ClaimedEventResponse> claimedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CLAIMED_EVENT));
        return this.claimedEventFlowable(filter);
    }

    public static List<InitializedEventResponse> getInitializedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)INITIALIZED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<InitializedEventResponse> responses = new ArrayList<InitializedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InitializedEventResponse typedResponse = new InitializedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.version = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static InitializedEventResponse getInitializedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)INITIALIZED_EVENT, (Log)log);
        InitializedEventResponse typedResponse = new InitializedEventResponse();
        typedResponse.log = log;
        typedResponse.version = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getInitializedEventFromLog(log));
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)INITIALIZED_EVENT));
        return this.initializedEventFlowable(filter);
    }

    public static List<ManagerAddedEventResponse> getManagerAddedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)MANAGERADDED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ManagerAddedEventResponse> responses = new ArrayList<ManagerAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ManagerAddedEventResponse getManagerAddedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)MANAGERADDED_EVENT, (Log)log);
        ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
        typedResponse.log = log;
        typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getManagerAddedEventFromLog(log));
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MANAGERADDED_EVENT));
        return this.managerAddedEventFlowable(filter);
    }

    public static List<ManagerRemovedEventResponse> getManagerRemovedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)MANAGERREMOVED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ManagerRemovedEventResponse> responses = new ArrayList<ManagerRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ManagerRemovedEventResponse getManagerRemovedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)MANAGERREMOVED_EVENT, (Log)log);
        ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
        typedResponse.log = log;
        typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getManagerRemovedEventFromLog(log));
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MANAGERREMOVED_EVENT));
        return this.managerRemovedEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OwnershipTransferredEventResponse getOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (Log)log);
        OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getOwnershipTransferredEventFromLog(log));
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public static List<ReportFraudEventResponse> getReportFraudEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)REPORTFRAUD_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ReportFraudEventResponse> responses = new ArrayList<ReportFraudEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ReportFraudEventResponse typedResponse = new ReportFraudEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.reportId = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ReportFraudEventResponse getReportFraudEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)REPORTFRAUD_EVENT, (Log)log);
        ReportFraudEventResponse typedResponse = new ReportFraudEventResponse();
        typedResponse.log = log;
        typedResponse.reportId = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<ReportFraudEventResponse> reportFraudEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getReportFraudEventFromLog(log));
    }

    public Flowable<ReportFraudEventResponse> reportFraudEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REPORTFRAUD_EVENT));
        return this.reportFraudEventFlowable(filter);
    }

    public static List<ReportSentEventResponse> getReportSentEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)REPORTSENT_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ReportSentEventResponse> responses = new ArrayList<ReportSentEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ReportSentEventResponse typedResponse = new ReportSentEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.hub = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.reportId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ReportSentEventResponse getReportSentEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)REPORTSENT_EVENT, (Log)log);
        ReportSentEventResponse typedResponse = new ReportSentEventResponse();
        typedResponse.log = log;
        typedResponse.hub = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.reportId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<ReportSentEventResponse> reportSentEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getReportSentEventFromLog(log));
    }

    public Flowable<ReportSentEventResponse> reportSentEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REPORTSENT_EVENT));
        return this.reportSentEventFlowable(filter);
    }

    public static List<RewardAmountChangedEventResponse> getRewardAmountChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)REWARDAMOUNTCHANGED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<RewardAmountChangedEventResponse> responses = new ArrayList<RewardAmountChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RewardAmountChangedEventResponse typedResponse = new RewardAmountChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.amount = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static RewardAmountChangedEventResponse getRewardAmountChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)REWARDAMOUNTCHANGED_EVENT, (Log)log);
        RewardAmountChangedEventResponse typedResponse = new RewardAmountChangedEventResponse();
        typedResponse.log = log;
        typedResponse.amount = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<RewardAmountChangedEventResponse> rewardAmountChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getRewardAmountChangedEventFromLog(log));
    }

    public Flowable<RewardAmountChangedEventResponse> rewardAmountChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REWARDAMOUNTCHANGED_EVENT));
        return this.rewardAmountChangedEventFlowable(filter);
    }

    public static List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = UserEngagementMinting.staticExtractEventParametersWithLog((Event)UPGRADED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementation = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static UpgradedEventResponse getUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = UserEngagementMinting.staticExtractEventParametersWithLog((Event)UPGRADED_EVENT, (Log)log);
        UpgradedEventResponse typedResponse = new UpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.implementation = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> UserEngagementMinting.getUpgradedEventFromLog(log));
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADED_EVENT));
        return this.upgradedEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> MULTIPLIER() {
        Function function = new Function(FUNC_MULTIPLIER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> REWARD_PERIOD_IN_SECONDS() {
        Function function = new Function(FUNC_REWARD_PERIOD_IN_SECONDS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> addManager(String account) {
        Function function = new Function(FUNC_ADDMANAGER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> addReport(HubReport _report) {
        Function function = new Function(FUNC_ADDREPORT, Arrays.asList(new Type[]{_report}), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> claim(String _receiver, BigInteger _amount) {
        Function function = new Function(FUNC_CLAIM, Arrays.asList(new Address(160, _receiver), new Uint256(_amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>> hubDeeds(BigInteger param0) {
        final Function function = new Function(FUNC_HUBDEEDS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint8>(){}, new TypeReference<Uint8>(){}, new TypeReference<Uint8>(){}, new TypeReference<Uint256>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>(){

            @Override
            public Tuple5<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger> call() throws Exception {
                List results = UserEngagementMinting.this.executeCallMultipleValueReturn(function);
                return new Tuple5((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((BigInteger)((Type)results.get(4)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<BigInteger> hubReportIds(String param0, BigInteger param1) {
        Function function = new Function(FUNC_HUBREPORTIDS, Arrays.asList(new Address(160, param0), new Uint256(param1)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Tuple10<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger>> hubReports(BigInteger param0) {
        final Function function = new Function(FUNC_HUBREPORTS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Address>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple10<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger>>(){

            @Override
            public Tuple10<String, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, String, BigInteger, BigInteger, BigInteger> call() throws Exception {
                List results = UserEngagementMinting.this.executeCallMultipleValueReturn(function);
                return new Tuple10((Object)((String)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((BigInteger)((Type)results.get(4)).getValue()), (Object)((BigInteger)((Type)results.get(5)).getValue()), (Object)((String)((Type)results.get(6)).getValue()), (Object)((BigInteger)((Type)results.get(7)).getValue()), (Object)((BigInteger)((Type)results.get(8)).getValue()), (Object)((BigInteger)((Type)results.get(9)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<Tuple9<BigInteger, String, String, BigInteger, BigInteger, BigInteger, BigInteger, Boolean, BigInteger>> hubRewards(BigInteger param0) {
        final Function function = new Function(FUNC_HUBREWARDS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Address>(){}, new TypeReference<Address>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Bool>(){}, new TypeReference<Uint256>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple9<BigInteger, String, String, BigInteger, BigInteger, BigInteger, BigInteger, Boolean, BigInteger>>(){

            @Override
            public Tuple9<BigInteger, String, String, BigInteger, BigInteger, BigInteger, BigInteger, Boolean, BigInteger> call() throws Exception {
                List results = UserEngagementMinting.this.executeCallMultipleValueReturn(function);
                return new Tuple9((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((String)((Type)results.get(1)).getValue()), (Object)((String)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((BigInteger)((Type)results.get(4)).getValue()), (Object)((BigInteger)((Type)results.get(5)).getValue()), (Object)((BigInteger)((Type)results.get(6)).getValue()), (Object)((Boolean)((Type)results.get(7)).getValue()), (Object)((BigInteger)((Type)results.get(8)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<TransactionReceipt> initialize(String _meed, String _wom, BigInteger _startRewardsTime) {
        Function function = new Function(FUNC_INITIALIZE, Arrays.asList(new Address(160, _meed), new Address(160, _wom), new Uint256(_startRewardsTime)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isManager(String account) {
        Function function = new Function(FUNC_ISMANAGER, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        Function function = new Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> lastReportId() {
        Function function = new Function(FUNC_LASTREPORTID, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> markAsFraud(BigInteger _reportId) {
        Function function = new Function(FUNC_MARKASFRAUD, Arrays.asList(new Uint256(_reportId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> meed() {
        Function function = new Function(FUNC_MEED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> pendingRewardBalanceOf(String _address) {
        Function function = new Function(FUNC_PENDINGREWARDBALANCEOF, Arrays.asList(new Address(160, _address)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> periodicRewardAmount() {
        Function function = new Function(FUNC_PERIODICREWARDAMOUNT, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<byte[]> proxiableUUID() {
        Function function = new Function(FUNC_PROXIABLEUUID, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bytes32>(){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<Tuple3<BigInteger, BigInteger, BigInteger>> recipients(String param0) {
        final Function function = new Function(FUNC_RECIPIENTS, Arrays.asList(new Address(160, param0)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple3<BigInteger, BigInteger, BigInteger>>(){

            @Override
            public Tuple3<BigInteger, BigInteger, BigInteger> call() throws Exception {
                List results = UserEngagementMinting.this.executeCallMultipleValueReturn(function);
                return new Tuple3((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<TransactionReceipt> removeManager(String account) {
        Function function = new Function(FUNC_REMOVEMANAGER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        Function function = new Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> reportsByPeriodByDeed(BigInteger param0, BigInteger param1) {
        Function function = new Function(FUNC_REPORTSBYPERIODBYDEED, Arrays.asList(new Uint256(param0), new Uint256(param1)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> reportsByPeriodByHub(BigInteger param0, String param1) {
        Function function = new Function(FUNC_REPORTSBYPERIODBYHUB, Arrays.asList(new Uint256(param0), new Address(160, param1)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<List> reportsByRecipient(String _address) {
        final Function function = new Function(FUNC_REPORTSBYRECIPIENT, Arrays.asList(new Address(160, _address)), Arrays.asList(new TypeReference<DynamicArray<Uint256>>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<List>(){

            @Override
            public List call() throws Exception {
                List result = (List)UserEngagementMinting.this.executeCallSingleValueReturn(function, List.class);
                return UserEngagementMinting.convertToNative((List)result);
            }
        });
    }

    public RemoteFunctionCall<Tuple7<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>> rewards(BigInteger param0) {
        final Function function = new Function(FUNC_REWARDS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple7<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger>>(){

            @Override
            public Tuple7<BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger, BigInteger> call() throws Exception {
                List results = UserEngagementMinting.this.executeCallMultipleValueReturn(function);
                return new Tuple7((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((BigInteger)((Type)results.get(4)).getValue()), (Object)((BigInteger)((Type)results.get(5)).getValue()), (Object)((BigInteger)((Type)results.get(6)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<TransactionReceipt> setPeriodicRewardAmount(BigInteger _periodicRewardAmount) {
        Function function = new Function(FUNC_SETPERIODICREWARDAMOUNT, Arrays.asList(new Uint256(_periodicRewardAmount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> startRewardsTime() {
        Function function = new Function(FUNC_STARTREWARDSTIME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeTo(String newImplementation) {
        Function function = new Function(FUNC_UPGRADETO, Arrays.asList(new Address(160, newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeToAndCall(String newImplementation, byte[] data, BigInteger weiValue) {
        Function function = new Function(FUNC_UPGRADETOANDCALL, Arrays.asList(new Address(160, newImplementation), new DynamicBytes(data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function, weiValue);
    }

    public RemoteFunctionCall<String> wom() {
        Function function = new Function(FUNC_WOM, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    @Deprecated
    public static UserEngagementMinting load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new UserEngagementMinting(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static UserEngagementMinting load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new UserEngagementMinting(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static UserEngagementMinting load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new UserEngagementMinting(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static UserEngagementMinting load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new UserEngagementMinting(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<UserEngagementMinting> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return UserEngagementMinting.deployRemoteCall(UserEngagementMinting.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<UserEngagementMinting> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return UserEngagementMinting.deployRemoteCall(UserEngagementMinting.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static RemoteCall<UserEngagementMinting> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return UserEngagementMinting.deployRemoteCall(UserEngagementMinting.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<UserEngagementMinting> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return UserEngagementMinting.deployRemoteCall(UserEngagementMinting.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static class AdminChangedEventResponse
    extends BaseEventResponse {
        public String previousAdmin;
        public String newAdmin;
    }

    public static class BeaconUpgradedEventResponse
    extends BaseEventResponse {
        public String beacon;
    }

    public static class ClaimedEventResponse
    extends BaseEventResponse {
        public String recipient;
        public String receiver;
        public BigInteger amount;
    }

    public static class InitializedEventResponse
    extends BaseEventResponse {
        public BigInteger version;
    }

    public static class ManagerAddedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class ManagerRemovedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class ReportFraudEventResponse
    extends BaseEventResponse {
        public BigInteger reportId;
    }

    public static class ReportSentEventResponse
    extends BaseEventResponse {
        public String hub;
        public BigInteger reportId;
    }

    public static class RewardAmountChangedEventResponse
    extends BaseEventResponse {
        public BigInteger amount;
    }

    public static class UpgradedEventResponse
    extends BaseEventResponse {
        public String implementation;
    }

    public static class HubReport
    extends StaticStruct {
        public String hub;
        public BigInteger usersCount;
        public BigInteger recipientsCount;
        public BigInteger participantsCount;
        public BigInteger achievementsCount;
        public BigInteger amount;
        public String tokenAddress;
        public BigInteger tokenChainId;
        public BigInteger fromDate;
        public BigInteger toDate;

        public HubReport(String hub, BigInteger usersCount, BigInteger recipientsCount, BigInteger participantsCount, BigInteger achievementsCount, BigInteger amount, String tokenAddress, BigInteger tokenChainId, BigInteger fromDate, BigInteger toDate) {
            super(new Type[]{new Address(160, hub), new Uint256(usersCount), new Uint256(recipientsCount), new Uint256(participantsCount), new Uint256(achievementsCount), new Uint256(amount), new Address(160, tokenAddress), new Uint256(tokenChainId), new Uint256(fromDate), new Uint256(toDate)});
            this.hub = hub;
            this.usersCount = usersCount;
            this.recipientsCount = recipientsCount;
            this.participantsCount = participantsCount;
            this.achievementsCount = achievementsCount;
            this.amount = amount;
            this.tokenAddress = tokenAddress;
            this.tokenChainId = tokenChainId;
            this.fromDate = fromDate;
            this.toDate = toDate;
        }

        public HubReport(Address hub, Uint256 usersCount, Uint256 recipientsCount, Uint256 participantsCount, Uint256 achievementsCount, Uint256 amount, Address tokenAddress, Uint256 tokenChainId, Uint256 fromDate, Uint256 toDate) {
            super(new Type[]{hub, usersCount, recipientsCount, participantsCount, achievementsCount, amount, tokenAddress, tokenChainId, fromDate, toDate});
            this.hub = hub.getValue();
            this.usersCount = usersCount.getValue();
            this.recipientsCount = recipientsCount.getValue();
            this.participantsCount = participantsCount.getValue();
            this.achievementsCount = achievementsCount.getValue();
            this.amount = amount.getValue();
            this.tokenAddress = tokenAddress.getValue();
            this.tokenChainId = tokenChainId.getValue();
            this.fromDate = fromDate.getValue();
            this.toDate = toDate.getValue();
        }
    }
}

