/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.meeds.deeds.common.elasticsearch.model.DeedTenantEvent;
import io.meeds.deeds.common.elasticsearch.storage.DeedTenantEventRepository;
import io.meeds.deeds.common.listener.EventListener;
import io.meeds.deeds.common.listerner.model.Event;
import io.meeds.deeds.common.listerner.model.EventSerialization;
import io.meeds.deeds.common.service.SettingService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ListenerService {
    public static final String ES_LAST_SCANNED_DATE_SETTING_NAME = "ES-LAST-SCANNED-DATE";
    public static final Logger LOG = LoggerFactory.getLogger(ListenerService.class);
    protected static final List<EventListener<?>> EVENT_LISTENERS = new ArrayList();
    protected static final Map<String, List<EventListener<?>>> LISTENERS = new HashMap();
    protected static final StampedLock ELASTIC_SEARCH_EVENT_READING_LOCK = new StampedLock();
    protected static boolean persistentFeatureEnabled = true;
    @Autowired(required=false)
    private SettingService settingService;
    @Autowired(required=false)
    private DeedTenantEventRepository deedTenantEventRepository;
    @Value(value="${meeds.elasticsearch.listener.events.cleanupHoursPeriodicity:}")
    private String cleanupHoursPeriodicity;
    @Value(value="${meeds.elasticsearch.listener.clientName}")
    protected String esClientName;

    public void publishEvent(String eventName, Object data) {
        LOG.debug("{} - Publish event {} locally with data {}", new Object[]{this.esClientName, eventName, data});
        Event event = new Event(eventName, data, data == null ? null : data.getClass().getName());
        this.triggerEventLocally(event);
        this.publishEventOnElasticsearch(event);
    }

    public void addListener(EventListener<?> listener) {
        List<String> supportedEvents = listener.getSupportedEvents();
        if (!CollectionUtils.isEmpty(supportedEvents)) {
            supportedEvents.forEach(eventName -> LISTENERS.computeIfAbsent((String)eventName, key -> new ArrayList()).add(listener));
        }
    }

    public void removeListsner(String listenerName) {
        Iterator<Map.Entry<String, List<EventListener<?>>>> iterator = LISTENERS.entrySet().iterator();
        iterator.forEachRemaining(entry -> {
            List list = (List)entry.getValue();
            list.removeIf(eventListener -> StringUtils.equals((CharSequence)eventListener.getName(), (CharSequence)listenerName));
            if (list.isEmpty()) {
                iterator.remove();
            }
        });
    }

    public void removeListsner(String eventName, String listenerName) {
        Iterator<Map.Entry<String, List<EventListener<?>>>> iterator = LISTENERS.entrySet().iterator();
        iterator.forEachRemaining(entry -> {
            if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)eventName)) {
                return;
            }
            List list = (List)entry.getValue();
            list.removeIf(eventListener -> StringUtils.equals((CharSequence)eventListener.getName(), (CharSequence)listenerName));
            if (list.isEmpty()) {
                iterator.remove();
            }
        });
    }

    public void triggerElasticSearchEvents() {
        if (!this.isUsePerisistentEvents()) {
            return;
        }
        this.executeElasticSearchScanning(() -> {
            Instant lastEventScanDate = this.getLastELasticsearchScanDate();
            List<DeedTenantEvent> events = this.deedTenantEventRepository.findByDateGreaterThanEqualAndConsumersNotOrderByDateAsc(lastEventScanDate, this.esClientName);
            try {
                for (DeedTenantEvent persistentEvent : events) {
                    if (this.hasListeners(persistentEvent.getEventName())) {
                        this.triggerElasticsearchEvent(persistentEvent);
                    }
                    lastEventScanDate = this.maxInstant(lastEventScanDate, persistentEvent.getDate());
                }
            }
            finally {
                this.saveLastELasticsearchScanDate(lastEventScanDate);
            }
        });
    }

    public void cleanupElasticsearchEvents() {
        if (!this.isUsePerisistentEvents()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.cleanupHoursPeriodicity)) {
            Instant lastEventScanDate = this.getLastELasticsearchScanDate();
            this.deedTenantEventRepository.deleteByDateLessThan(lastEventScanDate.minus(Long.parseLong(this.cleanupHoursPeriodicity.trim()), ChronoUnit.HOURS));
        }
    }

    private boolean isUsePerisistentEvents() {
        return persistentFeatureEnabled && (StringUtils.contains((CharSequence)this.esClientName, (CharSequence)"dApp") || StringUtils.contains((CharSequence)this.esClientName, (CharSequence)"tenant-provisioning"));
    }

    private void publishEventOnElasticsearch(Event event) {
        if (!this.isUsePerisistentEvents()) {
            return;
        }
        String eventJsonString = this.serializeObjectToJson(event);
        List<String> consumers = Collections.singletonList(this.esClientName);
        this.deedTenantEventRepository.save(new DeedTenantEvent(event.getEventName(), eventJsonString, consumers, Instant.now()));
    }

    private void triggerEventLocally(Event event) {
        String eventName = event.getEventName();
        Object data = event.getData();
        List<EventListener<?>> listenerList = LISTENERS.get(eventName);
        if (!CollectionUtils.isEmpty(listenerList)) {
            LOG.debug("{} - Trigger event {} locally with data {}", new Object[]{this.esClientName, eventName, data});
            listenerList.forEach(listener -> {
                LOG.debug("  {} - Trigger listener {}  with event {} with data {}", new Object[]{this.esClientName, listener.getName(), eventName, data});
                listener.handleEvent(eventName, data);
            });
        }
    }

    private void triggerElasticsearchEvent(DeedTenantEvent persistentEvent) {
        if (persistentEvent.getConsumers().contains(this.esClientName)) {
            return;
        }
        try {
            Event event = (Event)EventSerialization.OBJECT_MAPPER.readValue(persistentEvent.getObjectJson(), Event.class);
            if (event == null) {
                LOG.debug("Can't parse Event Class of name {}. Ignore the event, it should be meant to another type of clients", (Object)persistentEvent.getEventName());
            } else {
                this.triggerEventLocally(event);
            }
            this.addElasticsearchEventCurrentConsumer(persistentEvent);
        }
        catch (Exception e) {
            LOG.warn("{} - Error while triggering event from ES {}", new Object[]{this.esClientName, persistentEvent, e});
        }
    }

    private void addElasticsearchEventCurrentConsumer(DeedTenantEvent event) {
        try {
            event = this.deedTenantEventRepository.findById(event.getId()).orElse(event);
            ArrayList<String> consumers = CollectionUtils.isEmpty(event.getConsumers()) ? new ArrayList<String>() : new ArrayList<String>(event.getConsumers());
            consumers.add(this.esClientName);
            event.setConsumers(consumers);
            this.deedTenantEventRepository.save(event);
        }
        catch (Exception e) {
            LOG.warn("{} - Error saving consumer name of event {}/{}", new Object[]{this.esClientName, event.getId(), event.getEventName()});
        }
    }

    private Instant getLastELasticsearchScanDate() {
        String settingName = this.getSettingName(ES_LAST_SCANNED_DATE_SETTING_NAME);
        String lastEventScanDate = this.settingService.get(settingName);
        if (StringUtils.isBlank((CharSequence)lastEventScanDate)) {
            return Instant.now();
        }
        return Instant.ofEpochMilli(Long.parseLong(lastEventScanDate));
    }

    private void saveLastELasticsearchScanDate(Instant persistedEventDate) {
        String settingName = this.getSettingName(ES_LAST_SCANNED_DATE_SETTING_NAME);
        this.settingService.save(settingName, String.valueOf(persistedEventDate.toEpochMilli()));
    }

    private boolean hasListeners(String eventName) {
        return !CollectionUtils.isEmpty((Collection)LISTENERS.get(eventName));
    }

    private String serializeObjectToJson(Object event) {
        try {
            return EventSerialization.OBJECT_MAPPER.writeValueAsString(event);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("An error occurred while parsing POJO object to JSON:" + event, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeElasticSearchScanning(Runnable task) {
        try {
            long stamp = ELASTIC_SEARCH_EVENT_READING_LOCK.tryWriteLock(3L, TimeUnit.SECONDS);
            try {
                task.run();
            }
            finally {
                ELASTIC_SEARCH_EVENT_READING_LOCK.unlock(stamp);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private Instant maxInstant(Instant instant1, Instant instant2) {
        if (instant1.isBefore(instant2)) {
            instant1 = instant2;
        }
        return instant1;
    }

    private String getSettingName(String settingPrefix) {
        return settingPrefix + "-" + this.esClientName;
    }
}

