/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.elasticsearch.model;

import io.meeds.deeds.common.constant.DeedCard;
import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.constant.OfferType;
import io.meeds.deeds.common.constant.RentalPaymentPeriodicity;
import io.meeds.deeds.common.constant.TransactionStatus;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="deed_tenant_offer", createIndex=true)
@Setting(replicas=0, shards=1)
public class DeedTenantOffer
implements Cloneable {
    @Id
    private String id;
    @Field(type=FieldType.Long)
    private long offerId;
    @Field(type=FieldType.Long)
    private long nftId;
    @Field(type=FieldType.Auto)
    private DeedCity city;
    @Field(type=FieldType.Auto)
    private DeedCard cardType;
    @Field(type=FieldType.Keyword)
    private String owner;
    @Field(type=FieldType.Keyword, storeNullValue=true)
    private String hostAddress;
    @Field(type=FieldType.Keyword)
    private List<String> viewAddresses;
    @Field(type=FieldType.Keyword)
    private String ownerEmail;
    @Field(type=FieldType.Text)
    private String description;
    @Field(type=FieldType.Double)
    private double amount;
    @Field(type=FieldType.Double)
    private double allDurationAmount;
    @Field(type=FieldType.Keyword)
    private OfferType offerType;
    @Field(type=FieldType.Integer)
    private int expirationDays;
    @Field(type=FieldType.Integer)
    private int months;
    @Field(type=FieldType.Keyword)
    private RentalPaymentPeriodicity paymentPeriodicity;
    @Field(type=FieldType.Integer)
    private int noticePeriod;
    @Field(type=FieldType.Integer)
    private int ownerMintingPercentage;
    @Field(type=FieldType.Double)
    private double mintingPower;
    @Field(type=FieldType.Keyword)
    private String offerTransactionHash;
    @Field(type=FieldType.Keyword)
    private TransactionStatus offerTransactionStatus;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant startDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time}, storeNullValue=true)
    private Instant expirationDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time})
    private Instant createdDate;
    @Field(type=FieldType.Date, format={DateFormat.basic_date_time})
    private Instant modifiedDate;
    @Field(type=FieldType.Boolean)
    private boolean enabled;
    @Field(type=FieldType.Boolean)
    private boolean acquired;
    @Field(type=FieldType.Keyword)
    private String updateId;
    @Field(type=FieldType.Keyword)
    private String deleteId;
    @Field(type=FieldType.Keyword, storeNullValue=true)
    private String parentId;
    @Field(type=FieldType.Keyword)
    private Set<String> acquisitionIds;
    @Field(type=FieldType.Long)
    private long lastCheckedBlock;

    public DeedTenantOffer clone() {
        return new DeedTenantOffer(this.id, this.offerId, this.nftId, this.city, this.cardType, this.owner, this.hostAddress, this.viewAddresses, this.ownerEmail, this.description, this.amount, this.allDurationAmount, this.offerType, this.expirationDays, this.months, this.paymentPeriodicity, this.noticePeriod, this.ownerMintingPercentage, this.mintingPower, this.offerTransactionHash, this.offerTransactionStatus, this.startDate, this.expirationDate, this.createdDate, this.modifiedDate, this.enabled, this.acquired, this.updateId, this.deleteId, this.parentId, this.acquisitionIds, this.lastCheckedBlock);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getOfferId() {
        return this.offerId;
    }

    @Generated
    public long getNftId() {
        return this.nftId;
    }

    @Generated
    public DeedCity getCity() {
        return this.city;
    }

    @Generated
    public DeedCard getCardType() {
        return this.cardType;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Generated
    public List<String> getViewAddresses() {
        return this.viewAddresses;
    }

    @Generated
    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Generated
    public double getAllDurationAmount() {
        return this.allDurationAmount;
    }

    @Generated
    public OfferType getOfferType() {
        return this.offerType;
    }

    @Generated
    public int getExpirationDays() {
        return this.expirationDays;
    }

    @Generated
    public int getMonths() {
        return this.months;
    }

    @Generated
    public RentalPaymentPeriodicity getPaymentPeriodicity() {
        return this.paymentPeriodicity;
    }

    @Generated
    public int getNoticePeriod() {
        return this.noticePeriod;
    }

    @Generated
    public int getOwnerMintingPercentage() {
        return this.ownerMintingPercentage;
    }

    @Generated
    public double getMintingPower() {
        return this.mintingPower;
    }

    @Generated
    public String getOfferTransactionHash() {
        return this.offerTransactionHash;
    }

    @Generated
    public TransactionStatus getOfferTransactionStatus() {
        return this.offerTransactionStatus;
    }

    @Generated
    public Instant getStartDate() {
        return this.startDate;
    }

    @Generated
    public Instant getExpirationDate() {
        return this.expirationDate;
    }

    @Generated
    public Instant getCreatedDate() {
        return this.createdDate;
    }

    @Generated
    public Instant getModifiedDate() {
        return this.modifiedDate;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public boolean isAcquired() {
        return this.acquired;
    }

    @Generated
    public String getUpdateId() {
        return this.updateId;
    }

    @Generated
    public String getDeleteId() {
        return this.deleteId;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public Set<String> getAcquisitionIds() {
        return this.acquisitionIds;
    }

    @Generated
    public long getLastCheckedBlock() {
        return this.lastCheckedBlock;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setOfferId(long offerId) {
        this.offerId = offerId;
    }

    @Generated
    public void setNftId(long nftId) {
        this.nftId = nftId;
    }

    @Generated
    public void setCity(DeedCity city) {
        this.city = city;
    }

    @Generated
    public void setCardType(DeedCard cardType) {
        this.cardType = cardType;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    @Generated
    public void setViewAddresses(List<String> viewAddresses) {
        this.viewAddresses = viewAddresses;
    }

    @Generated
    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Generated
    public void setAllDurationAmount(double allDurationAmount) {
        this.allDurationAmount = allDurationAmount;
    }

    @Generated
    public void setOfferType(OfferType offerType) {
        this.offerType = offerType;
    }

    @Generated
    public void setExpirationDays(int expirationDays) {
        this.expirationDays = expirationDays;
    }

    @Generated
    public void setMonths(int months) {
        this.months = months;
    }

    @Generated
    public void setPaymentPeriodicity(RentalPaymentPeriodicity paymentPeriodicity) {
        this.paymentPeriodicity = paymentPeriodicity;
    }

    @Generated
    public void setNoticePeriod(int noticePeriod) {
        this.noticePeriod = noticePeriod;
    }

    @Generated
    public void setOwnerMintingPercentage(int ownerMintingPercentage) {
        this.ownerMintingPercentage = ownerMintingPercentage;
    }

    @Generated
    public void setMintingPower(double mintingPower) {
        this.mintingPower = mintingPower;
    }

    @Generated
    public void setOfferTransactionHash(String offerTransactionHash) {
        this.offerTransactionHash = offerTransactionHash;
    }

    @Generated
    public void setOfferTransactionStatus(TransactionStatus offerTransactionStatus) {
        this.offerTransactionStatus = offerTransactionStatus;
    }

    @Generated
    public void setStartDate(Instant startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setExpirationDate(Instant expirationDate) {
        this.expirationDate = expirationDate;
    }

    @Generated
    public void setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
    }

    @Generated
    public void setModifiedDate(Instant modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setAcquired(boolean acquired) {
        this.acquired = acquired;
    }

    @Generated
    public void setUpdateId(String updateId) {
        this.updateId = updateId;
    }

    @Generated
    public void setDeleteId(String deleteId) {
        this.deleteId = deleteId;
    }

    @Generated
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Generated
    public void setAcquisitionIds(Set<String> acquisitionIds) {
        this.acquisitionIds = acquisitionIds;
    }

    @Generated
    public void setLastCheckedBlock(long lastCheckedBlock) {
        this.lastCheckedBlock = lastCheckedBlock;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeedTenantOffer)) {
            return false;
        }
        DeedTenantOffer other = (DeedTenantOffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOfferId() != other.getOfferId()) {
            return false;
        }
        if (this.getNftId() != other.getNftId()) {
            return false;
        }
        if (Double.compare(this.getAmount(), other.getAmount()) != 0) {
            return false;
        }
        if (Double.compare(this.getAllDurationAmount(), other.getAllDurationAmount()) != 0) {
            return false;
        }
        if (this.getExpirationDays() != other.getExpirationDays()) {
            return false;
        }
        if (this.getMonths() != other.getMonths()) {
            return false;
        }
        if (this.getNoticePeriod() != other.getNoticePeriod()) {
            return false;
        }
        if (this.getOwnerMintingPercentage() != other.getOwnerMintingPercentage()) {
            return false;
        }
        if (Double.compare(this.getMintingPower(), other.getMintingPower()) != 0) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isAcquired() != other.isAcquired()) {
            return false;
        }
        if (this.getLastCheckedBlock() != other.getLastCheckedBlock()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        DeedCity this$city = this.getCity();
        DeedCity other$city = other.getCity();
        if (this$city == null ? other$city != null : !((Object)((Object)this$city)).equals((Object)other$city)) {
            return false;
        }
        DeedCard this$cardType = this.getCardType();
        DeedCard other$cardType = other.getCardType();
        if (this$cardType == null ? other$cardType != null : !((Object)((Object)this$cardType)).equals((Object)other$cardType)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$hostAddress = this.getHostAddress();
        String other$hostAddress = other.getHostAddress();
        if (this$hostAddress == null ? other$hostAddress != null : !this$hostAddress.equals(other$hostAddress)) {
            return false;
        }
        List<String> this$viewAddresses = this.getViewAddresses();
        List<String> other$viewAddresses = other.getViewAddresses();
        if (this$viewAddresses == null ? other$viewAddresses != null : !((Object)this$viewAddresses).equals(other$viewAddresses)) {
            return false;
        }
        String this$ownerEmail = this.getOwnerEmail();
        String other$ownerEmail = other.getOwnerEmail();
        if (this$ownerEmail == null ? other$ownerEmail != null : !this$ownerEmail.equals(other$ownerEmail)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        OfferType this$offerType = this.getOfferType();
        OfferType other$offerType = other.getOfferType();
        if (this$offerType == null ? other$offerType != null : !((Object)((Object)this$offerType)).equals((Object)other$offerType)) {
            return false;
        }
        RentalPaymentPeriodicity this$paymentPeriodicity = this.getPaymentPeriodicity();
        RentalPaymentPeriodicity other$paymentPeriodicity = other.getPaymentPeriodicity();
        if (this$paymentPeriodicity == null ? other$paymentPeriodicity != null : !((Object)((Object)this$paymentPeriodicity)).equals((Object)other$paymentPeriodicity)) {
            return false;
        }
        String this$offerTransactionHash = this.getOfferTransactionHash();
        String other$offerTransactionHash = other.getOfferTransactionHash();
        if (this$offerTransactionHash == null ? other$offerTransactionHash != null : !this$offerTransactionHash.equals(other$offerTransactionHash)) {
            return false;
        }
        TransactionStatus this$offerTransactionStatus = this.getOfferTransactionStatus();
        TransactionStatus other$offerTransactionStatus = other.getOfferTransactionStatus();
        if (this$offerTransactionStatus == null ? other$offerTransactionStatus != null : !((Object)((Object)this$offerTransactionStatus)).equals((Object)other$offerTransactionStatus)) {
            return false;
        }
        Instant this$startDate = this.getStartDate();
        Instant other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Instant this$expirationDate = this.getExpirationDate();
        Instant other$expirationDate = other.getExpirationDate();
        if (this$expirationDate == null ? other$expirationDate != null : !((Object)this$expirationDate).equals(other$expirationDate)) {
            return false;
        }
        Instant this$createdDate = this.getCreatedDate();
        Instant other$createdDate = other.getCreatedDate();
        if (this$createdDate == null ? other$createdDate != null : !((Object)this$createdDate).equals(other$createdDate)) {
            return false;
        }
        Instant this$modifiedDate = this.getModifiedDate();
        Instant other$modifiedDate = other.getModifiedDate();
        if (this$modifiedDate == null ? other$modifiedDate != null : !((Object)this$modifiedDate).equals(other$modifiedDate)) {
            return false;
        }
        String this$updateId = this.getUpdateId();
        String other$updateId = other.getUpdateId();
        if (this$updateId == null ? other$updateId != null : !this$updateId.equals(other$updateId)) {
            return false;
        }
        String this$deleteId = this.getDeleteId();
        String other$deleteId = other.getDeleteId();
        if (this$deleteId == null ? other$deleteId != null : !this$deleteId.equals(other$deleteId)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        Set<String> this$acquisitionIds = this.getAcquisitionIds();
        Set<String> other$acquisitionIds = other.getAcquisitionIds();
        return !(this$acquisitionIds == null ? other$acquisitionIds != null : !((Object)this$acquisitionIds).equals(other$acquisitionIds));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeedTenantOffer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offerId = this.getOfferId();
        result = result * 59 + (int)($offerId >>> 32 ^ $offerId);
        long $nftId = this.getNftId();
        result = result * 59 + (int)($nftId >>> 32 ^ $nftId);
        long $amount = Double.doubleToLongBits(this.getAmount());
        result = result * 59 + (int)($amount >>> 32 ^ $amount);
        long $allDurationAmount = Double.doubleToLongBits(this.getAllDurationAmount());
        result = result * 59 + (int)($allDurationAmount >>> 32 ^ $allDurationAmount);
        result = result * 59 + this.getExpirationDays();
        result = result * 59 + this.getMonths();
        result = result * 59 + this.getNoticePeriod();
        result = result * 59 + this.getOwnerMintingPercentage();
        long $mintingPower = Double.doubleToLongBits(this.getMintingPower());
        result = result * 59 + (int)($mintingPower >>> 32 ^ $mintingPower);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isAcquired() ? 79 : 97);
        long $lastCheckedBlock = this.getLastCheckedBlock();
        result = result * 59 + (int)($lastCheckedBlock >>> 32 ^ $lastCheckedBlock);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        DeedCity $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : ((Object)((Object)$city)).hashCode());
        DeedCard $cardType = this.getCardType();
        result = result * 59 + ($cardType == null ? 43 : ((Object)((Object)$cardType)).hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $hostAddress = this.getHostAddress();
        result = result * 59 + ($hostAddress == null ? 43 : $hostAddress.hashCode());
        List<String> $viewAddresses = this.getViewAddresses();
        result = result * 59 + ($viewAddresses == null ? 43 : ((Object)$viewAddresses).hashCode());
        String $ownerEmail = this.getOwnerEmail();
        result = result * 59 + ($ownerEmail == null ? 43 : $ownerEmail.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        OfferType $offerType = this.getOfferType();
        result = result * 59 + ($offerType == null ? 43 : ((Object)((Object)$offerType)).hashCode());
        RentalPaymentPeriodicity $paymentPeriodicity = this.getPaymentPeriodicity();
        result = result * 59 + ($paymentPeriodicity == null ? 43 : ((Object)((Object)$paymentPeriodicity)).hashCode());
        String $offerTransactionHash = this.getOfferTransactionHash();
        result = result * 59 + ($offerTransactionHash == null ? 43 : $offerTransactionHash.hashCode());
        TransactionStatus $offerTransactionStatus = this.getOfferTransactionStatus();
        result = result * 59 + ($offerTransactionStatus == null ? 43 : ((Object)((Object)$offerTransactionStatus)).hashCode());
        Instant $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Instant $expirationDate = this.getExpirationDate();
        result = result * 59 + ($expirationDate == null ? 43 : ((Object)$expirationDate).hashCode());
        Instant $createdDate = this.getCreatedDate();
        result = result * 59 + ($createdDate == null ? 43 : ((Object)$createdDate).hashCode());
        Instant $modifiedDate = this.getModifiedDate();
        result = result * 59 + ($modifiedDate == null ? 43 : ((Object)$modifiedDate).hashCode());
        String $updateId = this.getUpdateId();
        result = result * 59 + ($updateId == null ? 43 : $updateId.hashCode());
        String $deleteId = this.getDeleteId();
        result = result * 59 + ($deleteId == null ? 43 : $deleteId.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        Set<String> $acquisitionIds = this.getAcquisitionIds();
        result = result * 59 + ($acquisitionIds == null ? 43 : ((Object)$acquisitionIds).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DeedTenantOffer(id=" + this.getId() + ", offerId=" + this.getOfferId() + ", nftId=" + this.getNftId() + ", city=" + String.valueOf((Object)this.getCity()) + ", cardType=" + String.valueOf((Object)this.getCardType()) + ", owner=" + this.getOwner() + ", hostAddress=" + this.getHostAddress() + ", viewAddresses=" + String.valueOf(this.getViewAddresses()) + ", ownerEmail=" + this.getOwnerEmail() + ", description=" + this.getDescription() + ", amount=" + this.getAmount() + ", allDurationAmount=" + this.getAllDurationAmount() + ", offerType=" + String.valueOf((Object)this.getOfferType()) + ", expirationDays=" + this.getExpirationDays() + ", months=" + this.getMonths() + ", paymentPeriodicity=" + String.valueOf((Object)this.getPaymentPeriodicity()) + ", noticePeriod=" + this.getNoticePeriod() + ", ownerMintingPercentage=" + this.getOwnerMintingPercentage() + ", mintingPower=" + this.getMintingPower() + ", offerTransactionHash=" + this.getOfferTransactionHash() + ", offerTransactionStatus=" + String.valueOf((Object)this.getOfferTransactionStatus()) + ", startDate=" + String.valueOf(this.getStartDate()) + ", expirationDate=" + String.valueOf(this.getExpirationDate()) + ", createdDate=" + String.valueOf(this.getCreatedDate()) + ", modifiedDate=" + String.valueOf(this.getModifiedDate()) + ", enabled=" + this.isEnabled() + ", acquired=" + this.isAcquired() + ", updateId=" + this.getUpdateId() + ", deleteId=" + this.getDeleteId() + ", parentId=" + this.getParentId() + ", acquisitionIds=" + String.valueOf(this.getAcquisitionIds()) + ", lastCheckedBlock=" + this.getLastCheckedBlock() + ")";
    }

    @Generated
    public DeedTenantOffer(String id, long offerId, long nftId, DeedCity city, DeedCard cardType, String owner, String hostAddress, List<String> viewAddresses, String ownerEmail, String description, double amount, double allDurationAmount, OfferType offerType, int expirationDays, int months, RentalPaymentPeriodicity paymentPeriodicity, int noticePeriod, int ownerMintingPercentage, double mintingPower, String offerTransactionHash, TransactionStatus offerTransactionStatus, Instant startDate, Instant expirationDate, Instant createdDate, Instant modifiedDate, boolean enabled, boolean acquired, String updateId, String deleteId, String parentId, Set<String> acquisitionIds, long lastCheckedBlock) {
        this.id = id;
        this.offerId = offerId;
        this.nftId = nftId;
        this.city = city;
        this.cardType = cardType;
        this.owner = owner;
        this.hostAddress = hostAddress;
        this.viewAddresses = viewAddresses;
        this.ownerEmail = ownerEmail;
        this.description = description;
        this.amount = amount;
        this.allDurationAmount = allDurationAmount;
        this.offerType = offerType;
        this.expirationDays = expirationDays;
        this.months = months;
        this.paymentPeriodicity = paymentPeriodicity;
        this.noticePeriod = noticePeriod;
        this.ownerMintingPercentage = ownerMintingPercentage;
        this.mintingPower = mintingPower;
        this.offerTransactionHash = offerTransactionHash;
        this.offerTransactionStatus = offerTransactionStatus;
        this.startDate = startDate;
        this.expirationDate = expirationDate;
        this.createdDate = createdDate;
        this.modifiedDate = modifiedDate;
        this.enabled = enabled;
        this.acquired = acquired;
        this.updateId = updateId;
        this.deleteId = deleteId;
        this.parentId = parentId;
        this.acquisitionIds = acquisitionIds;
        this.lastCheckedBlock = lastCheckedBlock;
    }

    @Generated
    public DeedTenantOffer() {
    }

    @Generated
    public DeedTenantOffer withParentId(String parentId) {
        return this.parentId == parentId ? this : new DeedTenantOffer(this.id, this.offerId, this.nftId, this.city, this.cardType, this.owner, this.hostAddress, this.viewAddresses, this.ownerEmail, this.description, this.amount, this.allDurationAmount, this.offerType, this.expirationDays, this.months, this.paymentPeriodicity, this.noticePeriod, this.ownerMintingPercentage, this.mintingPower, this.offerTransactionHash, this.offerTransactionStatus, this.startDate, this.expirationDate, this.createdDate, this.modifiedDate, this.enabled, this.acquired, this.updateId, this.deleteId, parentId, this.acquisitionIds, this.lastCheckedBlock);
    }

    @Generated
    public DeedTenantOffer withAcquisitionIds(Set<String> acquisitionIds) {
        return this.acquisitionIds == acquisitionIds ? this : new DeedTenantOffer(this.id, this.offerId, this.nftId, this.city, this.cardType, this.owner, this.hostAddress, this.viewAddresses, this.ownerEmail, this.description, this.amount, this.allDurationAmount, this.offerType, this.expirationDays, this.months, this.paymentPeriodicity, this.noticePeriod, this.ownerMintingPercentage, this.mintingPower, this.offerTransactionHash, this.offerTransactionStatus, this.startDate, this.expirationDate, this.createdDate, this.modifiedDate, this.enabled, this.acquired, this.updateId, this.deleteId, this.parentId, acquisitionIds, this.lastCheckedBlock);
    }
}

