/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.service;

import io.meeds.deeds.common.elasticsearch.model.UserProfile;
import io.meeds.deeds.common.elasticsearch.storage.UserProfileRepository;
import io.meeds.deeds.common.model.UserProfileDTO;
import io.meeds.deeds.common.service.ListenerService;
import io.meeds.deeds.common.utils.UserProfileMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserProfileService {
    @Autowired
    private UserProfileRepository userProfileRepository;
    @Autowired
    private ListenerService listenerService;

    public UserProfileDTO getUserProfile(String address) {
        UserProfile userProfile = this.userProfileRepository.findByAddress(address.toLowerCase());
        return UserProfileMapper.toDTO(userProfile);
    }

    public void saveUserProfile(UserProfileDTO userProfileDTO) {
        UserProfile userProfile = this.userProfileRepository.findByAddress(userProfileDTO.getAddress().toLowerCase());
        userProfile = userProfile == null ? UserProfileMapper.fromDTO(userProfileDTO) : UserProfileMapper.fromDTO(userProfileDTO).withId(userProfile.getId());
        userProfile = (UserProfile)this.userProfileRepository.save(userProfile);
        this.listenerService.publishEvent("deed.event.userProfileSaved", UserProfileMapper.toDTO(userProfile));
    }
}

