/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.common.utils;

import io.meeds.deeds.common.elasticsearch.model.HubReportEntity;
import io.meeds.wom.api.model.HubReport;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class HubReportMapper {
    private HubReportMapper() {
    }

    public static HubReportEntity toEntity(HubReport report) {
        return new HubReportEntity(report.getReportId(), report.getRewardId(), StringUtils.lowerCase((String)report.getHubAddress()), StringUtils.lowerCase((String)report.getDeedManagerAddress()), StringUtils.lowerCase((String)report.getOwnerAddress()), report.getOwnerMintingPercentage(), report.getDeedId(), report.getCity(), report.getCardType(), report.getMintingPower(), report.getMaxUsers(), report.getFromDate(), report.getToDate(), report.getSentDate(), report.getPeriodType(), report.getUsersCount(), report.getParticipantsCount(), report.getRecipientsCount(), report.getAchievementsCount(), report.getActionsCount(), StringUtils.lowerCase((String)report.getRewardTokenAddress()), report.getRewardTokenNetworkId(), HubReportMapper.lowerCase(report.getTransactions()), report.getHubRewardAmount(), report.getHubTopRewardedAmount(), report.getFixedRewardIndex(), report.getOwnerFixedIndex(), report.getTenantFixedIndex(), report.isFraud(), report.getLastPeriodUemRewardAmount(), report.getUemRewardAmount(), report.getUpdatedDate(), report.getEngagementScore());
    }

    public static HubReport fromEntity(HubReportEntity entity) {
        return new HubReport(entity.getReportId(), entity.getHubAddress(), entity.getDeedId(), entity.getFromDate(), entity.getToDate(), entity.getSentDate(), entity.getPeriodType(), entity.getUsersCount(), entity.getParticipantsCount(), entity.getRecipientsCount(), entity.getAchievementsCount(), entity.getActionsCount(), entity.getRewardTokenAddress(), entity.getRewardTokenNetworkId(), entity.getHubRewardAmount(), entity.getHubTopRewardedAmount(), entity.getTransactions(), entity.getRewardId(), entity.getCity(), entity.getCardType(), entity.getMintingPower(), entity.getMaxUsers(), entity.getDeedManagerAddress(), entity.getOwnerAddress(), entity.getOwnerMintingPercentage(), entity.getFixedRewardIndex(), entity.getOwnerFixedIndex(), entity.getTenantFixedIndex(), entity.isFraud(), entity.getLastPeriodUemRewardAmount(), entity.getUemRewardAmount(), entity.getUpdatedDate(), entity.getEngagementScore());
    }

    public static SortedSet<String> lowerCase(SortedSet<String> transactions) {
        if (CollectionUtils.isEmpty(transactions)) {
            return new TreeSet<String>();
        }
        return transactions.stream().map(StringUtils::lowerCase).collect(Collectors.toCollection(TreeSet::new));
    }
}

