/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest;

import io.meeds.deeds.common.service.AuthorizationCodeService;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/authorization"})
public class AuthorizationCodeController {
    @Autowired
    private AuthorizationCodeService authorizationCodeService;

    @PostMapping(value={"/generateCode"}, consumes={"application/x-www-form-urlencoded"})
    public void generateCode(Principal principal, @RequestParam(value="email") String email, HttpServletRequest request) {
        String clientIp = request.getHeader("X-FORWARDED-FOR");
        if (clientIp == null) {
            clientIp = request.getRemoteAddr();
        }
        if (principal == null && StringUtils.isBlank((CharSequence)clientIp)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            if (principal == null) {
                this.authorizationCodeService.generateCode(email, email, (Object)email, clientIp);
            } else {
                String walletAddress = principal.getName();
                this.authorizationCodeService.generateCode(StringUtils.lowerCase((String)walletAddress), email, (Object)email, clientIp);
            }
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Max authorization code usage reached");
        }
    }

    @PostMapping(value={"/checkValidity"}, consumes={"application/x-www-form-urlencoded"})
    public void checkValidity(Principal principal, @RequestHeader(name="X-AUTHORIZATION", required=true) int code, @RequestParam(value="email") String email) {
        if (principal == null && StringUtils.isBlank((CharSequence)email)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        try {
            if (principal == null) {
                this.authorizationCodeService.checkValidity(email, code);
            } else {
                String walletAddress = StringUtils.lowerCase((String)principal.getName());
                this.authorizationCodeService.checkValidity(walletAddress, code);
            }
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Invalid code");
        }
    }
}

