/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.filter;

import io.meeds.deeds.common.constant.DeedCity;
import io.meeds.deeds.common.elasticsearch.model.DeedTenant;
import io.meeds.deeds.common.service.TenantService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TenantPlaceholderRequestDispatcherFilter
extends HttpFilter {
    private static final long serialVersionUID = 8971410534107824567L;
    private static final Pattern SERVER_HOST_PATTERN = Pattern.compile("(tanit|reshef|ashtarte|melqart|eshmun|kushor|hammon)-([\\d]+)\\.meeds\\.io");
    @Autowired
    protected TenantService tenantService;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        long nftId = this.getDeedId(request);
        if (nftId > 0L && !this.tenantService.isTenantCommandStop(nftId) && this.isDeedCity(request, nftId)) {
            response.setContentType("text/html; charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            RequestDispatcher dispatcher = request.getRequestDispatcher("/WEB-INF/jsp/placeholder.jsp");
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        } else {
            response.setStatus(404);
        }
    }

    private long getDeedId(HttpServletRequest request) {
        Matcher matcher;
        String nftId = request.getParameter("nftId");
        if (StringUtils.isBlank((CharSequence)nftId) && StringUtils.isNotBlank((CharSequence)request.getRequestURL()) && (matcher = SERVER_HOST_PATTERN.matcher(request.getRequestURL())).find()) {
            nftId = matcher.group(2);
        }
        if (StringUtils.isNotBlank((CharSequence)nftId)) {
            return Long.parseLong(nftId);
        }
        return -1L;
    }

    private boolean isDeedCity(HttpServletRequest request, long nftId) {
        int deedCityIndex = this.getDeedCityIndex(request);
        if (deedCityIndex >= 0) {
            DeedTenant deedTenant = this.tenantService.getDeedTenant(nftId);
            return deedTenant == null || deedTenant.getCityIndex() == deedCityIndex;
        }
        return true;
    }

    private int getDeedCityIndex(HttpServletRequest request) {
        String cityName = request.getParameter("cityName");
        if (StringUtils.isBlank((CharSequence)cityName)) {
            Matcher matcher = SERVER_HOST_PATTERN.matcher(request.getRequestURL());
            if (matcher.find()) {
                return DeedCity.valueOf((String)matcher.group(1).toUpperCase()).ordinal();
            }
            return -1;
        }
        return DeedCity.valueOf((String)cityName.toUpperCase()).ordinal();
    }
}

