/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest;

import io.meeds.deeds.common.service.HubReportService;
import io.meeds.wom.api.constant.WomAuthorizationException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.constant.WomParsingException;
import io.meeds.wom.api.constant.WomRequestException;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportVerifiableData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/hub/reports"})
public class HubReportController {
    @Autowired
    private HubReportService reportService;

    @GetMapping
    public ResponseEntity<PagedModel<EntityModel<HubReport>>> getReports(Pageable pageable, PagedResourcesAssembler<HubReport> assembler, @RequestParam(name="hubAddress", required=false) String hubAddress, @RequestParam(name="rewardId", required=false, defaultValue="0") long rewardId) {
        Page reports = this.reportService.getReports(hubAddress, rewardId, pageable);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)assembler.toModel(reports));
    }

    @GetMapping(value={"/{reportId}"})
    public ResponseEntity<Object> getReport(@PathVariable(name="reportId") long reportId, @RequestParam(name="forceRefresh", required=false) boolean forceRefresh) {
        HubReport hubReport;
        HubReport hubReport2 = hubReport = forceRefresh ? this.reportService.refreshReport(reportId) : this.reportService.getReport(reportId);
        if (hubReport == null) {
            return ResponseEntity.notFound().cacheControl(CacheControl.noStore()).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)hubReport);
    }

    @GetMapping(value={"/{rewardId}/{hubAddress}"})
    public ResponseEntity<Object> getReport(@PathVariable(name="rewardId") long rewardId, @PathVariable(name="hubAddress") String hubAddress) {
        HubReport hubReport = this.reportService.getReport(rewardId, hubAddress);
        if (hubReport == null) {
            return ResponseEntity.notFound().cacheControl(CacheControl.noStore()).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)hubReport);
    }

    @PostMapping
    public ResponseEntity<Object> saveReport(@RequestBody HubReportVerifiableData reportRequest) {
        try {
            HubReport report = this.reportService.saveReport(reportRequest);
            return ResponseEntity.ok((Object)report);
        }
        catch (WomParsingException | WomRequestException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)e.getErrorCode());
        }
        catch (WomAuthorizationException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)e.getErrorCode());
        }
        catch (WomException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getErrorCode());
        }
    }
}

