/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.web.rest;

import io.meeds.deeds.common.service.UemRewardService;
import io.meeds.wom.api.model.UemReward;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/uem/rewards"})
public class UemRewardController {
    @Autowired
    private UemRewardService rewardService;

    @GetMapping
    public ResponseEntity<PagedModel<EntityModel<UemReward>>> getRewards(Pageable pageable, PagedResourcesAssembler<UemReward> assembler, @RequestParam(name="hubAddress", required=false) String hubAddress) {
        Page rewards = this.rewardService.getRewards(hubAddress, pageable);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)assembler.toModel(rewards));
    }

    @GetMapping(value={"{rewardId}"})
    public ResponseEntity<UemReward> getReward(@PathVariable(name="rewardId") long rewardId, @RequestParam(name="forceRefresh", required=false) boolean forceRefresh) {
        UemReward reward = forceRefresh ? this.rewardService.refreshRewardProperties(rewardId) : this.rewardService.getRewardById(rewardId);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)reward);
    }

    @GetMapping(value={"claimable/{address}"})
    public ResponseEntity<Object> getClaimableRewards(@PathVariable(name="address") String address) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("address", address);
        properties.put("claimable", String.valueOf(this.rewardService.getClaimableRewards(address)));
        properties.put("contract", this.rewardService.getUemAddress());
        return ResponseEntity.ok(properties);
    }
}

