/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class MeedsPointsRewarding
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_DECREASEALLOWANCE = "decreaseAllowance";
    public static final String FUNC_EARNED = "earned";
    public static final String FUNC_EXIT = "exit";
    public static final String FUNC_INCREASEALLOWANCE = "increaseAllowance";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_MEED = "meed";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_REWARDDISTRIBUTION = "rewardDistribution";
    public static final String FUNC_STAKE = "stake";
    public static final String FUNC_STARTREWARDSTIME = "startRewardsTime";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_WITHDRAW = "withdraw";
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event STAKED_EVENT = new Event("Staked", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event WITHDRAWN_EVENT = new Event("Withdrawn", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));

    @Deprecated
    protected MeedsPointsRewarding(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected MeedsPointsRewarding(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected MeedsPointsRewarding(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected MeedsPointsRewarding(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List valueList = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)APPROVAL_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ApprovalEventResponse getApprovalEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)APPROVAL_EVENT, (Log)log);
        ApprovalEventResponse typedResponse = new ApprovalEventResponse();
        typedResponse.log = log;
        typedResponse.owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> MeedsPointsRewarding.getApprovalEventFromLog(log));
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVAL_EVENT));
        return this.approvalEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OwnershipTransferredEventResponse getOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (Log)log);
        OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> MeedsPointsRewarding.getOwnershipTransferredEventFromLog(log));
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public static List<StakedEventResponse> getStakedEvents(TransactionReceipt transactionReceipt) {
        List valueList = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)STAKED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<StakedEventResponse> responses = new ArrayList<StakedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            StakedEventResponse typedResponse = new StakedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static StakedEventResponse getStakedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)STAKED_EVENT, (Log)log);
        StakedEventResponse typedResponse = new StakedEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<StakedEventResponse> stakedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> MeedsPointsRewarding.getStakedEventFromLog(log));
    }

    public Flowable<StakedEventResponse> stakedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)STAKED_EVENT));
        return this.stakedEventFlowable(filter);
    }

    public static List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List valueList = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)TRANSFER_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static TransferEventResponse getTransferEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)TRANSFER_EVENT, (Log)log);
        TransferEventResponse typedResponse = new TransferEventResponse();
        typedResponse.log = log;
        typedResponse.from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> MeedsPointsRewarding.getTransferEventFromLog(log));
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventFlowable(filter);
    }

    public static List<WithdrawnEventResponse> getWithdrawnEvents(TransactionReceipt transactionReceipt) {
        List valueList = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)WITHDRAWN_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<WithdrawnEventResponse> responses = new ArrayList<WithdrawnEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            WithdrawnEventResponse typedResponse = new WithdrawnEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static WithdrawnEventResponse getWithdrawnEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = MeedsPointsRewarding.staticExtractEventParametersWithLog((Event)WITHDRAWN_EVENT, (Log)log);
        WithdrawnEventResponse typedResponse = new WithdrawnEventResponse();
        typedResponse.log = log;
        typedResponse.user = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<WithdrawnEventResponse> withdrawnEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> MeedsPointsRewarding.getWithdrawnEventFromLog(log));
    }

    public Flowable<WithdrawnEventResponse> withdrawnEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)WITHDRAWN_EVENT));
        return this.withdrawnEventFlowable(filter);
    }

    public RemoteFunctionCall<BigInteger> allowance(String owner, String spender) {
        Function function = new Function(FUNC_ALLOWANCE, Arrays.asList(new Address(160, owner), new Address(160, spender)), Arrays.asList(new TypeReference<Uint256>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> approve(String spender, BigInteger amount) {
        Function function = new Function(FUNC_APPROVE, Arrays.asList(new Address(160, spender), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String account) {
        Function function = new Function(FUNC_BALANCEOF, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Uint256>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> decimals() {
        Function function = new Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> decreaseAllowance(String spender, BigInteger subtractedValue) {
        Function function = new Function(FUNC_DECREASEALLOWANCE, Arrays.asList(new Address(160, spender), new Uint256(subtractedValue)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> earned(String account) {
        Function function = new Function(FUNC_EARNED, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Uint256>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> exit() {
        Function function = new Function(FUNC_EXIT, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> increaseAllowance(String spender, BigInteger addedValue) {
        Function function = new Function(FUNC_INCREASEALLOWANCE, Arrays.asList(new Address(160, spender), new Uint256(addedValue)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        Function function = new Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> meed() {
        Function function = new Function(FUNC_MEED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> name() {
        Function function = new Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        Function function = new Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> rewardDistribution() {
        Function function = new Function(FUNC_REWARDDISTRIBUTION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> stake(BigInteger amount) {
        Function function = new Function(FUNC_STAKE, Arrays.asList(new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> startRewardsTime() {
        Function function = new Function(FUNC_STARTREWARDSTIME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> symbol() {
        Function function = new Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        Function function = new Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transfer(String recipient, BigInteger amount) {
        Function function = new Function(FUNC_TRANSFER, Arrays.asList(new Address(160, recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferFrom(String sender, String recipient, BigInteger amount) {
        Function function = new Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(160, sender), new Address(160, recipient), new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> withdraw(BigInteger amount) {
        Function function = new Function(FUNC_WITHDRAW, Arrays.asList(new Uint256(amount)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static MeedsPointsRewarding load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new MeedsPointsRewarding(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static MeedsPointsRewarding load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new MeedsPointsRewarding(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static MeedsPointsRewarding load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new MeedsPointsRewarding(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static MeedsPointsRewarding load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new MeedsPointsRewarding(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<MeedsPointsRewarding> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, String _meed, String _rewardDistribution, BigInteger _startRewardsTime) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Address(160, _rewardDistribution), new Uint256(_startRewardsTime)));
        return MeedsPointsRewarding.deployRemoteCall(MeedsPointsRewarding.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    public static RemoteCall<MeedsPointsRewarding> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, String _meed, String _rewardDistribution, BigInteger _startRewardsTime) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Address(160, _rewardDistribution), new Uint256(_startRewardsTime)));
        return MeedsPointsRewarding.deployRemoteCall(MeedsPointsRewarding.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<MeedsPointsRewarding> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, String _meed, String _rewardDistribution, BigInteger _startRewardsTime) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Address(160, _rewardDistribution), new Uint256(_startRewardsTime)));
        return MeedsPointsRewarding.deployRemoteCall(MeedsPointsRewarding.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    @Deprecated
    public static RemoteCall<MeedsPointsRewarding> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, String _meed, String _rewardDistribution, BigInteger _startRewardsTime) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.asList(new Address(160, _meed), new Address(160, _rewardDistribution), new Uint256(_startRewardsTime)));
        return MeedsPointsRewarding.deployRemoteCall(MeedsPointsRewarding.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)encodedConstructor);
    }

    public static class ApprovalEventResponse
    extends BaseEventResponse {
        public String owner;
        public String spender;
        public BigInteger value;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class StakedEventResponse
    extends BaseEventResponse {
        public String user;
        public BigInteger amount;
    }

    public static class TransferEventResponse
    extends BaseEventResponse {
        public String from;
        public String to;
        public BigInteger value;
    }

    public static class WithdrawnEventResponse
    extends BaseEventResponse {
        public String user;
        public BigInteger amount;
    }
}

