/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.contract;

import io.reactivex.Flowable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Function;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tuples.generated.Tuple9;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class TestWoM
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_ADDMANAGER = "addManager";
    public static final String FUNC_CONNECT = "connect";
    public static final String FUNC_DISCONNECT = "disconnect";
    public static final String FUNC_GETCONNECTEDDEED = "getConnectedDeed";
    public static final String FUNC_GETCONNECTEDHUB = "getConnectedHub";
    public static final String FUNC_GETDEED = "getDeed";
    public static final String FUNC_GETHUB = "getHub";
    public static final String FUNC_GETHUBJOINDATE = "getHubJoinDate";
    public static final String FUNC_HUBS = "hubs";
    public static final String FUNC_INITIALIZE = "initialize";
    public static final String FUNC_ISDEEDCONNECTED = "isDeedConnected";
    public static final String FUNC_ISHUBCONNECTED = "isHubConnected";
    public static final String FUNC_ISMANAGER = "isManager";
    public static final String FUNC_ISOWNER = "isOwner";
    public static final String FUNC_NFTS = "nfts";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_PROXIABLEUUID = "proxiableUUID";
    public static final String FUNC_REMOVEMANAGER = "removeManager";
    public static final String FUNC_RENOUNCEOWNERSHIP = "renounceOwnership";
    public static final String FUNC_SETJOINDATE = "setJoinDate";
    public static final String FUNC_TRANSFERHUBOWNERSHIP = "transferHubOwnership";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_UPDATEDEED = "updateDeed";
    public static final String FUNC_UPGRADETO = "upgradeTo";
    public static final String FUNC_UPGRADETOANDCALL = "upgradeToAndCall";
    public static final Event ADMINCHANGED_EVENT = new Event("AdminChanged", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Address>(){}));
    public static final Event BEACONUPGRADED_EVENT = new Event("BeaconUpgraded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event DEEDUPDATED_EVENT = new Event("DeedUpdated", Arrays.asList(new TypeReference<Uint256>(true){}));
    public static final Event HUBCONNECTED_EVENT = new Event("HubConnected", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}, new TypeReference<Address>(){}));
    public static final Event HUBDISCONNECTED_EVENT = new Event("HubDisconnected", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Uint256>(true){}));
    public static final Event HUBOWNERSHIPTRANSFERRED_EVENT = new Event("HubOwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event INITIALIZED_EVENT = new Event("Initialized", Arrays.asList(new TypeReference<Uint8>(){}));
    public static final Event MANAGERADDED_EVENT = new Event("ManagerAdded", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event MANAGERREMOVED_EVENT = new Event("ManagerRemoved", Arrays.asList(new TypeReference<Address>(true){}));
    public static final Event OWNERSHIPTRANSFERRED_EVENT = new Event("OwnershipTransferred", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}));
    public static final Event UPGRADED_EVENT = new Event("Upgraded", Arrays.asList(new TypeReference<Address>(true){}));

    @Deprecated
    protected TestWoM(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected TestWoM(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected TestWoM(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected TestWoM(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<AdminChangedEventResponse> getAdminChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)ADMINCHANGED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<AdminChangedEventResponse> responses = new ArrayList<AdminChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousAdmin = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.newAdmin = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static AdminChangedEventResponse getAdminChangedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)ADMINCHANGED_EVENT, (Log)log);
        AdminChangedEventResponse typedResponse = new AdminChangedEventResponse();
        typedResponse.log = log;
        typedResponse.previousAdmin = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        typedResponse.newAdmin = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getAdminChangedEventFromLog(log));
    }

    public Flowable<AdminChangedEventResponse> adminChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADMINCHANGED_EVENT));
        return this.adminChangedEventFlowable(filter);
    }

    public static List<BeaconUpgradedEventResponse> getBeaconUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)BEACONUPGRADED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<BeaconUpgradedEventResponse> responses = new ArrayList<BeaconUpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.beacon = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static BeaconUpgradedEventResponse getBeaconUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)BEACONUPGRADED_EVENT, (Log)log);
        BeaconUpgradedEventResponse typedResponse = new BeaconUpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.beacon = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getBeaconUpgradedEventFromLog(log));
    }

    public Flowable<BeaconUpgradedEventResponse> beaconUpgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)BEACONUPGRADED_EVENT));
        return this.beaconUpgradedEventFlowable(filter);
    }

    public static List<DeedUpdatedEventResponse> getDeedUpdatedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)DEEDUPDATED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<DeedUpdatedEventResponse> responses = new ArrayList<DeedUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DeedUpdatedEventResponse typedResponse = new DeedUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.nftId = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static DeedUpdatedEventResponse getDeedUpdatedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)DEEDUPDATED_EVENT, (Log)log);
        DeedUpdatedEventResponse typedResponse = new DeedUpdatedEventResponse();
        typedResponse.log = log;
        typedResponse.nftId = (BigInteger)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<DeedUpdatedEventResponse> deedUpdatedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getDeedUpdatedEventFromLog(log));
    }

    public Flowable<DeedUpdatedEventResponse> deedUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DEEDUPDATED_EVENT));
        return this.deedUpdatedEventFlowable(filter);
    }

    public static List<HubConnectedEventResponse> getHubConnectedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)HUBCONNECTED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<HubConnectedEventResponse> responses = new ArrayList<HubConnectedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            HubConnectedEventResponse typedResponse = new HubConnectedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.hub = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.nftId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse.hubOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static HubConnectedEventResponse getHubConnectedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)HUBCONNECTED_EVENT, (Log)log);
        HubConnectedEventResponse typedResponse = new HubConnectedEventResponse();
        typedResponse.log = log;
        typedResponse.hub = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.nftId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        typedResponse.hubOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<HubConnectedEventResponse> hubConnectedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getHubConnectedEventFromLog(log));
    }

    public Flowable<HubConnectedEventResponse> hubConnectedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)HUBCONNECTED_EVENT));
        return this.hubConnectedEventFlowable(filter);
    }

    public static List<HubDisconnectedEventResponse> getHubDisconnectedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)HUBDISCONNECTED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<HubDisconnectedEventResponse> responses = new ArrayList<HubDisconnectedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            HubDisconnectedEventResponse typedResponse = new HubDisconnectedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.hub = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.nftId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static HubDisconnectedEventResponse getHubDisconnectedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)HUBDISCONNECTED_EVENT, (Log)log);
        HubDisconnectedEventResponse typedResponse = new HubDisconnectedEventResponse();
        typedResponse.log = log;
        typedResponse.hub = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.nftId = (BigInteger)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<HubDisconnectedEventResponse> hubDisconnectedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getHubDisconnectedEventFromLog(log));
    }

    public Flowable<HubDisconnectedEventResponse> hubDisconnectedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)HUBDISCONNECTED_EVENT));
        return this.hubDisconnectedEventFlowable(filter);
    }

    public static List<HubOwnershipTransferredEventResponse> getHubOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)HUBOWNERSHIPTRANSFERRED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<HubOwnershipTransferredEventResponse> responses = new ArrayList<HubOwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            HubOwnershipTransferredEventResponse typedResponse = new HubOwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static HubOwnershipTransferredEventResponse getHubOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)HUBOWNERSHIPTRANSFERRED_EVENT, (Log)log);
        HubOwnershipTransferredEventResponse typedResponse = new HubOwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<HubOwnershipTransferredEventResponse> hubOwnershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getHubOwnershipTransferredEventFromLog(log));
    }

    public Flowable<HubOwnershipTransferredEventResponse> hubOwnershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)HUBOWNERSHIPTRANSFERRED_EVENT));
        return this.hubOwnershipTransferredEventFlowable(filter);
    }

    public static List<InitializedEventResponse> getInitializedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)INITIALIZED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<InitializedEventResponse> responses = new ArrayList<InitializedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            InitializedEventResponse typedResponse = new InitializedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.version = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static InitializedEventResponse getInitializedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)INITIALIZED_EVENT, (Log)log);
        InitializedEventResponse typedResponse = new InitializedEventResponse();
        typedResponse.log = log;
        typedResponse.version = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getInitializedEventFromLog(log));
    }

    public Flowable<InitializedEventResponse> initializedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)INITIALIZED_EVENT));
        return this.initializedEventFlowable(filter);
    }

    public static List<ManagerAddedEventResponse> getManagerAddedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)MANAGERADDED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ManagerAddedEventResponse> responses = new ArrayList<ManagerAddedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ManagerAddedEventResponse getManagerAddedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)MANAGERADDED_EVENT, (Log)log);
        ManagerAddedEventResponse typedResponse = new ManagerAddedEventResponse();
        typedResponse.log = log;
        typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getManagerAddedEventFromLog(log));
    }

    public Flowable<ManagerAddedEventResponse> managerAddedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MANAGERADDED_EVENT));
        return this.managerAddedEventFlowable(filter);
    }

    public static List<ManagerRemovedEventResponse> getManagerRemovedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)MANAGERREMOVED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<ManagerRemovedEventResponse> responses = new ArrayList<ManagerRemovedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static ManagerRemovedEventResponse getManagerRemovedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)MANAGERREMOVED_EVENT, (Log)log);
        ManagerRemovedEventResponse typedResponse = new ManagerRemovedEventResponse();
        typedResponse.log = log;
        typedResponse.account = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getManagerRemovedEventFromLog(log));
    }

    public Flowable<ManagerRemovedEventResponse> managerRemovedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)MANAGERREMOVED_EVENT));
        return this.managerRemovedEventFlowable(filter);
    }

    public static List<OwnershipTransferredEventResponse> getOwnershipTransferredEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<OwnershipTransferredEventResponse> responses = new ArrayList<OwnershipTransferredEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static OwnershipTransferredEventResponse getOwnershipTransferredEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)OWNERSHIPTRANSFERRED_EVENT, (Log)log);
        OwnershipTransferredEventResponse typedResponse = new OwnershipTransferredEventResponse();
        typedResponse.log = log;
        typedResponse.previousOwner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        typedResponse.newOwner = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
        return typedResponse;
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getOwnershipTransferredEventFromLog(log));
    }

    public Flowable<OwnershipTransferredEventResponse> ownershipTransferredEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)OWNERSHIPTRANSFERRED_EVENT));
        return this.ownershipTransferredEventFlowable(filter);
    }

    public static List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = TestWoM.staticExtractEventParametersWithLog((Event)UPGRADED_EVENT, (TransactionReceipt)transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementation = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public static UpgradedEventResponse getUpgradedEventFromLog(Log log) {
        Contract.EventValuesWithLog eventValues = TestWoM.staticExtractEventParametersWithLog((Event)UPGRADED_EVENT, (Log)log);
        UpgradedEventResponse typedResponse = new UpgradedEventResponse();
        typedResponse.log = log;
        typedResponse.implementation = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
        return typedResponse;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map(log -> TestWoM.getUpgradedEventFromLog(log));
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADED_EVENT));
        return this.upgradedEventFlowable(filter);
    }

    public RemoteFunctionCall<TransactionReceipt> addManager(String account) {
        Function function = new Function(FUNC_ADDMANAGER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> connect(String _hubAddress, BigInteger _deedId) {
        Function function = new Function(FUNC_CONNECT, Arrays.asList(new Address(160, _hubAddress), new Uint256(_deedId)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> disconnect(String _hubAddress) {
        Function function = new Function(FUNC_DISCONNECT, Arrays.asList(new Address(160, _hubAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> getConnectedDeed(String _hubAddress) {
        Function function = new Function(FUNC_GETCONNECTEDDEED, Arrays.asList(new Address(160, _hubAddress)), Arrays.asList(new TypeReference<Uint256>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> getConnectedHub(BigInteger _deedId) {
        Function function = new Function(FUNC_GETCONNECTEDHUB, Arrays.asList(new Uint256(_deedId)), Arrays.asList(new TypeReference<Address>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Deed> getDeed(BigInteger _deedId) {
        Function function = new Function(FUNC_GETDEED, Arrays.asList(new Uint256(_deedId)), Arrays.asList(new TypeReference<Deed>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Deed.class);
    }

    public RemoteFunctionCall<Hub> getHub(String _hubAddress) {
        Function function = new Function(FUNC_GETHUB, Arrays.asList(new Address(160, _hubAddress)), Arrays.asList(new TypeReference<Hub>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Hub.class);
    }

    public RemoteFunctionCall<BigInteger> getHubJoinDate(String _hubAddress) {
        Function function = new Function(FUNC_GETHUBJOINDATE, Arrays.asList(new Address(160, _hubAddress)), Arrays.asList(new TypeReference<Uint256>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Tuple4<BigInteger, String, Boolean, BigInteger>> hubs(String param0) {
        final Function function = new Function(FUNC_HUBS, Arrays.asList(new Address(160, param0)), Arrays.asList(new TypeReference<Uint256>(this){}, new TypeReference<Address>(this){}, new TypeReference<Bool>(this){}, new TypeReference<Uint256>(this){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple4<BigInteger, String, Boolean, BigInteger>>(){

            @Override
            public Tuple4<BigInteger, String, Boolean, BigInteger> call() throws Exception {
                List results = TestWoM.this.executeCallMultipleValueReturn(function);
                return new Tuple4((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((String)((Type)results.get(1)).getValue()), (Object)((Boolean)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<TransactionReceipt> initialize() {
        Function function = new Function(FUNC_INITIALIZE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isDeedConnected(BigInteger _deedId) {
        Function function = new Function(FUNC_ISDEEDCONNECTED, Arrays.asList(new Uint256(_deedId)), Arrays.asList(new TypeReference<Bool>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isHubConnected(String _hubAddress) {
        Function function = new Function(FUNC_ISHUBCONNECTED, Arrays.asList(new Address(160, _hubAddress)), Arrays.asList(new TypeReference<Bool>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isManager(String account) {
        Function function = new Function(FUNC_ISMANAGER, Arrays.asList(new Address(160, account)), Arrays.asList(new TypeReference<Bool>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Boolean> isOwner() {
        Function function = new Function(FUNC_ISOWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<Tuple9<BigInteger, BigInteger, BigInteger, BigInteger, String, String, String, BigInteger, BigInteger>> nfts(BigInteger param0) {
        final Function function = new Function(FUNC_NFTS, Arrays.asList(new Uint256(param0)), Arrays.asList(new TypeReference<Uint8>(this){}, new TypeReference<Uint8>(this){}, new TypeReference<Uint8>(this){}, new TypeReference<Uint256>(this){}, new TypeReference<Address>(this){}, new TypeReference<Address>(this){}, new TypeReference<Address>(this){}, new TypeReference<Uint8>(this){}, new TypeReference<Uint8>(this){}));
        return new RemoteFunctionCall(function, (Callable)new Callable<Tuple9<BigInteger, BigInteger, BigInteger, BigInteger, String, String, String, BigInteger, BigInteger>>(){

            @Override
            public Tuple9<BigInteger, BigInteger, BigInteger, BigInteger, String, String, String, BigInteger, BigInteger> call() throws Exception {
                List results = TestWoM.this.executeCallMultipleValueReturn(function);
                return new Tuple9((Object)((BigInteger)((Type)results.get(0)).getValue()), (Object)((BigInteger)((Type)results.get(1)).getValue()), (Object)((BigInteger)((Type)results.get(2)).getValue()), (Object)((BigInteger)((Type)results.get(3)).getValue()), (Object)((String)((Type)results.get(4)).getValue()), (Object)((String)((Type)results.get(5)).getValue()), (Object)((String)((Type)results.get(6)).getValue()), (Object)((BigInteger)((Type)results.get(7)).getValue()), (Object)((BigInteger)((Type)results.get(8)).getValue()));
            }
        });
    }

    public RemoteFunctionCall<String> owner() {
        Function function = new Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<byte[]> proxiableUUID() {
        Function function = new Function(FUNC_PROXIABLEUUID, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bytes32>(this){}));
        return this.executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<TransactionReceipt> removeManager(String account) {
        Function function = new Function(FUNC_REMOVEMANAGER, Arrays.asList(new Address(160, account)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> renounceOwnership() {
        Function function = new Function(FUNC_RENOUNCEOWNERSHIP, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setJoinDate(String _hubAddress, BigInteger _joinDate) {
        Function function = new Function(FUNC_SETJOINDATE, Arrays.asList(new Address(160, _hubAddress), new Uint256(_joinDate)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferHubOwnership(String _hubAddress, String _owner) {
        Function function = new Function(FUNC_TRANSFERHUBOWNERSHIP, Arrays.asList(new Address(160, _hubAddress), new Address(160, _owner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String newOwner) {
        Function function = new Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateDeed(BigInteger _deedId, Deed _deed) {
        Function function = new Function(FUNC_UPDATEDEED, Arrays.asList(new Type[]{new Uint256(_deedId), _deed}), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeTo(String newImplementation) {
        Function function = new Function(FUNC_UPGRADETO, Arrays.asList(new Address(160, newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeToAndCall(String newImplementation, byte[] data, BigInteger weiValue) {
        Function function = new Function(FUNC_UPGRADETOANDCALL, Arrays.asList(new Address(160, newImplementation), new DynamicBytes(data)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function, weiValue);
    }

    @Deprecated
    public static TestWoM load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new TestWoM(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static TestWoM load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new TestWoM(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static TestWoM load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new TestWoM(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static TestWoM load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new TestWoM(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<TestWoM> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return TestWoM.deployRemoteCall(TestWoM.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<TestWoM> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return TestWoM.deployRemoteCall(TestWoM.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static RemoteCall<TestWoM> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return TestWoM.deployRemoteCall(TestWoM.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<TestWoM> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return TestWoM.deployRemoteCall(TestWoM.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static class AdminChangedEventResponse
    extends BaseEventResponse {
        public String previousAdmin;
        public String newAdmin;
    }

    public static class BeaconUpgradedEventResponse
    extends BaseEventResponse {
        public String beacon;
    }

    public static class DeedUpdatedEventResponse
    extends BaseEventResponse {
        public BigInteger nftId;
    }

    public static class HubConnectedEventResponse
    extends BaseEventResponse {
        public String hub;
        public BigInteger nftId;
        public String hubOwner;
    }

    public static class HubDisconnectedEventResponse
    extends BaseEventResponse {
        public String hub;
        public BigInteger nftId;
    }

    public static class HubOwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class InitializedEventResponse
    extends BaseEventResponse {
        public BigInteger version;
    }

    public static class ManagerAddedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class ManagerRemovedEventResponse
    extends BaseEventResponse {
        public String account;
    }

    public static class OwnershipTransferredEventResponse
    extends BaseEventResponse {
        public String previousOwner;
        public String newOwner;
    }

    public static class UpgradedEventResponse
    extends BaseEventResponse {
        public String implementation;
    }

    public static class Deed
    extends StaticStruct {
        public BigInteger city;
        public BigInteger cardType;
        public BigInteger mintingPower;
        public BigInteger maxUsers;
        public String owner;
        public String tenant;
        public String hub;
        public BigInteger ownerPercentage;
        public BigInteger tenantPercentage;

        public Deed(BigInteger city, BigInteger cardType, BigInteger mintingPower, BigInteger maxUsers, String owner, String tenant, String hub, BigInteger ownerPercentage, BigInteger tenantPercentage) {
            super(new Type[]{new Uint8(city), new Uint8(cardType), new Uint8(mintingPower), new Uint256(maxUsers), new Address(160, owner), new Address(160, tenant), new Address(160, hub), new Uint8(ownerPercentage), new Uint8(tenantPercentage)});
            this.city = city;
            this.cardType = cardType;
            this.mintingPower = mintingPower;
            this.maxUsers = maxUsers;
            this.owner = owner;
            this.tenant = tenant;
            this.hub = hub;
            this.ownerPercentage = ownerPercentage;
            this.tenantPercentage = tenantPercentage;
        }

        public Deed(Uint8 city, Uint8 cardType, Uint8 mintingPower, Uint256 maxUsers, Address owner, Address tenant, Address hub, Uint8 ownerPercentage, Uint8 tenantPercentage) {
            super(new Type[]{city, cardType, mintingPower, maxUsers, owner, tenant, hub, ownerPercentage, tenantPercentage});
            this.city = city.getValue();
            this.cardType = cardType.getValue();
            this.mintingPower = mintingPower.getValue();
            this.maxUsers = maxUsers.getValue();
            this.owner = owner.getValue();
            this.tenant = tenant.getValue();
            this.hub = hub.getValue();
            this.ownerPercentage = ownerPercentage.getValue();
            this.tenantPercentage = tenantPercentage.getValue();
        }
    }

    public static class Hub
    extends StaticStruct {
        public BigInteger deedId;
        public String owner;
        public Boolean enabled;
        public BigInteger joinDate;

        public Hub(BigInteger deedId, String owner, Boolean enabled, BigInteger joinDate) {
            super(new Type[]{new Uint256(deedId), new Address(160, owner), new Bool(enabled), new Uint256(joinDate)});
            this.deedId = deedId;
            this.owner = owner;
            this.enabled = enabled;
            this.joinDate = joinDate;
        }

        public Hub(Uint256 deedId, Address owner, Bool enabled, Uint256 joinDate) {
            super(new Type[]{deedId, owner, enabled, joinDate});
            this.deedId = deedId.getValue();
            this.owner = owner.getValue();
            this.enabled = enabled.getValue();
            this.joinDate = joinDate.getValue();
        }
    }
}

