/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest;

import io.meeds.deeds.constant.UnauthorizedOperationException;
import io.meeds.deeds.service.TenantService;
import java.security.Principal;
import javax.annotation.security.RolesAllowed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/tenant"})
public class TenantController {
    private static final Logger LOG = LoggerFactory.getLogger(TenantController.class);
    @Autowired
    private TenantService tenantService;

    @GetMapping(value={"/{nftId}/lastCommand"})
    @RolesAllowed(value={"USER"})
    public String lastCommand(@PathVariable(name="nftId") long nftId, Principal principal) {
        if (principal == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        String walletAddress = principal.getName();
        try {
            return this.tenantService.getLastTenantCommand(walletAddress, nftId);
        }
        catch (UnauthorizedOperationException e) {
            LOG.warn("[SECURITY ALERT] {} attempts to get tenant status for Deed with id {}", new Object[]{walletAddress, nftId, e});
            return "";
        }
    }

    @PostMapping(value={"/{nftId}"})
    @RolesAllowed(value={"USER"})
    public void startTenant(@PathVariable(name="nftId") long nftId, @RequestParam(name="email") String email, @RequestParam(name="transactionHash") String transactionHash, Principal principal) {
        if (principal == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        String walletAddress = principal.getName();
        try {
            this.tenantService.startTenant(walletAddress, transactionHash, nftId, email);
        }
        catch (UnauthorizedOperationException e) {
            LOG.warn("[SECURITY ALERT] {} attempts to send start tenant query for Deed with id {}", new Object[]{walletAddress, nftId, e});
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
    }

    @DeleteMapping(value={"/{nftId}"})
    @RolesAllowed(value={"USER"})
    public void stopTenant(@PathVariable(name="nftId") long nftId, @RequestParam(name="transactionHash") String transactionHash, Principal principal) {
        if (principal == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        String walletAddress = principal.getName();
        try {
            this.tenantService.stopTenant(walletAddress, transactionHash, nftId);
        }
        catch (UnauthorizedOperationException e) {
            LOG.warn("[SECURITY ALERT] {} attempts to send stop tenant query for Deed with id {}", new Object[]{walletAddress, nftId, e});
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
    }

    @PatchMapping(path={"/{nftId}"})
    @RolesAllowed(value={"USER"})
    public void updateEmail(@PathVariable(name="nftId") long nftId, @RequestParam(name="email") String email, Principal principal) {
        if (principal == null) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        String walletAddress = principal.getName();
        try {
            this.tenantService.saveEmail(walletAddress, nftId, email);
        }
        catch (UnauthorizedOperationException e) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
    }
}

