/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.scheduling.task;

import io.meeds.deeds.service.ExchangeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class CurrencyExchangeTask {
    private static final Logger LOG = LoggerFactory.getLogger(CurrencyExchangeTask.class);
    @Autowired
    private ExchangeService exchangeService;

    @Scheduled(cron="0 0 0/12 * * *")
    public synchronized void computeExchangeRate() {
        LOG.info("Start Computing EURO exchange rate");
        long start = System.currentTimeMillis();
        try {
            this.exchangeService.computeTodayCurrencyExchangeRate();
            LOG.info("End Computing EURO exchange rate in {}ms", (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            LOG.error("An error occurred while computing EURO exchange rates", (Throwable)e);
        }
    }
}

