/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.service;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.deeds.constant.DeedCard;
import io.meeds.deeds.constant.DeedCity;
import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.model.DeedMetadata;
import io.meeds.deeds.service.BlockchainService;
import io.meeds.deeds.storage.DeedMetadataRepository;
import java.net.URL;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class DeedMetadataService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOG;
    @Autowired(required=false)
    private DeedMetadataRepository deedMetadataRepository;
    @Autowired
    private BlockchainService blockchainService;
    @Value(value="${meeds.deed.metadatas.path:metadatas.json}")
    private String metadatasFilePath;
    @Value(value="${meeds.deed.contract.metadatas.path:deedCollection.json}")
    private String deedCollectionMetadataFilePath;
    private Map<String, DeedMetadata> deedMetadatas;
    private DeedMetadata contractMetadata;

    @PostConstruct
    public void init() {
        try {
            URL deedMetadatasResource = this.getClass().getClassLoader().getResource(this.metadatasFilePath);
            this.deedMetadatas = (Map)OBJECT_MAPPER.readerForMapOf(DeedMetadata.class).readValue(deedMetadatasResource);
            URL contractMetadataResource = this.getClass().getClassLoader().getResource(this.deedCollectionMetadataFilePath);
            this.contractMetadata = (DeedMetadata)OBJECT_MAPPER.readerFor(DeedMetadata.class).readValue(contractMetadataResource);
        }
        catch (Exception e) {
            LOG.error("Error reading Default NFT mappings", (Throwable)e);
        }
    }

    @Cacheable(cacheNames={"deedMetadata"})
    public DeedMetadata getDeedMetadata(Long nftId) {
        return this.deedMetadataRepository.findById(nftId).orElseGet(() -> this.buildDeedMetadata(nftId));
    }

    public DeedMetadata getDeedMetadataOfCard(short cityIndex, short cardTypeIndex) {
        DeedCity deedCity = DeedCity.values()[cityIndex];
        DeedCard cardType = DeedCard.values()[cardTypeIndex];
        String key = deedCity.name() + "-" + cardType.name();
        return this.deedMetadatas.get(key).clone();
    }

    public DeedMetadata getContractMetadata() {
        return this.contractMetadata.clone();
    }

    private DeedMetadata buildDeedMetadata(long nftId) {
        try {
            short cityIndex = this.blockchainService.getDeedCityIndex(nftId);
            short cardTypeIndex = this.blockchainService.getDeedCardType(nftId);
            DeedCity deedCity = DeedCity.values()[cityIndex];
            DeedCard cardType = DeedCard.values()[cardTypeIndex];
            String key = deedCity.name() + "-" + cardType.name();
            DeedMetadata deedMetadata = this.deedMetadatas.get(key).clone();
            deedMetadata.setNftId(nftId);
            return deedMetadata;
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        LOG = LoggerFactory.getLogger(DeedMetadataService.class);
    }
}

