/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest;

import io.meeds.deeds.model.DeedMetadata;
import io.meeds.deeds.service.DeedMetadataService;
import io.meeds.deeds.web.rest.model.DeedMetadataPresentation;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/deeds"})
public class DeedMetadataController {
    private static final String DAPP_IMAGE_SERVER_BASE = "${DAPP_SERVER_BASE}";
    @Autowired
    private DeedMetadataService deedMetadataService;
    @Value(value="${meeds.deed.metadata.serverBase:}")
    private String imageServerBase;

    @GetMapping
    public ResponseEntity<DeedMetadataPresentation> getContractMetadata(HttpServletRequest request) {
        DeedMetadata deedMetadata = this.deedMetadataService.getContractMetadata();
        return this.getDeedMetadataResponse(deedMetadata, request);
    }

    @GetMapping(value={"/{nftId}"})
    public ResponseEntity<DeedMetadataPresentation> getNftMetadata(@PathVariable(name="nftId") Long nftId, HttpServletRequest request) {
        DeedMetadata deedMetadata = this.deedMetadataService.getDeedMetadata(nftId);
        return this.getDeedMetadataResponse(deedMetadata, request);
    }

    @GetMapping(value={"/type/{cityIndex}/{cardType}"})
    public ResponseEntity<DeedMetadataPresentation> getNftMetadata(@PathVariable(name="cityIndex") short cityIndex, @PathVariable(name="cardType") short cardType, HttpServletRequest request) {
        DeedMetadata deedMetadata = this.deedMetadataService.getDeedMetadataOfCard(cityIndex, cardType);
        return this.getDeedMetadataResponse(deedMetadata, request);
    }

    private ResponseEntity<DeedMetadataPresentation> getDeedMetadataResponse(DeedMetadata deedMetadata, HttpServletRequest request) {
        if (deedMetadata == null) {
            return ResponseEntity.notFound().build();
        }
        if (StringUtils.contains((CharSequence)deedMetadata.getImageUrl(), (CharSequence)DAPP_IMAGE_SERVER_BASE)) {
            deedMetadata.setImageUrl(deedMetadata.getImageUrl().replace(DAPP_IMAGE_SERVER_BASE, this.getServerBase(request)));
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.DAYS).cachePublic())).lastModified(ZonedDateTime.now())).headers(headers -> {
            headers.set("Access-Control-Allow-Origin", "*");
            headers.addAll("Access-Control-Allow-Headers", Arrays.asList("Content-Type", "Range", "User-Agent", "X-Requested-With"));
            headers.addAll("Access-Control-Expose-Headers", Arrays.asList("Content-Range", "X-Chunked-Output", "X-Stream-Output"));
            headers.addAll("Access-Control-Allow-Methods", Arrays.asList("GET", "HEAD"));
        })).body((Object)DeedMetadataPresentation.build(deedMetadata));
    }

    private String getServerBase(HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)this.imageServerBase)) {
            return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        }
        return this.imageServerBase;
    }
}

