/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.meeds.deeds.model.DeedMetadata;
import io.meeds.deeds.model.DeedMetadataAttribute;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DeedMetadataPresentation {
    @JsonProperty(value="name")
    @NonNull
    private String name;
    @JsonProperty(value="description")
    @NonNull
    private String description;
    @JsonProperty(value="image")
    @NonNull
    private String imageUrl;
    @JsonProperty(value="background_color")
    private String backgroundColor;
    @JsonProperty(value="external_url")
    private String externalUrl;
    @JsonProperty(value="external_link")
    private String externalLink;
    @JsonProperty(value="seller_fee_basis_points")
    private String sellerFeeBasisPoints;
    @JsonProperty(value="fee_recipient")
    private String feeRecipient;
    @JsonProperty(value="attributes")
    private Set<DeedMetadataAttribute> attributes = new HashSet<DeedMetadataAttribute>();

    public static DeedMetadataPresentation build(DeedMetadata deedMetadata) {
        if (deedMetadata == null) {
            return null;
        }
        HashSet<DeedMetadataAttribute> attributes = deedMetadata.getAttributes() == null ? new HashSet<DeedMetadataAttribute>() : new HashSet(deedMetadata.getAttributes());
        return new DeedMetadataPresentation(deedMetadata.getName(), deedMetadata.getDescription(), deedMetadata.getImageUrl(), deedMetadata.getBackgroundColor(), deedMetadata.getExternalUrl(), deedMetadata.getExternalLink(), deedMetadata.getSellerFeeBasisPoints(), deedMetadata.getFeeRecipient(), attributes);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public String getExternalLink() {
        return this.externalLink;
    }

    public String getSellerFeeBasisPoints() {
        return this.sellerFeeBasisPoints;
    }

    public String getFeeRecipient() {
        return this.feeRecipient;
    }

    public Set<DeedMetadataAttribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="name")
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    @JsonProperty(value="image")
    public void setImageUrl(@NonNull String imageUrl) {
        if (imageUrl == null) {
            throw new NullPointerException("imageUrl is marked non-null but is null");
        }
        this.imageUrl = imageUrl;
    }

    @JsonProperty(value="background_color")
    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @JsonProperty(value="external_url")
    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    @JsonProperty(value="external_link")
    public void setExternalLink(String externalLink) {
        this.externalLink = externalLink;
    }

    @JsonProperty(value="seller_fee_basis_points")
    public void setSellerFeeBasisPoints(String sellerFeeBasisPoints) {
        this.sellerFeeBasisPoints = sellerFeeBasisPoints;
    }

    @JsonProperty(value="fee_recipient")
    public void setFeeRecipient(String feeRecipient) {
        this.feeRecipient = feeRecipient;
    }

    @JsonProperty(value="attributes")
    public void setAttributes(Set<DeedMetadataAttribute> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeedMetadataPresentation)) {
            return false;
        }
        DeedMetadataPresentation other = (DeedMetadataPresentation)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeedMetadataPresentation;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "DeedMetadataPresentation(name=" + this.getName() + ", description=" + this.getDescription() + ", imageUrl=" + this.getImageUrl() + ", backgroundColor=" + this.getBackgroundColor() + ", externalUrl=" + this.getExternalUrl() + ", externalLink=" + this.getExternalLink() + ", sellerFeeBasisPoints=" + this.getSellerFeeBasisPoints() + ", feeRecipient=" + this.getFeeRecipient() + ", attributes=" + this.getAttributes() + ")";
    }

    public DeedMetadataPresentation() {
    }

    public DeedMetadataPresentation(@NonNull String name, @NonNull String description, @NonNull String imageUrl, String backgroundColor, String externalUrl, String externalLink, String sellerFeeBasisPoints, String feeRecipient, Set<DeedMetadataAttribute> attributes) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (imageUrl == null) {
            throw new NullPointerException("imageUrl is marked non-null but is null");
        }
        this.name = name;
        this.description = description;
        this.imageUrl = imageUrl;
        this.backgroundColor = backgroundColor;
        this.externalUrl = externalUrl;
        this.externalLink = externalLink;
        this.sellerFeeBasisPoints = sellerFeeBasisPoints;
        this.feeRecipient = feeRecipient;
        this.attributes = attributes;
    }
}

