/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.listener;

import io.meeds.deeds.constant.ObjectAlreadyExistsException;
import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.model.DeedTenantLease;
import io.meeds.deeds.model.UserProfileDTO;
import io.meeds.deeds.service.OfferService;
import io.meeds.deeds.service.UserProfileService;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class OfferAcquisitionInProgressListener
implements EventListener<DeedTenantLease> {
    private static final Logger LOG = LoggerFactory.getLogger(OfferAcquisitionInProgressListener.class);
    public static final String LISTENER_NAME = "OfferAcquisitionInProgressListener";
    private static final List<String> SUPPORTED_EVENTS = Collections.singletonList("deed.event.leaseAcquired");
    @Autowired
    private UserProfileService userProfileService;
    @Autowired
    private OfferService offerService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, DeedTenantLease lease) {
        if (StringUtils.isNotBlank((CharSequence)lease.getManagerEmail())) {
            UserProfileDTO userProfileDTO = new UserProfileDTO(lease.getManager(), lease.getManagerEmail());
            this.userProfileService.saveUserProfile(userProfileDTO);
        }
        if (lease.isConfirmed()) {
            LOG.warn("Seems a bug, the lease change has been triggered as lease acquisition in progress while it's already confirmed!");
            return;
        }
        if (CollectionUtils.isEmpty(lease.getPendingTransactions())) {
            LOG.warn("Seems a bug, the lease change a transaction in progress!");
            return;
        }
        ZonedDateTime leaseEnDate = (ZonedDateTime)Period.ofMonths(lease.getMonths()).addTo(ZonedDateTime.ofInstant(lease.getCreatedDate(), ZoneId.systemDefault()));
        String transactionHash = lease.getPendingTransactions().get(0);
        try {
            this.offerService.markOfferAcquisitionInProgress(lease.getNftId(), transactionHash, leaseEnDate.toInstant());
        }
        catch (ObjectAlreadyExistsException e) {
            LOG.warn("Seems a bug, the transaction hash {} already exists in offers as acquisition in progress! Ignore adding the transaction hash.", (Object)transactionHash);
        }
    }
}

