/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.listener;

import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.model.DeedTenantOffer;
import io.meeds.deeds.model.UserProfileDTO;
import io.meeds.deeds.service.UserProfileService;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfferCreatedListener
implements EventListener<DeedTenantOffer> {
    public static final String LISTENER_NAME = "OfferCreatedListener";
    private static final List<String> SUPPORTED_EVENTS = Collections.singletonList("deed.event.offerCreated");
    @Autowired
    private UserProfileService userProfileService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, DeedTenantOffer deedTenantOffer) {
        if (StringUtils.isNotBlank((CharSequence)deedTenantOffer.getOwnerEmail())) {
            UserProfileDTO userProfileDTO = new UserProfileDTO(deedTenantOffer.getOwner(), deedTenantOffer.getOwnerEmail());
            this.userProfileService.saveUserProfile(userProfileDTO);
        }
    }
}

