/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;

public class RequestDispatcherFilter
extends HttpFilter {
    private static final String DEFAULT_PAGE_FILE_NAME = "/home";
    private static final long serialVersionUID = -4145074746513311839L;
    private static final List<String> STATIC_PATHS = Arrays.asList("/home", "/whitepaper", "/about-us", "/legals");
    private static final List<String> DAPP_PATHS = Arrays.asList("/marketplace", "/tenants", "/owners", "/overview", "/stake", "/deeds", "/farm");
    private static final long LAST_MODIFIED = System.currentTimeMillis();
    private static final String VERSION = String.valueOf(LAST_MODIFIED);

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String servletPath = request.getServletPath();
        if (StringUtils.contains((CharSequence)servletPath, (CharSequence)"api")) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            boolean isStaticPath;
            String eTagValue;
            String eTagHeader = request.getHeader("If-None-Match");
            if (StringUtils.equals((CharSequence)eTagHeader, (CharSequence)(eTagValue = this.getETagValue(request)))) {
                response.setStatus(304);
                return;
            }
            response.setHeader("Cache-Control", "public,must-revalidate");
            response.setHeader("etag", eTagValue);
            response.setDateHeader("Last-Modified", LAST_MODIFIED);
            response.setContentType("text/html; charset=UTF-8");
            if (StringUtils.isBlank((CharSequence)servletPath) || StringUtils.equals((CharSequence)servletPath, (CharSequence)"/")) {
                servletPath = DEFAULT_PAGE_FILE_NAME;
            }
            if ((isStaticPath = STATIC_PATHS.contains(servletPath)) || DAPP_PATHS.contains(servletPath)) {
                request.setAttribute("isStaticPath", (Object)isStaticPath);
                RequestDispatcher dispatcher = request.getRequestDispatcher("/WEB-INF/jsp/dapp.jsp");
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private String getETagValue(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return VERSION + Objects.hash(request.getRemoteUser(), session == null ? null : session.getId());
    }
}

