/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
public class StaticResourceFilter
extends HttpFilter {
    private static final long serialVersionUID = -1870848677869804113L;
    private static final long LAST_MODIFIED = System.currentTimeMillis();
    private static final long MAX_AGE = 31536000L;
    private static final long EXPIRES = LAST_MODIFIED + 31536000000L;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        response.setDateHeader("Last-Modified", LAST_MODIFIED);
        response.setDateHeader("Expires", EXPIRES);
        response.setHeader("Cache-Control", "public,31536000");
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

