/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest;

import io.meeds.deeds.constant.Currency;
import io.meeds.deeds.model.MeedTokenMetric;
import io.meeds.deeds.service.MeedTokenMetricService;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/token/meed"})
public class MeedTokenMetricController {
    @Autowired
    private MeedTokenMetricService meedTokenMetricService;

    @GetMapping(value={"/"}, produces={"application/json"})
    public ResponseEntity<MeedTokenMetric> getMetrics(@RequestParam(name="currency", required=false) Currency currency) {
        return ResponseEntity.ok((Object)this.meedTokenMetricService.getLastMetric(currency));
    }

    @GetMapping(value={"/circ"})
    public ResponseEntity<BigDecimal> getCirculatingSupply() {
        BigDecimal circulatingSupply = this.meedTokenMetricService.getCirculatingSupply();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)circulatingSupply);
    }

    @GetMapping(value={"/mcap"})
    public ResponseEntity<BigDecimal> getMarketCapitalization(@RequestParam(name="currency", required=false) Currency currency) {
        BigDecimal marketCapitalization = this.meedTokenMetricService.getMarketCapitalization(currency);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)marketCapitalization);
    }

    @GetMapping(value={"/tvl"})
    public ResponseEntity<BigDecimal> getTotalLockedValue(@RequestParam(name="currency", required=false) Currency currency) {
        BigDecimal totalValueLocked = this.meedTokenMetricService.getTotalValueLocked(currency);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)totalValueLocked);
    }

    @GetMapping(value={"/supply"})
    public ResponseEntity<BigDecimal> getTotalSupply() {
        BigDecimal totalSupply = this.meedTokenMetricService.getTotalSupply();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)totalSupply);
    }
}

