/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.scheduling.task;

import io.meeds.deeds.model.DeedTenantLease;
import io.meeds.deeds.service.BlockchainService;
import io.meeds.deeds.service.LeaseService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class LeaseBlockchainTransactionCheckTask {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseBlockchainTransactionCheckTask.class);
    @Autowired
    private LeaseService leaseService;
    @Autowired
    private BlockchainService blockchainService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelay=1L, timeUnit=TimeUnit.MINUTES, initialDelay=1L)
    public void checkPendingLeases() {
        List<DeedTenantLease> pendingLeases = this.leaseService.getPendingTransactions();
        int pendingLeasesSize = pendingLeases.size();
        if (pendingLeasesSize == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        LOG.info("Check {} pending Deed Lease pending transaction.", (Object)pendingLeasesSize);
        try {
            pendingLeases.forEach(lease -> {
                List<String> pendingTransactions = lease.getPendingTransactions();
                pendingTransactions.forEach(transactionHash -> {
                    try {
                        if (StringUtils.isBlank((CharSequence)transactionHash)) {
                            this.leaseService.saveLeaseTransactionAsError(lease.getId(), (String)transactionHash);
                        } else if (this.blockchainService.isTransactionMined(transactionHash)) {
                            Map minedEvents = this.blockchainService.getLeaseTransactionEvents(transactionHash);
                            this.leaseService.updateLeaseStatusFromBlockchain(lease.getId(), (String)transactionHash, minedEvents);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Can't update lease pending transaction {} status. It will be reattempted later.", transactionHash, (Object)e);
                    }
                });
            });
        }
        finally {
            LOG.info("End checking {} pending Deed Lease pending transaction in {}ms.", (Object)pendingLeasesSize, (Object)(System.currentTimeMillis() - start));
        }
    }
}

