/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.filter;

import io.meeds.deeds.web.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PropertyResourceBundle;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcherFilter
extends HttpFilter {
    protected static final String PREFERRED_LANGUAGE_COOKIE_NAME = "preferred-language";
    protected static final String DEFAULT_PAGE_FILE_NAME_EN = "/home";
    protected static final String DEFAULT_PAGE_FILE_NAME_FR = "/accueil";
    protected static final long serialVersionUID = -4145074746513311839L;
    protected static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("en", "fr");
    protected static final List<String> STATIC_PATHS_EN = Arrays.asList("/home", "/whitepaper", "/about-us", "/legals", "/tour");
    protected static final List<String> STATIC_PATHS_FR = Arrays.asList("/accueil", "/livre-blanc", "/qui-sommes-nous", "/mentions-legales", "/visite-guidee");
    protected static final List<String> STATIC_PATHS = CollectionUtils.concatLists(STATIC_PATHS_EN, STATIC_PATHS_FR);
    protected static final List<String> DAPP_PATHS_EN = Arrays.asList("/marketplace", "/tenants", "/owners", "/portfolio", "/stake", "/hubs", "/mint", "/farm", "/tokenomics");
    protected static final List<String> DAPP_PATHS_FR_UNCOM = Arrays.asList("/place-de-marche", "/locataires", "/proprietaires", "/portefeuille", "/rejoindre-dao", "/rejoindre-hubs");
    protected static final List<String> DAPP_PATHS_FR_COMM = Arrays.asList("/mint", "/farm", "/tokenomics");
    protected static final List<String> DAPP_PATHS_FR = CollectionUtils.concatLists(DAPP_PATHS_FR_UNCOM, DAPP_PATHS_FR_COMM);
    protected static final List<String> DAPP_PATHS = CollectionUtils.concatLists(DAPP_PATHS_EN, DAPP_PATHS_FR);
    protected static final List<String> METADATA_LABELS = Arrays.asList("pageDescription", "imageAlt", "twitterTitle", "pageTitle");
    protected static final long LAST_MODIFIED = System.currentTimeMillis();
    protected static final String VERSION = String.valueOf(LAST_MODIFIED);
    protected static final Map<String, String> PAGE_METADATAS = new HashMap<String, String>();
    private static final Logger LOG = LoggerFactory.getLogger(RequestDispatcherFilter.class);

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Object servletPath = request.getServletPath();
        if (StringUtils.contains((CharSequence)servletPath, (CharSequence)"api")) {
            this.doFilter(chain, request, response);
        } else if (StringUtils.contains((CharSequence)servletPath, (CharSequence)"/static/") && !StringUtils.startsWith((CharSequence)servletPath, (CharSequence)"/static/")) {
            response.setHeader("Location", ((String)servletPath).substring(((String)servletPath).indexOf("/static/")));
            response.setStatus(301);
        } else {
            String eTagValue;
            String eTagHeader;
            if (((String)servletPath).endsWith("/")) {
                String servletPathCanonical = ((String)servletPath).substring(0, ((String)servletPath).length() - 1);
                if (DAPP_PATHS.contains(servletPathCanonical) || STATIC_PATHS.contains(servletPathCanonical)) {
                    response.setHeader("Location", servletPathCanonical);
                    response.setStatus(301);
                    return;
                }
            } else {
                if (((String)servletPath).equals(DEFAULT_PAGE_FILE_NAME_EN)) {
                    response.setHeader("Location", "/");
                    response.setStatus(301);
                    return;
                }
                if (((String)servletPath).equals("/fr/accueil")) {
                    response.setHeader("Location", "/fr");
                    response.setStatus(301);
                    return;
                }
                if (((String)servletPath).equals("/deeds")) {
                    response.setHeader("Location", "/mint");
                    response.setStatus(301);
                    return;
                }
            }
            if (StringUtils.equals((CharSequence)(eTagHeader = request.getHeader("If-None-Match")), (CharSequence)(eTagValue = this.getETagValue(request)))) {
                response.setStatus(304);
                return;
            }
            if (StringUtils.isBlank((CharSequence)servletPath) || StringUtils.equals((CharSequence)servletPath, (CharSequence)"/")) {
                servletPath = DEFAULT_PAGE_FILE_NAME_EN;
            } else if (StringUtils.equals((CharSequence)servletPath, (CharSequence)"/fr")) {
                servletPath = (String)servletPath + DEFAULT_PAGE_FILE_NAME_FR;
            }
            Object uri = servletPath;
            if (((String)uri).startsWith("/fr/")) {
                uri = ((String)uri).substring(3, ((String)uri).length());
            } else if (DAPP_PATHS_FR_UNCOM.contains(uri) || STATIC_PATHS_FR.contains(uri)) {
                uri = "/fr" + (String)uri;
                response.setHeader("Location", (String)uri);
                response.setStatus(301);
                return;
            }
            boolean isStaticPath = STATIC_PATHS.contains(uri);
            if (isStaticPath || DAPP_PATHS.contains(uri)) {
                String lang = this.getLanguage(request);
                response.setContentType("text/html; charset=UTF-8");
                response.setDateHeader("Last-Modified", LAST_MODIFIED);
                response.setHeader("Cache-Control", "public,must-revalidate");
                response.setHeader("etag", eTagValue);
                request.setAttribute("isStaticPath", (Object)isStaticPath);
                request.setAttribute("lang", (Object)lang);
                String pageName = this.getNormalizedPageName((String)servletPath, (String)uri);
                request.setAttribute("pageName", (Object)pageName.substring(1));
                this.buildPageMetadata(request, (String)servletPath, pageName, lang);
                RequestDispatcher dispatcher = request.getRequestDispatcher("/WEB-INF/jsp/dapp.jsp");
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            } else {
                this.doFilter(chain, request, response);
            }
        }
    }

    private void doFilter(FilterChain chain, HttpServletRequest request, HttpServletResponse response) {
        block4: {
            try {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Error while requesting resource", (Throwable)e);
                } else {
                    LOG.warn(e.getMessage());
                }
                if (response.isCommitted()) break block4;
                response.setStatus(404);
            }
        }
    }

    private void buildPageMetadata(HttpServletRequest request, String servletPath, String defaultPageName, String lang) throws IOException {
        if (Utils.isProductionEnvironment()) {
            String pageContent = this.getPageHeaderMetadataContent(request, servletPath, defaultPageName, lang);
            request.setAttribute("pageHeaderMetadatas", (Object)pageContent);
        } else {
            request.setAttribute("pageHeaderMetadatas", (Object)"");
        }
    }

    private String getPageHeaderMetadataContent(HttpServletRequest request, String servletPath, String defaultPageName, String lang) throws IOException {
        String pageName = defaultPageName.substring(1);
        String key = pageName + "_" + lang;
        String pageContent = PAGE_METADATAS.get(key);
        if (StringUtils.isBlank((CharSequence)pageContent)) {
            PropertyResourceBundle resourceBundle = null;
            try (InputStream is = request.getServletContext().getResourceAsStream("/static/i18n/messages_" + lang + ".properties");){
                resourceBundle = new PropertyResourceBundle(is);
            }
            is = request.getServletContext().getResourceAsStream("/WEB-INF/metadata" + defaultPageName + ".html");
            try {
                pageContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                for (String label : METADATA_LABELS) {
                    String i18nKey = "metadata." + pageName + "." + label;
                    pageContent = pageContent.replace("#{" + i18nKey + "}", resourceBundle.getString(i18nKey));
                }
                pageContent = pageContent.replace("${lang}", lang);
                pageContent = pageContent.replace("${servletPath}", servletPath);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            PAGE_METADATAS.put(key, pageContent);
        }
        return pageContent;
    }

    private String getNormalizedPageName(String servletPath, String uri) {
        if (DAPP_PATHS_FR.contains(uri) && servletPath.startsWith("/fr/")) {
            return DAPP_PATHS_EN.get(DAPP_PATHS_FR.indexOf(uri));
        }
        if (STATIC_PATHS_FR.contains(uri) && servletPath.startsWith("/fr/")) {
            return STATIC_PATHS_EN.get(STATIC_PATHS_FR.indexOf(uri));
        }
        return STATIC_PATHS_EN.contains(uri) || DAPP_PATHS_EN.contains(uri) ? uri : DEFAULT_PAGE_FILE_NAME_EN;
    }

    private String getLanguage(HttpServletRequest request) {
        String path = request.getServletPath();
        return StringUtils.equals((CharSequence)path, (CharSequence)"/fr") || path.startsWith("/fr/") ? "fr" : "en";
    }

    private String getETagValue(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return VERSION + Objects.hash(request.getRemoteUser(), session == null ? null : session.getId());
    }
}

