/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.rest;

import io.meeds.deeds.service.AuthorizationCodeService;
import java.security.Principal;
import javax.annotation.security.RolesAllowed;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/authorization"})
public class AuthorizationCodeController {
    @Autowired
    private AuthorizationCodeService authorizationCodeService;

    @PostMapping(consumes={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"USER"})
    public void generateCode(Principal principal, @RequestParam(value="email") String email) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || StringUtils.isBlank((CharSequence)email)) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
        try {
            String walletAddress = principal.getName();
            this.authorizationCodeService.generateCode(StringUtils.lowerCase((String)walletAddress), email, (Object)email);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Max authorization code usage reached");
        }
    }

    @GetMapping
    @RolesAllowed(value={"USER"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void checkValidity(Principal principal, @RequestHeader(name="X-AUTHORIZATION", required=true) int code) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName())) {
            throw new ResponseStatusException(HttpStatus.FORBIDDEN);
        }
        String walletAddress = StringUtils.lowerCase((String)principal.getName());
        try {
            this.authorizationCodeService.checkValidity(walletAddress, code);
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED, "Invalid code");
        }
    }
}

