/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds.web.servlet;

import io.meeds.deeds.web.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotsServlet
extends HttpServlet {
    private static final long serialVersionUID = 2720033323076566476L;
    private static final Logger LOG = LoggerFactory.getLogger(RobotsServlet.class);
    private static String robotsContent;

    public RobotsServlet() {
        RobotsServlet.retrieveRobotsFileContent();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            resp.getWriter().append(robotsContent);
            resp.setHeader("Content-Type", "text/plain");
            resp.setStatus(200);
        }
        catch (IOException e) {
            LOG.error("Error writing robots content", (Throwable)e);
            resp.setStatus(404);
        }
    }

    private static void retrieveRobotsFileContent() {
        String filePath = Utils.isProductionEnvironment() ? "/robots_prod_env.txt" : "/robots_test_env.txt";
        try (InputStream fileIs = RobotsServlet.class.getClassLoader().getResourceAsStream(filePath);){
            robotsContent = IOUtils.toString((InputStream)fileIs, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOG.error("Error retrieving file content with path '{}'", (Object)filePath, (Object)e);
            robotsContent = "";
        }
    }
}

