/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.elasticsearch.model;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

@Document(indexName="meed_token_metrics", createIndex=true)
@Setting(sortFields={"date"}, sortOrders={Setting.SortOrder.desc}, replicas=0, shards=1)
public class MeedTokenMetric {
    @Id
    @Field(type=FieldType.Date, format={DateFormat.year_month_day})
    private LocalDate date;
    private BigDecimal totalSupply;
    private Map<String, BigDecimal> lockedBalances;
    private Map<String, BigDecimal> reserveBalances;
    private BigDecimal circulatingSupply;
    private BigDecimal marketCapitalization;
    private BigDecimal totalValuelocked;
    private BigDecimal meedUsdPrice;

    public MeedTokenMetric(LocalDate date) {
        this.date = date;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public BigDecimal getTotalSupply() {
        return this.totalSupply;
    }

    public Map<String, BigDecimal> getLockedBalances() {
        return this.lockedBalances;
    }

    public Map<String, BigDecimal> getReserveBalances() {
        return this.reserveBalances;
    }

    public BigDecimal getCirculatingSupply() {
        return this.circulatingSupply;
    }

    public BigDecimal getMarketCapitalization() {
        return this.marketCapitalization;
    }

    public BigDecimal getTotalValuelocked() {
        return this.totalValuelocked;
    }

    public BigDecimal getMeedUsdPrice() {
        return this.meedUsdPrice;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public void setTotalSupply(BigDecimal totalSupply) {
        this.totalSupply = totalSupply;
    }

    public void setLockedBalances(Map<String, BigDecimal> lockedBalances) {
        this.lockedBalances = lockedBalances;
    }

    public void setReserveBalances(Map<String, BigDecimal> reserveBalances) {
        this.reserveBalances = reserveBalances;
    }

    public void setCirculatingSupply(BigDecimal circulatingSupply) {
        this.circulatingSupply = circulatingSupply;
    }

    public void setMarketCapitalization(BigDecimal marketCapitalization) {
        this.marketCapitalization = marketCapitalization;
    }

    public void setTotalValuelocked(BigDecimal totalValuelocked) {
        this.totalValuelocked = totalValuelocked;
    }

    public void setMeedUsdPrice(BigDecimal meedUsdPrice) {
        this.meedUsdPrice = meedUsdPrice;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeedTokenMetric)) {
            return false;
        }
        MeedTokenMetric other = (MeedTokenMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        BigDecimal this$totalSupply = this.getTotalSupply();
        BigDecimal other$totalSupply = other.getTotalSupply();
        if (this$totalSupply == null ? other$totalSupply != null : !((Object)this$totalSupply).equals(other$totalSupply)) {
            return false;
        }
        Map<String, BigDecimal> this$lockedBalances = this.getLockedBalances();
        Map<String, BigDecimal> other$lockedBalances = other.getLockedBalances();
        if (this$lockedBalances == null ? other$lockedBalances != null : !((Object)this$lockedBalances).equals(other$lockedBalances)) {
            return false;
        }
        Map<String, BigDecimal> this$reserveBalances = this.getReserveBalances();
        Map<String, BigDecimal> other$reserveBalances = other.getReserveBalances();
        if (this$reserveBalances == null ? other$reserveBalances != null : !((Object)this$reserveBalances).equals(other$reserveBalances)) {
            return false;
        }
        BigDecimal this$circulatingSupply = this.getCirculatingSupply();
        BigDecimal other$circulatingSupply = other.getCirculatingSupply();
        if (this$circulatingSupply == null ? other$circulatingSupply != null : !((Object)this$circulatingSupply).equals(other$circulatingSupply)) {
            return false;
        }
        BigDecimal this$marketCapitalization = this.getMarketCapitalization();
        BigDecimal other$marketCapitalization = other.getMarketCapitalization();
        if (this$marketCapitalization == null ? other$marketCapitalization != null : !((Object)this$marketCapitalization).equals(other$marketCapitalization)) {
            return false;
        }
        BigDecimal this$totalValuelocked = this.getTotalValuelocked();
        BigDecimal other$totalValuelocked = other.getTotalValuelocked();
        if (this$totalValuelocked == null ? other$totalValuelocked != null : !((Object)this$totalValuelocked).equals(other$totalValuelocked)) {
            return false;
        }
        BigDecimal this$meedUsdPrice = this.getMeedUsdPrice();
        BigDecimal other$meedUsdPrice = other.getMeedUsdPrice();
        return !(this$meedUsdPrice == null ? other$meedUsdPrice != null : !((Object)this$meedUsdPrice).equals(other$meedUsdPrice));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeedTokenMetric;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        BigDecimal $totalSupply = this.getTotalSupply();
        result = result * 59 + ($totalSupply == null ? 43 : ((Object)$totalSupply).hashCode());
        Map<String, BigDecimal> $lockedBalances = this.getLockedBalances();
        result = result * 59 + ($lockedBalances == null ? 43 : ((Object)$lockedBalances).hashCode());
        Map<String, BigDecimal> $reserveBalances = this.getReserveBalances();
        result = result * 59 + ($reserveBalances == null ? 43 : ((Object)$reserveBalances).hashCode());
        BigDecimal $circulatingSupply = this.getCirculatingSupply();
        result = result * 59 + ($circulatingSupply == null ? 43 : ((Object)$circulatingSupply).hashCode());
        BigDecimal $marketCapitalization = this.getMarketCapitalization();
        result = result * 59 + ($marketCapitalization == null ? 43 : ((Object)$marketCapitalization).hashCode());
        BigDecimal $totalValuelocked = this.getTotalValuelocked();
        result = result * 59 + ($totalValuelocked == null ? 43 : ((Object)$totalValuelocked).hashCode());
        BigDecimal $meedUsdPrice = this.getMeedUsdPrice();
        result = result * 59 + ($meedUsdPrice == null ? 43 : ((Object)$meedUsdPrice).hashCode());
        return result;
    }

    public String toString() {
        return "MeedTokenMetric(date=" + this.getDate() + ", totalSupply=" + this.getTotalSupply() + ", lockedBalances=" + this.getLockedBalances() + ", reserveBalances=" + this.getReserveBalances() + ", circulatingSupply=" + this.getCirculatingSupply() + ", marketCapitalization=" + this.getMarketCapitalization() + ", totalValuelocked=" + this.getTotalValuelocked() + ", meedUsdPrice=" + this.getMeedUsdPrice() + ")";
    }

    public MeedTokenMetric(LocalDate date, BigDecimal totalSupply, Map<String, BigDecimal> lockedBalances, Map<String, BigDecimal> reserveBalances, BigDecimal circulatingSupply, BigDecimal marketCapitalization, BigDecimal totalValuelocked, BigDecimal meedUsdPrice) {
        this.date = date;
        this.totalSupply = totalSupply;
        this.lockedBalances = lockedBalances;
        this.reserveBalances = reserveBalances;
        this.circulatingSupply = circulatingSupply;
        this.marketCapitalization = marketCapitalization;
        this.totalValuelocked = totalValuelocked;
        this.meedUsdPrice = meedUsdPrice;
    }

    public MeedTokenMetric() {
    }
}

