/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.web.rest.HubReportController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import io.meeds.deeds.common.service.HubReportService;
import io.meeds.wom.api.constant.WomAuthorizationException;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.constant.WomParsingException;
import io.meeds.wom.api.constant.WomRequestException;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportVerifiableData;
import io.meeds.wom.api.utils.JsonUtils;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.security.test.context.support.WithAnonymousUser;
import org.springframework.security.test.web.servlet.setup.SecurityMockMvcConfigurers;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={HubReportController.class, DeedAuthenticationProvider.class, WebSecurityConfig.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
public class HubReportControllerTest {
    private static final String HUB_ADDRESS_PARAM = "hubAddress";
    private static final String REWARD_ID_PARAM = "rewardId";
    private static final String API_HUB_REPORTS = "/api/hub/reports";
    @MockBean
    private HubReportService reportService;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;
    private String hubAddress = "0x27d282d1e7e790df596f50a234602d9e761d22aa";
    private long rewardId = 56648L;
    private long deedId = 3L;
    private long reportId = 56684L;
    private long periodStartTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(3L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private long periodEndTime = ZonedDateTime.now().with(DayOfWeek.MONDAY).minusWeeks(2L).toLocalDate().atStartOfDay(ZoneOffset.UTC).toEpochSecond();
    private short city = 1;
    private short cardType = (short)3;
    private short mintingPower = (short)120;
    private long maxUsers = Long.MAX_VALUE;
    private int ownerMintingPercentage = 60;
    private double fixedRewardIndex = 0.005446;
    private double ownerFixedIndex = 0.0032676;
    private double tenantFixedIndex = 0.0021784;
    private double lastPeriodUemRewardAmount = 84.0;
    private double uemRewardAmount = 90.0;
    private double engagementScore = 1.3;
    private double hubRewardAmount = 150.0;
    private double hubTopRewardedAmount = 39.0;
    private Instant updatedDate = Instant.now();
    private boolean fraud = false;
    private long usersCount = 125L;
    private long participantsCount = 85L;
    private long recipientsCount = 65L;
    private int achievementsCount = 55698;
    private int actionsCount = 569;
    private String rewardTokenAddress = "0x334d85047da64738c065d36e10b2adeb965000d0";
    private long rewardTokenNetworkId = 1L;
    private String deedManagerAddress = "0x609a6f01b7976439603356e41d5456b42df957b7";
    private String ownerAddress = "0x27d282d1e7e790df596f50a234602d9e761d22aa";
    private String periodType = "WEEK";
    private String txHash = "0xef4e9db309b5dd7020ce463ae726b4d0759e1de0635661de91d8d98e83ae2862";
    private Instant sentDate = Instant.now();

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).apply(SecurityMockMvcConfigurers.springSecurity())).build();
    }

    @Test
    @WithAnonymousUser
    void getReports() throws Exception {
        Mockito.when((Object)this.reportService.getReports((String)ArgumentMatchers.eq((Object)this.hubAddress), ArgumentMatchers.eq((long)this.rewardId), (Pageable)ArgumentMatchers.any())).thenReturn((Object)new PageImpl(Arrays.asList(this.newHubReport())));
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)API_HUB_REPORTS, (Object[])new Object[0]).param(HUB_ADDRESS_PARAM, new String[]{this.hubAddress}).param(REWARD_ID_PARAM, new String[]{String.valueOf(this.rewardId)}));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.page.totalPages", (Matcher)Matchers.is((Object)1)));
    }

    @Test
    @WithAnonymousUser
    void getReportByHubAndRewardIdWhenNotFound() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hub/reports/" + this.rewardId + "/" + this.hubAddress), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void getReportByHubAndRewardId() throws Exception {
        Mockito.when((Object)this.reportService.getReport(this.rewardId, this.hubAddress)).thenReturn((Object)this.newHubReport());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hub/reports/" + this.rewardId + "/" + this.hubAddress), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedId", (Matcher)Matchers.is((Object)((int)this.deedId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardId", (Matcher)Matchers.is((Object)((int)this.rewardId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.city", (Matcher)Matchers.is((Object)this.city))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.cardType", (Matcher)Matchers.is((Object)this.cardType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.mintingPower", (Matcher)Matchers.is((Object)this.mintingPower))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maxUsers", (Matcher)Matchers.is((Object)this.maxUsers))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedManagerAddress", (Matcher)Matchers.is((Object)this.deedManagerAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.ownerAddress", (Matcher)Matchers.is((Object)this.ownerAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.ownerMintingPercentage", (Matcher)Matchers.is((Object)this.ownerMintingPercentage))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.fixedRewardIndex", (Matcher)Matchers.is((Object)this.fixedRewardIndex))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.ownerFixedIndex", (Matcher)Matchers.is((Object)this.ownerFixedIndex))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantFixedIndex", (Matcher)Matchers.is((Object)this.tenantFixedIndex))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.fraud", (Matcher)Matchers.is((Object)this.fraud))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uemRewardAmount", (Matcher)Matchers.is((Object)this.uemRewardAmount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.reportId", (Matcher)Matchers.is((Object)((int)this.reportId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.hubAddress", (Matcher)Matchers.is((Object)this.hubAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.usersCount", (Matcher)Matchers.is((Object)((int)this.usersCount)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.participantsCount", (Matcher)Matchers.is((Object)((int)this.participantsCount)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.recipientsCount", (Matcher)Matchers.is((Object)((int)this.recipientsCount)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.achievementsCount", (Matcher)Matchers.is((Object)this.achievementsCount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.actionsCount", (Matcher)Matchers.is((Object)this.actionsCount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardTokenNetworkId", (Matcher)Matchers.is((Object)((int)this.rewardTokenNetworkId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.hubRewardAmount", (Matcher)Matchers.is((Object)this.hubRewardAmount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardTokenAddress", (Matcher)Matchers.is((Object)this.rewardTokenAddress)));
    }

    @Test
    @WithAnonymousUser
    void getReportWhenNotFound() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hub/reports/" + this.reportId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    @WithAnonymousUser
    void getReport() throws Exception {
        Mockito.when((Object)this.reportService.getReport(this.reportId)).thenReturn((Object)this.newHubReport());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)("/api/hub/reports/" + this.reportId), (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isOk()).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedId", (Matcher)Matchers.is((Object)((int)this.deedId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardId", (Matcher)Matchers.is((Object)((int)this.rewardId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.city", (Matcher)Matchers.is((Object)this.city))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.cardType", (Matcher)Matchers.is((Object)this.cardType))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.mintingPower", (Matcher)Matchers.is((Object)this.mintingPower))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.maxUsers", (Matcher)Matchers.is((Object)this.maxUsers))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.deedManagerAddress", (Matcher)Matchers.is((Object)this.deedManagerAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.ownerAddress", (Matcher)Matchers.is((Object)this.ownerAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.ownerMintingPercentage", (Matcher)Matchers.is((Object)this.ownerMintingPercentage))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.fixedRewardIndex", (Matcher)Matchers.is((Object)this.fixedRewardIndex))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.ownerFixedIndex", (Matcher)Matchers.is((Object)this.ownerFixedIndex))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.tenantFixedIndex", (Matcher)Matchers.is((Object)this.tenantFixedIndex))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.fraud", (Matcher)Matchers.is((Object)this.fraud))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.uemRewardAmount", (Matcher)Matchers.is((Object)this.uemRewardAmount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.reportId", (Matcher)Matchers.is((Object)((int)this.reportId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.hubAddress", (Matcher)Matchers.is((Object)this.hubAddress))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.usersCount", (Matcher)Matchers.is((Object)((int)this.usersCount)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.participantsCount", (Matcher)Matchers.is((Object)((int)this.participantsCount)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.recipientsCount", (Matcher)Matchers.is((Object)((int)this.recipientsCount)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.achievementsCount", (Matcher)Matchers.is((Object)this.achievementsCount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardTokenNetworkId", (Matcher)Matchers.is((Object)((int)this.rewardTokenNetworkId)))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.hubRewardAmount", (Matcher)Matchers.is((Object)this.hubRewardAmount))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.engagementScore", (Matcher)Matchers.is((Object)this.engagementScore))).andExpect(MockMvcResultMatchers.jsonPath((String)"$.rewardTokenAddress", (Matcher)Matchers.is((Object)this.rewardTokenAddress)));
    }

    @Test
    @WithAnonymousUser
    void saveReportWhenWomRequestException() throws Exception {
        ((HubReportService)Mockito.doThrow(WomRequestException.class).when((Object)this.reportService)).saveReport((HubReportVerifiableData)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUB_REPORTS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubReportVerifiableData())));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void saveReportWhenWomParsingException() throws Exception {
        ((HubReportService)Mockito.doThrow(WomParsingException.class).when((Object)this.reportService)).saveReport((HubReportVerifiableData)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUB_REPORTS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubReportVerifiableData())));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    @WithAnonymousUser
    void saveReportWhenWomAuthorizationException() throws Exception {
        ((HubReportService)Mockito.doThrow(WomAuthorizationException.class).when((Object)this.reportService)).saveReport((HubReportVerifiableData)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUB_REPORTS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubReportVerifiableData())));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    @WithAnonymousUser
    void saveReportWhenWomException() throws Exception {
        ((HubReportService)Mockito.doThrow(WomException.class).when((Object)this.reportService)).saveReport((HubReportVerifiableData)ArgumentMatchers.any());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUB_REPORTS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubReportVerifiableData())));
        response.andExpect(MockMvcResultMatchers.status().isInternalServerError());
    }

    @Test
    @WithAnonymousUser
    void saveReport() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)API_HUB_REPORTS, (Object[])new Object[0]).contentType(MediaType.APPLICATION_JSON).content(JsonUtils.toJsonStringNoCheckedEx((Object)new HubReportVerifiableData())));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    private HubReport newHubReport() {
        return new HubReport(this.reportId, StringUtils.lowerCase((String)this.hubAddress), this.deedId, this.fromDate(), this.toDate(), this.sentDate, this.periodType, this.usersCount, this.participantsCount, this.recipientsCount, (long)this.achievementsCount, (long)this.actionsCount, this.rewardTokenAddress, this.rewardTokenNetworkId, this.hubRewardAmount, this.hubTopRewardedAmount, this.transactions(), this.rewardId, this.city, this.cardType, this.mintingPower, this.maxUsers, StringUtils.lowerCase((String)this.deedManagerAddress), StringUtils.lowerCase((String)this.ownerAddress), this.ownerMintingPercentage, this.fixedRewardIndex, this.ownerFixedIndex, this.tenantFixedIndex, this.fraud, this.lastPeriodUemRewardAmount, this.uemRewardAmount, this.updatedDate, this.engagementScore);
    }

    private Instant toDate() {
        return Instant.ofEpochSecond(this.periodEndTime);
    }

    private Instant fromDate() {
        return Instant.ofEpochSecond(this.periodStartTime);
    }

    private TreeSet<String> transactions() {
        TreeSet<String> transactions = new TreeSet<String>();
        transactions.add(this.txHash);
        return transactions;
    }
}

